# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from io import IOBase
import json
import sys
from typing import Any, Callable, Dict, IO, Iterable, Iterator, List, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.polling.base_polling import LROBasePolling
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import _model_base, models as _models
from .._model_base import SdkJSONEncoder, _deserialize
from .._serialization import Serializer
from .._vendor import (
    DocumentTranslationClientMixinABC,
    SingleDocumentTranslationClientMixinABC,
    prepare_multipart_form_data,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_document_translation__begin_translation_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-05-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/document/batches"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_document_translation_list_translation_statuses_request(  # pylint: disable=name-too-long
    *,
    top: Optional[int] = None,
    skip: Optional[int] = None,
    maxpagesize: Optional[int] = None,
    translation_ids: Optional[List[str]] = None,
    statuses: Optional[List[str]] = None,
    created_date_time_utc_start: Optional[datetime.datetime] = None,
    created_date_time_utc_end: Optional[datetime.datetime] = None,
    orderby: Optional[List[str]] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-05-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/document/batches"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")
    if translation_ids is not None:
        _params["ids"] = _SERIALIZER.query("translation_ids", translation_ids, "[str]", div=",")
    if statuses is not None:
        _params["statuses"] = _SERIALIZER.query("statuses", statuses, "[str]", div=",")
    if created_date_time_utc_start is not None:
        _params["createdDateTimeUtcStart"] = _SERIALIZER.query(
            "created_date_time_utc_start", created_date_time_utc_start, "iso-8601"
        )
    if created_date_time_utc_end is not None:
        _params["createdDateTimeUtcEnd"] = _SERIALIZER.query(
            "created_date_time_utc_end", created_date_time_utc_end, "iso-8601"
        )
    if orderby is not None:
        _params["orderby"] = _SERIALIZER.query("orderby", orderby, "[str]", div=",")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_document_translation_get_document_status_request(  # pylint: disable=name-too-long
    translation_id: str, document_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-05-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/document/batches/{id}/documents/{documentId}"
    path_format_arguments = {
        "id": _SERIALIZER.url("translation_id", translation_id, "str"),
        "documentId": _SERIALIZER.url("document_id", document_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_document_translation_get_translation_status_request(  # pylint: disable=name-too-long
    translation_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-05-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/document/batches/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("translation_id", translation_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_document_translation_cancel_translation_request(  # pylint: disable=name-too-long
    translation_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-05-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/document/batches/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("translation_id", translation_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_document_translation_list_document_statuses_request(  # pylint: disable=name-too-long
    translation_id: str,
    *,
    top: Optional[int] = None,
    skip: Optional[int] = None,
    maxpagesize: Optional[int] = None,
    document_ids: Optional[List[str]] = None,
    statuses: Optional[List[str]] = None,
    created_date_time_utc_start: Optional[datetime.datetime] = None,
    created_date_time_utc_end: Optional[datetime.datetime] = None,
    orderby: Optional[List[str]] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-05-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/document/batches/{id}/documents"
    path_format_arguments = {
        "id": _SERIALIZER.url("translation_id", translation_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")
    if skip is not None:
        _params["skip"] = _SERIALIZER.query("skip", skip, "int")
    if maxpagesize is not None:
        _params["maxpagesize"] = _SERIALIZER.query("maxpagesize", maxpagesize, "int")
    if document_ids is not None:
        _params["ids"] = _SERIALIZER.query("document_ids", document_ids, "[str]", div=",")
    if statuses is not None:
        _params["statuses"] = _SERIALIZER.query("statuses", statuses, "[str]", div=",")
    if created_date_time_utc_start is not None:
        _params["createdDateTimeUtcStart"] = _SERIALIZER.query(
            "created_date_time_utc_start", created_date_time_utc_start, "iso-8601"
        )
    if created_date_time_utc_end is not None:
        _params["createdDateTimeUtcEnd"] = _SERIALIZER.query(
            "created_date_time_utc_end", created_date_time_utc_end, "iso-8601"
        )
    if orderby is not None:
        _params["orderby"] = _SERIALIZER.query("orderby", orderby, "[str]", div=",")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_document_translation_get_supported_formats_request(  # pylint: disable=name-too-long
    *, type: Optional[Union[str, _models.FileFormatType]] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-05-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/document/formats"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if type is not None:
        _params["type"] = _SERIALIZER.query("type", type, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_single_document_translation_translate_request(  # pylint: disable=name-too-long
    *,
    target_language: str,
    source_language: Optional[str] = None,
    category: Optional[str] = None,
    allow_fallback: Optional[bool] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-05-01"))
    accept = _headers.pop("Accept", "application/octet-stream")

    # Construct URL
    _url = "/document:translate"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if source_language is not None:
        _params["sourceLanguage"] = _SERIALIZER.query("source_language", source_language, "str")
    _params["targetLanguage"] = _SERIALIZER.query("target_language", target_language, "str")
    if category is not None:
        _params["category"] = _SERIALIZER.query("category", category, "str")
    if allow_fallback is not None:
        _params["allowFallback"] = _SERIALIZER.query("allow_fallback", allow_fallback, "bool")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class DocumentTranslationClientOperationsMixin(DocumentTranslationClientMixinABC):

    def __begin_translation_initial(
        self, body: Union[_models.StartTranslationDetails, JSON, IO[bytes]], **kwargs: Any
    ) -> Iterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_document_translation__begin_translation_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _begin_translation(
        self, body: _models.StartTranslationDetails, *, content_type: str = "application/json", **kwargs: Any
    ) -> LROPoller[_models.TranslationStatus]:
        """Submit a document translation request to the Document Translation service.

        Use this API to submit a bulk (batch) translation request to the Document
        Translation service.
        Each request can contain multiple documents and must
        contain a source and destination container for each document.

        The
        prefix and suffix filter (if supplied) are used to filter folders. The prefix
        is applied to the subpath after the container name.

        Glossaries /
        Translation memory can be included in the request and are applied by the
        service when the document is translated.

        If the glossary is
        invalid or unreachable during translation, an error is indicated in the
        document status.
        If a file with the same name already exists at the
        destination, it will be overwritten. The targetUrl for each target language
        must be unique.

        :param body: Translation job submission batch request. Required.
        :type body: ~azure.ai.translation.document.models.StartTranslationDetails
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns TranslationStatus. The TranslationStatus is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.ai.translation.document.models.TranslationStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def _begin_translation(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> LROPoller[_models.TranslationStatus]:
        """Submit a document translation request to the Document Translation service.

        Use this API to submit a bulk (batch) translation request to the Document
        Translation service.
        Each request can contain multiple documents and must
        contain a source and destination container for each document.

        The
        prefix and suffix filter (if supplied) are used to filter folders. The prefix
        is applied to the subpath after the container name.

        Glossaries /
        Translation memory can be included in the request and are applied by the
        service when the document is translated.

        If the glossary is
        invalid or unreachable during translation, an error is indicated in the
        document status.
        If a file with the same name already exists at the
        destination, it will be overwritten. The targetUrl for each target language
        must be unique.

        :param body: Translation job submission batch request. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns TranslationStatus. The TranslationStatus is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.ai.translation.document.models.TranslationStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def _begin_translation(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> LROPoller[_models.TranslationStatus]:
        """Submit a document translation request to the Document Translation service.

        Use this API to submit a bulk (batch) translation request to the Document
        Translation service.
        Each request can contain multiple documents and must
        contain a source and destination container for each document.

        The
        prefix and suffix filter (if supplied) are used to filter folders. The prefix
        is applied to the subpath after the container name.

        Glossaries /
        Translation memory can be included in the request and are applied by the
        service when the document is translated.

        If the glossary is
        invalid or unreachable during translation, an error is indicated in the
        document status.
        If a file with the same name already exists at the
        destination, it will be overwritten. The targetUrl for each target language
        must be unique.

        :param body: Translation job submission batch request. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of LROPoller that returns TranslationStatus. The TranslationStatus is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.ai.translation.document.models.TranslationStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def _begin_translation(
        self, body: Union[_models.StartTranslationDetails, JSON, IO[bytes]], **kwargs: Any
    ) -> LROPoller[_models.TranslationStatus]:
        """Submit a document translation request to the Document Translation service.

        Use this API to submit a bulk (batch) translation request to the Document
        Translation service.
        Each request can contain multiple documents and must
        contain a source and destination container for each document.

        The
        prefix and suffix filter (if supplied) are used to filter folders. The prefix
        is applied to the subpath after the container name.

        Glossaries /
        Translation memory can be included in the request and are applied by the
        service when the document is translated.

        If the glossary is
        invalid or unreachable during translation, an error is indicated in the
        document status.
        If a file with the same name already exists at the
        destination, it will be overwritten. The targetUrl for each target language
        must be unique.

        :param body: Translation job submission batch request. Is one of the following types:
         StartTranslationDetails, JSON, IO[bytes] Required.
        :type body: ~azure.ai.translation.document.models.StartTranslationDetails or JSON or IO[bytes]
        :return: An instance of LROPoller that returns TranslationStatus. The TranslationStatus is
         compatible with MutableMapping
        :rtype: ~azure.core.polling.LROPoller[~azure.ai.translation.document.models.TranslationStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.TranslationStatus] = kwargs.pop("cls", None)
        polling: Union[bool, PollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = self.__begin_translation_initial(
                body=body, content_type=content_type, cls=lambda x, y, z: x, headers=_headers, params=_params, **kwargs
            )
            raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response_headers = {}
            response = pipeline_response.http_response
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

            deserialized = _deserialize(_models.TranslationStatus, response.json())
            if cls:
                return cls(pipeline_response, deserialized, response_headers)  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: PollingMethod = cast(
                PollingMethod, LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(PollingMethod, NoPolling())
        else:
            polling_method = polling
        if cont_token:
            return LROPoller[_models.TranslationStatus].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller[_models.TranslationStatus](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list_translation_statuses(
        self,
        *,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        translation_ids: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        created_date_time_utc_start: Optional[datetime.datetime] = None,
        created_date_time_utc_end: Optional[datetime.datetime] = None,
        orderby: Optional[List[str]] = None,
        **kwargs: Any,
    ) -> Iterable["_models.TranslationStatus"]:
        """Returns a list of batch requests submitted and the status for each request.

        Returns a list of batch requests submitted and the status for each
        request.
        This list only contains batch requests submitted by the user (based on
        the resource).

        If the number of requests exceeds our paging limit,
        server-side paging is used. Paginated responses indicate a partial result and
        include a continuation token in the response.
        The absence of a continuation
        token means that no additional pages are available.

        top, skip
        and maxpagesize query parameters can be used to specify a number of results to
        return and an offset for the collection.

        top indicates the total
        number of records the user wants to be returned across all pages.
        skip
        indicates the number of records to skip from the list of batches based on the
        sorting method specified.  By default, we sort by descending start
        time.
        maxpagesize is the maximum items returned in a page.  If more items are
        requested via top (or top is not specified and there are more items to be
        returned), @nextLink will contain the link to the next page.

        orderby query parameter can be used to sort the returned list (ex
        "orderby=createdDateTimeUtc asc" or "orderby=createdDateTimeUtc
        desc").
        The default sorting is descending by createdDateTimeUtc.
        Some query
        parameters can be used to filter the returned list (ex:
        "status=Succeeded,Cancelled") will only return succeeded and cancelled
        operations.
        createdDateTimeUtcStart and createdDateTimeUtcEnd can be used
        combined or separately to specify a range of datetime to filter the returned
        list by.
        The supported filtering query parameters are (status, ids,
        createdDateTimeUtcStart, createdDateTimeUtcEnd).

        The server honors
        the values specified by the client. However, clients must be prepared to handle
        responses that contain a different page size or contain a continuation token.

        When both top and skip are included, the server should first apply
        skip and then top on the collection.
        Note: If the server can't honor top
        and/or skip, the server must return an error to the client informing about it
        instead of just ignoring the query options.
        This reduces the risk of the client
        making assumptions about the data returned.

        :keyword top: top indicates the total number of records the user wants to be returned across
         all pages.

         Clients MAY use top and skip query parameters to
         specify a number of results to return and an offset into the collection.
         When
         both top and skip are given by a client, the server SHOULD first apply skip
         and then top on the collection.

         Note: If the server can't honor
         top and/or skip, the server MUST return an error to the client informing
         about it instead of just ignoring the query options. Default value is None.
        :paramtype top: int
        :keyword skip: skip indicates the number of records to skip from the list of records held by
         the server based on the sorting method specified.  By default, we sort by
         descending start time.

         Clients MAY use top and skip query
         parameters to specify a number of results to return and an offset into the
         collection.
         When both top and skip are given by a client, the server SHOULD
         first apply skip and then top on the collection.

         Note: If the
         server can't honor top and/or skip, the server MUST return an error to the
         client informing about it instead of just ignoring the query options. Default value is None.
        :paramtype skip: int
        :keyword translation_ids: Ids to use in filtering. Default value is None.
        :paramtype translation_ids: list[str]
        :keyword statuses: Statuses to use in filtering. Default value is None.
        :paramtype statuses: list[str]
        :keyword created_date_time_utc_start: the start datetime to get items after. Default value is
         None.
        :paramtype created_date_time_utc_start: ~datetime.datetime
        :keyword created_date_time_utc_end: the end datetime to get items before. Default value is
         None.
        :paramtype created_date_time_utc_end: ~datetime.datetime
        :keyword orderby: the sorting query for the collection (ex: 'CreatedDateTimeUtc
         asc','CreatedDateTimeUtc desc'). Default value is None.
        :paramtype orderby: list[str]
        :return: An iterator like instance of TranslationStatus
        :rtype: ~azure.core.paging.ItemPaged[~azure.ai.translation.document.models.TranslationStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.TranslationStatus]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_document_translation_list_translation_statuses_request(
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    translation_ids=translation_ids,
                    statuses=statuses,
                    created_date_time_utc_start=created_date_time_utc_start,
                    created_date_time_utc_end=created_date_time_utc_end,
                    orderby=orderby,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.TranslationStatus], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_document_status(self, translation_id: str, document_id: str, **kwargs: Any) -> _models.DocumentStatus:
        """Returns the status for a specific document.

        Returns the translation status for a specific document based on the request Id
        and document Id.

        :param translation_id: Format - uuid.  The batch id. Required.
        :type translation_id: str
        :param document_id: Format - uuid.  The document id. Required.
        :type document_id: str
        :return: DocumentStatus. The DocumentStatus is compatible with MutableMapping
        :rtype: ~azure.ai.translation.document.models.DocumentStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.DocumentStatus] = kwargs.pop("cls", None)

        _request = build_document_translation_get_document_status_request(
            translation_id=translation_id,
            document_id=document_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DocumentStatus, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_translation_status(self, translation_id: str, **kwargs: Any) -> _models.TranslationStatus:
        """Returns the status for a document translation request.

        Returns the status for a document translation request.
        The status includes the
        overall request status, as well as the status for documents that are being
        translated as part of that request.

        :param translation_id: Format - uuid.  The operation id. Required.
        :type translation_id: str
        :return: TranslationStatus. The TranslationStatus is compatible with MutableMapping
        :rtype: ~azure.ai.translation.document.models.TranslationStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TranslationStatus] = kwargs.pop("cls", None)

        _request = build_document_translation_get_translation_status_request(
            translation_id=translation_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TranslationStatus, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def cancel_translation(self, translation_id: str, **kwargs: Any) -> _models.TranslationStatus:
        """Cancel a currently processing or queued translation.

        Cancel a currently processing or queued translation.
        A translation will not be
        cancelled if it is already completed or failed or cancelling. A bad request
        will be returned.
        All documents that have completed translation will not be
        cancelled and will be charged.
        All pending documents will be cancelled if
        possible.

        :param translation_id: Format - uuid.  The operation-id. Required.
        :type translation_id: str
        :return: TranslationStatus. The TranslationStatus is compatible with MutableMapping
        :rtype: ~azure.ai.translation.document.models.TranslationStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TranslationStatus] = kwargs.pop("cls", None)

        _request = build_document_translation_cancel_translation_request(
            translation_id=translation_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TranslationStatus, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_document_statuses(
        self,
        translation_id: str,
        *,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        document_ids: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        created_date_time_utc_start: Optional[datetime.datetime] = None,
        created_date_time_utc_end: Optional[datetime.datetime] = None,
        orderby: Optional[List[str]] = None,
        **kwargs: Any,
    ) -> Iterable["_models.DocumentStatus"]:
        """Returns the status for all documents in a batch document translation request.

        Returns the status for all documents in a batch document translation request.

        If the number of documents in the response exceeds our paging limit,
        server-side paging is used.
        Paginated responses indicate a partial result and
        include a continuation token in the response. The absence of a continuation
        token means that no additional pages are available.

        top, skip
        and maxpagesize query parameters can be used to specify a number of results to
        return and an offset for the collection.

        top indicates the total
        number of records the user wants to be returned across all pages.
        skip
        indicates the number of records to skip from the list of document status held
        by the server based on the sorting method specified.  By default, we sort by
        descending start time.
        maxpagesize is the maximum items returned in a page.
        If more items are requested via top (or top is not specified and there are
        more items to be returned), @nextLink will contain the link to the next page.

        orderby query parameter can be used to sort the returned list (ex
        "orderby=createdDateTimeUtc asc" or "orderby=createdDateTimeUtc
        desc").
        The default sorting is descending by createdDateTimeUtc.
        Some query
        parameters can be used to filter the returned list (ex:
        "status=Succeeded,Cancelled") will only return succeeded and cancelled
        documents.
        createdDateTimeUtcStart and createdDateTimeUtcEnd can be used
        combined or separately to specify a range of datetime to filter the returned
        list by.
        The supported filtering query parameters are (status, ids,
        createdDateTimeUtcStart, createdDateTimeUtcEnd).

        When both top
        and skip are included, the server should first apply skip and then top on
        the collection.
        Note: If the server can't honor top and/or skip, the server
        must return an error to the client informing about it instead of just ignoring
        the query options.
        This reduces the risk of the client making assumptions about
        the data returned.

        :param translation_id: Format - uuid.  The operation id. Required.
        :type translation_id: str
        :keyword top: top indicates the total number of records the user wants to be returned across
         all pages.

         Clients MAY use top and skip query parameters to
         specify a number of results to return and an offset into the collection.
         When
         both top and skip are given by a client, the server SHOULD first apply skip
         and then top on the collection.

         Note: If the server can't honor
         top and/or skip, the server MUST return an error to the client informing
         about it instead of just ignoring the query options. Default value is None.
        :paramtype top: int
        :keyword skip: skip indicates the number of records to skip from the list of records held by
         the server based on the sorting method specified.  By default, we sort by
         descending start time.

         Clients MAY use top and skip query
         parameters to specify a number of results to return and an offset into the
         collection.
         When both top and skip are given by a client, the server SHOULD
         first apply skip and then top on the collection.

         Note: If the
         server can't honor top and/or skip, the server MUST return an error to the
         client informing about it instead of just ignoring the query options. Default value is None.
        :paramtype skip: int
        :keyword document_ids: Ids to use in filtering. Default value is None.
        :paramtype document_ids: list[str]
        :keyword statuses: Statuses to use in filtering. Default value is None.
        :paramtype statuses: list[str]
        :keyword created_date_time_utc_start: the start datetime to get items after. Default value is
         None.
        :paramtype created_date_time_utc_start: ~datetime.datetime
        :keyword created_date_time_utc_end: the end datetime to get items before. Default value is
         None.
        :paramtype created_date_time_utc_end: ~datetime.datetime
        :keyword orderby: the sorting query for the collection (ex: 'CreatedDateTimeUtc
         asc','CreatedDateTimeUtc desc'). Default value is None.
        :paramtype orderby: list[str]
        :return: An iterator like instance of DocumentStatus
        :rtype: ~azure.core.paging.ItemPaged[~azure.ai.translation.document.models.DocumentStatus]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        maxpagesize = kwargs.pop("maxpagesize", None)
        cls: ClsType[List[_models.DocumentStatus]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_document_translation_list_document_statuses_request(
                    translation_id=translation_id,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    document_ids=document_ids,
                    statuses=statuses,
                    created_date_time_utc_start=created_date_time_utc_start,
                    created_date_time_utc_end=created_date_time_utc_end,
                    orderby=orderby,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.DocumentStatus], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def _get_supported_formats(
        self, *, type: Optional[Union[str, _models.FileFormatType]] = None, **kwargs: Any
    ) -> _models._models.SupportedFileFormats:
        """Returns a list of supported document formats.

        The list of supported formats supported by the Document Translation
        service.
        The list includes the common file extension, as well as the
        content-type if using the upload API.

        :keyword type: the type of format like document or glossary. Known values are: "document" and
         "glossary". Default value is None.
        :paramtype type: str or ~azure.ai.translation.document.models.FileFormatType
        :return: SupportedFileFormats. The SupportedFileFormats is compatible with MutableMapping
        :rtype: ~azure.ai.translation.document.models._models.SupportedFileFormats
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models._models.SupportedFileFormats] = kwargs.pop("cls", None)

        _request = build_document_translation_get_supported_formats_request(
            type=type,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models._models.SupportedFileFormats, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class SingleDocumentTranslationClientOperationsMixin(  # pylint: disable=name-too-long
    SingleDocumentTranslationClientMixinABC
):

    @overload
    def translate(
        self,
        body: _models.DocumentTranslateContent,
        *,
        target_language: str,
        source_language: Optional[str] = None,
        category: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        **kwargs: Any,
    ) -> Iterator[bytes]:
        """Submit a single document translation request to the Document Translation service.

        Use this API to submit a single translation request to the Document Translation Service.

        :param body: Document Translate Request Content. Required.
        :type body: ~azure.ai.translation.document.models.DocumentTranslateContent
        :keyword target_language: Specifies the language of the output document.
         The target language must be one of the supported languages included in the translation scope.
         For example if you want to translate the document in German language, then use
         targetLanguage=de. Required.
        :paramtype target_language: str
        :keyword source_language: Specifies source language of the input document.
         If this parameter isn't specified, automatic language detection is applied to determine the
         source language.
         For example if the source document is written in English, then use sourceLanguage=en. Default
         value is None.
        :paramtype source_language: str
        :keyword category: A string specifying the category (domain) of the translation. This parameter
         is used to get translations
         from a customized system built with Custom Translator. Add the Category ID from your Custom
         Translator
         project details to this parameter to use your deployed customized system. Default value is:
         general. Default value is None.
        :paramtype category: str
        :keyword allow_fallback: Specifies that the service is allowed to fall back to a general system
         when a custom system doesn't exist.
         Possible values are: true (default) or false. Default value is None.
        :paramtype allow_fallback: bool
        :return: Iterator[bytes]
        :rtype: Iterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def translate(
        self,
        body: JSON,
        *,
        target_language: str,
        source_language: Optional[str] = None,
        category: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        **kwargs: Any,
    ) -> Iterator[bytes]:
        """Submit a single document translation request to the Document Translation service.

        Use this API to submit a single translation request to the Document Translation Service.

        :param body: Document Translate Request Content. Required.
        :type body: JSON
        :keyword target_language: Specifies the language of the output document.
         The target language must be one of the supported languages included in the translation scope.
         For example if you want to translate the document in German language, then use
         targetLanguage=de. Required.
        :paramtype target_language: str
        :keyword source_language: Specifies source language of the input document.
         If this parameter isn't specified, automatic language detection is applied to determine the
         source language.
         For example if the source document is written in English, then use sourceLanguage=en. Default
         value is None.
        :paramtype source_language: str
        :keyword category: A string specifying the category (domain) of the translation. This parameter
         is used to get translations
         from a customized system built with Custom Translator. Add the Category ID from your Custom
         Translator
         project details to this parameter to use your deployed customized system. Default value is:
         general. Default value is None.
        :paramtype category: str
        :keyword allow_fallback: Specifies that the service is allowed to fall back to a general system
         when a custom system doesn't exist.
         Possible values are: true (default) or false. Default value is None.
        :paramtype allow_fallback: bool
        :return: Iterator[bytes]
        :rtype: Iterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def translate(
        self,
        body: Union[_models.DocumentTranslateContent, JSON],
        *,
        target_language: str,
        source_language: Optional[str] = None,
        category: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        **kwargs: Any,
    ) -> Iterator[bytes]:
        """Submit a single document translation request to the Document Translation service.

        Use this API to submit a single translation request to the Document Translation Service.

        :param body: Document Translate Request Content. Is either a DocumentTranslateContent type or a
         JSON type. Required.
        :type body: ~azure.ai.translation.document.models.DocumentTranslateContent or JSON
        :keyword target_language: Specifies the language of the output document.
         The target language must be one of the supported languages included in the translation scope.
         For example if you want to translate the document in German language, then use
         targetLanguage=de. Required.
        :paramtype target_language: str
        :keyword source_language: Specifies source language of the input document.
         If this parameter isn't specified, automatic language detection is applied to determine the
         source language.
         For example if the source document is written in English, then use sourceLanguage=en. Default
         value is None.
        :paramtype source_language: str
        :keyword category: A string specifying the category (domain) of the translation. This parameter
         is used to get translations
         from a customized system built with Custom Translator. Add the Category ID from your Custom
         Translator
         project details to this parameter to use your deployed customized system. Default value is:
         general. Default value is None.
        :paramtype category: str
        :keyword allow_fallback: Specifies that the service is allowed to fall back to a general system
         when a custom system doesn't exist.
         Possible values are: true (default) or false. Default value is None.
        :paramtype allow_fallback: bool
        :return: Iterator[bytes]
        :rtype: Iterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Iterator[bytes]] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _model_base.Model) else body
        _file_fields: List[str] = ["document", "glossary"]
        _data_fields: List[str] = []
        _files, _data = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_single_document_translation_translate_request(
            target_language=target_language,
            source_language=source_language,
            category=category,
            allow_fallback=allow_fallback,
            api_version=self._config.api_version,
            files=_files,
            data=_data,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore
