## Issues and Pull Requests

- [Create an Issue](https://github.com/cprogrammer1994/ModernGL/issues)
- [Create a Pull Request](https://github.com/cprogrammer1994/ModernGL/pulls)

## Contributing

### Changing the python module

- Follow the pep8 style.
- Check the module with pylint, pyflakes and pep8.
- [Google Style Docstring](http://sphinxcontrib-napoleon.readthedocs.io/en/latest/example_google.html) and [Type Hints](https://www.python.org/dev/peps/pep-0484/) are required.

### Changing the core module (c++)

- I prefer using tabs here.
- No python documentation is required for types / methods.
- Don't forget to change the python module too.

### New examples

- Follow the pep8 style guide.
- Pylint check is not required.

## Auto correct

If you are not sure about the style, we will format the code later.

## Useful links

- [Changelog](https://github.com/cprogrammer1994/ModernGL/blob/master/CHANGELOG.md).
- [Readme](https://github.com/cprogrammer1994/ModernGL/blob/master/README.md).
- [License](https://github.com/cprogrammer1994/ModernGL/blob/master/LICENSE).
