/******************************************************************************
 *
 * package:     Log4Qt
 * file:        nullappender.cpp
 * created:     September 2007
 * author:      Martin Heinrich
 *
 * 
 * Copyright 2007 Martin Heinrich
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ******************************************************************************/



/******************************************************************************
 * Dependencies
 ******************************************************************************/


#include "log4qt/varia/nullappender.h"

#include <QtCore/QDebug>
#include "log4qt/layout.h"
#include "log4qt/loggingevent.h"



namespace Log4Qt
{
	
	
	/**************************************************************************
	 * Declarations
	 **************************************************************************/
	
	
	
	/**************************************************************************
	 * C helper functions
	 **************************************************************************/
	
	
	
	/**************************************************************************
	 * Class implementation: NullAppender
	 **************************************************************************/
	
	
	NullAppender::NullAppender(QObject *pParent) :
	    AppenderSkeleton(false, pParent)
	{
	}
	
	
	NullAppender::~NullAppender()
	{
	    close();
	}
	
	
	void NullAppender::append(const LoggingEvent &rEvent)
	{
	    Q_UNUSED(rEvent);
	}

	void NullAppender::asyncAppend(const LoggingEvent &rEvent)
	{
	    Q_UNUSED(rEvent);
	}
	
	
#ifndef QT_NO_DEBUG_STREAM
	QDebug NullAppender::debug(QDebug &rDebug) const
	{
	    QString layout_name;
	    if (layout())
	        layout_name = layout()->name();
	    
	    rDebug.nospace() << "NullAppender(" 
	        << "name:" << name() << " "
	        << "isactive:" << isActive() << " "
	        << "isclosed:" << isClosed() << " "
	        << "layout:" << layout_name << " "
	        << "threshold:" << threshold().toString() << " "
	        << ")";
	    return rDebug.space();    
	}
#endif // QT_NO_DEBUG_STREAM
	
	
	
	/**************************************************************************
	 * Implementation: Operators, Helper
	 **************************************************************************/
	
	
} // namespace Log4Qt
