#ifndef _ASM_PAGE_H
#define _ASM_PAGE_H

#include <linux/config.h>
#include <asm/virtconvert.h>
#include <asm/mem-layout.h>
#include <asm/vmlinux.h>

#ifdef __KERNEL__

#include <asm/setup.h>
 
#ifndef __ASSEMBLY__
 
#define get_user_page(vaddr)		__get_free_page(GFP_KERNEL)
#define free_user_page(page, addr)	free_page(addr)

#define clear_page(page)		memset((page), 0, PAGE_SIZE)
#define copy_page(to,from)		memcpy((to), (from), PAGE_SIZE)

#define clear_user_page(page, vaddr)	clear_page(page)
#define copy_user_page(to, from, vaddr)	copy_page(to, from)

/*
 * These are used to make use of C type-checking..
 */
typedef struct { unsigned long pte;	} pte_t;
typedef struct { unsigned long ste[64];	} pmd_t;
typedef struct { pmd_t         pge[1];	} pgd_t;
typedef struct { unsigned long pgprot;	} pgprot_t;

#define pte_val(x)	((x).pte)
#define pmd_val(x)	((&x)->ste[0])
#define pgd_val(x)	((x).pge[0])
#define pgprot_val(x)	((x).pgprot)

#define __pte(x)	((pte_t) { (x) } )
#define __pmd(x)	((pmd_t) { (x) } )
#define __pgd(x)	((pgd_t) { (x) } )
#define __pgprot(x)	((pgprot_t) { (x) } )
#define PTE_MASK	PAGE_MASK

/* to align the pointer to the (next) page boundary */
#define PAGE_ALIGN(addr)	(((addr) + PAGE_SIZE - 1) & PAGE_MASK)

/* Pure 2^n version of get_order */
extern __inline__ int get_order(unsigned long size)
{
	int order;

	size = (size - 1) >> (PAGE_SHIFT - 1);
	order = -1;
	do {
		size >>= 1;
		order++;
	} while (size);
	return order;
}

#define __pa(vaddr)		virt_to_phys((void *)vaddr)
#define __va(paddr)		phys_to_virt((unsigned long)paddr)

#define MAP_NR(addr)		(((unsigned long)(addr) - PAGE_OFFSET) >> PAGE_SHIFT)
#define virt_to_page(addr)	(mem_map + (((unsigned long)(addr) - PAGE_OFFSET) >> PAGE_SHIFT))
#define VALID_PAGE(page)	((page - mem_map) < max_mapnr)


#ifdef CONFIG_NO_KERNEL_MSG
#define	BUG_PRINT()
#else
#define	BUG_PRINT() printk("kernel BUG at %s:%d!\n", __FILE__, __LINE__)
#endif

extern asmlinkage void __debug_bug_trap(void);
#define BUG_PANIC()				\
do {						\
	__debug_bug_trap();			\
	asm volatile("nop");			\
	/*panic("BUG!");*/			\
} while(0)


#define BUG() do {				\
	BUG_PRINT();				\
	BUG_PANIC();				\
} while (0)

#define PAGE_BUG(page) do {			\
	BUG();					\
} while (0)

#ifndef CONFIG_UCLINUX
#define VM_DATA_DEFAULT_FLAGS	(VM_READ | VM_WRITE | VM_EXEC | \
				VM_MAYREAD | VM_MAYWRITE | VM_MAYEXEC)
#endif

#endif /* __ASSEMBLY__ */

#endif /* __KERNEL__ */

#ifdef CONFIG_CONTIGUOUS_PAGE_ALLOC
#define WANT_PAGE_VIRTUAL	1
#endif

#endif /* _ASM_PAGE_H */
