#############################################################
#
# psmisc
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
PSMISC_SOURCE:=psmisc.tar.gz
PSMISC_SITE:=ftp://ftp.gnu.org/gnu/psmisc
PSMISC_CAT:=zcat
endif

PSMISC_DIR:=$(BUILD_DIR)/psmisc
PSMISC_BINARY:=src/killall
PSMISC_TARGET_BINARY:=usr/bin/killall

ifneq ($(USE_CVS),true)
psmisc-fetch:
	 $(WGET) -P $(DL_DIR) $(PSMISC_SITE)/$(PSMISC_SOURCE)

psmisc-source: $(DL_DIR)/$(PSMISC_SOURCE)
else
psmisc-source:
endif

PSMISC_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d psmisc $(CVS_TAG) $(CVS_PREFIX)psmisc

psmisc-checkout:
	@$(PSMISC_CVSCO)

$(PSMISC_DIR)/.unpacked: $(DL_DIR)/$(PSMISC_SOURCE)
ifneq ($(USE_CVS),true)
	$(PSMISC_CAT) $(DL_DIR)/$(PSMISC_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PSMISC_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(PSMISC_DIR)/
	touch $(PSMISC_DIR)/.unpacked

$(PSMISC_DIR)/.configured: $(PSMISC_DIR)/.unpacked
	(cd $(PSMISC_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(PSMISC_DIR)/.configured

$(PSMISC_DIR)/$(PSMISC_BINARY): $(PSMISC_DIR)/.configured
	$(MAKE) CFLAGS="$(TARGET_CFLAGS)" CC=$(TARGET_CC) CC_FOR_BUILD=$(HOSTCC) -C $(PSMISC_DIR)

$(TARGET_DIR)/$(PSMISC_TARGET_BINARY): $(PSMISC_DIR)/$(PSMISC_BINARY)
	$(MAKE) STRIP=$(TARGET_CROSS)strip DESTDIR=$(TARGET_DIR) -C $(PSMISC_DIR) install
	-@rm -f $(TARGET_DIR)/usr/bin/pstree.x11
	$(STRIP) $(TARGET_DIR)/usr/bin/fuser $(TARGET_DIR)/usr/bin/killall $(TARGET_DIR)/usr/bin/pstree
	install -d $(DOC_DIR)/doc/psmisc
	@for f in COPYING NEWS README ; do \
		install -m0644 $(PSMISC_DIR)/$$f $(DOC_DIR)/doc/psmisc/$$f ;\
	done

psmisc: uclibc $(TARGET_DIR)/$(PSMISC_TARGET_BINARY)

psmisc-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(PSMISC_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/psmisc
	-$(MAKE) -C $(PSMISC_DIR) clean

psmisc-dirclean:
	rm -rf $(PSMISC_DIR)
endif

