#############################################################
#
# tinylogin
#
#############################################################
ifneq ($(USE_CVS),true)
TINYLOGIN_DIR:=$(BUILD_DIR)/tinylogin
TINYLOGIN_SOURCE:=tinylogin.tar.gz
TINYLOGIN_SITE:=http://tinylogin.busybox.net/downloads
else
# using CVS
TINYLOGIN_DIR:=$(BUILD_DIR)/tinylogin
endif

TINYLOGIN_PATCH:=$(SOURCE_DIR)/tinylogin.patch

ifneq ($(USE_CVS),true)
tinylogin-fetch:
	$(WGET) -P $(DL_DIR) $(TINYLOGIN_SITE)/$(TINYLOGIN_SOURCE)

tinylogin-source: $(DL_DIR)/$(TINYLOGIN_SOURCE)

$(TINYLOGIN_DIR)/Config.h: $(DL_DIR)/$(TINYLOGIN_SOURCE)
else
tinylogin-source:
endif

TINYLOGIN_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co $(CVS_TAG) -d tinylogin $(CVS_PREFIX)tinylogin

tinylogin-checkout:
	@$(TINYLOGIN_CVSCO)

$(TINYLOGIN_DIR)/Config.h: $(TINYLOGIN_PATCH)
ifneq ($(USE_CVS),true)
	zcat $(DL_DIR)/$(TINYLOGIN_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(TINYLOGIN_CVSCO)
endif
	# date test this one
	touch $(TINYLOGIN_DIR)/Config.h

$(TINYLOGIN_DIR)/tinylogin: $(TINYLOGIN_DIR)/Config.h
	$(MAKE) CC=$(TARGET_CC) CFLAGS_EXTRA="$(TARGET_CFLAGS)" CROSS="$(TARGET_CROSS)" -C $(TINYLOGIN_DIR)

$(TARGET_DIR)/bin/tinylogin: $(TINYLOGIN_DIR)/tinylogin
	$(MAKE) CC=$(TARGET_CC) CROSS="$(TARGET_CROSS)" \
		PREFIX="$(TARGET_DIR)" -C $(TINYLOGIN_DIR) install
	chmod 4755 $(TARGET_DIR)/bin/tinylogin
	install -m0644 $(TINYLOGIN_DIR)/docs/TinyLogin.1 $(TARGET_DIR)/usr/man/man1/
	ln -sf TinyLogin.1 $(TARGET_DIR)/usr/man/man1/tinylogin.1
	install -m0644 $(TINYLOGIN_DIR)/docs/getty.8 $(TARGET_DIR)/usr/man/man8/
	mkdir -p $(DOC_DIR)/doc/tinylogin
	for f in LICENSE README ; do \
	    install -m0644 $(TINYLOGIN_DIR)/$$f $(DOC_DIR)/doc/tinylogin/ ; \
	done 

tinylogin: uclibc $(TARGET_DIR)/bin/tinylogin

tinylogin-clean:
	-rm -f $(TARGET_DIR)/bin/tinylogin
	-$(MAKE) -C $(TINYLOGIN_DIR) clean
	-rm -rf $(DOC_DIR)/doc/tinylogin
	-rm -f $(TARGET_DIR)/usr/man/man1/TinyLogin.1
	-rm -f $(TARGET_DIR)/usr/man/man1/tinylogin.1

tinylogin-dirclean:
	rm -rf $(TINYLOGIN_DIR)
