/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001          */


#include <stdio.h>
#include <stdlib.h>

#include "unistd.h"

#include "4758_status.h"
#include "pkcs11types.h"
#include "defs.h"

#include "scc_host.h"

CK_ULONG long_reverse( CK_ULONG x )
{
   CK_ULONG rev;
   CK_BYTE  *p1 = (CK_BYTE *)&x;
   CK_BYTE  *p2 = (CK_BYTE *)&rev;

   p2[3] = p1[0];
   p2[2] = p1[1];
   p2[1] = p1[2];
   p2[0] = p1[3];

   return rev;
}
#define HTOCL(Z) (Z)
#define CTOHL(Z) (Z)

CK_RV 
communicate( CK_ULONG    slot_id, CK_ULONG cmd_id,
             CK_VOID_PTR pReq,   CK_ULONG     req_len,
             CK_VOID_PTR pRep,   CK_ULONG_PTR repl_len,
             CK_BYTE_PTR pOut,   CK_ULONG     out_len,
             CK_BYTE_PTR pIn,    CK_ULONG     in_len )
{
   union
   {
      double  d;
      CK_BYTE b[1024];
   } alignedBuffers[2];

   LEEDS_REQUEST  * send_packet = (LEEDS_REQUEST *)&(alignedBuffers[0]);
   LEEDS_REPLY    * recv_packet = (LEEDS_REPLY   *)&(alignedBuffers[1]);
   CK_BYTE        * ptr         = NULL;
   CK_BYTE        * in_buf      = pIn;
   CK_BYTE        * out_buf     = pOut;
   CK_ULONG         send_len, recv_len = 0;
   CK_ULONG         in_buf_len = in_len, out_buf_len = out_len;
   CK_RV            rc = CKR_OK;

   sccAdapterNumber_t num_adapters;
   sccAgentID_t       leeds_id;
   sccAdapterHandle_t adapter_handle;
   sccRB_t            request_block;

   memset( &leeds_id, 0, sizeof(leeds_id) );

   leeds_id.DeveloperID[0] = PKCS_11_DEVELOPER_ID;
   leeds_id.DeveloperID[1] = 0x00;

   memcpy( leeds_id.ProgramID,
           PKCS_11_PRG_ID,
           sizeof(leeds_id.ProgramID) );

   leeds_id.Version[0]  = PKCS_11_VERSION;
   leeds_id.Instance[0] = PKCS_11_INSTANCE;
   leeds_id.Queue[0]    = PKCS_11_QUEUE;

   rc = sccOpenAdapter( slot_id, &adapter_handle );
   if (rc)
      exit (SEG2_NOT_RUNABLE);


   if (repl_len == NULL)
      return CKR_GENERAL_ERROR;

   if (pReq == NULL && req_len != 0)
      return CKR_FUNCTION_FAILED;

   if (pRep == NULL && *repl_len != 0)
      return CKR_FUNCTION_FAILED;

   if (pOut == NULL && out_len != 0)
      return CKR_FUNCTION_FAILED;

   if (pIn == NULL && in_len != 0)
      return CKR_FUNCTION_FAILED;


   // ensure the buffer lengths are multiples of 4 and that the buffers we
   // have are big enough
   //
   send_len = (sizeof(LEEDS_REQUEST) + req_len + 3) & ~3;
   recv_len = (sizeof(LEEDS_REPLY) + *repl_len + 3) & ~3;

   if (send_len > sizeof(alignedBuffers[0]))
      send_packet = (LEEDS_REQUEST *)malloc( send_len );

   if (recv_len > sizeof(alignedBuffers[1]))
      recv_packet = (LEEDS_REPLY *)malloc( recv_len );

   if ((out_len & 3) != 0)
   {
      out_buf_len = (out_len + 3) & ~3;
      out_buf = (CK_BYTE *)malloc( out_buf_len );
      memcpy( out_buf, pOut, out_len );
   }

   if ((in_len & 3) != 0)
   {
      in_buf_len = (in_len + 3) & ~3;
      in_buf = (CK_BYTE *)malloc( in_buf_len );
   }

   // If we couldn't allocate something we needed, die
   //
   if (send_packet == NULL ||
       recv_packet == NULL ||
      (out_buf     == NULL && out_buf_len != 0) ||
      (in_buf      == NULL && in_buf_len  != 0))
   {
      if (send_len > sizeof(alignedBuffers[0]) && send_packet != NULL)
         free( send_packet );

      if (recv_len > sizeof(alignedBuffers[1]) && recv_packet != NULL)
         free( recv_packet );

      if (out_buf != NULL && out_buf != pOut)
         free( out_buf );

      if (in_buf != NULL && in_buf != pIn)
         free( in_buf );

      return CKR_HOST_MEMORY;
   }

   memset( send_packet, 0x0, send_len );
   memset( recv_packet, 0x0, recv_len );

   memset( &request_block,         0x00,      sizeof(request_block) );
   memcpy( &request_block.AgentID, &leeds_id, sizeof(leeds_id) );

   send_packet->pid     = HTOCL( 0);
   send_packet->req_len = HTOCL( req_len );

   send_packet->repl_max[0] = HTOCL( *repl_len );
   send_packet->repl_max[1] = HTOCL( in_len );
   send_packet->repl_max[2] = 0;      // we don't currently use these buffers
   send_packet->repl_max[3] = 0;      // but maybe in the future...

   // Skip request header
   //
   ptr = (CK_BYTE *)send_packet + sizeof(LEEDS_REQUEST);

   if (pReq != NULL)
      memcpy( ptr, pReq, req_len );

   request_block.pOutBuffer[0] = (unsigned char *)send_packet;
   request_block.pInBuffer [0] = (unsigned char *)recv_packet;
   request_block.pOutBuffer[1] = (unsigned char *)out_buf;
   request_block.pInBuffer [1] = (unsigned char *)in_buf;

   // I don't know if the following needs to be adjusted for endianness or not
   // (the device driver could in principle take care of the swapping)
   //
   request_block.UserDefined = cmd_id;

   request_block.OutBufferLength[0] = send_len;
   request_block.InBufferLength [0] = recv_len;
   request_block.OutBufferLength[1] = out_buf_len;
   request_block.InBufferLength [1] = in_buf_len;

   // send the request synchronously to the adapter
   //

   rc = sccRequest( adapter_handle, &request_block );


   if (rc != 0)
   {
      rc = CKR_FUNCTION_FAILED;
      goto error;
   }

   // handle the replies
   //
   if ((CTOHL(recv_packet->repl_len[0]) > *repl_len) ||
       (CTOHL(recv_packet->repl_len[1]) >  in_len))
   {
      rc = CKR_FUNCTION_FAILED;
      goto error;
   }

   *repl_len = CTOHL(recv_packet->repl_len[0]);

   // Skip reply header
   //
   ptr = (CK_BYTE *)recv_packet + sizeof(LEEDS_REPLY);

   if (pRep != NULL)
      memcpy( pRep, ptr, CTOHL(recv_packet->repl_len[0]) );

   if (in_buf != pIn)
      memcpy( pIn, in_buf, CTOHL(recv_packet->repl_len[1]) );

   // This may need to be swapped...
   //
   rc = request_block.Status;
printf("communicate rc in req block %x \n",rc);

error:
   if (send_len > sizeof(alignedBuffers[0])) free( send_packet );
   if (recv_len > sizeof(alignedBuffers[1])) free( recv_packet );
   if (in_buf  != pIn)  free( in_buf );
   if (out_buf != pOut) free( out_buf );

   return rc;
}

int
main (int argc, char *argv[]){
   CK_CHAR_PTR card, tempc;
   int dev_minor = 0;

   int c, errflag = 0;

   while ((c = getopt (argc, argv, "c:")) != (-1)) {
      switch (c){
         case 'c':  /* a specific card (slot) is specified */
            card = (CK_CHAR_PTR) malloc (strlen(optarg));
            memcpy(card, optarg, strlen(optarg));
         break;
         default:
            errflag++;
         break;
      }
   }

   if (errflag != 0)
      return INVALID_PARAMS;


   if (strlen(card) < 6) 
      return INVALID_PARAMS;
   else
      tempc = (char *)malloc(strlen(card));
   
   sscanf(card, "crypto%s", tempc);
   dev_minor = atoi(tempc);
   free (tempc);
   

   {
      CK_ULONG data = 0;
      CK_ULONG req_len, repl_len = 0;

      int rc;

      req_len = sizeof(data);

      if (rc = communicate(dev_minor, CHECK_DEEP, &data, req_len, NULL, 
            &repl_len, NULL, 0, NULL, 0) != CKR_OK)
         if (rc = communicate(dev_minor, CHECK_SHALLOW, &data, req_len, NULL, 
            &repl_len, NULL, 0, NULL, 0) != CKR_OK)  {
	    printf("return from communicate 2 %x \n",rc);
            return PKCS11_NOT_LOADED;
         }else
            return LEEDS2_SHALLOW;
      else
         return LEEDS2_DEEP;
   }
}
