/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.handler.AbstractHandlerSupport;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.Endpoint;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.Visitable;
import org.codehaus.xfire.service.Visitor;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.invoker.Invoker;
import org.codehaus.xfire.wsdl.WSDLWriter;

public class Service
extends AbstractHandlerSupport
implements Visitable {
    public static final String ROLE = Service.class.getName();
    public static final String DISABLE_WSDL_GENERATION = "wsdl.generation.disabled";
    private QName name;
    private ServiceInfo service;
    private Map bindings = new HashMap();
    private Invoker invoker;
    private BindingProvider bindingProvider;
    private Object executor;
    private MessageSerializer faultSerializer;
    private WSDLWriter wsdlWriter;
    private Map endpoints = new HashMap();
    private Map bindingToEndpoint = new HashMap();
    private Map idToBinding = new HashMap();

    public Service(ServiceInfo service) {
        this.service = service;
        service.setService(this);
    }

    public Service() {
    }

    public void accept(Visitor visitor) {
        visitor.startEndpoint(this);
        this.service.accept(visitor);
        visitor.endEndpoint(this);
    }

    public Object getExecutor() {
        return this.executor;
    }

    public void setExecutor(Object executor) {
        this.executor = executor;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public BindingProvider getBindingProvider() {
        return this.bindingProvider;
    }

    public void setBindingProvider(BindingProvider bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    public MessageSerializer getFaultSerializer() {
        return this.faultSerializer;
    }

    public void setFaultSerializer(MessageSerializer faultSerializer) {
        this.faultSerializer = faultSerializer;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public String getSimpleName() {
        return this.getName().getLocalPart();
    }

    public String getTargetNamespace() {
        return this.getName().getNamespaceURI();
    }

    public ServiceInfo getServiceInfo() {
        return this.service;
    }

    public WSDLWriter getWSDLWriter() {
        return this.wsdlWriter;
    }

    public void setWSDLWriter(WSDLWriter wsdlWriter) {
        this.wsdlWriter = wsdlWriter;
    }

    public void addBinding(Binding binding) {
        this.bindings.put(binding.getName(), binding);
        this.idToBinding.put(binding.getBindingId(), binding);
    }

    public Binding getBinding(QName name) {
        return (Binding)this.bindings.get(name);
    }

    public Collection getBindings() {
        return Collections.unmodifiableCollection(this.bindings.values());
    }

    public Binding getBinding(String id) {
        Iterator itr = this.bindings.values().iterator();
        while (itr.hasNext()) {
            Binding binding = (Binding)itr.next();
            if (!binding.getBindingId().equals(id)) continue;
            return binding;
        }
        return null;
    }

    public Collection getEndpoints() {
        return Collections.unmodifiableCollection(this.endpoints.values());
    }

    public void addEndpoint(Endpoint endpoint) {
        this.endpoints.put(endpoint.getName(), endpoint);
        HashSet<Endpoint> eps = (HashSet<Endpoint>)this.bindingToEndpoint.get(endpoint.getBinding().getName());
        if (eps == null) {
            eps = new HashSet<Endpoint>();
            this.bindingToEndpoint.put(endpoint.getBinding().getName(), eps);
        }
        eps.add(endpoint);
    }

    public Endpoint getEndpoint(QName name) {
        return (Endpoint)this.endpoints.get(name);
    }

    public Endpoint addEndpoint(QName name, QName bindingName, String address) {
        Binding binding = this.getBinding(bindingName);
        if (binding == null) {
            throw new IllegalStateException("Invalid binding: " + bindingName);
        }
        Endpoint ep = new Endpoint(name, binding, address);
        this.addEndpoint(ep);
        return ep;
    }

    public Endpoint addEndpoint(QName name, Binding binding, String address) {
        Endpoint endpoint = new Endpoint(name, binding, address);
        this.addEndpoint(endpoint);
        return endpoint;
    }

    public Collection getEndpoints(QName name2) {
        ArrayList<Endpoint> eps = new ArrayList<Endpoint>();
        Iterator itr = this.endpoints.values().iterator();
        while (itr.hasNext()) {
            Endpoint ep = (Endpoint)itr.next();
            if (!ep.getBinding().getName().equals(name2)) continue;
            eps.add(ep);
        }
        return eps;
    }
}

