# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_py3 import Resource


class EnvironmentSettingFragment(Resource):
    """Represents settings of an environment, from which environment instances
    would be created.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param configuration_state: Describes the user's progress in configuring
     their environment setting. Possible values include: 'NotApplicable',
     'Completed'
    :type configuration_state: str or
     ~azure.mgmt.labservices.models.ConfigurationState
    :param description: Describes the environment and its resource settings
    :type description: str
    :param title: Brief title describing the environment and its resource
     settings
    :type title: str
    :param resource_settings: The resource specific settings
    :type resource_settings:
     ~azure.mgmt.labservices.models.ResourceSettingsFragment
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :type unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'configuration_state': {'key': 'properties.configurationState', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'resource_settings': {'key': 'properties.resourceSettings', 'type': 'ResourceSettingsFragment'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, configuration_state=None, description: str=None, title: str=None, resource_settings=None, provisioning_state: str=None, unique_identifier: str=None, **kwargs) -> None:
        super(EnvironmentSettingFragment, self).__init__(location=location, tags=tags, **kwargs)
        self.configuration_state = configuration_state
        self.description = description
        self.title = title
        self.resource_settings = resource_settings
        self.provisioning_state = provisioning_state
        self.unique_identifier = unique_identifier
