# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import json
import sys
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._model_base import AzureJSONEncoder, _deserialize
from .._serialization import Serializer
from .._vendor import TextTranslationClientMixinABC

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_text_translation_get_languages_request(
    *,
    client_trace_id: Optional[str] = None,
    scope: Optional[str] = None,
    accept_language: Optional[str] = None,
    if_none_match: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: Literal["3.0"] = kwargs.pop("api_version", _params.pop("api-version", "3.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/languages"

    # Construct parameters
    if scope is not None:
        _params["scope"] = _SERIALIZER.query("scope", scope, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if client_trace_id is not None:
        _headers["X-ClientTraceId"] = _SERIALIZER.header("client_trace_id", client_trace_id, "str")
    if accept_language is not None:
        _headers["Accept-Language"] = _SERIALIZER.header("accept_language", accept_language, "str")
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_text_translation_translate_request(
    *,
    to: List[str],
    client_trace_id: Optional[str] = None,
    from_parameter: Optional[str] = None,
    text_type: Optional[Union[str, _models.TextType]] = None,
    category: Optional[str] = None,
    profanity_action: Optional[Union[str, _models.ProfanityAction]] = None,
    profanity_marker: Optional[Union[str, _models.ProfanityMarker]] = None,
    include_alignment: Optional[bool] = None,
    include_sentence_length: Optional[bool] = None,
    suggested_from: Optional[str] = None,
    from_script: Optional[str] = None,
    to_script: Optional[str] = None,
    allow_fallback: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: Literal["3.0"] = kwargs.pop("api_version", _params.pop("api-version", "3.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/translate"

    # Construct parameters
    _params["to"] = [_SERIALIZER.query("to", q, "str") if q is not None else "" for q in to]
    if from_parameter is not None:
        _params["from"] = _SERIALIZER.query("from_parameter", from_parameter, "str")
    if text_type is not None:
        _params["textType"] = _SERIALIZER.query("text_type", text_type, "str")
    if category is not None:
        _params["category"] = _SERIALIZER.query("category", category, "str")
    if profanity_action is not None:
        _params["profanityAction"] = _SERIALIZER.query("profanity_action", profanity_action, "str")
    if profanity_marker is not None:
        _params["profanityMarker"] = _SERIALIZER.query("profanity_marker", profanity_marker, "str")
    if include_alignment is not None:
        _params["includeAlignment"] = _SERIALIZER.query("include_alignment", include_alignment, "bool")
    if include_sentence_length is not None:
        _params["includeSentenceLength"] = _SERIALIZER.query("include_sentence_length", include_sentence_length, "bool")
    if suggested_from is not None:
        _params["suggestedFrom"] = _SERIALIZER.query("suggested_from", suggested_from, "str")
    if from_script is not None:
        _params["fromScript"] = _SERIALIZER.query("from_script", from_script, "str")
    if to_script is not None:
        _params["toScript"] = _SERIALIZER.query("to_script", to_script, "str")
    if allow_fallback is not None:
        _params["allowFallback"] = _SERIALIZER.query("allow_fallback", allow_fallback, "bool")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if client_trace_id is not None:
        _headers["X-ClientTraceId"] = _SERIALIZER.header("client_trace_id", client_trace_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_text_translation_transliterate_request(
    *, language: str, from_script: str, to_script: str, client_trace_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: Literal["3.0"] = kwargs.pop("api_version", _params.pop("api-version", "3.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/transliterate"

    # Construct parameters
    _params["language"] = _SERIALIZER.query("language", language, "str")
    _params["fromScript"] = _SERIALIZER.query("from_script", from_script, "str")
    _params["toScript"] = _SERIALIZER.query("to_script", to_script, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if client_trace_id is not None:
        _headers["X-ClientTraceId"] = _SERIALIZER.header("client_trace_id", client_trace_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_text_translation_find_sentence_boundaries_request(
    *,
    client_trace_id: Optional[str] = None,
    language: Optional[str] = None,
    script: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: Literal["3.0"] = kwargs.pop("api_version", _params.pop("api-version", "3.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/breaksentence"

    # Construct parameters
    if language is not None:
        _params["language"] = _SERIALIZER.query("language", language, "str")
    if script is not None:
        _params["script"] = _SERIALIZER.query("script", script, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if client_trace_id is not None:
        _headers["X-ClientTraceId"] = _SERIALIZER.header("client_trace_id", client_trace_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_text_translation_lookup_dictionary_entries_request(
    *, from_parameter: str, to: str, client_trace_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: Literal["3.0"] = kwargs.pop("api_version", _params.pop("api-version", "3.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/dictionary/lookup"

    # Construct parameters
    _params["from"] = _SERIALIZER.query("from_parameter", from_parameter, "str")
    _params["to"] = _SERIALIZER.query("to", to, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if client_trace_id is not None:
        _headers["X-ClientTraceId"] = _SERIALIZER.header("client_trace_id", client_trace_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_text_translation_lookup_dictionary_examples_request(
    *, from_parameter: str, to: str, client_trace_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: Literal["3.0"] = kwargs.pop("api_version", _params.pop("api-version", "3.0"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/dictionary/examples"

    # Construct parameters
    _params["from"] = _SERIALIZER.query("from_parameter", from_parameter, "str")
    _params["to"] = _SERIALIZER.query("to", to, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if client_trace_id is not None:
        _headers["X-ClientTraceId"] = _SERIALIZER.header("client_trace_id", client_trace_id, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class TextTranslationClientOperationsMixin(TextTranslationClientMixinABC):
    @distributed_trace
    def get_languages(
        self,
        *,
        client_trace_id: Optional[str] = None,
        scope: Optional[str] = None,
        accept_language: Optional[str] = None,
        if_none_match: Optional[str] = None,
        **kwargs: Any
    ) -> _models.GetLanguagesResult:
        """Gets the set of languages currently supported by other operations of the Translator.

        Gets the set of languages currently supported by other operations of the Translator.

        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword scope: A comma-separated list of names defining the group of languages to return.
         Allowed group names are: ``translation``\ , ``transliteration`` and ``dictionary``.
         If no scope is given, then all groups are returned, which is equivalent to passing
         ``scope=translation,transliteration,dictionary``. To decide which set of supported languages
         is appropriate for your scenario, see the description of the `response object
         <#response-body>`_. Default value is None.
        :paramtype scope: str
        :keyword accept_language: The language to use for user interface strings. Some of the fields in
         the response are names of languages or
         names of regions. Use this parameter to define the language in which these names are returned.
         The language is specified by providing a well-formed BCP 47 language tag. For instance, use
         the value ``fr``
         to request names in French or use the value ``zh-Hant`` to request names in Chinese
         Traditional.
         Names are provided in the English language when a target language is not specified or when
         localization
         is not available. Default value is None.
        :paramtype accept_language: str
        :keyword if_none_match: Passing the value of the ETag response header in an If-None-Match field
         will allow the service to optimize the response.
         If the resource has not been modified, the service will return status code 304 and an empty
         response body. Default value is None.
        :paramtype if_none_match: str
        :return: GetLanguagesResult. The GetLanguagesResult is compatible with MutableMapping
        :rtype: ~azure.ai.translation.text.models.GetLanguagesResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.GetLanguagesResult] = kwargs.pop("cls", None)

        request = build_text_translation_get_languages_request(
            client_trace_id=client_trace_id,
            scope=scope,
            accept_language=accept_language,
            if_none_match=if_none_match,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))

        deserialized = _deserialize(_models.GetLanguagesResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def translate(
        self,
        content: List[_models.InputTextItem],
        *,
        to: List[str],
        client_trace_id: Optional[str] = None,
        from_parameter: Optional[str] = None,
        text_type: Optional[Union[str, _models.TextType]] = None,
        category: Optional[str] = None,
        profanity_action: Optional[Union[str, _models.ProfanityAction]] = None,
        profanity_marker: Optional[Union[str, _models.ProfanityMarker]] = None,
        include_alignment: Optional[bool] = None,
        include_sentence_length: Optional[bool] = None,
        suggested_from: Optional[str] = None,
        from_script: Optional[str] = None,
        to_script: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.TranslatedTextItem]:
        """Translate Text.

        Translate Text.

        :param content: Array of the text to be translated. Required.
        :type content: list[~azure.ai.translation.text.models.InputTextItem]
        :keyword to: Specifies the language of the output text. The target language must be one of the
         supported languages included
         in the translation scope. For example, use to=de to translate to German.
         It's possible to translate to multiple languages simultaneously by repeating the parameter in
         the query string.
         For example, use to=de&to=it to translate to German and Italian. Required.
        :paramtype to: list[str]
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword from_parameter: Specifies the language of the input text. Find which languages are
         available to translate from by
         looking up supported languages using the translation scope. If the from parameter isn't
         specified,
         automatic language detection is applied to determine the source language.

         You must use the from parameter rather than autodetection when using the dynamic dictionary
         feature.
         Note: the dynamic dictionary feature is case-sensitive. Default value is None.
        :paramtype from_parameter: str
        :keyword text_type: Defines whether the text being translated is plain text or HTML text. Any
         HTML needs to be a well-formed,
         complete element. Possible values are: plain (default) or html. Known values are: "plain" and
         "html". Default value is None.
        :paramtype text_type: str or ~azure.ai.translation.text.models.TextType
        :keyword category: A string specifying the category (domain) of the translation. This parameter
         is used to get translations
         from a customized system built with Custom Translator. Add the Category ID from your Custom
         Translator
         project details to this parameter to use your deployed customized system. Default value is:
         general. Default value is None.
        :paramtype category: str
        :keyword profanity_action: Specifies how profanities should be treated in translations.
         Possible values are: NoAction (default), Marked or Deleted. Known values are: "NoAction",
         "Marked", and "Deleted". Default value is None.
        :paramtype profanity_action: str or ~azure.ai.translation.text.models.ProfanityAction
        :keyword profanity_marker: Specifies how profanities should be marked in translations.
         Possible values are: Asterisk (default) or Tag. Known values are: "Asterisk" and "Tag".
         Default value is None.
        :paramtype profanity_marker: str or ~azure.ai.translation.text.models.ProfanityMarker
        :keyword include_alignment: Specifies whether to include alignment projection from source text
         to translated text.
         Possible values are: true or false (default). Default value is None.
        :paramtype include_alignment: bool
        :keyword include_sentence_length: Specifies whether to include sentence boundaries for the
         input text and the translated text.
         Possible values are: true or false (default). Default value is None.
        :paramtype include_sentence_length: bool
        :keyword suggested_from: Specifies a fallback language if the language of the input text can't
         be identified.
         Language autodetection is applied when the from parameter is omitted. If detection fails,
         the suggestedFrom language will be assumed. Default value is None.
        :paramtype suggested_from: str
        :keyword from_script: Specifies the script of the input text. Default value is None.
        :paramtype from_script: str
        :keyword to_script: Specifies the script of the translated text. Default value is None.
        :paramtype to_script: str
        :keyword allow_fallback: Specifies that the service is allowed to fall back to a general system
         when a custom system doesn't exist.
         Possible values are: true (default) or false.

         allowFallback=false specifies that the translation should only use systems trained for the
         category specified
         by the request. If a translation for language X to language Y requires chaining through a
         pivot language E,
         then all the systems in the chain (X → E and E → Y) will need to be custom and have the same
         category.
         If no system is found with the specific category, the request will return a 400 status code.
         allowFallback=true
         specifies that the service is allowed to fall back to a general system when a custom system
         doesn't exist. Default value is None.
        :paramtype allow_fallback: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of TranslatedTextItem
        :rtype: list[~azure.ai.translation.text.models.TranslatedTextItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def translate(
        self,
        content: IO,
        *,
        to: List[str],
        client_trace_id: Optional[str] = None,
        from_parameter: Optional[str] = None,
        text_type: Optional[Union[str, _models.TextType]] = None,
        category: Optional[str] = None,
        profanity_action: Optional[Union[str, _models.ProfanityAction]] = None,
        profanity_marker: Optional[Union[str, _models.ProfanityMarker]] = None,
        include_alignment: Optional[bool] = None,
        include_sentence_length: Optional[bool] = None,
        suggested_from: Optional[str] = None,
        from_script: Optional[str] = None,
        to_script: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.TranslatedTextItem]:
        """Translate Text.

        Translate Text.

        :param content: Array of the text to be translated. Required.
        :type content: IO
        :keyword to: Specifies the language of the output text. The target language must be one of the
         supported languages included
         in the translation scope. For example, use to=de to translate to German.
         It's possible to translate to multiple languages simultaneously by repeating the parameter in
         the query string.
         For example, use to=de&to=it to translate to German and Italian. Required.
        :paramtype to: list[str]
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword from_parameter: Specifies the language of the input text. Find which languages are
         available to translate from by
         looking up supported languages using the translation scope. If the from parameter isn't
         specified,
         automatic language detection is applied to determine the source language.

         You must use the from parameter rather than autodetection when using the dynamic dictionary
         feature.
         Note: the dynamic dictionary feature is case-sensitive. Default value is None.
        :paramtype from_parameter: str
        :keyword text_type: Defines whether the text being translated is plain text or HTML text. Any
         HTML needs to be a well-formed,
         complete element. Possible values are: plain (default) or html. Known values are: "plain" and
         "html". Default value is None.
        :paramtype text_type: str or ~azure.ai.translation.text.models.TextType
        :keyword category: A string specifying the category (domain) of the translation. This parameter
         is used to get translations
         from a customized system built with Custom Translator. Add the Category ID from your Custom
         Translator
         project details to this parameter to use your deployed customized system. Default value is:
         general. Default value is None.
        :paramtype category: str
        :keyword profanity_action: Specifies how profanities should be treated in translations.
         Possible values are: NoAction (default), Marked or Deleted. Known values are: "NoAction",
         "Marked", and "Deleted". Default value is None.
        :paramtype profanity_action: str or ~azure.ai.translation.text.models.ProfanityAction
        :keyword profanity_marker: Specifies how profanities should be marked in translations.
         Possible values are: Asterisk (default) or Tag. Known values are: "Asterisk" and "Tag".
         Default value is None.
        :paramtype profanity_marker: str or ~azure.ai.translation.text.models.ProfanityMarker
        :keyword include_alignment: Specifies whether to include alignment projection from source text
         to translated text.
         Possible values are: true or false (default). Default value is None.
        :paramtype include_alignment: bool
        :keyword include_sentence_length: Specifies whether to include sentence boundaries for the
         input text and the translated text.
         Possible values are: true or false (default). Default value is None.
        :paramtype include_sentence_length: bool
        :keyword suggested_from: Specifies a fallback language if the language of the input text can't
         be identified.
         Language autodetection is applied when the from parameter is omitted. If detection fails,
         the suggestedFrom language will be assumed. Default value is None.
        :paramtype suggested_from: str
        :keyword from_script: Specifies the script of the input text. Default value is None.
        :paramtype from_script: str
        :keyword to_script: Specifies the script of the translated text. Default value is None.
        :paramtype to_script: str
        :keyword allow_fallback: Specifies that the service is allowed to fall back to a general system
         when a custom system doesn't exist.
         Possible values are: true (default) or false.

         allowFallback=false specifies that the translation should only use systems trained for the
         category specified
         by the request. If a translation for language X to language Y requires chaining through a
         pivot language E,
         then all the systems in the chain (X → E and E → Y) will need to be custom and have the same
         category.
         If no system is found with the specific category, the request will return a 400 status code.
         allowFallback=true
         specifies that the service is allowed to fall back to a general system when a custom system
         doesn't exist. Default value is None.
        :paramtype allow_fallback: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of TranslatedTextItem
        :rtype: list[~azure.ai.translation.text.models.TranslatedTextItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def translate(
        self,
        content: Union[List[_models.InputTextItem], IO],
        *,
        to: List[str],
        client_trace_id: Optional[str] = None,
        from_parameter: Optional[str] = None,
        text_type: Optional[Union[str, _models.TextType]] = None,
        category: Optional[str] = None,
        profanity_action: Optional[Union[str, _models.ProfanityAction]] = None,
        profanity_marker: Optional[Union[str, _models.ProfanityMarker]] = None,
        include_alignment: Optional[bool] = None,
        include_sentence_length: Optional[bool] = None,
        suggested_from: Optional[str] = None,
        from_script: Optional[str] = None,
        to_script: Optional[str] = None,
        allow_fallback: Optional[bool] = None,
        **kwargs: Any
    ) -> List[_models.TranslatedTextItem]:
        """Translate Text.

        Translate Text.

        :param content: Array of the text to be translated. Is either a [InputTextItem] type or a IO
         type. Required.
        :type content: list[~azure.ai.translation.text.models.InputTextItem] or IO
        :keyword to: Specifies the language of the output text. The target language must be one of the
         supported languages included
         in the translation scope. For example, use to=de to translate to German.
         It's possible to translate to multiple languages simultaneously by repeating the parameter in
         the query string.
         For example, use to=de&to=it to translate to German and Italian. Required.
        :paramtype to: list[str]
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword from_parameter: Specifies the language of the input text. Find which languages are
         available to translate from by
         looking up supported languages using the translation scope. If the from parameter isn't
         specified,
         automatic language detection is applied to determine the source language.

         You must use the from parameter rather than autodetection when using the dynamic dictionary
         feature.
         Note: the dynamic dictionary feature is case-sensitive. Default value is None.
        :paramtype from_parameter: str
        :keyword text_type: Defines whether the text being translated is plain text or HTML text. Any
         HTML needs to be a well-formed,
         complete element. Possible values are: plain (default) or html. Known values are: "plain" and
         "html". Default value is None.
        :paramtype text_type: str or ~azure.ai.translation.text.models.TextType
        :keyword category: A string specifying the category (domain) of the translation. This parameter
         is used to get translations
         from a customized system built with Custom Translator. Add the Category ID from your Custom
         Translator
         project details to this parameter to use your deployed customized system. Default value is:
         general. Default value is None.
        :paramtype category: str
        :keyword profanity_action: Specifies how profanities should be treated in translations.
         Possible values are: NoAction (default), Marked or Deleted. Known values are: "NoAction",
         "Marked", and "Deleted". Default value is None.
        :paramtype profanity_action: str or ~azure.ai.translation.text.models.ProfanityAction
        :keyword profanity_marker: Specifies how profanities should be marked in translations.
         Possible values are: Asterisk (default) or Tag. Known values are: "Asterisk" and "Tag".
         Default value is None.
        :paramtype profanity_marker: str or ~azure.ai.translation.text.models.ProfanityMarker
        :keyword include_alignment: Specifies whether to include alignment projection from source text
         to translated text.
         Possible values are: true or false (default). Default value is None.
        :paramtype include_alignment: bool
        :keyword include_sentence_length: Specifies whether to include sentence boundaries for the
         input text and the translated text.
         Possible values are: true or false (default). Default value is None.
        :paramtype include_sentence_length: bool
        :keyword suggested_from: Specifies a fallback language if the language of the input text can't
         be identified.
         Language autodetection is applied when the from parameter is omitted. If detection fails,
         the suggestedFrom language will be assumed. Default value is None.
        :paramtype suggested_from: str
        :keyword from_script: Specifies the script of the input text. Default value is None.
        :paramtype from_script: str
        :keyword to_script: Specifies the script of the translated text. Default value is None.
        :paramtype to_script: str
        :keyword allow_fallback: Specifies that the service is allowed to fall back to a general system
         when a custom system doesn't exist.
         Possible values are: true (default) or false.

         allowFallback=false specifies that the translation should only use systems trained for the
         category specified
         by the request. If a translation for language X to language Y requires chaining through a
         pivot language E,
         then all the systems in the chain (X → E and E → Y) will need to be custom and have the same
         category.
         If no system is found with the specific category, the request will return a 400 status code.
         allowFallback=true
         specifies that the service is allowed to fall back to a general system when a custom system
         doesn't exist. Default value is None.
        :paramtype allow_fallback: bool
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :return: list of TranslatedTextItem
        :rtype: list[~azure.ai.translation.text.models.TranslatedTextItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.TranslatedTextItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(content, (IO, bytes)):
            _content = content
        else:
            _content = json.dumps(content, cls=AzureJSONEncoder)  # type: ignore

        request = build_text_translation_translate_request(
            to=to,
            client_trace_id=client_trace_id,
            from_parameter=from_parameter,
            text_type=text_type,
            category=category,
            profanity_action=profanity_action,
            profanity_marker=profanity_marker,
            include_alignment=include_alignment,
            include_sentence_length=include_sentence_length,
            suggested_from=suggested_from,
            from_script=from_script,
            to_script=to_script,
            allow_fallback=allow_fallback,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))
        response_headers["x-mt-system"] = self._deserialize("str", response.headers.get("x-mt-system"))
        response_headers["x-metered-usage"] = self._deserialize("int", response.headers.get("x-metered-usage"))

        deserialized = _deserialize(List[_models.TranslatedTextItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def transliterate(
        self,
        content: List[_models.InputTextItem],
        *,
        language: str,
        from_script: str,
        to_script: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.TransliteratedText]:
        """Transliterate Text.

        Transliterate Text.

        :param content: Array of the text to be transliterated. Required.
        :type content: list[~azure.ai.translation.text.models.InputTextItem]
        :keyword language: Specifies the language of the text to convert from one script to another.
         Possible languages are listed in the transliteration scope obtained by querying the service
         for its supported languages. Required.
        :paramtype language: str
        :keyword from_script: Specifies the script used by the input text. Look up supported languages
         using the transliteration scope,
         to find input scripts available for the selected language. Required.
        :paramtype from_script: str
        :keyword to_script: Specifies the output script. Look up supported languages using the
         transliteration scope, to find output
         scripts available for the selected combination of input language and input script. Required.
        :paramtype to_script: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of TransliteratedText
        :rtype: list[~azure.ai.translation.text.models.TransliteratedText]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def transliterate(
        self,
        content: IO,
        *,
        language: str,
        from_script: str,
        to_script: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.TransliteratedText]:
        """Transliterate Text.

        Transliterate Text.

        :param content: Array of the text to be transliterated. Required.
        :type content: IO
        :keyword language: Specifies the language of the text to convert from one script to another.
         Possible languages are listed in the transliteration scope obtained by querying the service
         for its supported languages. Required.
        :paramtype language: str
        :keyword from_script: Specifies the script used by the input text. Look up supported languages
         using the transliteration scope,
         to find input scripts available for the selected language. Required.
        :paramtype from_script: str
        :keyword to_script: Specifies the output script. Look up supported languages using the
         transliteration scope, to find output
         scripts available for the selected combination of input language and input script. Required.
        :paramtype to_script: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of TransliteratedText
        :rtype: list[~azure.ai.translation.text.models.TransliteratedText]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def transliterate(
        self,
        content: Union[List[_models.InputTextItem], IO],
        *,
        language: str,
        from_script: str,
        to_script: str,
        client_trace_id: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.TransliteratedText]:
        """Transliterate Text.

        Transliterate Text.

        :param content: Array of the text to be transliterated. Is either a [InputTextItem] type or a
         IO type. Required.
        :type content: list[~azure.ai.translation.text.models.InputTextItem] or IO
        :keyword language: Specifies the language of the text to convert from one script to another.
         Possible languages are listed in the transliteration scope obtained by querying the service
         for its supported languages. Required.
        :paramtype language: str
        :keyword from_script: Specifies the script used by the input text. Look up supported languages
         using the transliteration scope,
         to find input scripts available for the selected language. Required.
        :paramtype from_script: str
        :keyword to_script: Specifies the output script. Look up supported languages using the
         transliteration scope, to find output
         scripts available for the selected combination of input language and input script. Required.
        :paramtype to_script: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :return: list of TransliteratedText
        :rtype: list[~azure.ai.translation.text.models.TransliteratedText]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.TransliteratedText]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(content, (IO, bytes)):
            _content = content
        else:
            _content = json.dumps(content, cls=AzureJSONEncoder)  # type: ignore

        request = build_text_translation_transliterate_request(
            language=language,
            from_script=from_script,
            to_script=to_script,
            client_trace_id=client_trace_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))

        deserialized = _deserialize(List[_models.TransliteratedText], response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def find_sentence_boundaries(
        self,
        content: List[_models.InputTextItem],
        *,
        client_trace_id: Optional[str] = None,
        language: Optional[str] = None,
        script: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.BreakSentenceItem]:
        """Find Sentence Boundaries.

        Find Sentence Boundaries.

        :param content: Array of the text for which values the sentence boundaries will be calculated.
         Required.
        :type content: list[~azure.ai.translation.text.models.InputTextItem]
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword language: Language tag identifying the language of the input text.
         If a code isn't specified, automatic language detection will be applied. Default value is
         None.
        :paramtype language: str
        :keyword script: Script tag identifying the script used by the input text.
         If a script isn't specified, the default script of the language will be assumed. Default value
         is None.
        :paramtype script: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of BreakSentenceItem
        :rtype: list[~azure.ai.translation.text.models.BreakSentenceItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def find_sentence_boundaries(
        self,
        content: IO,
        *,
        client_trace_id: Optional[str] = None,
        language: Optional[str] = None,
        script: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.BreakSentenceItem]:
        """Find Sentence Boundaries.

        Find Sentence Boundaries.

        :param content: Array of the text for which values the sentence boundaries will be calculated.
         Required.
        :type content: IO
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword language: Language tag identifying the language of the input text.
         If a code isn't specified, automatic language detection will be applied. Default value is
         None.
        :paramtype language: str
        :keyword script: Script tag identifying the script used by the input text.
         If a script isn't specified, the default script of the language will be assumed. Default value
         is None.
        :paramtype script: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of BreakSentenceItem
        :rtype: list[~azure.ai.translation.text.models.BreakSentenceItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def find_sentence_boundaries(
        self,
        content: Union[List[_models.InputTextItem], IO],
        *,
        client_trace_id: Optional[str] = None,
        language: Optional[str] = None,
        script: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.BreakSentenceItem]:
        """Find Sentence Boundaries.

        Find Sentence Boundaries.

        :param content: Array of the text for which values the sentence boundaries will be calculated.
         Is either a [InputTextItem] type or a IO type. Required.
        :type content: list[~azure.ai.translation.text.models.InputTextItem] or IO
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword language: Language tag identifying the language of the input text.
         If a code isn't specified, automatic language detection will be applied. Default value is
         None.
        :paramtype language: str
        :keyword script: Script tag identifying the script used by the input text.
         If a script isn't specified, the default script of the language will be assumed. Default value
         is None.
        :paramtype script: str
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :return: list of BreakSentenceItem
        :rtype: list[~azure.ai.translation.text.models.BreakSentenceItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.BreakSentenceItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(content, (IO, bytes)):
            _content = content
        else:
            _content = json.dumps(content, cls=AzureJSONEncoder)  # type: ignore

        request = build_text_translation_find_sentence_boundaries_request(
            client_trace_id=client_trace_id,
            language=language,
            script=script,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))

        deserialized = _deserialize(List[_models.BreakSentenceItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def lookup_dictionary_entries(
        self,
        content: List[_models.InputTextItem],
        *,
        from_parameter: str,
        to: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.DictionaryLookupItem]:
        """Lookup Dictionary Entries.

        Lookup Dictionary Entries.

        :param content: Array of the text to be sent to dictionary. Required.
        :type content: list[~azure.ai.translation.text.models.InputTextItem]
        :keyword from_parameter: Specifies the language of the input text.
         The source language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype from_parameter: str
        :keyword to: Specifies the language of the output text.
         The target language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype to: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of DictionaryLookupItem
        :rtype: list[~azure.ai.translation.text.models.DictionaryLookupItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def lookup_dictionary_entries(
        self,
        content: IO,
        *,
        from_parameter: str,
        to: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.DictionaryLookupItem]:
        """Lookup Dictionary Entries.

        Lookup Dictionary Entries.

        :param content: Array of the text to be sent to dictionary. Required.
        :type content: IO
        :keyword from_parameter: Specifies the language of the input text.
         The source language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype from_parameter: str
        :keyword to: Specifies the language of the output text.
         The target language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype to: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of DictionaryLookupItem
        :rtype: list[~azure.ai.translation.text.models.DictionaryLookupItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def lookup_dictionary_entries(
        self,
        content: Union[List[_models.InputTextItem], IO],
        *,
        from_parameter: str,
        to: str,
        client_trace_id: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.DictionaryLookupItem]:
        """Lookup Dictionary Entries.

        Lookup Dictionary Entries.

        :param content: Array of the text to be sent to dictionary. Is either a [InputTextItem] type or
         a IO type. Required.
        :type content: list[~azure.ai.translation.text.models.InputTextItem] or IO
        :keyword from_parameter: Specifies the language of the input text.
         The source language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype from_parameter: str
        :keyword to: Specifies the language of the output text.
         The target language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype to: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :return: list of DictionaryLookupItem
        :rtype: list[~azure.ai.translation.text.models.DictionaryLookupItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.DictionaryLookupItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(content, (IO, bytes)):
            _content = content
        else:
            _content = json.dumps(content, cls=AzureJSONEncoder)  # type: ignore

        request = build_text_translation_lookup_dictionary_entries_request(
            from_parameter=from_parameter,
            to=to,
            client_trace_id=client_trace_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))

        deserialized = _deserialize(List[_models.DictionaryLookupItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    def lookup_dictionary_examples(
        self,
        content: List[_models.DictionaryExampleTextItem],
        *,
        from_parameter: str,
        to: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.DictionaryExampleItem]:
        """Lookup Dictionary Examples.

        Lookup Dictionary Examples.

        :param content: Array of the text to be sent to dictionary. Required.
        :type content: list[~azure.ai.translation.text.models.DictionaryExampleTextItem]
        :keyword from_parameter: Specifies the language of the input text.
         The source language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype from_parameter: str
        :keyword to: Specifies the language of the output text.
         The target language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype to: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of DictionaryExampleItem
        :rtype: list[~azure.ai.translation.text.models.DictionaryExampleItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def lookup_dictionary_examples(
        self,
        content: IO,
        *,
        from_parameter: str,
        to: str,
        client_trace_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.DictionaryExampleItem]:
        """Lookup Dictionary Examples.

        Lookup Dictionary Examples.

        :param content: Array of the text to be sent to dictionary. Required.
        :type content: IO
        :keyword from_parameter: Specifies the language of the input text.
         The source language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype from_parameter: str
        :keyword to: Specifies the language of the output text.
         The target language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype to: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of DictionaryExampleItem
        :rtype: list[~azure.ai.translation.text.models.DictionaryExampleItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def lookup_dictionary_examples(
        self,
        content: Union[List[_models.DictionaryExampleTextItem], IO],
        *,
        from_parameter: str,
        to: str,
        client_trace_id: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.DictionaryExampleItem]:
        """Lookup Dictionary Examples.

        Lookup Dictionary Examples.

        :param content: Array of the text to be sent to dictionary. Is either a
         [DictionaryExampleTextItem] type or a IO type. Required.
        :type content: list[~azure.ai.translation.text.models.DictionaryExampleTextItem] or IO
        :keyword from_parameter: Specifies the language of the input text.
         The source language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype from_parameter: str
        :keyword to: Specifies the language of the output text.
         The target language must be one of the supported languages included in the dictionary scope.
         Required.
        :paramtype to: str
        :keyword client_trace_id: A client-generated GUID to uniquely identify the request. Default
         value is None.
        :paramtype client_trace_id: str
        :keyword content_type: Body parameter Content-Type. Known values are: application/json. Default
         value is None.
        :paramtype content_type: str
        :return: list of DictionaryExampleItem
        :rtype: list[~azure.ai.translation.text.models.DictionaryExampleItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.DictionaryExampleItem]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(content, (IO, bytes)):
            _content = content
        else:
            _content = json.dumps(content, cls=AzureJSONEncoder)  # type: ignore

        request = build_text_translation_lookup_dictionary_examples_request(
            from_parameter=from_parameter,
            to=to,
            client_trace_id=client_trace_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["X-RequestId"] = self._deserialize("str", response.headers.get("X-RequestId"))

        deserialized = _deserialize(List[_models.DictionaryExampleItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore
