Description: Fix FTBFS with gcc-6
Author: Anton Gladky <gladk@debian.org>
Bug-Debian: https://bugs.debian.org/831069
Last-Update: 2016-08-07

--- qtiplot-0.9.8.9.orig/qtiplot/src/analysis/dialogs/FitDialog.cpp
+++ qtiplot-0.9.8.9/qtiplot/src/analysis/dialogs/FitDialog.cpp
@@ -1022,7 +1022,7 @@ void FitDialog::showFitPage()
 #ifdef Q_CC_MSVC
         it->setFlags(it->flags() & (~Qt::ItemIsEditable));
 #else
-        it->setFlags(!Qt::ItemIsEditable);
+        it->setFlags(Qt::ItemFlags(!Qt::ItemIsEditable));
 #endif
         it->setBackground(QBrush(Qt::lightGray));
         it->setForeground(Qt::black);
@@ -1049,7 +1049,7 @@ void FitDialog::showFitPage()
         boxParams->setCellWidget(i, 2, sb);
 
         it = new QTableWidgetItem();
-		it->setFlags(!Qt::ItemIsEditable);
+		it->setFlags(Qt::ItemFlags(!Qt::ItemIsEditable));
 		it->setText("--");
 		boxParams->setItem(i, 5, it);
 	}
@@ -1064,7 +1064,7 @@ void FitDialog::showFitPage()
 #ifdef Q_CC_MSVC
             it->setFlags(it->flags() & (~Qt::ItemIsEditable));
 #else
-            it->setFlags(!Qt::ItemIsEditable);
+            it->setFlags(Qt::ItemFlags(!Qt::ItemIsEditable));
 #endif
             it->setBackground(QBrush(Qt::lightGray));
             boxParams->setItem(i, 4, it);
--- qtiplot-0.9.8.9.orig/qtiplot/src/core/ConfigDialog.cpp
+++ qtiplot-0.9.8.9/qtiplot/src/core/ConfigDialog.cpp
@@ -1390,7 +1390,7 @@ void ConfigDialog::setColorsList(const Q
 	colorsList->setRowCount(colors);
 	for (int i = 0; i < colors; i++){
 		QTableWidgetItem *it = new QTableWidgetItem();
-		it->setFlags(!Qt::ItemIsEditable);
+		it->setFlags(Qt::ItemFlags(!Qt::ItemIsEditable));
 		it->setBackground(QBrush(colList[i]));
 		colorsList->setItem(i, 0, it);
 
--- qtiplot-0.9.8.9.orig/qtiplot/src/lib/src/ColorMapEditor.cpp
+++ qtiplot-0.9.8.9/qtiplot/src/lib/src/ColorMapEditor.cpp
@@ -158,7 +158,7 @@ void ColorMapEditor::setColorMap(const L
 	#ifdef Q_CC_MSVC
 		it->setFlags(it->flags() & (~Qt::ItemIsEditable));
 	#else
-		it->setFlags(!Qt::ItemIsEditable);
+		it->setFlags(Qt::ItemFlags(!Qt::ItemIsEditable));
 	#endif
 		it->setBackground(QBrush(c));
 		it->setForeground(QBrush(c));
@@ -249,7 +249,7 @@ void ColorMapEditor::insertLevel()
 #ifdef Q_CC_MSVC
 	it->setFlags(it->flags() & (~Qt::ItemIsEditable));
 #else
-	it->setFlags(!Qt::ItemIsEditable);
+	it->setFlags(Qt::ItemFlags(!Qt::ItemIsEditable));
 #endif
 	it->setBackground(QBrush(c));
 	it->setForeground(QBrush(c));
--- qtiplot-0.9.8.9.orig/qtiplot/src/matrix/MatrixValuesDialog.cpp
+++ qtiplot-0.9.8.9/qtiplot/src/matrix/MatrixValuesDialog.cpp
@@ -70,7 +70,7 @@ MatrixValuesDialog::MatrixValuesDialog(
 	endCol->setRange(1, INT_MAX);
 	gl1->addWidget(endCol, 1, 3);
 
-	functions = new QComboBox(false);
+	functions = new QComboBox();
 	functions->addItems(scriptEnv->mathFunctions());
 	btnAddFunction = new QPushButton(tr( "Add &Function" ));
 	btnAddCell = new QPushButton(tr( "Add Ce&ll" ));
--- qtiplot-0.9.8.9.orig/qtiplot/src/plot2D/dialogs/LayerDialog.cpp
+++ qtiplot-0.9.8.9/qtiplot/src/plot2D/dialogs/LayerDialog.cpp
@@ -69,14 +69,14 @@ multi_layer(NULL)
 	QGridLayout *gl2 = new QGridLayout(gb2);
 	gl2->addWidget(new QLabel(tr("Horizontal")), 0, 0);
 
-	alignHorBox = new QComboBox( false );
+	alignHorBox = new QComboBox();
 	alignHorBox->insertItem( tr( "Center" ) );
 	alignHorBox->insertItem( tr( "Left" ) );
 	alignHorBox->insertItem( tr( "Right" ) );
 	gl2->addWidget(alignHorBox, 0, 1);
 
 	gl2->addWidget(new QLabel( tr( "Vertical" )), 1, 0 );
-	alignVertBox = new QComboBox( false );
+	alignVertBox = new QComboBox( );
 	alignVertBox->insertItem( tr( "Center" ) );
 	alignVertBox->insertItem( tr( "Top" ) );
 	alignVertBox->insertItem( tr( "Bottom" ) );
--- qtiplot-0.9.8.9.orig/qtiplot/src/plot2D/dialogs/PlotDialog.cpp
+++ qtiplot-0.9.8.9/qtiplot/src/plot2D/dialogs/PlotDialog.cpp
@@ -954,7 +954,7 @@ void PlotDialog::initPiePage()
 	l4->setBuddy(boxFirstColor);
 	gl2->addWidget(l4, 0, 0);
 
-	boxPiePattern = new PatternBox(false);
+	boxPiePattern = new PatternBox();
 	gl2->addWidget(boxPiePattern, 1, 1);
 	gl2->setRowStretch(2, 1);
 
@@ -1337,7 +1337,7 @@ void PlotDialog::initLinePage()
 	hb->addWidget(boxCurveOpacity);
 	gl2->addLayout(hb, 1, 1);
 
-	boxPattern = new PatternBox(false);
+	boxPattern = new PatternBox();
 	gl2->addWidget(boxPattern, 2, 1);
 	
 	QLabel *l6 = new QLabel("&" + tr("Pattern"));
@@ -2126,17 +2126,17 @@ void PlotDialog::initVectPage()
     QGridLayout *gl3 = new QGridLayout(GroupBoxVectEnd);
     labelXEnd = new QLabel(tr( "X End" ));
     gl3->addWidget(labelXEnd, 0, 0);
-	xEndBox = new QComboBox(false);
+	xEndBox = new QComboBox();
     gl3->addWidget(xEndBox, 0, 1);
 
 	labelYEnd = new QLabel(tr( "Y End" ));
     gl3->addWidget(labelYEnd, 1, 0);
-	yEndBox = new  QComboBox( false);
+	yEndBox = new  QComboBox();
     gl3->addWidget(yEndBox, 1, 1);
 
 	labelPosition = new QLabel(tr( "Position" ));
     gl3->addWidget(labelPosition, 2, 0);
-	vectPosBox = new  QComboBox( false);
+	vectPosBox = new  QComboBox( );
 	vectPosBox->addItem(tr("Tail"));
 	vectPosBox->addItem(tr("Middle"));
 	vectPosBox->addItem(tr("Head"));
--- qtiplot-0.9.8.9.orig/qtiplot/src/table/SetColValuesDialog.cpp
+++ qtiplot-0.9.8.9/qtiplot/src/table/SetColValuesDialog.cpp
@@ -72,12 +72,12 @@ SetColValuesDialog::SetColValuesDialog(
 	hbox1->addWidget(end);
 
 	QGridLayout *gl1 = new QGridLayout();
-	functions = new QComboBox(false);
+	functions = new QComboBox();
 	functions->addItems(muParserScripting::functionsList(true));
 	gl1->addWidget(functions, 0, 0);
 	btnAddFunction = new QPushButton(tr( "Add function" ));
 	gl1->addWidget(btnAddFunction, 0, 1);
-	boxColumn = new QComboBox(false);
+	boxColumn = new QComboBox();
 	gl1->addWidget(boxColumn, 1, 0);
 	btnAddCol = new QPushButton(tr( "Add column" ));
 	gl1->addWidget(btnAddCol, 1, 1);
--- qtiplot-0.9.8.9.orig/qtiplot/src/table/TableDialog.cpp
+++ qtiplot-0.9.8.9/qtiplot/src/table/TableDialog.cpp
@@ -127,7 +127,7 @@ TableDialog::TableDialog(Table *t, QWidg
     labelFormat = new QLabel(tr( "Format:" ));
  	gl1->addWidget(labelFormat, 2, 0);
 
-    formatBox = new QComboBox(false);
+    formatBox = new QComboBox();
     gl1->addWidget(formatBox, 2, 1);
 
 	labelNumeric = new QLabel(tr( "Precision:" ));
         <location filename="../src/core/ApplicationWindow.cpp" line="4651"/>
         <location filename="../src/core/ApplicationWindow.cpp" line="5176"/>
-        <location filename="../src/core/ApplicationWindow.cpp" line="16494"/>
+        <location filename="../src/core/ApplicationWindow.cpp" line="16495"/>
         <source>The file: &lt;b&gt;%1&lt;/b&gt; doesn&apos;t exist!</source>
         <translation>文件：&lt;b&gt;%1&lt;/b&gt;不存在！</translation>
     </message>
