/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import net.sf.saxon.evpull.EndDocumentEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventStackIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.StartDocumentEvent;
import net.sf.saxon.trans.XPathException;

public class BracketedDocumentIterator
implements EventIterator {
    private StartDocumentEvent start;
    private EventIterator content;
    private EndDocumentEvent end;
    private int state = 0;
    private static final int INITIAL_STATE = 0;
    private static final int PROCESSING_CHILDREN = 1;
    private static final int EXHAUSTED = 2;

    public BracketedDocumentIterator(StartDocumentEvent start, EventIterator content, EndDocumentEvent end) {
        this.start = start;
        this.content = EventStackIterator.flatten(content);
        this.end = end;
        this.state = 0;
    }

    public PullEvent next() throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 1;
                return this.start;
            }
            case 1: {
                PullEvent pe = this.content.next();
                if (pe == null) {
                    this.state = 2;
                    return this.end;
                }
                return pe;
            }
            case 2: {
                return null;
            }
        }
        throw new AssertionError((Object)("BracketedDocumentIterator state " + this.state));
    }

    public boolean isFlatSequence() {
        return true;
    }
}

