/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.pack200.tests;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.harmony.pack200.BHSDCodec;
import org.apache.harmony.pack200.Codec;
import org.apache.harmony.pack200.Pack200Exception;
import org.apache.harmony.pack200.RunCodec;

/*
 * Exception performing whole class analysis ignored.
 */
public class CodecTest
extends TestCase {
    public void testInvalidCodings() {
        int i = 0;
        while (i < 256) {
            try {
                new BHSDCodec(1, i);
                CodecTest.fail((String)"b=1 -> h=256");
            }
            catch (IllegalArgumentException e) {
                CodecTest.assertTrue((boolean)true);
            }
            ++i;
        }
        i = 1;
        while (i <= 5) {
            try {
                new BHSDCodec(i, 256);
                if (i == 5) {
                    CodecTest.fail((String)"h=256 -> b!=5");
                }
            }
            catch (IllegalArgumentException e) {
                CodecTest.assertTrue((boolean)true);
            }
            ++i;
        }
    }

    public void testCodecToString() {
        CodecTest.assertEquals((String)"(1,256)", (String)Codec.BYTE1.toString());
        CodecTest.assertEquals((String)"(3,128)", (String)Codec.CHAR3.toString());
        CodecTest.assertEquals((String)"(5,4)", (String)Codec.BCI5.toString());
        CodecTest.assertEquals((String)"(5,4,2)", (String)Codec.BRANCH5.toString());
        CodecTest.assertEquals((String)"(5,64)", (String)Codec.UNSIGNED5.toString());
        CodecTest.assertEquals((String)"(5,64,1)", (String)Codec.SIGNED5.toString());
        CodecTest.assertEquals((String)"(5,64,0,1)", (String)Codec.UDELTA5.toString());
        CodecTest.assertEquals((String)"(5,64,1,1)", (String)Codec.DELTA5.toString());
        CodecTest.assertEquals((String)"(5,64,2,1)", (String)Codec.MDELTA5.toString());
        CodecTest.assertEquals((String)"(5,64)", (String)Codec.UNSIGNED5.toString());
        CodecTest.assertEquals((String)"(5,64,1)", (String)Codec.SIGNED5.toString());
        CodecTest.assertEquals((String)"(5,64,1,1)", (String)Codec.DELTA5.toString());
        CodecTest.assertEquals((String)"(5,64,2,1)", (String)Codec.MDELTA5.toString());
    }

    public void testByte1() throws Exception {
        int i = 0;
        while (i < 255) {
            this.decode((Codec)Codec.BYTE1, new byte[]{(byte)i}, (long)i, 0L);
            ++i;
        }
    }

    public void testByte1Delta() throws Exception {
        BHSDCodec BYTE1D = new BHSDCodec(1, 256, 0, 1);
        long last = 0L;
        int i = 1;
        while (i < 255) {
            last = this.decode((Codec)BYTE1D, new byte[]{1}, (long)i, last);
            ++i;
        }
    }

    public void testByte1DeltaException() throws Exception {
        BHSDCodec BYTE1D = new BHSDCodec(1, 256, 0, 1);
        try {
            BYTE1D.decode((InputStream)new ByteArrayInputStream(new byte[]{1}));
            CodecTest.fail((String)"Decoding with a delta stream and not passing a last value should throw exception");
        }
        catch (Pack200Exception e) {
            CodecTest.assertTrue((boolean)true);
        }
    }

    public void testByte1Signed() throws Exception {
        BHSDCodec BYTE1S2 = new BHSDCodec(1, 256, 2);
        this.decode((Codec)BYTE1S2, new byte[1], 0L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{1}, 1L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{2}, 2L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{3}, -1L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{4}, 3L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{5}, 4L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{6}, 5L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{7}, -2L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{8}, 6L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{9}, 7L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{10}, 8L, 0L);
        this.decode((Codec)BYTE1S2, new byte[]{11}, -3L, 0L);
    }

    public void testCardinality() throws Exception {
        BHSDCodec byte1 = Codec.BYTE1;
        CodecTest.assertEquals((long)256L, (long)byte1.cardinality());
        CodecTest.assertEquals((long)0L, (long)byte1.smallest());
        CodecTest.assertEquals((long)255L, (long)byte1.largest());
        CodecTest.assertFalse((boolean)byte1.encodes(-257L));
        CodecTest.assertFalse((boolean)byte1.encodes(-256L));
        CodecTest.assertFalse((boolean)byte1.encodes(-255L));
        CodecTest.assertFalse((boolean)byte1.encodes(-129L));
        CodecTest.assertFalse((boolean)byte1.encodes(-128L));
        CodecTest.assertFalse((boolean)byte1.encodes(-127L));
        CodecTest.assertFalse((boolean)byte1.encodes(-1L));
        CodecTest.assertTrue((boolean)byte1.encodes(0L));
        CodecTest.assertTrue((boolean)byte1.encodes(1L));
        CodecTest.assertTrue((boolean)byte1.encodes(255L));
        CodecTest.assertFalse((boolean)byte1.encodes(256L));
        BHSDCodec byte1s = new BHSDCodec(1, 256, 1);
        CodecTest.assertEquals((long)256L, (long)byte1s.cardinality());
        CodecTest.assertEquals((long)-128L, (long)byte1s.smallest());
        CodecTest.assertEquals((long)127L, (long)byte1s.largest());
        CodecTest.assertFalse((boolean)byte1s.encodes(-257L));
        CodecTest.assertFalse((boolean)byte1s.encodes(-256L));
        CodecTest.assertFalse((boolean)byte1s.encodes(-255L));
        CodecTest.assertFalse((boolean)byte1s.encodes(-129L));
        CodecTest.assertTrue((boolean)byte1s.encodes(-128L));
        CodecTest.assertTrue((boolean)byte1s.encodes(-127L));
        CodecTest.assertTrue((boolean)byte1s.encodes(-1L));
        CodecTest.assertTrue((boolean)byte1s.encodes(0L));
        CodecTest.assertTrue((boolean)byte1s.encodes(1L));
        CodecTest.assertTrue((boolean)byte1s.encodes(127L));
        CodecTest.assertFalse((boolean)byte1s.encodes(128L));
        CodecTest.assertFalse((boolean)byte1s.encodes(129L));
        CodecTest.assertFalse((boolean)byte1s.encodes(255L));
        CodecTest.assertFalse((boolean)byte1s.encodes(256L));
        BHSDCodec byte2s = new BHSDCodec(1, 256, 2);
        CodecTest.assertEquals((long)256L, (long)byte2s.cardinality());
        CodecTest.assertEquals((long)-64L, (long)byte2s.smallest());
        CodecTest.assertEquals((long)191L, (long)byte2s.largest());
        CodecTest.assertFalse((boolean)byte2s.encodes(-257L));
        CodecTest.assertFalse((boolean)byte2s.encodes(-256L));
        CodecTest.assertFalse((boolean)byte2s.encodes(-255L));
        CodecTest.assertFalse((boolean)byte2s.encodes(-129L));
        CodecTest.assertFalse((boolean)byte2s.encodes(-128L));
        CodecTest.assertFalse((boolean)byte2s.encodes(-127L));
        CodecTest.assertFalse((boolean)byte2s.encodes(-65L));
        CodecTest.assertTrue((boolean)byte2s.encodes(-64L));
        CodecTest.assertTrue((boolean)byte2s.encodes(-64L));
        CodecTest.assertTrue((boolean)byte2s.encodes(-1L));
        CodecTest.assertTrue((boolean)byte2s.encodes(0L));
        CodecTest.assertTrue((boolean)byte2s.encodes(1L));
        CodecTest.assertTrue((boolean)byte2s.encodes(127L));
        CodecTest.assertTrue((boolean)byte2s.encodes(128L));
        CodecTest.assertTrue((boolean)byte2s.encodes(191L));
        CodecTest.assertFalse((boolean)byte2s.encodes(192L));
        CodecTest.assertFalse((boolean)byte2s.encodes(256L));
    }

    public void testRunCodec() throws Exception {
        RunCodec runCodec = new RunCodec(1, (Codec)Codec.UNSIGNED5, (Codec)Codec.BYTE1);
        byte[] byArray = new byte[4];
        byArray[0] = -64;
        byArray[2] = -64;
        ByteArrayInputStream bais = new ByteArrayInputStream(byArray);
        CodecTest.assertEquals((long)192L, (long)runCodec.decode((InputStream)bais));
        CodecTest.assertEquals((long)192L, (long)runCodec.decode((InputStream)bais));
        CodecTest.assertEquals((long)0L, (long)runCodec.decode((InputStream)bais));
        CodecTest.assertEquals((int)0, (int)bais.available());
        runCodec = new RunCodec(1, (Codec)Codec.BYTE1, (Codec)Codec.UNSIGNED5);
        byte[] byArray2 = new byte[4];
        byArray2[0] = -64;
        byArray2[2] = -64;
        bais = new ByteArrayInputStream(byArray2);
        CodecTest.assertEquals((long)192L, (long)runCodec.decode((InputStream)bais));
        CodecTest.assertEquals((long)0L, (long)runCodec.decode((InputStream)bais));
        CodecTest.assertEquals((long)192L, (long)runCodec.decode((InputStream)bais));
        CodecTest.assertEquals((int)0, (int)bais.available());
    }

    public void testUnsigned5() throws Exception {
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{1}, 1L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-65}, 191L, 0L);
        byte[] byArray = new byte[2];
        byArray[0] = -64;
        this.decode((Codec)Codec.UNSIGNED5, byArray, 192L, 0L);
        byte[] byArray2 = new byte[2];
        byArray2[0] = -63;
        this.decode((Codec)Codec.UNSIGNED5, byArray2, 193L, 0L);
        byte[] byArray3 = new byte[2];
        byArray3[0] = -1;
        this.decode((Codec)Codec.UNSIGNED5, byArray3, 255L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-64, 1}, 256L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-64, 5}, 512L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-64, 13}, 1024L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-64, 29}, 2048L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-1, -65}, 12479L, 0L);
        byte[] byArray4 = new byte[3];
        byArray4[0] = -64;
        byArray4[1] = -64;
        this.decode((Codec)Codec.UNSIGNED5, byArray4, 12480L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-1, -1, -65}, 798911L, 0L);
        byte[] byArray5 = new byte[4];
        byArray5[0] = -64;
        byArray5[1] = -64;
        byArray5[2] = -64;
        this.decode((Codec)Codec.UNSIGNED5, byArray5, 798912L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-1, -1, -1, -65}, 51130559L, 0L);
        byte[] byArray6 = new byte[5];
        byArray6[0] = -64;
        byArray6[1] = -64;
        byArray6[2] = -64;
        byArray6[3] = -64;
        this.decode((Codec)Codec.UNSIGNED5, byArray6, 0x30C30C0L, 0L);
        this.decode((Codec)Codec.UNSIGNED5, new byte[]{-1, -4, -4, -4, -4}, 0xFFFFFFFFL, 0L);
        this.decodeFail((Codec)Codec.UNSIGNED5, new byte[]{-64});
        this.decodeFail((Codec)Codec.UNSIGNED5, new byte[]{-64, -64});
        this.decodeFail((Codec)Codec.UNSIGNED5, new byte[]{-64, -64, -64});
        this.decodeFail((Codec)Codec.UNSIGNED5, new byte[]{-64, -64, -64, -64});
    }

    private void decodeFail(Codec codec, byte[] data) throws IOException, Pack200Exception {
        try {
            this.decode(codec, data, 0L, 0L);
            CodecTest.fail((String)"Should have detected an EOFException");
        }
        catch (EOFException e) {
            CodecTest.assertTrue((boolean)true);
        }
    }

    private long decode(Codec codec, byte[] data, long value, long last) throws IOException, Pack200Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        CodecTest.assertEquals((long)value, (long)codec.decode((InputStream)in, last));
        CodecTest.assertEquals((int)-1, (int)in.read());
        return value;
    }
}

