/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

import java.io.IOException;
import java.io.OutputStream;

/**
 * Specifies methods for an HTTP client.
 * Methods must be called in specific order for a successful HTTP
 * exchange to take place.  The order of calls that must be made:
 * <ul>
 * <li>{@link #writeRequest}</li>
 * <li>{@link #getOutputStream}</li>
 * <li>{@link #readResponse}</li>
 * </ul>
 * If the HTTP server and client are <code>HTTP/1.1</code>, then
 * of course the same output and input stream can be re-used.
 */
public interface HttpClient
{
	/**
	 * Sends the first part of a <code>Request</code> message,
	 * consisting of a request line and headers.
	 * The message body may be sent in one of two ways: 
	 * <ol>
	 * <li> By returning a {@link DataPoster} in the client request
	 * object.
	 * <li> Or, by using the stream returned by {@link #getOutputStream}.
	 * </ol>
	 *
	 * @throws IllegalHttpStateException if the request was already sent
	 * and the response was not yet read
	 */
	void writeRequest(ClientRequest request)
		throws IOException;

	/**
	 * Returns a stream for writing data to, if data is to be sent to the
	 * server.  For some HTTP methods, like <code>GET</code>, calling this
	 * method of course makes little sense.  Data must be sent if
	 * content-length or transfer encoding headers were sent.
	 * This stream should be wrapped to control output based on the
	 * headers specified in the request.
	 *
	 * @throws IllegalHttpStateException if the request was not yet sent
	 * or the response was already read, data was sent with a
	 * <code>DataPoster<code>, or this method was already called
	 */
	OutputStream getOutputStream();

	/**
	 * Reads the response data from the HTTP server.
	 * This commits the output stream and reads the response from the input
	 * stream.  If data is being sent by the HTTP server, it must be
	 * read fully before another request can be accepted.
	 *
	 * @throws IllegalHttpStateException if the request was not yet sent
	 * @throws HttpException if the server returned an invalid HTTP
	 * response
	 */
	ClientResponse readResponse()
		throws IOException;

	/**
	 * Closes any underlying sockets or streams.
	 * May optionally release other sorts of allocated resources.
	 */
	void close()
		throws IOException;

}
