/* Copyright (C) 2016 D. V. Wiebe
 *
 ***************************************************************************
 *
 * This file is part of the GetData project.
 *
 * GetData is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * GetData is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with GetData; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "test.h"

int main(void)
{
  const char *filedir = "dirfile";
  const char *format = "dirfile/format";
  int e1, e2, e3, e4, e5, r = 0;
  gd_type_t t1;
  DIRFILE *D;
  gd_entry_t E;

  rmdirfile();
  mkdir(filedir, 0700);

  MAKEFORMATFILE(format, "data RAW COMPLEX128 1\n");

  D = gd_open(filedir, GD_RDWR | GD_VERBOSE);
  e1 = gd_add_spec(D, "real LINCOM data.r 1 0", 0);
  CHECKI(e1, 0);
  e2 = gd_add_spec(D, "complex LINCOM data.z 1 0", 0);
  CHECKI(e2, 0);

  e3 = gd_close(D);
  CHECKI(e3, 0);

  D = gd_open(filedir, GD_RDONLY | GD_VERBOSE);
  t1 = gd_native_type(D, "real");
  CHECKI(t1, GD_FLOAT64);
  t1 = gd_native_type(D, "complex");
  CHECKI(t1, GD_COMPLEX128);

  e4 = gd_entry(D, "real", &E);
  CHECKI(e4, 0);
  CHECKS(E.in_fields[0], "data.r");
  gd_free_entry_strings(&E);

  e5 = gd_entry(D, "complex", &E);
  CHECKI(e5, 0);
  CHECKS(E.in_fields[0], "data");
  gd_free_entry_strings(&E);

  gd_discard(D);

  unlink(format);
  rmdir(filedir);

  return r;
}
