/* gcomment.c generated by valac, the Vala compiler
 * generated from gcomment.vala, do not modify */

/* gcomment.vala
 *
 * Copyright (C) 2010 Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <valagee.h>
#include <valadoc.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GTKDOC_TYPE_HEADER (gtkdoc_header_get_type ())
#define GTKDOC_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_HEADER, GtkdocHeader))
#define GTKDOC_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))
#define GTKDOC_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_HEADER))
#define GTKDOC_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_HEADER))
#define GTKDOC_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))

typedef struct _GtkdocHeader GtkdocHeader;
typedef struct _GtkdocHeaderClass GtkdocHeaderClass;
typedef struct _GtkdocHeaderPrivate GtkdocHeaderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GtkdocParamSpecHeader GtkdocParamSpecHeader;

#define GTKDOC_TYPE_GCOMMENT (gtkdoc_gcomment_get_type ())
#define GTKDOC_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGComment))
#define GTKDOC_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))
#define GTKDOC_IS_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_IS_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_GCOMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))

typedef struct _GtkdocGComment GtkdocGComment;
typedef struct _GtkdocGCommentClass GtkdocGCommentClass;
typedef struct _GtkdocGCommentPrivate GtkdocGCommentPrivate;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _gtkdoc_header_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_header_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GtkdocParamSpecGComment GtkdocParamSpecGComment;

struct _GtkdocHeader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* name;
	gchar** annotations;
	gint annotations_length1;
	gchar* value;
	gdouble pos;
	gboolean block;
	GtkdocHeaderPrivate * priv;
};

struct _GtkdocHeaderClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocHeader *self);
};

struct _GtkdocParamSpecHeader {
	GParamSpec parent_instance;
};

struct _GtkdocGComment {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* symbol;
	gchar** symbol_annotations;
	gint symbol_annotations_length1;
	ValaList* headers;
	gboolean short_description;
	gchar* brief_comment;
	gchar* long_comment;
	gchar* returns;
	gchar** returns_annotations;
	gint returns_annotations_length1;
	ValaList* versioning;
	gchar** see_also;
	gint see_also_length1;
	gboolean is_section;
	GtkdocGCommentPrivate * priv;
};

struct _GtkdocGCommentClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocGComment *self);
};

struct _GtkdocParamSpecGComment {
	GParamSpec parent_instance;
};

static gpointer gtkdoc_header_parent_class = NULL;
static gpointer gtkdoc_gcomment_parent_class = NULL;

VALA_EXTERN gpointer gtkdoc_header_ref (gpointer instance);
VALA_EXTERN void gtkdoc_header_unref (gpointer instance);
VALA_EXTERN GParamSpec* gtkdoc_param_spec_header (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void gtkdoc_value_set_header (GValue* value,
                              gpointer v_object);
VALA_EXTERN void gtkdoc_value_take_header (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer gtkdoc_value_get_header (const GValue* value);
VALA_EXTERN GType gtkdoc_header_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocHeader, gtkdoc_header_unref)
VALA_EXTERN GtkdocHeader* gtkdoc_header_new (const gchar* name,
                                 const gchar* value,
                                 gdouble pos,
                                 gboolean block);
VALA_EXTERN GtkdocHeader* gtkdoc_header_construct (GType object_type,
                                       const gchar* name,
                                       const gchar* value,
                                       gdouble pos,
                                       gboolean block);
VALA_EXTERN gint gtkdoc_header_cmp (GtkdocHeader* self,
                        GtkdocHeader* header);
static void gtkdoc_header_finalize (GtkdocHeader * obj);
static GType gtkdoc_header_get_type_once (void);
VALA_EXTERN gpointer gtkdoc_gcomment_ref (gpointer instance);
VALA_EXTERN void gtkdoc_gcomment_unref (gpointer instance);
VALA_EXTERN GParamSpec* gtkdoc_param_spec_gcomment (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void gtkdoc_value_set_gcomment (GValue* value,
                                gpointer v_object);
VALA_EXTERN void gtkdoc_value_take_gcomment (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer gtkdoc_value_get_gcomment (const GValue* value);
VALA_EXTERN GType gtkdoc_gcomment_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocGComment, gtkdoc_gcomment_unref)
VALA_EXTERN gchar* gtkdoc_gcomment_to_string (GtkdocGComment* self);
VALA_EXTERN gchar* gtkdoc_commentize (const gchar* comment);
VALA_EXTERN gchar* gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                                   ValadocErrorReporter* reporter);
VALA_EXTERN GtkdocGComment* gtkdoc_gcomment_new (void);
VALA_EXTERN GtkdocGComment* gtkdoc_gcomment_construct (GType object_type);
static void gtkdoc_gcomment_finalize (GtkdocGComment * obj);
static GType gtkdoc_gcomment_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

GtkdocHeader*
gtkdoc_header_construct (GType object_type,
                         const gchar* name,
                         const gchar* value,
                         gdouble pos,
                         gboolean block)
{
	GtkdocHeader* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GtkdocHeader*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup (value);
	_g_free0 (self->value);
	self->value = _tmp1_;
	self->pos = pos;
	self->block = block;
	return self;
}

GtkdocHeader*
gtkdoc_header_new (const gchar* name,
                   const gchar* value,
                   gdouble pos,
                   gboolean block)
{
	return gtkdoc_header_construct (GTKDOC_TYPE_HEADER, name, value, pos, block);
}

gint
gtkdoc_header_cmp (GtkdocHeader* self,
                   GtkdocHeader* header)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (header != NULL, 0);
	if (self->pos > header->pos) {
		result = 1;
		return result;
	} else {
		if (self->pos < header->pos) {
			result = -1;
			return result;
		}
	}
	result = 0;
	return result;
}

static void
gtkdoc_value_header_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_value_header_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_header_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_value_header_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_header_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_value_header_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_value_header_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocHeader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_header_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_value_header_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	GtkdocHeader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_header_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_param_spec_header (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	GtkdocParamSpecHeader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_TYPE_HEADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_value_get_header (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_value_set_header (GValue* value,
                         gpointer v_object)
{
	GtkdocHeader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_HEADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_header_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_header_unref (old);
	}
}

void
gtkdoc_value_take_header (GValue* value,
                          gpointer v_object)
{
	GtkdocHeader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_HEADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_HEADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_header_unref (old);
	}
}

static void
gtkdoc_header_class_init (GtkdocHeaderClass * klass,
                          gpointer klass_data)
{
	gtkdoc_header_parent_class = g_type_class_peek_parent (klass);
	((GtkdocHeaderClass *) klass)->finalize = gtkdoc_header_finalize;
}

static void
gtkdoc_header_instance_init (GtkdocHeader * self,
                             gpointer klass)
{
	self->ref_count = 1;
}

static void
gtkdoc_header_finalize (GtkdocHeader * obj)
{
	GtkdocHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_HEADER, GtkdocHeader);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	self->annotations = (_vala_array_free (self->annotations, self->annotations_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->value);
}

static GType
gtkdoc_header_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gtkdoc_value_header_init, gtkdoc_value_header_free_value, gtkdoc_value_header_copy_value, gtkdoc_value_header_peek_pointer, "p", gtkdoc_value_header_collect_value, "p", gtkdoc_value_header_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GtkdocHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocHeader), 0, (GInstanceInitFunc) gtkdoc_header_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gtkdoc_header_type_id;
	gtkdoc_header_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocHeader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gtkdoc_header_type_id;
}

GType
gtkdoc_header_get_type (void)
{
	static volatile gsize gtkdoc_header_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_header_type_id__volatile)) {
		GType gtkdoc_header_type_id;
		gtkdoc_header_type_id = gtkdoc_header_get_type_once ();
		g_once_init_leave (&gtkdoc_header_type_id__volatile, gtkdoc_header_type_id);
	}
	return gtkdoc_header_type_id__volatile;
}

gpointer
gtkdoc_header_ref (gpointer instance)
{
	GtkdocHeader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_header_unref (gpointer instance)
{
	GtkdocHeader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_HEADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

gchar*
gtkdoc_gcomment_to_string (GtkdocGComment* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GString* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gboolean _tmp13_ = FALSE;
	ValaList* _tmp19_;
	gboolean _tmp50_ = FALSE;
	const gchar* _tmp56_;
	gchar** _tmp61_;
	gint _tmp61__length1;
	gboolean _tmp66_ = FALSE;
	const gchar* _tmp67_;
	ValaList* _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	GString* _tmp105_;
	GString* _tmp106_;
	const gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	if (self->is_section) {
		_tmp1_ = "SECTION:%s";
	} else {
		_tmp1_ = "%s:";
	}
	_tmp2_ = builder;
	_tmp3_ = self->symbol;
	_tmp4_ = g_strdup_printf (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	g_string_append_printf (_tmp2_, "/**\n * %s", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp7_ = self->symbol_annotations;
	_tmp7__length1 = self->symbol_annotations_length1;
	if (_tmp7_ != NULL) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp8_ = self->symbol_annotations;
		_tmp8__length1 = self->symbol_annotations_length1;
		_tmp6_ = _tmp8__length1 > 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = self->symbol_annotations;
		_tmp9__length1 = self->symbol_annotations_length1;
		{
			gchar** annotation_collection = NULL;
			gint annotation_collection_length1 = 0;
			gint _annotation_collection_size_ = 0;
			gint annotation_it = 0;
			annotation_collection = _tmp9_;
			annotation_collection_length1 = _tmp9__length1;
			for (annotation_it = 0; annotation_it < annotation_collection_length1; annotation_it = annotation_it + 1) {
				gchar* _tmp10_;
				gchar* annotation = NULL;
				_tmp10_ = g_strdup (annotation_collection[annotation_it]);
				annotation = _tmp10_;
				{
					GString* _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = builder;
					_tmp12_ = annotation;
					g_string_append_printf (_tmp11_, " (%s)", _tmp12_);
					_g_free0 (annotation);
				}
			}
		}
	}
	if (self->short_description) {
		const gchar* _tmp14_;
		_tmp14_ = self->brief_comment;
		_tmp13_ = _tmp14_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GString* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp15_ = builder;
		_tmp16_ = self->brief_comment;
		_tmp17_ = gtkdoc_commentize (_tmp16_);
		_tmp18_ = _tmp17_;
		g_string_append_printf (_tmp15_, "\n * @short_description: %s", _tmp18_);
		_g_free0 (_tmp18_);
	}
	_tmp19_ = self->headers;
	vala_list_sort (_tmp19_, (GCompareDataFunc) gtkdoc_header_cmp, NULL, NULL);
	{
		ValaList* _header_list = NULL;
		ValaList* _tmp20_;
		gint _header_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _header_index = 0;
		_tmp20_ = self->headers;
		_header_list = _tmp20_;
		_tmp21_ = _header_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_header_size = _tmp23_;
		_header_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			GtkdocHeader* header = NULL;
			ValaList* _tmp26_;
			gpointer _tmp27_;
			GString* _tmp28_;
			GtkdocHeader* _tmp29_;
			const gchar* _tmp30_;
			gboolean _tmp31_ = FALSE;
			GtkdocHeader* _tmp32_;
			gchar** _tmp33_;
			gint _tmp33__length1;
			GtkdocHeader* _tmp42_;
			const gchar* _tmp43_;
			_header_index = _header_index + 1;
			_tmp24_ = _header_index;
			_tmp25_ = _header_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _header_list;
			_tmp27_ = vala_list_get (_tmp26_, _header_index);
			header = (GtkdocHeader*) _tmp27_;
			_tmp28_ = builder;
			_tmp29_ = header;
			_tmp30_ = _tmp29_->name;
			g_string_append_printf (_tmp28_, "\n * @%s:", _tmp30_);
			_tmp32_ = header;
			_tmp33_ = _tmp32_->annotations;
			_tmp33__length1 = _tmp32_->annotations_length1;
			if (_tmp33_ != NULL) {
				GtkdocHeader* _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				_tmp34_ = header;
				_tmp35_ = _tmp34_->annotations;
				_tmp35__length1 = _tmp34_->annotations_length1;
				_tmp31_ = _tmp35__length1 > 0;
			} else {
				_tmp31_ = FALSE;
			}
			if (_tmp31_) {
				GtkdocHeader* _tmp36_;
				gchar** _tmp37_;
				gint _tmp37__length1;
				GString* _tmp41_;
				_tmp36_ = header;
				_tmp37_ = _tmp36_->annotations;
				_tmp37__length1 = _tmp36_->annotations_length1;
				{
					gchar** annotation_collection = NULL;
					gint annotation_collection_length1 = 0;
					gint _annotation_collection_size_ = 0;
					gint annotation_it = 0;
					annotation_collection = _tmp37_;
					annotation_collection_length1 = _tmp37__length1;
					for (annotation_it = 0; annotation_it < annotation_collection_length1; annotation_it = annotation_it + 1) {
						gchar* _tmp38_;
						gchar* annotation = NULL;
						_tmp38_ = g_strdup (annotation_collection[annotation_it]);
						annotation = _tmp38_;
						{
							GString* _tmp39_;
							const gchar* _tmp40_;
							_tmp39_ = builder;
							_tmp40_ = annotation;
							g_string_append_printf (_tmp39_, " (%s)", _tmp40_);
							_g_free0 (annotation);
						}
					}
				}
				_tmp41_ = builder;
				g_string_append_c (_tmp41_, ':');
			}
			_tmp42_ = header;
			_tmp43_ = _tmp42_->value;
			if (_tmp43_ != NULL) {
				GString* _tmp44_;
				GString* _tmp45_;
				GtkdocHeader* _tmp46_;
				const gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				_tmp44_ = builder;
				g_string_append_c (_tmp44_, ' ');
				_tmp45_ = builder;
				_tmp46_ = header;
				_tmp47_ = _tmp46_->value;
				_tmp48_ = gtkdoc_commentize (_tmp47_);
				_tmp49_ = _tmp48_;
				g_string_append (_tmp45_, _tmp49_);
				_g_free0 (_tmp49_);
			}
			_gtkdoc_header_unref0 (header);
		}
	}
	if (!self->short_description) {
		const gchar* _tmp51_;
		_tmp51_ = self->brief_comment;
		_tmp50_ = _tmp51_ != NULL;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		GString* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp52_ = builder;
		_tmp53_ = self->brief_comment;
		_tmp54_ = gtkdoc_commentize (_tmp53_);
		_tmp55_ = _tmp54_;
		g_string_append_printf (_tmp52_, "\n * \n * %s", _tmp55_);
		_g_free0 (_tmp55_);
	}
	_tmp56_ = self->long_comment;
	if (_tmp56_ != NULL) {
		GString* _tmp57_;
		const gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp57_ = builder;
		_tmp58_ = self->long_comment;
		_tmp59_ = gtkdoc_commentize (_tmp58_);
		_tmp60_ = _tmp59_;
		g_string_append_printf (_tmp57_, "\n * \n * %s", _tmp60_);
		_g_free0 (_tmp60_);
	}
	_tmp61_ = self->see_also;
	_tmp61__length1 = self->see_also_length1;
	if (_tmp61__length1 > 0) {
		GString* _tmp62_;
		gchar** _tmp63_;
		gint _tmp63__length1;
		gchar* _tmp64_;
		gchar* _tmp65_;
		_tmp62_ = builder;
		_tmp63_ = self->see_also;
		_tmp63__length1 = self->see_also_length1;
		_tmp64_ = _vala_g_strjoinv (", ", _tmp63_, (gint) _tmp63__length1);
		_tmp65_ = _tmp64_;
		g_string_append_printf (_tmp62_, "\n * \n * <emphasis>See also</emphasis>: %s", _tmp65_);
		_g_free0 (_tmp65_);
	}
	_tmp67_ = self->returns;
	if (_tmp67_ != NULL) {
		_tmp66_ = TRUE;
	} else {
		gchar** _tmp68_;
		gint _tmp68__length1;
		_tmp68_ = self->returns_annotations;
		_tmp68__length1 = self->returns_annotations_length1;
		_tmp66_ = _tmp68__length1 > 0;
	}
	if (_tmp66_) {
		GString* _tmp69_;
		gchar** _tmp70_;
		gint _tmp70__length1;
		GString* _tmp77_;
		const gchar* _tmp78_;
		_tmp69_ = builder;
		g_string_append (_tmp69_, "\n * \n * Returns:");
		_tmp70_ = self->returns_annotations;
		_tmp70__length1 = self->returns_annotations_length1;
		if (_tmp70_ != NULL) {
			gchar** _tmp71_;
			gint _tmp71__length1;
			gchar** _tmp75_;
			gint _tmp75__length1;
			_tmp71_ = self->returns_annotations;
			_tmp71__length1 = self->returns_annotations_length1;
			{
				gchar** annotation_collection = NULL;
				gint annotation_collection_length1 = 0;
				gint _annotation_collection_size_ = 0;
				gint annotation_it = 0;
				annotation_collection = _tmp71_;
				annotation_collection_length1 = _tmp71__length1;
				for (annotation_it = 0; annotation_it < annotation_collection_length1; annotation_it = annotation_it + 1) {
					gchar* _tmp72_;
					gchar* annotation = NULL;
					_tmp72_ = g_strdup (annotation_collection[annotation_it]);
					annotation = _tmp72_;
					{
						GString* _tmp73_;
						const gchar* _tmp74_;
						_tmp73_ = builder;
						_tmp74_ = annotation;
						g_string_append_printf (_tmp73_, " (%s)", _tmp74_);
						_g_free0 (annotation);
					}
				}
			}
			_tmp75_ = self->returns_annotations;
			_tmp75__length1 = self->returns_annotations_length1;
			if (_tmp75__length1 > 0) {
				GString* _tmp76_;
				_tmp76_ = builder;
				g_string_append_c (_tmp76_, ':');
			}
		}
		_tmp77_ = builder;
		g_string_append_c (_tmp77_, ' ');
		_tmp78_ = self->returns;
		if (_tmp78_ != NULL) {
			GString* _tmp79_;
			const gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			_tmp79_ = builder;
			_tmp80_ = self->returns;
			_tmp81_ = gtkdoc_commentize (_tmp80_);
			_tmp82_ = _tmp81_;
			g_string_append (_tmp79_, _tmp82_);
			_g_free0 (_tmp82_);
		}
	}
	_tmp83_ = self->versioning;
	_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
	_tmp85_ = _tmp84_;
	if (_tmp85_ > 0) {
		GString* _tmp86_;
		_tmp86_ = builder;
		g_string_append (_tmp86_, "\n *");
		{
			ValaList* _version_list = NULL;
			ValaList* _tmp87_;
			gint _version_size = 0;
			ValaList* _tmp88_;
			gint _tmp89_;
			gint _tmp90_;
			gint _version_index = 0;
			_tmp87_ = self->versioning;
			_version_list = _tmp87_;
			_tmp88_ = _version_list;
			_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
			_tmp90_ = _tmp89_;
			_version_size = _tmp90_;
			_version_index = -1;
			while (TRUE) {
				gint _tmp91_;
				gint _tmp92_;
				GtkdocHeader* version = NULL;
				ValaList* _tmp93_;
				gpointer _tmp94_;
				GString* _tmp95_;
				GtkdocHeader* _tmp96_;
				const gchar* _tmp97_;
				GtkdocHeader* _tmp98_;
				const gchar* _tmp99_;
				_version_index = _version_index + 1;
				_tmp91_ = _version_index;
				_tmp92_ = _version_size;
				if (!(_tmp91_ < _tmp92_)) {
					break;
				}
				_tmp93_ = _version_list;
				_tmp94_ = vala_list_get (_tmp93_, _version_index);
				version = (GtkdocHeader*) _tmp94_;
				_tmp95_ = builder;
				_tmp96_ = version;
				_tmp97_ = _tmp96_->name;
				g_string_append_printf (_tmp95_, "\n * %s:", _tmp97_);
				_tmp98_ = version;
				_tmp99_ = _tmp98_->value;
				if (_tmp99_ != NULL) {
					GString* _tmp100_;
					GtkdocHeader* _tmp101_;
					const gchar* _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					_tmp100_ = builder;
					_tmp101_ = version;
					_tmp102_ = _tmp101_->value;
					_tmp103_ = gtkdoc_commentize (_tmp102_);
					_tmp104_ = _tmp103_;
					g_string_append_printf (_tmp100_, " %s", _tmp104_);
					_g_free0 (_tmp104_);
				}
				_gtkdoc_header_unref0 (version);
			}
		}
	}
	_tmp105_ = builder;
	g_string_append (_tmp105_, "\n */");
	_tmp106_ = builder;
	_tmp107_ = _tmp106_->str;
	_tmp108_ = g_strdup (_tmp107_);
	result = _tmp108_;
	_g_string_free0 (builder);
	return result;
}

gchar*
gtkdoc_gcomment_to_docbook (GtkdocGComment* self,
                            ValadocErrorReporter* reporter)
{
	gchar* deprecated = NULL;
	gchar* since = NULL;
	GString* builder = NULL;
	GString* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp25_;
	const gchar* _tmp28_;
	ValaList* _tmp31_;
	gboolean _tmp32_ = FALSE;
	ValaList* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	const gchar* _tmp55_;
	GString* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	deprecated = NULL;
	since = NULL;
	{
		ValaList* _header_list = NULL;
		ValaList* _tmp0_;
		gint _header_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _header_index = 0;
		_tmp0_ = self->versioning;
		_header_list = _tmp0_;
		_tmp1_ = _header_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_header_size = _tmp3_;
		_header_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GtkdocHeader* header = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			GtkdocHeader* _tmp8_;
			const gchar* _tmp9_;
			_header_index = _header_index + 1;
			_tmp4_ = _header_index;
			_tmp5_ = _header_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _header_list;
			_tmp7_ = vala_list_get (_tmp6_, _header_index);
			header = (GtkdocHeader*) _tmp7_;
			_tmp8_ = header;
			_tmp9_ = _tmp8_->name;
			if (g_strcmp0 (_tmp9_, "Deprecated") == 0) {
				GtkdocHeader* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp10_ = header;
				_tmp11_ = _tmp10_->value;
				_tmp12_ = g_strdup (_tmp11_);
				_g_free0 (deprecated);
				deprecated = _tmp12_;
			} else {
				GtkdocHeader* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = header;
				_tmp14_ = _tmp13_->name;
				if (g_strcmp0 (_tmp14_, "Since") == 0) {
					GtkdocHeader* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp15_ = header;
					_tmp16_ = _tmp15_->value;
					_tmp17_ = g_strdup (_tmp16_);
					_g_free0 (since);
					since = _tmp17_;
				} else {
					GtkdocHeader* _tmp18_;
					const gchar* _tmp19_;
					_tmp18_ = header;
					_tmp19_ = _tmp18_->name;
					valadoc_error_reporter_simple_warning (reporter, "GtkDoc", "Unknown versioning tag '%s'", _tmp19_);
				}
			}
			_gtkdoc_header_unref0 (header);
		}
	}
	_tmp20_ = g_string_new ("");
	builder = _tmp20_;
	_tmp21_ = deprecated;
	if (_tmp21_ != NULL) {
		GString* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp22_ = builder;
		_tmp23_ = self->symbol;
		_tmp24_ = deprecated;
		g_string_append_printf (_tmp22_, "<warning><para><literal>%s</literal> is deprecated and should not be u" \
"sed in newly-written code. %s</para></warning>", _tmp23_, _tmp24_);
	}
	_tmp25_ = self->brief_comment;
	if (_tmp25_ != NULL) {
		GString* _tmp26_;
		const gchar* _tmp27_;
		_tmp26_ = builder;
		_tmp27_ = self->brief_comment;
		g_string_append_printf (_tmp26_, "<para>%s</para>", _tmp27_);
	}
	_tmp28_ = self->long_comment;
	if (_tmp28_ != NULL) {
		GString* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = builder;
		_tmp30_ = self->long_comment;
		g_string_append (_tmp29_, _tmp30_);
	}
	_tmp31_ = self->headers;
	vala_list_sort (_tmp31_, (GCompareDataFunc) gtkdoc_header_cmp, NULL, NULL);
	_tmp33_ = self->headers;
	_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_ > 0) {
		_tmp32_ = TRUE;
	} else {
		const gchar* _tmp36_;
		_tmp36_ = self->returns;
		_tmp32_ = _tmp36_ != NULL;
	}
	if (_tmp32_) {
		GString* _tmp37_;
		const gchar* _tmp51_;
		GString* _tmp54_;
		_tmp37_ = builder;
		g_string_append (_tmp37_, "<variablelist role=\"params\">");
		{
			ValaList* _header_list = NULL;
			ValaList* _tmp38_;
			gint _header_size = 0;
			ValaList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _header_index = 0;
			_tmp38_ = self->headers;
			_header_list = _tmp38_;
			_tmp39_ = _header_list;
			_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_header_size = _tmp41_;
			_header_index = -1;
			while (TRUE) {
				gint _tmp42_;
				gint _tmp43_;
				GtkdocHeader* header = NULL;
				ValaList* _tmp44_;
				gpointer _tmp45_;
				GString* _tmp46_;
				GtkdocHeader* _tmp47_;
				const gchar* _tmp48_;
				GtkdocHeader* _tmp49_;
				const gchar* _tmp50_;
				_header_index = _header_index + 1;
				_tmp42_ = _header_index;
				_tmp43_ = _header_size;
				if (!(_tmp42_ < _tmp43_)) {
					break;
				}
				_tmp44_ = _header_list;
				_tmp45_ = vala_list_get (_tmp44_, _header_index);
				header = (GtkdocHeader*) _tmp45_;
				_tmp46_ = builder;
				_tmp47_ = header;
				_tmp48_ = _tmp47_->name;
				_tmp49_ = header;
				_tmp50_ = _tmp49_->value;
				g_string_append_printf (_tmp46_, "<varlistentry><term><parameter>%s</parameter>&#160;:</term>\n" \
"<listitem><simpara> %s </simpara></listitem></varlistentry>", _tmp48_, _tmp50_);
				_gtkdoc_header_unref0 (header);
			}
		}
		_tmp51_ = self->returns;
		if (_tmp51_ != NULL) {
			GString* _tmp52_;
			const gchar* _tmp53_;
			_tmp52_ = builder;
			_tmp53_ = self->returns;
			g_string_append_printf (_tmp52_, "<varlistentry><term><emphasis>Returns</emphasis>&#160;:</term>\n" \
"<listitem><simpara> %s </simpara></listitem></varlistentry>", _tmp53_);
		}
		_tmp54_ = builder;
		g_string_append (_tmp54_, "</variablelist>");
	}
	_tmp55_ = since;
	if (_tmp55_ != NULL) {
		GString* _tmp56_;
		const gchar* _tmp57_;
		_tmp56_ = builder;
		_tmp57_ = since;
		g_string_append_printf (_tmp56_, "<para role=\"since\">Since %s</para>", _tmp57_);
	}
	_tmp58_ = builder;
	_tmp59_ = _tmp58_->str;
	_tmp60_ = g_strdup (_tmp59_);
	result = _tmp60_;
	_g_string_free0 (builder);
	_g_free0 (since);
	_g_free0 (deprecated);
	return result;
}

GtkdocGComment*
gtkdoc_gcomment_construct (GType object_type)
{
	GtkdocGComment* self = NULL;
	self = (GtkdocGComment*) g_type_create_instance (object_type);
	return self;
}

GtkdocGComment*
gtkdoc_gcomment_new (void)
{
	return gtkdoc_gcomment_construct (GTKDOC_TYPE_GCOMMENT);
}

static void
gtkdoc_value_gcomment_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_value_gcomment_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_gcomment_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_value_gcomment_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_gcomment_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_value_gcomment_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_value_gcomment_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocGComment * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_gcomment_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_value_gcomment_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	GtkdocGComment ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_gcomment_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_param_spec_gcomment (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	GtkdocParamSpecGComment* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_TYPE_GCOMMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_value_get_gcomment (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_value_set_gcomment (GValue* value,
                           gpointer v_object)
{
	GtkdocGComment * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_GCOMMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_gcomment_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_gcomment_unref (old);
	}
}

void
gtkdoc_value_take_gcomment (GValue* value,
                            gpointer v_object)
{
	GtkdocGComment * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_GCOMMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_GCOMMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_gcomment_unref (old);
	}
}

static void
gtkdoc_gcomment_class_init (GtkdocGCommentClass * klass,
                            gpointer klass_data)
{
	gtkdoc_gcomment_parent_class = g_type_class_peek_parent (klass);
	((GtkdocGCommentClass *) klass)->finalize = gtkdoc_gcomment_finalize;
}

static void
gtkdoc_gcomment_instance_init (GtkdocGComment * self,
                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp0_);
	self->headers = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp2_);
	self->versioning = (ValaList*) _tmp3_;
	self->ref_count = 1;
}

static void
gtkdoc_gcomment_finalize (GtkdocGComment * obj)
{
	GtkdocGComment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_GCOMMENT, GtkdocGComment);
	g_signal_handlers_destroy (self);
	_g_free0 (self->symbol);
	self->symbol_annotations = (_vala_array_free (self->symbol_annotations, self->symbol_annotations_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->headers);
	_g_free0 (self->brief_comment);
	_g_free0 (self->long_comment);
	_g_free0 (self->returns);
	self->returns_annotations = (_vala_array_free (self->returns_annotations, self->returns_annotations_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->versioning);
	self->see_also = (_vala_array_free (self->see_also, self->see_also_length1, (GDestroyNotify) g_free), NULL);
}

static GType
gtkdoc_gcomment_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gtkdoc_value_gcomment_init, gtkdoc_value_gcomment_free_value, gtkdoc_value_gcomment_copy_value, gtkdoc_value_gcomment_peek_pointer, "p", gtkdoc_value_gcomment_collect_value, "p", gtkdoc_value_gcomment_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GtkdocGCommentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_gcomment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocGComment), 0, (GInstanceInitFunc) gtkdoc_gcomment_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gtkdoc_gcomment_type_id;
	gtkdoc_gcomment_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocGComment", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gtkdoc_gcomment_type_id;
}

GType
gtkdoc_gcomment_get_type (void)
{
	static volatile gsize gtkdoc_gcomment_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_gcomment_type_id__volatile)) {
		GType gtkdoc_gcomment_type_id;
		gtkdoc_gcomment_type_id = gtkdoc_gcomment_get_type_once ();
		g_once_init_leave (&gtkdoc_gcomment_type_id__volatile, gtkdoc_gcomment_type_id);
	}
	return gtkdoc_gcomment_type_id__volatile;
}

gpointer
gtkdoc_gcomment_ref (gpointer instance)
{
	GtkdocGComment * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_gcomment_unref (gpointer instance)
{
	GtkdocGComment * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_GCOMMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

