.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_source_stat.mdoc -- get information about zip source
.\" Copyright (C) 2014-2021 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_SOURCE_STAT" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_source_stat\fR
\- get information about zip_source
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.br
.PD 0
.HP 4n
\fBzip_source_stat\fR(\fIzip_source_t\ *source\fR, \fIzip_stat_t\ *sb\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_source_stat\fR()
function obtains information about the zip source
\fIsource\fR
.PP
The
\fIsb\fR
argument is a pointer to a
\fIstruct zip_source_stat\fR
(shown below), into which information about the zip source is placed.
.nf
.sp
.RS 0n
struct zip_source_stat {
    zip_uint64_t valid;                 /* which fields have valid values */
    const char *name;                   /* name of the file */
    zip_uint64_t index;                 /* index within archive */
    zip_uint64_t size;                  /* size of file (uncompressed) */
    zip_uint64_t comp_size;             /* size of file (compressed) */
    time_t mtime;                       /* modification time */
    zip_uint32_t crc;                   /* crc of file data */
    zip_uint16_t comp_method;           /* compression method used */
    zip_uint16_t encryption_method;     /* encryption method used */
    zip_uint32_t flags;                 /* reserved for future use */
};
.RE
.fi
The structure pointed to by
\fIsb\fR
must be initialized with
\fBzip_stat_init\fR(\fI3\fR)
before calling
\fBzip_source_stat\fR().
.PP
The
\fIvalid\fR
field of the structure specifies which other fields are valid.
Check if the flag defined by the following defines are in
\fIvalid\fR
before accessing the fields:
.RS 6n
.PD 0
.TP 30n
\fRZIP_STAT_NAME\fR
\fIname\fR
.TP 30n
\fRZIP_STAT_INDEX\fR
\fIindex\fR
.TP 30n
\fRZIP_STAT_SIZE\fR
\fIsize\fR
.TP 30n
\fRZIP_STAT_COMP_SIZE\fR
\fIcomp_size\fR
.TP 30n
\fRZIP_STAT_MTIME\fR
\fImtime\fR
.TP 30n
\fRZIP_STAT_CRC\fR
\fIcrc\fR
.TP 30n
\fRZIP_STAT_COMP_METHOD\fR
\fIcomp_method\fR
.TP 30n
\fRZIP_STAT_ENCRYPTION_METHOD\fR
\fIencryption_method\fR
.TP 30n
\fRZIP_STAT_FLAGS\fR
\fIflags\fR
.RE
.PD
.PP
\fINOTE\fR:
Some fields may only be filled out after all data has been read from
the source, for example the
\fIcrc\fR
or
\fIsize\fR
fields.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fIsource\fR
is set to indicate the error.
.SH "SEE ALSO"
libzip(3),
zip_source(5)
.SH "HISTORY"
\fBzip_source_stat\fR()
was added in libzip 1.0.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fIwiz@gatalith.at\fR>
