################## Sample file for test automation #####################
#** All comment lines must start with '#' in the first column
#** Blank lines not allowed
#
#** The following lines which start with a '+' are for defining replacement
#** strings (or aliases) which can be used anywhere in this file.
# 
+def_kernel  ausgsa.austin.ibm.com/projects/l/ltcperformance/kernels     #location for custom kernels
+def_config  ausgsa.austin.ibm.com/projects/l/ltcperformance/configs     #location for kernel config files
+def_patch   ausgsa.austin.ibm.com/projects/l/ltcperformance/patches     #location for kernel patches
+def_results ausgsa.austin.ibm.com/projects/l/ltcperformance/2003benchmarks     #location to publish results
##########################################################################
#
#********************  build examples *************************************
#**build $1=kern_location $2=kern_tarball $3=configfile_loc/file $4-$9=patchfile_loc/file
#build my_public linux-2.5.59.tar.gz my_public/8500R.config my_public/ips.patch ausgsa/home/s/l/slpratt/web/public/real.patch
#build my_public linux-2.5.59.tar.gz my_public/8500R.config my_public/ips.patch def_patch/patch-2.5.59-mjb4.gz
#build stock 2.5.59 def_config/8500R.config my_public/ips.patch ausgsa/home/s/l/slpratt/web/public/real.patch
#
#********************  boot examples *************************************
#**boot $1=kernel_lable $n=boot_parms
#** the following boots the standard autobench generated kernel with profiling.
#boot autobench profile=2 sysmap=/boot/System.map-autobench
#
#********************  setup examples *************************************
#** Setup runs scripts to set up before a test
#** setup $1=scriptname $2-9 script specific
#** example of making a filesystem and mounting for use by test
#**setup $1='mkmount' $2=device $3=mountpoint $4='-t' $5=fstype $6=fsargs
#setup mkmount /dev/sdc /mnt/tmp -t jfs -q
#
#**  startsar is a setup script to set the desired sar interval
#**  if not used, sar will run with 5 second interval, set interval to 0 to disable.
#**  setup startsar $interval
# setup startsar 0
#
#********************  run examples *************************************
#** Basic format of a run statement
#**#run $1=testidentifier or . to reuse logdir from last test $2=benchname $n bench args
#
#********************  tio run example *************************************
#**run $1=log_prefix $2='tio' $3=tioparms $n=(see ./tio for list of args)
#run "4k-8thread" tio --dir /mnt/tmp --block 4096 --size 200 --numruns 1 --threads 8
#
#********************  nbench run example *************************************
#** run $1=dir $2='nbench' no other args.
#run "newlog" nbench
#
#******************** unmount  example *************************************
#**setup $1=unmount $2=mountpoint 
#setup unmount /mnt/tmp  
#
#
#******************** specjbb  example *************************************
#**run $1=dir $2='specjbb' $3=heapsize $4=num_cpus $5=WHstart $6=WHinc $7=WHend $8=rampup $9=mtime
#run "test" specjbb 1600 . 1 1 2 30 120
#
#
#******************** kernbench  example *************************************
#**run $1=dirname $2='kernbench' $3=threads $4=iterations
#run "8threads" kernbench 8 2
#
#
#******************** numabench  example *************************************
#**run $1=dir $2='numaschedbench'
#run "test" numaschedbench
#
#
#******************** rawio  example *************************************
#**run $1=dir $2='rawio' $n=rawparms (see ./rawio for list of args)
#** There are lots of paramters to this benchmark.  To use raw io you
#** will need to run setup scipts.  These tests can be very destructive
#run "io" rawio  -p4 -d3 -s4096 -n8196 -l4 -x -t0
#
#
#******************** dbench  example *************************************
#** run $1=dir $2='dbench' $3 testdir $n=dbench parms(see ./dbench for list of args)
#** Must setup place for dbench to run for real results.  This sets up drive as JFS
#setup mkmount /dev/sdc /mnt/tmp -t jfs -q
#** now run the benchmark 
#run "2thread-jfs" dbench /mnt/tmp 2
#** Don't forget to unmount when you are done.
#setup unmount /mnt/tmp 
#
#
#******************** tbench  example *************************************
#**run $1=dir $2='tbench' $3 testdir $n=dbench parms(see ./dbench for list of args)
#** Must setup place for dbench to run for real results.  This sets up drive as JFS
#setup mkmount /dev/sdc /mnt/tmp -t jfs -q
#** now run the benchmark 
#run "io" tbench /mnt/tmp 2
#** Don't forget to unmount when you are done.
#setup unmount /mnt/tmp 
#
#
#******************** volanomark  example *************************************
#**run $1=dir $2='volanomark' $3=startheap $4=maxheap $5=msg count
#run "8-64-100" volanomark 8 64 100
#
#
#******************** lmbench example *************************************
#**run $1=dir $2='lmbench' 
run "test" lmbench
#
#
#******************** publish results *************************************
#**  results $1=publish_location $2=email_addr_to_notify.
#** location is just a directory, needs to be world writeable.
#** email arg is optional.
#results ausgsa.austin.ibm.com/home/s/l/slpratt/web/public/results slpratt@austin.ibm.com
#results my_public/results slpratt@austin.ibm.com
# end of file, do not put new-lines after this
