
#ifndef PAM_RADIUS_H
#define PAM_RADIUS_H

#include <stdio.h>
#define __USE_BSD /* for bzero() prototype in string.h */
#define __USE_POSIX2
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <syslog.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/resource.h>
#include <utmp.h>
#include <time.h>
#include <netinet/in.h>
#include <netdb.h>
#include <rpcsvc/ypclnt.h>
#include <rpc/rpc.h>

#include "radius.h"
#include "md5.h"

/* RADIUS stuff */

/* For the folowing struct, the 255 string length limit
 * is supposed to be enforced by the RADIUS server...
 */
typedef struct {
/* flags set in this structure */
            u_char flags[255];
/*  1 */	u_char user_name[255];
/*  2 */	u_char password[255];
/*  3 */	u_char chap_password[255];
/*  4 */	u_char client_id[4];
/*  5 */	u_int  client_port_id;
/*  6 */	u_int  user_service_type;
/*  7 */	u_int  framed_protocol;
/*  8 */	u_char framed_address[4];
/*  9 */	u_char framed_netmask[4];
/* 10 */	u_int  framed_routing;
/* 11 */	u_char framed_filter_id[255];
/* 12 */	u_int  framed_mtu;
/* 13 */	u_int  framed_compression;
/* 14 */	u_char login_host[4];
/* 15 */	u_int  login_service;
/* 16 */	u_int  login_tcp_port;
/* 17 */	u_char old_password[255];
/* 18 */	u_char port_message[255];
/* 19 */	u_char dialback_no[255];
/* 20 */	u_char dialback_name[255];
/* 21 */	u_int  expiration;
/* 22 */	u_char framed_route[255];
/* 23 */	u_char framed_ipx_network[4];
/* 24 */	u_char challenge_state[255];
/* 40 */	u_int  acct_status_type;
/* 41 */	u_int  acct_delay_time;
/* 42 */	u_char acct_session_id[255];
/* 43 */	u_int  acct_authentic;
/* 44 */	u_int  acct_session_time;
} RAD_USER_DATA;

/* This is the core functions we export */
int radius_start (RAD_USER_DATA *, const char*);
int radius_stop (RAD_USER_DATA *, const char*);

/******************************************************************/

#endif /* PAM_RADIUS_H */
