
/*  
 * Experiemental:
 * Pam Module to Auth, Accting, Sess, etc.
 * pam_pgsql (dayton version) 0.1
 *
 * Some Features, I am attemtping to implement
 * 
 * - Postgresql, auth, and session management (no /etc/passwd)
 *** Partially Implemented ***
 * - MD5 Password Storage, why leave it plain.
 *** I have to find a good MD5 protocol that doesn't play with it ***
 * - Service Based Passwords, so POP3 and telnet are different
 *** Not to be implemented for awhile ***
 * - Host based ID - allows you to force a user to a individual IP
 *** Have to figure out how to grab the IP Address, from daemons that ***
 *** do not set the IP Address into PAM ***
 * - Logging of connections.
 *** Same reason as above ***
 * - Chrooting of sessions.
 *** No time to do right now, but will workon it later ***
 * - Single location of disabling Accounts.
 *** Implemented ***
 * 
 */

#include <security/_pam_aconf.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include <alloca.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>

#define PAM_SM_AUTH


#include <security/_pam_macros.h>
#include <security/pam_modules.h>
#include <security/pam_misc.h>
#include <pgsql/libpq-fe.h>

#include "support.h"
#include "pam_pgsql.h"



PAM_EXTERN int pam_sm_authenticate (pam_handle_t * pamh, int flags, int argc, 
const char **argv) {

  unsigned int ctrl;
  int retval, *ret_data = NULL;
  const char *name, *p;


  /* To set flags for the module */
  ctrl = PAM_set_ctrl(flags, NULL, argc, argv);

  /* */
  ret_data = malloc(sizeof(int));

  /* get User*/
	
  retval = pam_get_user(pamh, &name, USER_PROMPT);
  /* Verify User */
  if (retval == PAM_SUCCESS) {
    if (name == NULL || !isalnum(*name)) {
      D(("bad username [%s]", name));
      retval = PAM_USER_UNKNOWN;
      AUTH_RETURN
    } 
    if (retval == PAM_SUCCESS && on(UNIX_DEBUG, ctrl)) {
      D(("username [%s] obtained", name));
    }
  } else {
    D(("trouble reading username"));
    if (retval == PAM_CONV_AGAIN) {
      retval = PAM_INCOMPLETE;
    }
    AUTH_RETURN
  }

  /* Get Password */
  retval = PAM_read_password(pamh, ctrl, NULL, PWD_PROMPT, NULL, _UNIX_AUTHTOK, &p);
  /* Verify Pass */
  if (retval != PAM_SUCCESS) {
    if (retval != PAM_CONV_AGAIN) {
      _log_err(PAM_MODULE_NAME,LOG_ALERT, "auth could not identify password for [%s]",name);
    } else {
      retval = PAM_INCOMPLETE;
    }
    name = NULL;
    AUTH_RETURN
  }
  D(("user=%s, password=[%s]",name, p));

  /* Verify Password */
  retval = _verify_password(pamh,name,p,ctrl);
  name = p = NULL;

  AUTH_RETURN
}


int _verify_password(pam_handle_t * pamh, const char *name, const char *p, unsigned int ctrl) {
  
  char query[BUFFER], l_user[USRLEN], l_pass[PWDLEN];
  int retval,testval;
  PGconn *pgcon = NULL;
  PGresult *pgres = NULL;
  const char *rhost;

  D(("called"));
#ifdef HAVE_PAM_FAIL_DELAY
  if (off(UNIX_NODELAY, ctrl)) {
    D(("setting delay"));
    (void) pam_fail_delay(pamh,2000000);
  }
#endif
  strncpy(l_user,name,USRLEN);
  strncpy(l_pass,p,PWDLEN);

  retval = snprintf(query,BUFFER,"select %s from %s where %s = '%s' and active = '1' and (expire >now() or expire = NULL)", 
  PASSWD, TABLE, USER, l_user);
 
  if (retval == -1) return PAM_AUTH_ERR;

  pgcon = PQconnectdb(CONNECT_STRING);

  if ((pgcon != NULL) && (PQstatus(pgcon) != CONNECTION_BAD)) {
    if (PQresultStatus(pgres=PQexec(pgcon,query)) == PGRES_TUPLES_OK) {
      if (PQntuples(pgres) == 1) {
        if ((strcmp(l_pass,PQgetvalue(pgres,0,0))) == 0) {
          /* Password is correct */
          _log_err(PAM_MODULE_NAME,LOG_ALERT, "User Authenticated %s", l_user);
          D(("user [%s] authenticated",l_user));
          retval = PAM_SUCCESS;
        } else {
          /* Password was in Error */
          _log_err(PAM_MODULE_NAME,LOG_ALERT, "Authentication Failed %s", l_user);
          D(("user [%s] did not authenticated",l_user));
          retval = PAM_AUTH_ERR;
        }
      } else if (PQntuples(pgres) == 0) {
        /* No User found in Database */
        _log_err(PAM_MODULE_NAME,LOG_ALERT, "Unknown User %s", l_user);
        D(("No user [%s]",l_user));
        retval = PAM_USER_UNKNOWN;
      } else {
        /* Multipe Entries found in Database, though this should not happen */   
        /* as the username is the primary key                               */   
        _log_err(PAM_MODULE_NAME,LOG_ALERT, "Database Error: Multiple Entries %d", PQntuples(pgres));
        D(("Duplicate Users [%s] in Database",l_user));
        retval = PAM_USER_UNKNOWN;
      }
    } else {
      /* Unable to Query Database */
        _log_err(PAM_MODULE_NAME,LOG_ALERT, "Database Error: %s", PQresultErrorMessage(pgres));
      retval = PAM_AUTHINFO_UNAVAIL;
    }
  } else {
    /* Unable to Connect to Database */
    _log_err(PAM_MODULE_NAME,LOG_ALERT, "Database Error: %s", PQerrorMessage(pgcon));
    retval = PAM_AUTHINFO_UNAVAIL;
  }

/*  Here is where the Authenticated Host will be Logged so as to give an 
 *  extra method of logging connections
*/
  testval = pam_get_item(pamh, PAM_SERVICE, (const void **)&rhost);  
  D(("[%s]",rhost));
    
  if (pgres) PQclear(pgres);
  if (pgcon) PQfinish(pgcon);

  D(("Cleanup of Temp Strings (Not being done yet)"));
/*  I haven't finished this for some reason the standard functions do not work here */
  if (l_pass)
    _pam_overwrite(l_pass);
  D(("Return"));

  return retval;
}


PAM_EXTERN int pam_sm_setcred(pam_handle_t * pamh, int flags, int argc, const char **argv) {

  unsigned int ctrl;
  int retval;

  D(("called"));

  ctrl = PAM_set_ctrl(flags,NULL,argc,argv);
  retval = PAM_SUCCESS;

  if (on(UNIX_LIKE_AUTH,ctrl)) {
    int *pretval = NULL;
    
    D(("recovering return code from auth call"));

    pam_get_data(pamh,"unix_setcred_return", (const void **)pretval);

    if (pretval) {
      retval = *pretval;
      free(pretval);
      D(("recovered data %d",retval));
    }
  }
  return retval;
}


