from ... import ElementsType
from .. import Provider as BaseProvider


class Provider(BaseProvider):
    # Source:
    # https://bic.at/berufe_von_a_bis_z.php?bst=a
    jobs_dict: ElementsType[dict] = (
        {"neutral": "3D-Artist", "female": "3D-Artist", "male": "3D-Artist"},
        {"neutral": "3D-Druck-Spezialist*in", "female": "3D-Druck-Spezialistin", "male": "3D-Druck-Spezialist"},
        {
            "neutral": "A&R- (Artist & Repertoire) Manager*in",
            "female": "A&R- (Artist & Repertoire) Managerin",
            "male": "A&R- (Artist & Repertoire) Manager",
        },
        {"neutral": "AI Developer*in", "female": "AI Developerin", "male": "AI Developer"},
        {"neutral": "AI-Spezialist*in", "female": "AI-Spezialistin", "male": "AI-Spezialist"},
        {"neutral": "ASIC-Techniker*in", "female": "ASIC-Technikerin", "male": "ASIC-Techniker"},
        {"neutral": "Abfallbeauftragte*r", "female": "Abfallbeauftragte", "male": "Abfallbeauftragter"},
        {"neutral": "Abfallberater*in", "female": "Abfallberaterin", "male": "Abfallberater"},
        {
            "neutral": "Abfallwirtschaftstechniker*in",
            "female": "Abfallwirtschaftstechnikerin",
            "male": "Abfallwirtschaftstechniker",
        },
        {"neutral": "Abnahmetechniker*in", "female": "Abnahmetechnikerin", "male": "Abnahmetechniker"},
        {"neutral": "Abteilungsleiter*in", "female": "Abteilungsleiterin", "male": "Abteilungsleiter"},
        {"neutral": "Abwassertechnik", "female": "Abwassertechnik", "male": "Abwassertechnik"},
        {"neutral": "Adressmakler*in", "female": "Adressmaklerin", "male": "Adressmakler"},
        {"neutral": "Adressvermittler*in", "female": "Adressvermittlerin", "male": "Adressvermittler"},
        {"neutral": "Aerobic-Trainer*in", "female": "Aerobic-Trainerin", "male": "Aerobic-Trainer"},
        {"neutral": "Afrikanist*in", "female": "Afrikanistin", "male": "Afrikanist"},
        {"neutral": "After-Sales-Betreuer*in", "female": "After-Sales-Betreuerin", "male": "After-Sales-Betreuer"},
        {"neutral": "Agraringenieur*in", "female": "Agraringenieurin", "male": "Agraringenieur"},
        {"neutral": "Agrarkaufmann / Agrarkauffrau", "female": "Agrarkauffrau", "male": "Agrarkaufmann"},
        {"neutral": "Agrarmanager*in", "female": "Agrarmanagerin", "male": "Agrarmanager"},
        {"neutral": "Agrartechniker*in", "female": "Agrartechnikerin", "male": "Agrartechniker"},
        {
            "neutral": "Agrartechniker*in (Agrarökonomie)",
            "female": "Agrartechnikerin (Agrarökonomie)",
            "male": "Agrartechniker (Agrarökonomie)",
        },
        {
            "neutral": "Agrartechniker*in (Bodenwirtschaft und Pflanzenproduktion)",
            "female": "Agrartechnikerin (Bodenwirtschaft und Pflanzenproduktion)",
            "male": "Agrartechniker (Bodenwirtschaft und Pflanzenproduktion)",
        },
        {
            "neutral": "Agrartechniker*in (Grünraumgestaltung und Gartenbau)",
            "female": "Agrartechnikerin (Grünraumgestaltung und Gartenbau)",
            "male": "Agrartechniker (Grünraumgestaltung und Gartenbau)",
        },
        {
            "neutral": "Agrartechniker*in (Tierproduktion)",
            "female": "Agrartechnikerin (Tierproduktion)",
            "male": "Agrartechniker (Tierproduktion)",
        },
        {
            "neutral": "Agrarwirt*in - landwirtschaftliche Direktvermarktung",
            "female": "Agrarwirtin - landwirtschaftliche Direktvermarktung",
            "male": "Agrarwirt - landwirtschaftliche Direktvermarktung",
        },
        {"neutral": "Agrarwissenschafter*in", "female": "Agrarwissenschafterin", "male": "Agrarwissenschafter"},
        {"neutral": "Aktuar*in", "female": "Aktuarin", "male": "Aktuar"},
        {"neutral": "Allergologe / Allergologin", "female": "Allergologin", "male": "Allergologe"},
        {"neutral": "Alltagsbegleiter*in", "female": "Alltagsbegleiterin", "male": "Alltagsbegleiter"},
        {"neutral": "Almbewirtschafter*in", "female": "Almbewirtschafterin", "male": "Almbewirtschafter"},
        {"neutral": "Altersforscher*in", "female": "Altersforscherin", "male": "Altersforscher"},
        {"neutral": "Altwarenhändler*in", "female": "Altwarenhändlerin", "male": "Altwarenhändler"},
        {"neutral": "Amtsgehilfe / Amtsgehilfin", "female": "Amtsgehilfin", "male": "Amtsgehilfe"},
        {"neutral": "Amtsvormund", "female": "Amtsvormund", "male": "Amtsvormund"},
        {
            "neutral": "Anglist*in / Amerikanist*in",
            "female": "Anglistin / Amerikanistin",
            "male": "Anglist / Amerikanist",
        },
        {
            "neutral": "Animateur*in / Freizeitbetreuer*in",
            "female": "Animateurin / Freizeitbetreuerin",
            "male": "Animateur / Freizeitbetreuer",
        },
        {
            "neutral": "Anlage- und Vermögensberater*in",
            "female": "Anlage- und Vermögensberaterin",
            "male": "Anlage- und Vermögensberater",
        },
        {"neutral": "Anlageanalytiker*in", "female": "Anlageanalytikerin", "male": "Anlageanalytiker"},
        {"neutral": "Anlagenbautechniker*in", "female": "Anlagenbautechnikerin", "male": "Anlagenbautechniker"},
        {"neutral": "Anlagenelektrik", "female": "Anlagenelektrik", "male": "Anlagenelektrik"},
        {"neutral": "Anlagenmonteur*in", "female": "Anlagenmonteurin", "male": "Anlagenmonteur"},
        {"neutral": "Anthropologe / Anthropologin", "female": "Anthropologin", "male": "Anthropologe"},
        {"neutral": "Antiquar*in", "female": "Antiquarin", "male": "Antiquar"},
        {
            "neutral": "Antiquitäten- und Kunstgegenständehändler*in",
            "female": "Antiquitäten- und Kunstgegenständehändlerin",
            "male": "Antiquitäten- und Kunstgegenständehändler",
        },
        {
            "neutral": "Antriebstechniker*in (Elektrotechnik)",
            "female": "Antriebstechnikerin (Elektrotechnik)",
            "male": "Antriebstechniker (Elektrotechnik)",
        },
        {
            "neutral": "Anwendungsprogrammierer*in",
            "female": "Anwendungsprogrammiererin",
            "male": "Anwendungsprogrammierer",
        },
        {"neutral": "Anwendungstechniker*in", "female": "Anwendungstechnikerin", "male": "Anwendungstechniker"},
        {"neutral": "Anzeigenverkäufer*in", "female": "Anzeigenverkäuferin", "male": "Anzeigenverkäufer"},
        {"neutral": "Apotheker*in", "female": "Apothekerin", "male": "Apotheker"},
        {"neutral": "App-Entwickler*in", "female": "App-Entwicklerin", "male": "App-Entwickler"},
        {"neutral": "Apparatebautechniker*in", "female": "Apparatebautechnikerin", "male": "Apparatebautechniker"},
        {
            "neutral": "Applikations-Programmierer*in",
            "female": "Applikations-Programmiererin",
            "male": "Applikations-Programmierer",
        },
        {
            "neutral": "Applikationsentwicklung - Coding",
            "female": "Applikationsentwicklung - Coding",
            "male": "Applikationsentwicklung - Coding",
        },
        {"neutral": "Applikationstechniker*in", "female": "Applikationstechnikerin", "male": "Applikationstechniker"},
        {"neutral": "Arabist*in", "female": "Arabistin", "male": "Arabist"},
        {
            "neutral": "Arbeits- und Organisationspsychologe / Arbeits- und Organisationspsychologin",
            "female": "Arbeits- und Organisationspsychologin",
            "male": "Arbeits- und Organisationspsychologe",
        },
        {"neutral": "Arbeitsmediziner*in", "female": "Arbeitsmedizinerin", "male": "Arbeitsmediziner"},
        {
            "neutral": "Arbeitsmedizinische Administrations-Assistenz",
            "female": "Arbeitsmedizinische Administrations-Assistenz",
            "male": "Arbeitsmedizinische Administrations-Assistenz",
        },
        {
            "neutral": "Arbeitsmedizinische Assistenz",
            "female": "Arbeitsmedizinische Assistenz",
            "male": "Arbeitsmedizinische Assistenz",
        },
        {
            "neutral": "Arbeitsmedizinische Fach-Assistenz",
            "female": "Arbeitsmedizinische Fach-Assistenz",
            "male": "Arbeitsmedizinische Fach-Assistenz",
        },
        {"neutral": "Arbeitsplatzbewerter*in", "female": "Arbeitsplatzbewerterin", "male": "Arbeitsplatzbewerter"},
        {"neutral": "Arbeitsvorbereiter*in", "female": "Arbeitsvorbereiterin", "male": "Arbeitsvorbereiter"},
        {"neutral": "Arbeitswissenschafter*in", "female": "Arbeitswissenschafterin", "male": "Arbeitswissenschafter"},
        {"neutral": "Architekt*in", "female": "Architektin", "male": "Architekt"},
        {
            "neutral": "Archiv-, Bibliotheks- und Informationsassistent*in",
            "female": "Archiv-, Bibliotheks- und Informationsassistentin",
            "male": "Archiv-, Bibliotheks- und Informationsassistent",
        },
        {"neutral": "Archivar*in", "female": "Archivarin", "male": "Archivar"},
        {"neutral": "Archäologe / Archäologin", "female": "Archäologin", "male": "Archäologe"},
        {
            "neutral": "Archäologe / Archäologin (Ur- und Frühgeschichte)",
            "female": "Archäologin (Ur- und Frühgeschichte)",
            "male": "Archäologe (Ur- und Frühgeschichte)",
        },
        {"neutral": "Area-Sales-Betreuer*in", "female": "Area-Sales-Betreuerin", "male": "Area-Sales-Betreuer"},
        {"neutral": "Art Buyer", "female": "Art Buyer", "male": "Art Buyer"},
        {"neutral": "Art Director", "female": "Art Director", "male": "Art Director"},
        {"neutral": "Artist*in", "female": "Artistin", "male": "Artist"},
        {"neutral": "Arzt / Ärztin", "female": "Ärztin", "male": "Arzt"},
        {
            "neutral": "Arzt / Ärztin für Allgemeinmedizin",
            "female": "Ärztin für Allgemeinmedizin",
            "male": "Arzt für Allgemeinmedizin",
        },
        {"neutral": "Arzthelfer*in", "female": "Arzthelferin", "male": "Arzthelfer"},
        {"neutral": "Asphaltierer*in", "female": "Asphaltiererin", "male": "Asphaltierer"},
        {"neutral": "Asset Manager*in", "female": "Asset Managerin", "male": "Asset Manager"},
        {
            "neutral": "Assistent*in der Geschäftsführung",
            "female": "Assistentin der Geschäftsführung",
            "male": "Assistent der Geschäftsführung",
        },
        {
            "neutral": "Assistent*in in der Sicherheitsverwaltung",
            "female": "Assistentin in der Sicherheitsverwaltung",
            "male": "Assistent in der Sicherheitsverwaltung",
        },
        {"neutral": "Assistenzhundetrainer*in", "female": "Assistenzhundetrainerin", "male": "Assistenzhundetrainer"},
        {"neutral": "Assistenzprofessor*in", "female": "Assistenzprofessorin", "male": "Assistenzprofessor"},
        {
            "neutral": "Assistenzpädagoge / Assistenzpädagogin",
            "female": "Assistenzpädagogin",
            "male": "Assistenzpädagoge",
        },
        {
            "neutral": "Assoziierte*r (a.o.) Professor*in",
            "female": "Assoziierte (a.o.) Professorin",
            "male": "Assoziierter (a.o.) Professor",
        },
        {"neutral": "Astrobiologe / Astrobiologin", "female": "Astrobiologin", "male": "Astrobiologe"},
        {"neutral": "Astrologe / Astrologin", "female": "Astrologin", "male": "Astrologe"},
        {"neutral": "Astronaut*in", "female": "Astronautin", "male": "Astronaut"},
        {"neutral": "Astronom*in", "female": "Astronomin", "male": "Astronom"},
        {"neutral": "Astrophysiker*in", "female": "Astrophysikerin", "male": "Astrophysiker"},
        {
            "neutral": "Atem- und Sprechtrainer*in",
            "female": "Atem- und Sprechtrainerin",
            "male": "Atem- und Sprechtrainer",
        },
        {"neutral": "Atomphysiker*in", "female": "Atomphysikerin", "male": "Atomphysiker"},
        {"neutral": "Audio Engineer", "female": "Audio Engineer", "male": "Audio Engineer"},
        {"neutral": "Auditor*in", "female": "Auditorin", "male": "Auditor"},
        {"neutral": "Aufnahmeleiter*in", "female": "Aufnahmeleiterin", "male": "Aufnahmeleiter"},
        {"neutral": "Aufnahmetechniker*in", "female": "Aufnahmetechnikerin", "male": "Aufnahmetechniker"},
        {"neutral": "Aufräumcoach", "female": "Aufräumcoach", "male": "Aufräumcoach"},
        {"neutral": "Aufsichtsökonom*in", "female": "Aufsichtsökonomin", "male": "Aufsichtsökonom"},
        {"neutral": "Augenoptik", "female": "Augenoptik", "male": "Augenoptik"},
        {"neutral": "Auktionator*in", "female": "Auktionatorin", "male": "Auktionator"},
        {
            "neutral": "Ausfertiger*in (Strick-, Wirkwaren)",
            "female": "Ausfertigerin (Strick-, Wirkwaren)",
            "male": "Ausfertiger (Strick-, Wirkwaren)",
        },
        {"neutral": "Auslandskorrespondent*in", "female": "Auslandskorrespondentin", "male": "Auslandskorrespondent"},
        {"neutral": "Ausstellungstischler*in", "female": "Ausstellungstischlerin", "male": "Ausstellungstischler"},
        {"neutral": "Autobusfahrer*in", "female": "Autobusfahrerin", "male": "Autobusfahrer"},
        {"neutral": "Autohändler*in", "female": "Autohändlerin", "male": "Autohändler"},
        {
            "neutral": "Automatisierungstechniker*in",
            "female": "Automatisierungstechnikerin",
            "male": "Automatisierungstechniker",
        },
        {
            "neutral": "Automotive Computing Engineer",
            "female": "Automotive Computing Engineer",
            "male": "Automotive Computing Engineer",
        },
        {
            "neutral": "Automotive Mechatronics Engineer",
            "female": "Automotive Mechatronics Engineer",
            "male": "Automotive Mechatronics Engineer",
        },
        {"neutral": "Autor*in", "female": "Autorin", "male": "Autor"},
        {"neutral": "Autoverkäufer*in", "female": "Autoverkäuferin", "male": "Autoverkäufer"},
        {"neutral": "Außenhandelssekretär*in", "female": "Außenhandelssekretärin", "male": "Außenhandelssekretär"},
        {"neutral": "Außenrequisiteur*in", "female": "Außenrequisiteurin", "male": "Außenrequisiteur"},
        {"neutral": "Babysitter*in", "female": "Babysitterin", "male": "Babysitter"},
        {"neutral": "Backtechnologie", "female": "Backtechnologie", "male": "Backtechnologie"},
        {
            "neutral": "Badewärter*in und Saunawärter*in",
            "female": "Badewärterin und Saunawärterin",
            "male": "Badewärter und Saunawärter",
        },
        {"neutral": "Baggerfahrer*in", "female": "Baggerfahrerin", "male": "Baggerfahrer"},
        {
            "neutral": "Bahnreise- und Mobilitätsservice",
            "female": "Bahnreise- und Mobilitätsservice",
            "male": "Bahnreise- und Mobilitätsservice",
        },
        {"neutral": "Balletttänzer*in", "female": "Balletttänzerin", "male": "Balletttänzer"},
        {"neutral": "Ballistiker*in", "female": "Ballistikerin", "male": "Ballistiker"},
        {"neutral": "Bandagist*in", "female": "Bandagistin", "male": "Bandagist"},
        {"neutral": "Bankangestellter / Bankangestellte", "female": "Bankangestellte", "male": "Bankangestellter"},
        {
            "neutral": "Bankangestellter / Bankangestellte (Auslandsreferate)",
            "female": "Bankangestellte (Auslandsreferate)",
            "male": "Bankangestellter (Auslandsreferate)",
        },
        {
            "neutral": "Bankangestellter / Bankangestellte (Bankexterner Bereich)",
            "female": "Bankangestellte (Bankexterner Bereich)",
            "male": "Bankangestellter (Bankexterner Bereich)",
        },
        {
            "neutral": "Bankangestellter / Bankangestellte (Bankinterner Bereich)",
            "female": "Bankangestellte (Bankinterner Bereich)",
            "male": "Bankangestellter (Bankinterner Bereich)",
        },
        {
            "neutral": "Bankangestellter / Bankangestellte (Zentral- und Kontrollbanken)",
            "female": "Bankangestellte (Zentral- und Kontrollbanken)",
            "male": "Bankangestellter (Zentral- und Kontrollbanken)",
        },
        {"neutral": "Bankettmanager*in", "female": "Bankettmanagerin", "male": "Bankettmanager"},
        {"neutral": "Bankkassier*in", "female": "Bankkassierin", "male": "Bankkassier"},
        {"neutral": "Bankkaufmann / Bankkauffrau", "female": "Bankkauffrau", "male": "Bankkaufmann"},
        {"neutral": "Bankkundenbetreuer*in", "female": "Bankkundenbetreuerin", "male": "Bankkundenbetreuer"},
        {"neutral": "Barista", "female": "Barista", "male": "Barista"},
        {"neutral": "Barkeeper / Barmaid", "female": "Barmaid", "male": "Barkeeper"},
        {"neutral": "Barmixer*in", "female": "Barmixerin", "male": "Barmixer"},
        {"neutral": "Bauarbeiter*in", "female": "Bauarbeiterin", "male": "Bauarbeiter"},
        {"neutral": "Bauingenieur*in", "female": "Bauingenieurin", "male": "Bauingenieur"},
        {"neutral": "Baukaufmann / Baukauffrau", "female": "Baukauffrau", "male": "Baukaufmann"},
        {"neutral": "Bauleiter*in", "female": "Bauleiterin", "male": "Bauleiter"},
        {"neutral": "Baumaschinenführer*in", "female": "Baumaschinenführerin", "male": "Baumaschinenführer"},
        {"neutral": "Baumaschinentechnik", "female": "Baumaschinentechnik", "male": "Baumaschinentechnik"},
        {"neutral": "Baumaschinist*in", "female": "Baumaschinistin", "male": "Baumaschinist"},
        {"neutral": "Baumeister*in", "female": "Baumeisterin", "male": "Baumeister"},
        {"neutral": "Baumpfleger*in", "female": "Baumpflegerin", "male": "Baumpfleger"},
        {"neutral": "Bauschlosser*in", "female": "Bauschlosserin", "male": "Bauschlosser"},
        {"neutral": "Bauspengler*in", "female": "Bauspenglerin", "male": "Bauspengler"},
        {"neutral": "Baustatiker*in", "female": "Baustatikerin", "male": "Baustatiker"},
        {"neutral": "Baustellenkoordinator*in", "female": "Baustellenkoordinatorin", "male": "Baustellenkoordinator"},
        {"neutral": "Baustofftechniker*in", "female": "Baustofftechnikerin", "male": "Baustofftechniker"},
        {"neutral": "Bautechniker*in", "female": "Bautechnikerin", "male": "Bautechniker"},
        {
            "neutral": "Bautechniker*in (Bauökologie)",
            "female": "Bautechnikerin (Bauökologie)",
            "male": "Bautechniker (Bauökologie)",
        },
        {
            "neutral": "Bautechniker*in (Gebäudetechnik)",
            "female": "Bautechnikerin (Gebäudetechnik)",
            "male": "Bautechniker (Gebäudetechnik)",
        },
        {
            "neutral": "Bautechniker*in (Hochbau)",
            "female": "Bautechnikerin (Hochbau)",
            "male": "Bautechniker (Hochbau)",
        },
        {
            "neutral": "Bautechniker*in (Klimatechnik, Heizungstechnik)",
            "female": "Bautechnikerin (Klimatechnik, Heizungstechnik)",
            "male": "Bautechniker (Klimatechnik, Heizungstechnik)",
        },
        {
            "neutral": "Bautechniker*in (Konstruktion)",
            "female": "Bautechnikerin (Konstruktion)",
            "male": "Bautechniker (Konstruktion)",
        },
        {
            "neutral": "Bautechniker*in (Sanierungstechnik)",
            "female": "Bautechnikerin (Sanierungstechnik)",
            "male": "Bautechniker (Sanierungstechnik)",
        },
        {
            "neutral": "Bautechniker*in (Tiefbau)",
            "female": "Bautechnikerin (Tiefbau)",
            "male": "Bautechniker (Tiefbau)",
        },
        {
            "neutral": "Bautechniker*in (Verkehrsinfrastruktur)",
            "female": "Bautechnikerin (Verkehrsinfrastruktur)",
            "male": "Bautechniker (Verkehrsinfrastruktur)",
        },
        {"neutral": "Bautechnische Assistenz", "female": "Bautechnische Assistenz", "male": "Bautechnische Assistenz"},
        {
            "neutral": "Bautechnischer Zeichner / Bautechnische Zeichnerin",
            "female": "Bautechnische Zeichnerin",
            "male": "Bautechnischer Zeichner",
        },
        {"neutral": "Bautischler*in", "female": "Bautischlerin", "male": "Bautischler"},
        {
            "neutral": "Bauwerksabdichtungstechnik",
            "female": "Bauwerksabdichtungstechnik",
            "male": "Bauwerksabdichtungstechnik",
        },
        {"neutral": "Bauökologe / Bauökologin", "female": "Bauökologin", "male": "Bauökologe"},
        {
            "neutral": "Begleitlehrer*in / Integrationslehrer*in",
            "female": "Begleitlehrerin / Integrationslehrerin",
            "male": "Begleitlehrer / Integrationslehrer",
        },
        {"neutral": "Behindertenbegleiter*in", "female": "Behindertenbegleiterin", "male": "Behindertenbegleiter"},
        {"neutral": "Behindertenbetreuer*in", "female": "Behindertenbetreuerin", "male": "Behindertenbetreuer"},
        {"neutral": "Bekleidungsfertiger*in", "female": "Bekleidungsfertigerin", "male": "Bekleidungsfertiger"},
        {"neutral": "Bekleidungsgestaltung", "female": "Bekleidungsgestaltung", "male": "Bekleidungsgestaltung"},
        {
            "neutral": "Bekleidungsgestaltung - Damenbekleidung",
            "female": "Bekleidungsgestaltung - Damenbekleidung",
            "male": "Bekleidungsgestaltung - Damenbekleidung",
        },
        {
            "neutral": "Bekleidungsgestaltung - Herrenbekleidung",
            "female": "Bekleidungsgestaltung - Herrenbekleidung",
            "male": "Bekleidungsgestaltung - Herrenbekleidung",
        },
        {
            "neutral": "Bekleidungsgestaltung - Kürschner*in und Säckler*in",
            "female": "Bekleidungsgestaltung - Kürschnerin und Säcklerin",
            "male": "Bekleidungsgestaltung - Kürschner und Säckler",
        },
        {
            "neutral": "Bekleidungsgestaltung - Modist*in und Hutmacher*in",
            "female": "Bekleidungsgestaltung - Modistin und Hutmacherin",
            "male": "Bekleidungsgestaltung - Modist und Hutmacher",
        },
        {
            "neutral": "Bekleidungsgestaltung - Wäschewarenerzeugung",
            "female": "Bekleidungsgestaltung - Wäschewarenerzeugung",
            "male": "Bekleidungsgestaltung - Wäschewarenerzeugung",
        },
        {"neutral": "Bekleidungstechniker*in", "female": "Bekleidungstechnikerin", "male": "Bekleidungstechniker"},
        {"neutral": "Beleuchter*in", "female": "Beleuchterin", "male": "Beleuchter"},
        {"neutral": "Bereichsleiter*in", "female": "Bereichsleiterin", "male": "Bereichsleiter"},
        {
            "neutral": "Bereiter*in (Spanische Hofreitschule)",
            "female": "Bereiterin (Spanische Hofreitschule)",
            "male": "Bereiter (Spanische Hofreitschule)",
        },
        {"neutral": "Berg- und Schiführer*in", "female": "Berg- und Schiführerin", "male": "Berg- und Schiführer"},
        {"neutral": "Bergbauingenieur*in", "female": "Bergbauingenieurin", "male": "Bergbauingenieur"},
        {"neutral": "Bergbautechniker*in", "female": "Bergbautechnikerin", "male": "Bergbautechniker"},
        {
            "neutral": "Bergwerkschlosser-Maschinenhäuer*in",
            "female": "Bergwerkschlosser-Maschinenhäuerin",
            "male": "Bergwerkschlosser-Maschinenhäuer",
        },
        {"neutral": "Berufsdetektiv*in", "female": "Berufsdetektivin", "male": "Berufsdetektiv"},
        {
            "neutral": "Berufsdetektiv-Assistent*in",
            "female": "Berufsdetektiv-Assistentin",
            "male": "Berufsdetektiv-Assistent",
        },
        {
            "neutral": "Berufsfeuerwehrmann / Berufsfeuerwehrfrau",
            "female": "Berufsfeuerwehrfrau",
            "male": "Berufsfeuerwehrmann",
        },
        {"neutral": "Berufsfotograf*in", "female": "Berufsfotografin", "male": "Berufsfotograf"},
        {"neutral": "Berufsfotografie", "female": "Berufsfotografie", "male": "Berufsfotografie"},
        {"neutral": "Berufsjäger*in", "female": "Berufsjägerin", "male": "Berufsjäger"},
        {"neutral": "Berufskraftfahrer*in", "female": "Berufskraftfahrerin", "male": "Berufskraftfahrer"},
        {
            "neutral": "Berufskraftfahrer*in - Güterbeförderung",
            "female": "Berufskraftfahrerin - Güterbeförderung",
            "male": "Berufskraftfahrer - Güterbeförderung",
        },
        {
            "neutral": "Berufskraftfahrer*in - Personenbeförderung",
            "female": "Berufskraftfahrerin - Personenbeförderung",
            "male": "Berufskraftfahrer - Personenbeförderung",
        },
        {"neutral": "Berufsoffizier*in", "female": "Berufsoffizierin", "male": "Berufsoffizier"},
        {"neutral": "Berufsschullehrer*in", "female": "Berufsschullehrerin", "male": "Berufsschullehrer"},
        {"neutral": "Berufstaucher*in", "female": "Berufstaucherin", "male": "Berufstaucher"},
        {"neutral": "Besamungstechniker*in", "female": "Besamungstechnikerin", "male": "Besamungstechniker"},
        {"neutral": "Beschließer*in", "female": "Beschließerin", "male": "Beschließer"},
        {
            "neutral": "Beschriftungsdesign und Werbetechnik",
            "female": "Beschriftungsdesign und Werbetechnik",
            "male": "Beschriftungsdesign und Werbetechnik",
        },
        {"neutral": "Bestatter*in", "female": "Bestatterin", "male": "Bestatter"},
        {"neutral": "Beteiligungsmanager*in", "female": "Beteiligungsmanagerin", "male": "Beteiligungsmanager"},
        {"neutral": "Betonbau", "female": "Betonbau", "male": "Betonbau"},
        {"neutral": "Betonbauspezialist*in", "female": "Betonbauspezialistin", "male": "Betonbauspezialist"},
        {
            "neutral": "Betonbauspezialist*in - Konstruktiver Betonbau",
            "female": "Betonbauspezialistin - Konstruktiver Betonbau",
            "male": "Betonbauspezialist - Konstruktiver Betonbau",
        },
        {
            "neutral": "Betonbauspezialist*in - Stahlbetonhochbau",
            "female": "Betonbauspezialistin - Stahlbetonhochbau",
            "male": "Betonbauspezialist - Stahlbetonhochbau",
        },
        {
            "neutral": "Betonfertiger*in - Betonwarenerzeugung",
            "female": "Betonfertigerin - Betonwarenerzeugung",
            "male": "Betonfertiger - Betonwarenerzeugung",
        },
        {
            "neutral": "Betonfertiger*in - Betonwerksteinerzeugung",
            "female": "Betonfertigerin - Betonwerksteinerzeugung",
            "male": "Betonfertiger - Betonwerksteinerzeugung",
        },
        {
            "neutral": "Betonfertiger*in - Terrazzoherstellung",
            "female": "Betonfertigerin - Terrazzoherstellung",
            "male": "Betonfertiger - Terrazzoherstellung",
        },
        {"neutral": "Betonfertigteiltechnik", "female": "Betonfertigteiltechnik", "male": "Betonfertigteiltechnik"},
        {"neutral": "Betonfertigungstechnik", "female": "Betonfertigungstechnik", "male": "Betonfertigungstechnik"},
        {"neutral": "Betonwarenerzeuger*in", "female": "Betonwarenerzeugerin", "male": "Betonwarenerzeuger"},
        {"neutral": "Betriebsarzt / Betriebsärztin", "female": "Betriebsärztin", "male": "Betriebsarzt"},
        {"neutral": "Betriebsdienstleister*in", "female": "Betriebsdienstleisterin", "male": "Betriebsdienstleister"},
        {"neutral": "Betriebsdienstleistung", "female": "Betriebsdienstleistung", "male": "Betriebsdienstleistung"},
        {"neutral": "Betriebselektriker*in", "female": "Betriebselektrikerin", "male": "Betriebselektriker"},
        {"neutral": "Betriebsinformatiker*in", "female": "Betriebsinformatikerin", "male": "Betriebsinformatiker"},
        {"neutral": "Betriebsleiter*in", "female": "Betriebsleiterin", "male": "Betriebsleiter"},
        {
            "neutral": "Betriebslogistikkaufmann / Betriebslogistikkauffrau",
            "female": "Betriebslogistikkauffrau",
            "male": "Betriebslogistikkaufmann",
        },
        {"neutral": "Betriebsrat / Betriebsrätin", "female": "Betriebsrätin", "male": "Betriebsrat"},
        {"neutral": "Betriebsschlosser*in", "female": "Betriebsschlosserin", "male": "Betriebsschlosser"},
        {"neutral": "Betriebstechniker*in", "female": "Betriebstechnikerin", "male": "Betriebstechniker"},
        {"neutral": "Betriebswirt*in", "female": "Betriebswirtin", "male": "Betriebswirt"},
        {"neutral": "Bewacher*in", "female": "Bewacherin", "male": "Bewacher"},
        {
            "neutral": "Bewegungspädagoge / Bewegungspädagogin",
            "female": "Bewegungspädagogin",
            "male": "Bewegungspädagoge",
        },
        {"neutral": "Bewährungshelfer*in", "female": "Bewährungshelferin", "male": "Bewährungshelfer"},
        {"neutral": "Bezirksanwalt / Bezirksanwältin", "female": "Bezirksanwältin", "male": "Bezirksanwalt"},
        {"neutral": "Bibliothekar*in", "female": "Bibliothekarin", "male": "Bibliothekar"},
        {
            "neutral": "Bibliothekar*in (wissenschaftl. Bibliotheken)",
            "female": "Bibliothekarin (wissenschaftl. Bibliotheken)",
            "male": "Bibliothekar (wissenschaftl. Bibliotheken)",
        },
        {"neutral": "Bienenwirtschaft", "female": "Bienenwirtschaft", "male": "Bienenwirtschaft"},
        {"neutral": "Bilanzbuchhalter*in", "female": "Bilanzbuchhalterin", "male": "Bilanzbuchhalter"},
        {"neutral": "Bildhauer*in", "female": "Bildhauerin", "male": "Bildhauer"},
        {"neutral": "Bildhauerei", "female": "Bildhauerei", "male": "Bildhauerei"},
        {"neutral": "Bildjournalist*in", "female": "Bildjournalistin", "male": "Bildjournalist"},
        {
            "neutral": "Bildungs- und Berufsberater*in",
            "female": "Bildungs- und Berufsberaterin",
            "male": "Bildungs- und Berufsberater",
        },
        {"neutral": "Bildungsberater*in", "female": "Bildungsberaterin", "male": "Bildungsberater"},
        {"neutral": "Bildungscontroller*in", "female": "Bildungscontrollerin", "male": "Bildungscontroller"},
        {"neutral": "Bildungsmanager*in", "female": "Bildungsmanagerin", "male": "Bildungsmanager"},
        {
            "neutral": "Bildungswissenschafter*in",
            "female": "Bildungswissenschafterin",
            "male": "Bildungswissenschafter",
        },
        {
            "neutral": "Billeteur*in (Kartenverkäufer*in)",
            "female": "Billeteurin (Kartenverkäuferin)",
            "male": "Billeteur (Kartenverkäufer)",
        },
        {"neutral": "Binder*in", "female": "Binderin", "male": "Binder"},
        {"neutral": "Binnenschifffahrt", "female": "Binnenschifffahrt", "male": "Binnenschifffahrt"},
        {"neutral": "Biobauer / Biobäuerin", "female": "Biobäuerin", "male": "Biobauer"},
        {"neutral": "Biobäcker*in", "female": "Biobäckerin", "male": "Biobäcker"},
        {"neutral": "Biochemiker*in", "female": "Biochemikerin", "male": "Biochemiker"},
        {"neutral": "Biofeedbacktrainer*in", "female": "Biofeedbacktrainerin", "male": "Biofeedbacktrainer"},
        {"neutral": "Bioinformatiker*in", "female": "Bioinformatikerin", "male": "Bioinformatiker"},
        {"neutral": "Biologe / Biologin", "female": "Biologin", "male": "Biologe"},
        {
            "neutral": "Biomasseproduktion und land- und forstwirtschaftliche Bioenergiegewinnung",
            "female": "Biomasseproduktion und land- und forstwirtschaftliche Bioenergiegewinnung",
            "male": "Biomasseproduktion und land- und forstwirtschaftliche Bioenergiegewinnung",
        },
        {"neutral": "Biomedical Engineer", "female": "Biomedical Engineer", "male": "Biomedical Engineer"},
        {
            "neutral": "Biomedizinische*r Analytiker*in",
            "female": "Biomedizinische Analytikerin",
            "male": "Biomedizinischer Analytiker",
        },
        {"neutral": "Bioniker*in", "female": "Bionikerin", "male": "Bioniker"},
        {"neutral": "Biophysiker*in", "female": "Biophysikerin", "male": "Biophysiker"},
        {"neutral": "Biotechniker*in", "female": "Biotechnikerin", "male": "Biotechniker"},
        {"neutral": "Biotechnologe / Biotechnologin", "female": "Biotechnologin", "male": "Biotechnologe"},
        {
            "neutral": "Bioverfahrenstechniker*in",
            "female": "Bioverfahrenstechnikerin",
            "male": "Bioverfahrenstechniker",
        },
        {
            "neutral": "Blechblasinstrumentenerzeugung",
            "female": "Blechblasinstrumentenerzeugung",
            "male": "Blechblasinstrumentenerzeugung",
        },
        {"neutral": "Blechschlosser*in", "female": "Blechschlosserin", "male": "Blechschlosser"},
        {"neutral": "Blockchain-Entwickler*in", "female": "Blockchain-Entwicklerin", "male": "Blockchain-Entwickler"},
        {"neutral": "Blogger*in", "female": "Bloggerin", "male": "Blogger"},
        {
            "neutral": "Blumenbinder*in und -händler*in (Florist*in)",
            "female": "Blumenbinderin und -händlerin (Floristin)",
            "male": "Blumenbinder und -händler (Florist)",
        },
        {"neutral": "Bodenleger*in", "female": "Bodenlegerin", "male": "Bodenleger"},
        {"neutral": "Bodyguard", "female": "Bodyguard", "male": "Bodyguard"},
        {"neutral": "Bohrarbeiter*in", "female": "Bohrarbeiterin", "male": "Bohrarbeiter"},
        {
            "neutral": "Bonbon- und Konfektmacher*in",
            "female": "Bonbon- und Konfektmacherin",
            "male": "Bonbon- und Konfektmacher",
        },
        {"neutral": "Booker", "female": "Booker", "male": "Booker"},
        {"neutral": "Bootbauer*in", "female": "Bootbauerin", "male": "Bootbauer"},
        {"neutral": "Bordtechniker*in", "female": "Bordtechnikerin", "male": "Bordtechniker"},
        {"neutral": "Botaniker*in", "female": "Botanikerin", "male": "Botaniker"},
        {"neutral": "Bote/Botin", "female": "Botin", "male": "Bote"},
        {"neutral": "Botschafter*in", "female": "Botschafterin", "male": "Botschafter"},
        {"neutral": "Botschaftssekretär*in", "female": "Botschaftssekretärin", "male": "Botschaftssekretär"},
        {"neutral": "Brand Manager*in", "female": "Brand Managerin", "male": "Brand Manager"},
        {
            "neutral": "Brandschutzbeauftragter / Brandschutzbeauftragte",
            "female": "Brandschutzbeauftragte",
            "male": "Brandschutzbeauftragter",
        },
        {
            "neutral": "Brau- und Getränketechnik",
            "female": "Brau- und Getränketechnik",
            "male": "Brau- und Getränketechnik",
        },
        {"neutral": "Brauer*in und Mälzer*in", "female": "Brauerin und Mälzerin", "male": "Brauer und Mälzer"},
        {
            "neutral": "Brief- und Paketzusteller*in",
            "female": "Brief- und Paketzustellerin",
            "male": "Brief- und Paketzusteller",
        },
        {"neutral": "Briefträger*in", "female": "Briefträgerin", "male": "Briefträger"},
        {"neutral": "Broker", "female": "Broker", "male": "Broker"},
        {"neutral": "Brunnen- und Grundbau", "female": "Brunnen- und Grundbau", "male": "Brunnen- und Grundbau"},
        {"neutral": "Brunnenmacher*in", "female": "Brunnenmacherin", "male": "Brunnenmacher"},
        {
            "neutral": "Buch- und Medienwirtschaft",
            "female": "Buch- und Medienwirtschaft",
            "male": "Buch- und Medienwirtschaft",
        },
        {
            "neutral": "Buch- und Medienwirtschaft - Buch- und Musikalienhandel",
            "female": "Buch- und Medienwirtschaft - Buch- und Musikalienhandel",
            "male": "Buch- und Medienwirtschaft - Buch- und Musikalienhandel",
        },
        {
            "neutral": "Buch- und Medienwirtschaft - Buch- und Pressegroßhandel",
            "female": "Buch- und Medienwirtschaft - Buch- und Pressegroßhandel",
            "male": "Buch- und Medienwirtschaft - Buch- und Pressegroßhandel",
        },
        {
            "neutral": "Buch- und Medienwirtschaft - Verlag",
            "female": "Buch- und Medienwirtschaft - Verlag",
            "male": "Buch- und Medienwirtschaft - Verlag",
        },
        {"neutral": "Buchbinder*in", "female": "Buchbinderin", "male": "Buchbinder"},
        {
            "neutral": "Buchbindetechnik und Postpresstechnologie",
            "female": "Buchbindetechnik und Postpresstechnologie",
            "male": "Buchbindetechnik und Postpresstechnologie",
        },
        {
            "neutral": "Buchbindetechnik und Postpresstechnologie - Buchbinder*in",
            "female": "Buchbindetechnik und Postpresstechnologie - Buchbinderin",
            "male": "Buchbindetechnik und Postpresstechnologie - Buchbinder",
        },
        {
            "neutral": "Buchbindetechnik und Postpresstechnologie - Buchfertigungstechnik",
            "female": "Buchbindetechnik und Postpresstechnologie - Buchfertigungstechnik",
            "male": "Buchbindetechnik und Postpresstechnologie - Buchfertigungstechnik",
        },
        {
            "neutral": "Buchbindetechnik und Postpresstechnologie - Postpresstechnologie",
            "female": "Buchbindetechnik und Postpresstechnologie - Postpresstechnologie",
            "male": "Buchbindetechnik und Postpresstechnologie - Postpresstechnologie",
        },
        {"neutral": "Buchdrucker*in", "female": "Buchdruckerin", "male": "Buchdrucker"},
        {"neutral": "Buchhalter*in", "female": "Buchhalterin", "male": "Buchhalter"},
        {"neutral": "Buchhaltung", "female": "Buchhaltung", "male": "Buchhaltung"},
        {"neutral": "Buchhändler*in", "female": "Buchhändlerin", "male": "Buchhändler"},
        {"neutral": "Buchmacher*in", "female": "Buchmacherin", "male": "Buchmacher"},
        {"neutral": "Buffet- und Schankkraft", "female": "Buffet- und Schankkraft", "male": "Buffet- und Schankkraft"},
        {
            "neutral": "Building Information Modeling (BIM) Manager*in",
            "female": "Building Information Modeling (BIM) Managerin",
            "male": "Building Information Modeling (BIM) Manager",
        },
        {
            "neutral": "Burnout-Prophylaxe Trainer*in",
            "female": "Burnout-Prophylaxe Trainerin",
            "male": "Burnout-Prophylaxe Trainer",
        },
        {"neutral": "Business Analyst*in", "female": "Business Analystin", "male": "Business Analyst"},
        {"neutral": "Business Developer", "female": "Business Developer", "male": "Business Developer"},
        {"neutral": "Butler / Butleress", "female": "Butleress", "male": "Butler"},
        {"neutral": "Bäckerei", "female": "Bäckerei", "male": "Bäckerei"},
        {"neutral": "Börsendisponent*in", "female": "Börsendisponentin", "male": "Börsendisponent"},
        {"neutral": "Börsenhändler*in", "female": "Börsenhändlerin", "male": "Börsenhändler"},
        {"neutral": "Börsenmakler*in", "female": "Börsenmaklerin", "male": "Börsenmakler"},
        {"neutral": "Büchsenmacher*in", "female": "Büchsenmacherin", "male": "Büchsenmacher"},
        {"neutral": "Bügler*in", "female": "Büglerin", "male": "Bügler"},
        {"neutral": "Bühnenarbeiter*in", "female": "Bühnenarbeiterin", "male": "Bühnenarbeiter"},
        {"neutral": "Bühnenbildner*in", "female": "Bühnenbildnerin", "male": "Bühnenbildner"},
        {"neutral": "Bühnenmaler*in", "female": "Bühnenmalerin", "male": "Bühnenmaler"},
        {"neutral": "Bühnentechniker*in", "female": "Bühnentechnikerin", "male": "Bühnentechniker"},
        {"neutral": "Bühnentischler*in", "female": "Bühnentischlerin", "male": "Bühnentischler"},
        {"neutral": "Büroangestellter / Büroangestellte", "female": "Büroangestellte", "male": "Büroangestellter"},
        {"neutral": "Büroassistent*in", "female": "Büroassistentin", "male": "Büroassistent"},
        {"neutral": "Bürokaufmann / Bürokauffrau", "female": "Bürokauffrau", "male": "Bürokaufmann"},
        {"neutral": "Büroleiter*in", "female": "Büroleiterin", "male": "Büroleiter"},
        {
            "neutral": "Büromaschinentechniker*in",
            "female": "Büromaschinentechnikerin",
            "male": "Büromaschinentechniker",
        },
        {
            "neutral": "Bürsten- und Pinselmacher*in",
            "female": "Bürsten- und Pinselmacherin",
            "male": "Bürsten- und Pinselmacher",
        },
        {"neutral": "CAD-Techniker*in", "female": "CAD-Technikerin", "male": "CAD-Techniker"},
        {"neutral": "CAM-Techniker*in", "female": "CAM-Technikerin", "male": "CAM-Techniker"},
        {"neutral": "CATIA-Techniker*in", "female": "CATIA-Technikerin", "male": "CATIA-Techniker"},
        {"neutral": "Callcenter Agent", "female": "Callcenter Agent", "male": "Callcenter Agent"},
        {"neutral": "Campaign Manager*in", "female": "Campaign Managerin", "male": "Campaign Manager"},
        {"neutral": "Campingplatzwart*in", "female": "Campingplatzwartin", "male": "Campingplatzwart"},
        {"neutral": "Canyoningführer*in", "female": "Canyoningführerin", "male": "Canyoningführer"},
        {"neutral": "Casting Director", "female": "Casting Director", "male": "Casting Director"},
        {"neutral": "Category Manager*in", "female": "Category Managerin", "male": "Category Manager"},
        {"neutral": "Catering-Spezialist*in", "female": "Catering-Spezialistin", "male": "Catering-Spezialist"},
        {"neutral": "Change Manager*in", "female": "Change Managerin", "male": "Change Manager"},
        {"neutral": "Chatbot-Entwickler*in", "female": "Chatbot-Entwicklerin", "male": "Chatbot-Entwickler"},
        {"neutral": "Chauffeur*in", "female": "Chauffeurin", "male": "Chauffeur"},
        {"neutral": "Chefredakteur*in", "female": "Chefredakteurin", "male": "Chefredakteur"},
        {"neutral": "Chemieinformatiker*in", "female": "Chemieinformatikerin", "male": "Chemieinformatiker"},
        {"neutral": "Chemieingenieur*in", "female": "Chemieingenieurin", "male": "Chemieingenieur"},
        {"neutral": "Chemielaborant*in", "female": "Chemielaborantin", "male": "Chemielaborant"},
        {"neutral": "Chemielabortechnik", "female": "Chemielabortechnik", "male": "Chemielabortechnik"},
        {"neutral": "Chemietechniker*in", "female": "Chemietechnikerin", "male": "Chemietechniker"},
        {"neutral": "Chemieverfahrenstechnik", "female": "Chemieverfahrenstechnik", "male": "Chemieverfahrenstechnik"},
        {"neutral": "Chemiewerker*in", "female": "Chemiewerkerin", "male": "Chemiewerker"},
        {"neutral": "Chemiker*in", "female": "Chemikerin", "male": "Chemiker"},
        {
            "neutral": "Chemiker*in für Analytische Chemie",
            "female": "Chemikerin für Analytische Chemie",
            "male": "Chemiker für Analytische Chemie",
        },
        {
            "neutral": "Chemiker*in für Anorganische Chemie",
            "female": "Chemikerin für Anorganische Chemie",
            "male": "Chemiker für Anorganische Chemie",
        },
        {
            "neutral": "Chemiker*in für Organische Chemie",
            "female": "Chemikerin für Organische Chemie",
            "male": "Chemiker für Organische Chemie",
        },
        {
            "neutral": "Chemiker*in für Physikalische Chemie",
            "female": "Chemikerin für Physikalische Chemie",
            "male": "Chemiker für Physikalische Chemie",
        },
        {
            "neutral": "Chemiker*in für Technische Chemie",
            "female": "Chemikerin für Technische Chemie",
            "male": "Chemiker für Technische Chemie",
        },
        {"neutral": "Chip-Designer*in", "female": "Chip-Designerin", "male": "Chip-Designer"},
        {
            "neutral": "Chirurgieinstrumentenerzeuger*in",
            "female": "Chirurgieinstrumentenerzeugerin",
            "male": "Chirurgieinstrumentenerzeuger",
        },
        {"neutral": "Chocolatier / Chocolatière", "female": "Chocolatière", "male": "Chocolatier"},
        {"neutral": "Choreograf*in", "female": "Choreografin", "male": "Choreograf"},
        {"neutral": "Chorsänger*in", "female": "Chorsängerin", "male": "Chorsänger"},
        {"neutral": "Clinical Engineer", "female": "Clinical Engineer", "male": "Clinical Engineer"},
        {"neutral": "Cloud Engineer", "female": "Cloud Engineer", "male": "Cloud Engineer"},
        {"neutral": "Cloud Software Engineer", "female": "Cloud Software Engineer", "male": "Cloud Software Engineer"},
        {"neutral": "Cloud-Architekt*in", "female": "Cloud-Architektin", "male": "Cloud-Architekt"},
        {
            "neutral": "Cloud-Netzwerktechniker*in",
            "female": "Cloud-Netzwerktechnikerin",
            "male": "Cloud-Netzwerktechniker",
        },
        {
            "neutral": "Cloud-Sicherheitstechniker*in",
            "female": "Cloud-Sicherheitstechnikerin",
            "male": "Cloud-Sicherheitstechniker",
        },
        {"neutral": "Cloud-Systemtechniker*in", "female": "Cloud-Systemtechnikerin", "male": "Cloud-Systemtechniker"},
        {"neutral": "Clown", "female": "Clown", "male": "Clown"},
        {"neutral": "Co-Pilot*in", "female": "Co-Pilotin", "male": "Co-Pilot"},
        {"neutral": "Coach", "female": "Coach", "male": "Coach"},
        {"neutral": "Cognitive Developer", "female": "Cognitive Developer", "male": "Cognitive Developer"},
        {
            "neutral": "Commerce Manager*in E- & M-Commerce",
            "female": "Commerce Managerin E- & M-Commerce",
            "male": "Commerce Manager E- & M-Commerce",
        },
        {"neutral": "Community Manager*in", "female": "Community Managerin", "male": "Community Manager"},
        {
            "neutral": "Compensation & Benefits Betreuer*in",
            "female": "Compensation & Benefits Betreuerin",
            "male": "Compensation & Benefits Betreuer",
        },
        {"neutral": "Compliance-Officer", "female": "Compliance-Officer", "male": "Compliance-Officer"},
        {"neutral": "Compositing Artist", "female": "Compositing Artist", "male": "Compositing Artist"},
        {"neutral": "Computer Forensiker*in", "female": "Computer Forensikerin", "male": "Computer Forensiker"},
        {"neutral": "Computer Visualist*in", "female": "Computer Visualistin", "male": "Computer Visualist"},
        {
            "neutral": "Computer-Animationsdesigner*in",
            "female": "Computer-Animationsdesignerin",
            "male": "Computer-Animationsdesigner",
        },
        {"neutral": "Computeranimateur*in", "female": "Computeranimateurin", "male": "Computeranimateur"},
        {"neutral": "Computerbuch-Autor*in", "female": "Computerbuch-Autorin", "male": "Computerbuch-Autor"},
        {"neutral": "Computergrafiker*in", "female": "Computergrafikerin", "male": "Computergrafiker"},
        {"neutral": "Computerlinguist*in", "female": "Computerlinguistin", "male": "Computerlinguist"},
        {"neutral": "Computermathematiker*in", "female": "Computermathematikerin", "male": "Computermathematiker"},
        {
            "neutral": "Computerspielprogrammierer*in",
            "female": "Computerspielprogrammiererin",
            "male": "Computerspielprogrammierer",
        },
        {"neutral": "Computertechniker*in", "female": "Computertechnikerin", "male": "Computertechniker"},
        {"neutral": "Concierge", "female": "Concierge", "male": "Concierge"},
        {
            "neutral": "Concierge Service Provider",
            "female": "Concierge Service Provider",
            "male": "Concierge Service Provider",
        },
        {"neutral": "Content Manager*in", "female": "Content Managerin", "male": "Content Manager"},
        {"neutral": "Continuity", "female": "Continuity", "male": "Continuity"},
        {"neutral": "Controller*in", "female": "Controllerin", "male": "Controller"},
        {
            "neutral": "Corporate-Social-Responsibility Manager*in",
            "female": "Corporate-Social-Responsibility Managerin",
            "male": "Corporate-Social-Responsibility Manager",
        },
        {"neutral": "Cost Engineer", "female": "Cost Engineer", "male": "Cost Engineer"},
        {"neutral": "Creative Director", "female": "Creative Director", "male": "Creative Director"},
        {"neutral": "Croupier/Croupière", "female": "Croupière", "male": "Croupier"},
        {
            "neutral": "Customer Relation Manager*in",
            "female": "Customer Relation Managerin",
            "male": "Customer Relation Manager",
        },
        {"neutral": "Cutter*in", "female": "Cutterin", "male": "Cutter"},
        {"neutral": "Cyber Security Analyst", "female": "Cyber Security Analyst", "male": "Cyber Security Analyst"},
        {
            "neutral": "Cyber Security Professional",
            "female": "Cyber Security Professional",
            "male": "Cyber Security Professional",
        },
        {"neutral": "DJ (Disc-Jockey)", "female": "DJ (Disc-Jockey)", "male": "DJ (Disc-Jockey)"},
        {"neutral": "DV-Berater*in", "female": "DV-Beraterin", "male": "DV-Berater"},
        {"neutral": "Dachdecker*in", "female": "Dachdeckerin", "male": "Dachdecker"},
        {"neutral": "Damenkleidermacher*in", "female": "Damenkleidermacherin", "male": "Damenkleidermacher"},
        {"neutral": "Data Scientist", "female": "Data Scientist", "male": "Data Scientist"},
        {"neutral": "Data Security Advisor", "female": "Data Security Advisor", "male": "Data Security Advisor"},
        {"neutral": "Data Warehouse Analyst", "female": "Data Warehouse Analyst", "male": "Data Warehouse Analyst"},
        {"neutral": "Database Analyst*in", "female": "Database Analystin", "male": "Database Analyst"},
        {"neutral": "Database Developer", "female": "Database Developer", "male": "Database Developer"},
        {"neutral": "Database Engineer", "female": "Database Engineer", "male": "Database Engineer"},
        {"neutral": "Database Executive", "female": "Database Executive", "male": "Database Executive"},
        {"neutral": "Database Manager*in", "female": "Database Managerin", "male": "Database Manager"},
        {"neutral": "Database Professional", "female": "Database Professional", "male": "Database Professional"},
        {
            "neutral": "Database Systems Analyst",
            "female": "Database Systems Analyst",
            "male": "Database Systems Analyst",
        },
        {
            "neutral": "Database-Administrator*in",
            "female": "Database-Administratorin",
            "male": "Database-Administrator",
        },
        {"neutral": "Datascout", "female": "Datascout", "male": "Datascout"},
        {"neutral": "Datenanalytiker*in", "female": "Datenanalytikerin", "male": "Datenanalytiker"},
        {"neutral": "Datenarchivar*in", "female": "Datenarchivarin", "male": "Datenarchivar"},
        {
            "neutral": "Datenbankadministrator*in",
            "female": "Datenbankadministratorin",
            "male": "Datenbankadministrator",
        },
        {"neutral": "Datenbankentwickler*in", "female": "Datenbankentwicklerin", "male": "Datenbankentwickler"},
        {
            "neutral": "Datenbankprogrammierer*in",
            "female": "Datenbankprogrammiererin",
            "male": "Datenbankprogrammierer",
        },
        {"neutral": "Datenbankspezialist*in", "female": "Datenbankspezialistin", "male": "Datenbankspezialist"},
        {"neutral": "Datenbankverwalter*in", "female": "Datenbankverwalterin", "male": "Datenbankverwalter"},
        {"neutral": "Datenmanager*in", "female": "Datenmanagerin", "male": "Datenmanager"},
        {"neutral": "Datenmodellierer*in", "female": "Datenmodelliererin", "male": "Datenmodellierer"},
        {"neutral": "Datenschutzbeauftragte*r", "female": "Datenschutzbeauftragte", "male": "Datenschutzbeauftragter"},
        {
            "neutral": "Datensicherheitsexpert*in",
            "female": "Datensicherheitsexpertin",
            "male": "Datensicherheitsexpert",
        },
        {
            "neutral": "Datensicherheitstechniker*in",
            "female": "Datensicherheitstechnikerin",
            "male": "Datensicherheitstechniker",
        },
        {"neutral": "Deep Learning Engineer", "female": "Deep Learning Engineer", "male": "Deep Learning Engineer"},
        {"neutral": "Dekorateur*in", "female": "Dekorateurin", "male": "Dekorateur"},
        {
            "neutral": "Denk- und Gedächtnistrainer*in",
            "female": "Denk- und Gedächtnistrainerin",
            "male": "Denk- und Gedächtnistrainer",
        },
        {
            "neutral": "Denkmal- und Ensembelschützer*in",
            "female": "Denkmal- und Ensembelschützerin",
            "male": "Denkmal- und Ensembelschützer",
        },
        {
            "neutral": "Denkmal-, Fassaden- und Gebäudereiniger*in",
            "female": "Denkmal-, Fassaden- und Gebäudereinigerin",
            "male": "Denkmal-, Fassaden- und Gebäudereiniger",
        },
        {"neutral": "Deponiewart*in", "female": "Deponiewartin", "male": "Deponiewart"},
        {"neutral": "Designer*in", "female": "Designerin", "male": "Designer"},
        {
            "neutral": "Desinfektionsassistent*in",
            "female": "Desinfektionsassistentin",
            "male": "Desinfektionsassistent",
        },
        {
            "neutral": "Desinfektionsgehilfe / Desinfektionsgehilfin",
            "female": "Desinfektionsgehilfin",
            "male": "Desinfektionsgehilfe",
        },
        {"neutral": "Desktop Publisher", "female": "Desktop Publisher", "male": "Desktop Publisher"},
        {
            "neutral": "Dessinateur*in für Stoffdruck",
            "female": "Dessinateurin für Stoffdruck",
            "male": "Dessinateur für Stoffdruck",
        },
        {"neutral": "Destillateur*in", "female": "Destillateurin", "male": "Destillateur"},
        {"neutral": "Detektiv*in", "female": "Detektivin", "male": "Detektiv"},
        {"neutral": "DevOps Engineer", "female": "DevOps Engineer", "male": "DevOps Engineer"},
        {"neutral": "Devisenhändler*in", "female": "Devisenhändlerin", "male": "Devisenhändler"},
        {"neutral": "Diabetesberater*in", "female": "Diabetesberaterin", "male": "Diabetesberater"},
        {"neutral": "Diakon*in", "female": "Diakonin", "male": "Diakon"},
        {
            "neutral": "Dienstleistungsassistent*in",
            "female": "Dienstleistungsassistentin",
            "male": "Dienstleistungsassistent",
        },
        {"neutral": "Digital Artist", "female": "Digital Artist", "male": "Digital Artist"},
        {"neutral": "Digital Banker", "female": "Digital Banker", "male": "Digital Banker"},
        {
            "neutral": "Digital Learning Designer",
            "female": "Digital Learning Designer",
            "male": "Digital Learning Designer",
        },
        {
            "neutral": "Digital Marketing Specialist",
            "female": "Digital Marketing Specialist",
            "male": "Digital Marketing Specialist",
        },
        {
            "neutral": "Digitalisierungsberater*in",
            "female": "Digitalisierungsberaterin",
            "male": "Digitalisierungsberater",
        },
        {"neutral": "Diplom-Sozialbetreuer*in", "female": "Diplom-Sozialbetreuerin", "male": "Diplom-Sozialbetreuer"},
        {
            "neutral": "Diplom-Sozialbetreuer*in für Familienarbeit",
            "female": "Diplom-Sozialbetreuerin für Familienarbeit",
            "male": "Diplom-Sozialbetreuer für Familienarbeit",
        },
        {"neutral": "Diplomat*in", "female": "Diplomatin", "male": "Diplomat"},
        {
            "neutral": "Diplomierte Medizinisch-technische Fachkraft",
            "female": "Diplomierte Medizinisch-technische Fachkraft",
            "male": "Diplomierte Medizinisch-technische Fachkraft",
        },
        {
            "neutral": "Diplomierte*r Gesundheits- und Krankenpfleger*in",
            "female": "Diplomierte Gesundheits- und Krankenpflegerin",
            "male": "Diplomierter Gesundheits- und Krankenpfleger",
        },
        {
            "neutral": "Diplomierte*r Kardiotechniker*in",
            "female": "Diplomierte Kardiotechnikerin",
            "male": "Diplomierter Kardiotechniker",
        },
        {
            "neutral": "Diplomierte*r Kinderkrankenpfleger*in",
            "female": "Diplomierte Kinderkrankenpflegerin",
            "male": "Diplomierter Kinderkrankenpfleger",
        },
        {
            "neutral": "Diplomierte*r medizinische*r Fachassistent*in (MFA)",
            "female": "Diplomierte medizinischer Fachassistentin (MFA)",
            "male": "Diplomierter medizinischer Fachassistent (MFA)",
        },
        {
            "neutral": "Diplomierte*r psychiatrische*r Gesundheits- und Krankenpfleger*in",
            "female": "Diplomierte psychiatrischer Gesundheits- und Krankenpflegerin",
            "male": "Diplomierter psychiatrischer Gesundheits- und Krankenpfleger",
        },
        {"neutral": "Diplomrechtspfleger*in", "female": "Diplomrechtspflegerin", "male": "Diplomrechtspfleger"},
        {
            "neutral": "Direct-Marketing-Manager*in",
            "female": "Direct-Marketing-Managerin",
            "male": "Direct-Marketing-Manager",
        },
        {"neutral": "Direktberater*in", "female": "Direktberaterin", "male": "Direktberater"},
        {"neutral": "Dirigent*in", "female": "Dirigentin", "male": "Dirigent"},
        {
            "neutral": "Dispatcher  - Flugverkehr",
            "female": "Dispatcher  - Flugverkehr",
            "male": "Dispatcher  - Flugverkehr",
        },
        {"neutral": "Disponent*in", "female": "Disponentin", "male": "Disponent"},
        {"neutral": "Diversity Manager*in", "female": "Diversity Managerin", "male": "Diversity Manager"},
        {"neutral": "Diätkoch / Diätköchin", "female": "Diätköchin", "male": "Diätkoch"},
        {"neutral": "Diätologe / Diätologin", "female": "Diätologin", "male": "Diätologe"},
        {"neutral": "Dokumentar*in", "female": "Dokumentarin", "male": "Dokumentar"},
        {"neutral": "Dolmetscher*in", "female": "Dolmetscherin", "male": "Dolmetscher"},
        {
            "neutral": "Dolmetscher*in, Übersetzer*in bei der EU",
            "female": "Dolmetscherin, Übersetzerin bei der EU",
            "male": "Dolmetscher, Übersetzer bei der EU",
        },
        {"neutral": "Dorfhelfer*in", "female": "Dorfhelferin", "male": "Dorfhelfer"},
        {
            "neutral": "Dorfleiter*in (Kinderdorf)",
            "female": "Dorfleiterin (Kinderdorf)",
            "male": "Dorfleiter (Kinderdorf)",
        },
        {
            "neutral": "Drachenflug- und Paragleitlehrer*in",
            "female": "Drachenflug- und Paragleitlehrerin",
            "male": "Drachenflug- und Paragleitlehrer",
        },
        {"neutral": "Dramatiker*in", "female": "Dramatikerin", "male": "Dramatiker"},
        {"neutral": "Dramaturg*in", "female": "Dramaturgin", "male": "Dramaturg"},
        {"neutral": "Drechsler*in", "female": "Drechslerin", "male": "Drechsler"},
        {"neutral": "Drehbuchautor*in", "female": "Drehbuchautorin", "male": "Drehbuchautor"},
        {"neutral": "Dreher*in", "female": "Dreherin", "male": "Dreher"},
        {"neutral": "Drogist*in", "female": "Drogistin", "male": "Drogist"},
        {"neutral": "Drohnenfluglehrer*in", "female": "Drohnenfluglehrerin", "male": "Drohnenfluglehrer"},
        {"neutral": "Drohnenpilot*in", "female": "Drohnenpilotin", "male": "Drohnenpilot"},
        {"neutral": "Dropshipper", "female": "Dropshipper", "male": "Dropshipper"},
        {"neutral": "Drucker*in", "female": "Druckerin", "male": "Drucker"},
        {"neutral": "Drucktechnik", "female": "Drucktechnik", "male": "Drucktechnik"},
        {
            "neutral": "Drucktechnik - Bogenflachdruck",
            "female": "Drucktechnik - Bogenflachdruck",
            "male": "Drucktechnik - Bogenflachdruck",
        },
        {
            "neutral": "Drucktechnik - Digitaldruck",
            "female": "Drucktechnik - Digitaldruck",
            "male": "Drucktechnik - Digitaldruck",
        },
        {
            "neutral": "Drucktechnik - Rollenrotationsdruck",
            "female": "Drucktechnik - Rollenrotationsdruck",
            "male": "Drucktechnik - Rollenrotationsdruck",
        },
        {
            "neutral": "Drucktechnik - Siebdruck",
            "female": "Drucktechnik - Siebdruck",
            "male": "Drucktechnik - Siebdruck",
        },
        {"neutral": "Druckvorstufentechnik", "female": "Druckvorstufentechnik", "male": "Druckvorstufentechnik"},
        {
            "neutral": "E-Business-Key-Account-Manager*in",
            "female": "E-Business-Key-Account-Managerin",
            "male": "E-Business-Key-Account-Manager",
        },
        {
            "neutral": "E-Business-Projektmanager*in",
            "female": "E-Business-Projektmanagerin",
            "male": "E-Business-Projektmanager",
        },
        {"neutral": "E-Commerce-Assistent*in", "female": "E-Commerce-Assistentin", "male": "E-Commerce-Assistent"},
        {"neutral": "E-Commerce-Consultant", "female": "E-Commerce-Consultant", "male": "E-Commerce-Consultant"},
        {
            "neutral": "E-Commerce-Kaufmann / E-Commerce-Kauffrau",
            "female": "E-Commerce-Kauffrau",
            "male": "E-Commerce-Kaufmann",
        },
        {"neutral": "E-Commerce-Manager*in", "female": "E-Commerce-Managerin", "male": "E-Commerce-Manager"},
        {"neutral": "E-Jurist*in", "female": "E-Juristin", "male": "E-Jurist"},
        {"neutral": "E-Learning-Autor*in", "female": "E-Learning-Autorin", "male": "E-Learning-Autor"},
        {"neutral": "E-Logistiker*in", "female": "E-Logistikerin", "male": "E-Logistiker"},
        {"neutral": "E-Sportler*in", "female": "E-Sportlerin", "male": "E-Sportler"},
        {"neutral": "EDV-Consultant", "female": "EDV-Consultant", "male": "EDV-Consultant"},
        {"neutral": "EDV-Kaufmann / EDV-Kauffrau", "female": "EDV-Kauffrau", "male": "EDV-Kaufmann"},
        {"neutral": "EDV-Servicetechniker*in", "female": "EDV-Servicetechnikerin", "male": "EDV-Servicetechniker"},
        {"neutral": "EDV-Systemtechnik", "female": "EDV-Systemtechnik", "male": "EDV-Systemtechnik"},
        {"neutral": "EDV-Techniker*in", "female": "EDV-Technikerin", "male": "EDV-Techniker"},
        {"neutral": "ERP-Consultant", "female": "ERP-Consultant", "male": "ERP-Consultant"},
        {"neutral": "EU-Beamter / EU-Beamtin", "female": "EU-Beamtin", "male": "EU-Beamter"},
        {"neutral": "Edelsteinschleifer*in", "female": "Edelsteinschleiferin", "male": "Edelsteinschleifer"},
        {
            "neutral": "Ehe- und Familienberater*in",
            "female": "Ehe- und Familienberaterin",
            "male": "Ehe- und Familienberater",
        },
        {"neutral": "Einkäufer*in", "female": "Einkäuferin", "male": "Einkäufer"},
        {
            "neutral": "Einkäufer*in (Gastgewerbe)",
            "female": "Einkäuferin (Gastgewerbe)",
            "male": "Einkäufer (Gastgewerbe)",
        },
        {"neutral": "Einrichtungsberater*in", "female": "Einrichtungsberaterin", "male": "Einrichtungsberater"},
        {"neutral": "Einzelhandel", "female": "Einzelhandel", "male": "Einzelhandel"},
        {
            "neutral": "Einzelhandel - Allgemeiner Einzelhandel",
            "female": "Einzelhandel - Allgemeiner Einzelhandel",
            "male": "Einzelhandel - Allgemeiner Einzelhandel",
        },
        {
            "neutral": "Einzelhandel - Baustoffhandel",
            "female": "Einzelhandel - Baustoffhandel",
            "male": "Einzelhandel - Baustoffhandel",
        },
        {
            "neutral": "Einzelhandel - Digitaler Verkauf",
            "female": "Einzelhandel - Digitaler Verkauf",
            "male": "Einzelhandel - Digitaler Verkauf",
        },
        {
            "neutral": "Einzelhandel - Einrichtungsberatung",
            "female": "Einzelhandel - Einrichtungsberatung",
            "male": "Einzelhandel - Einrichtungsberatung",
        },
        {
            "neutral": "Einzelhandel - Eisen- und Hartwaren",
            "female": "Einzelhandel - Eisen- und Hartwaren",
            "male": "Einzelhandel - Eisen- und Hartwaren",
        },
        {
            "neutral": "Einzelhandel - Elektro-Elektronikberatung",
            "female": "Einzelhandel - Elektro-Elektronikberatung",
            "male": "Einzelhandel - Elektro-Elektronikberatung",
        },
        {
            "neutral": "Einzelhandel - Feinkostfachverkauf",
            "female": "Einzelhandel - Feinkostfachverkauf",
            "male": "Einzelhandel - Feinkostfachverkauf",
        },
        {
            "neutral": "Einzelhandel - Gartencenter",
            "female": "Einzelhandel - Gartencenter",
            "male": "Einzelhandel - Gartencenter",
        },
        {
            "neutral": "Einzelhandel - Kraftfahrzeuge und Ersatzteile",
            "female": "Einzelhandel - Kraftfahrzeuge und Ersatzteile",
            "male": "Einzelhandel - Kraftfahrzeuge und Ersatzteile",
        },
        {
            "neutral": "Einzelhandel - Lebensmittelhandel",
            "female": "Einzelhandel - Lebensmittelhandel",
            "male": "Einzelhandel - Lebensmittelhandel",
        },
        {
            "neutral": "Einzelhandel - Parfümerie",
            "female": "Einzelhandel - Parfümerie",
            "male": "Einzelhandel - Parfümerie",
        },
        {"neutral": "Einzelhandel - Schuhe", "female": "Einzelhandel - Schuhe", "male": "Einzelhandel - Schuhe"},
        {
            "neutral": "Einzelhandel - Sportartikel",
            "female": "Einzelhandel - Sportartikel",
            "male": "Einzelhandel - Sportartikel",
        },
        {
            "neutral": "Einzelhandel - Telekommunikation",
            "female": "Einzelhandel - Telekommunikation",
            "male": "Einzelhandel - Telekommunikation",
        },
        {
            "neutral": "Einzelhandel - Textilhandel",
            "female": "Einzelhandel - Textilhandel",
            "male": "Einzelhandel - Textilhandel",
        },
        {
            "neutral": "Einzelhandel - Uhren- und Juwelenberatung",
            "female": "Einzelhandel - Uhren- und Juwelenberatung",
            "male": "Einzelhandel - Uhren- und Juwelenberatung",
        },
        {
            "neutral": "Eisenbahnbetriebstechnik",
            "female": "Eisenbahnbetriebstechnik",
            "male": "Eisenbahnbetriebstechnik",
        },
        {"neutral": "Eisenbahnelektrotechnik", "female": "Eisenbahnelektrotechnik", "male": "Eisenbahnelektrotechnik"},
        {
            "neutral": "Eisenbahnfahrzeuginstandhaltungstechnik",
            "female": "Eisenbahnfahrzeuginstandhaltungstechnik",
            "male": "Eisenbahnfahrzeuginstandhaltungstechnik",
        },
        {
            "neutral": "Eisenbahnfahrzeugtechnik",
            "female": "Eisenbahnfahrzeugtechnik",
            "male": "Eisenbahnfahrzeugtechnik",
        },
        {
            "neutral": "Eisenbahnsicherungstechnik",
            "female": "Eisenbahnsicherungstechnik",
            "male": "Eisenbahnsicherungstechnik",
        },
        {
            "neutral": "Eisenbahntelekommunikationstechnik",
            "female": "Eisenbahntelekommunikationstechnik",
            "male": "Eisenbahntelekommunikationstechnik",
        },
        {
            "neutral": "Eisenbahntransporttechnik",
            "female": "Eisenbahntransporttechnik",
            "male": "Eisenbahntransporttechnik",
        },
        {
            "neutral": "Electronic-Marketing-Manager*in",
            "female": "Electronic-Marketing-Managerin",
            "male": "Electronic-Marketing-Manager",
        },
        {"neutral": "Elektriker*in", "female": "Elektrikerin", "male": "Elektriker"},
        {"neutral": "Elektroanlagentechnik", "female": "Elektroanlagentechnik", "male": "Elektroanlagentechnik"},
        {"neutral": "Elektrobetriebstechnik", "female": "Elektrobetriebstechnik", "male": "Elektrobetriebstechnik"},
        {
            "neutral": "Elektrobetriebstechnik mit Schwerpunkt Prozessleittechnik",
            "female": "Elektrobetriebstechnik mit Schwerpunkt Prozessleittechnik",
            "male": "Elektrobetriebstechnik mit Schwerpunkt Prozessleittechnik",
        },
        {"neutral": "Elektroenergietechnik", "female": "Elektroenergietechnik", "male": "Elektroenergietechnik"},
        {"neutral": "Elektroinstallateur*in", "female": "Elektroinstallateurin", "male": "Elektroinstallateur"},
        {
            "neutral": "Elektroinstallationstechnik",
            "female": "Elektroinstallationstechnik",
            "male": "Elektroinstallationstechnik",
        },
        {
            "neutral": "Elektroinstallationstechnik mit Schwerpunkt Prozessleit- und Bustechnik",
            "female": "Elektroinstallationstechnik mit Schwerpunkt Prozessleit- und Bustechnik",
            "male": "Elektroinstallationstechnik mit Schwerpunkt Prozessleit- und Bustechnik",
        },
        {"neutral": "Elektromaschinentechnik", "female": "Elektromaschinentechnik", "male": "Elektromaschinentechnik"},
        {
            "neutral": "Elektromechaniker*in für Schwachstrom",
            "female": "Elektromechanikerin für Schwachstrom",
            "male": "Elektromechaniker für Schwachstrom",
        },
        {
            "neutral": "Elektromechaniker*in für Starkstrom",
            "female": "Elektromechanikerin für Starkstrom",
            "male": "Elektromechaniker für Starkstrom",
        },
        {
            "neutral": "Elektromechaniker*in und -maschinenbauer*in",
            "female": "Elektromechanikerin und -maschinenbauerin",
            "male": "Elektromechaniker und -maschinenbauer",
        },
        {
            "neutral": "Elektromedizintechniker*in",
            "female": "Elektromedizintechnikerin",
            "male": "Elektromedizintechniker",
        },
        {"neutral": "Elektronik", "female": "Elektronik", "male": "Elektronik"},
        {
            "neutral": "Elektronik - Angewandte Elektronik",
            "female": "Elektronik - Angewandte Elektronik",
            "male": "Elektronik - Angewandte Elektronik",
        },
        {
            "neutral": "Elektronik - Informations- und Kommunikationselektronik",
            "female": "Elektronik - Informations- und Kommunikationselektronik",
            "male": "Elektronik - Informations- und Kommunikationselektronik",
        },
        {
            "neutral": "Elektronik - Informations- und Telekommunikationstechnik",
            "female": "Elektronik - Informations- und Telekommunikationstechnik",
            "male": "Elektronik - Informations- und Telekommunikationstechnik",
        },
        {
            "neutral": "Elektronik - Kommunikationselektronik",
            "female": "Elektronik - Kommunikationselektronik",
            "male": "Elektronik - Kommunikationselektronik",
        },
        {
            "neutral": "Elektronik - Mikrotechnik",
            "female": "Elektronik - Mikrotechnik",
            "male": "Elektronik - Mikrotechnik",
        },
        {"neutral": "Elektroniker*in", "female": "Elektronikerin", "male": "Elektroniker"},
        {
            "neutral": "Elektroniker*in (Assistenztechnologien)",
            "female": "Elektronikerin (Assistenztechnologien)",
            "male": "Elektroniker (Assistenztechnologien)",
        },
        {
            "neutral": "Elektroniker*in (Gebäude- und Infrastruktursysteme)",
            "female": "Elektronikerin (Gebäude- und Infrastruktursysteme)",
            "male": "Elektroniker (Gebäude- und Infrastruktursysteme)",
        },
        {
            "neutral": "Elektroniker*in (Industrieelektronik)",
            "female": "Elektronikerin (Industrieelektronik)",
            "male": "Elektroniker (Industrieelektronik)",
        },
        {"neutral": "Elektrotechnik", "female": "Elektrotechnik", "male": "Elektrotechnik"},
        {
            "neutral": "Elektrotechnik - Anlagen- und Betriebstechnik",
            "female": "Elektrotechnik - Anlagen- und Betriebstechnik",
            "male": "Elektrotechnik - Anlagen- und Betriebstechnik",
        },
        {
            "neutral": "Elektrotechnik - Automatisierungs- und Prozessleittechnik",
            "female": "Elektrotechnik - Automatisierungs- und Prozessleittechnik",
            "male": "Elektrotechnik - Automatisierungs- und Prozessleittechnik",
        },
        {
            "neutral": "Elektrotechnik - Elektro- und Gebäudetechnik",
            "female": "Elektrotechnik - Elektro- und Gebäudetechnik",
            "male": "Elektrotechnik - Elektro- und Gebäudetechnik",
        },
        {
            "neutral": "Elektrotechnik - Energietechnik",
            "female": "Elektrotechnik - Energietechnik",
            "male": "Elektrotechnik - Energietechnik",
        },
        {"neutral": "Elektrotechniker*in", "female": "Elektrotechnikerin", "male": "Elektrotechniker"},
        {
            "neutral": "Elementarpädagoge / Elementarpädagogin",
            "female": "Elementarpädagogin",
            "male": "Elementarpädagoge",
        },
        {"neutral": "Emailleur*in", "female": "Emailleurin", "male": "Emailleur"},
        {
            "neutral": "Embedded Systems Engineer",
            "female": "Embedded Systems Engineer",
            "male": "Embedded Systems Engineer",
        },
        {"neutral": "Energetiker*in", "female": "Energetikerin", "male": "Energetiker"},
        {"neutral": "Energieberater*in", "female": "Energieberaterin", "male": "Energieberater"},
        {"neutral": "Energietechniker*in", "female": "Energietechnikerin", "male": "Energietechniker"},
        {
            "neutral": "Energietechniker*in (Nachhaltige Energiesysteme)",
            "female": "Energietechnikerin (Nachhaltige Energiesysteme)",
            "male": "Energietechniker (Nachhaltige Energiesysteme)",
        },
        {
            "neutral": "Energietechniker*in (Windenergie)",
            "female": "Energietechnikerin (Windenergie)",
            "male": "Energietechniker (Windenergie)",
        },
        {"neutral": "Entlassungsmanager*in", "female": "Entlassungsmanagerin", "male": "Entlassungsmanager"},
        {
            "neutral": "Entsorgungs- und Recyclingfachkraft",
            "female": "Entsorgungs- und Recyclingfachkraft",
            "male": "Entsorgungs- und Recyclingfachkraft",
        },
        {
            "neutral": "Entsorgungs- und Recyclingfachmann / Entsorgungs- und Recyclingfachfrau - Abwasser",
            "female": "Entsorgungs- und Recyclingfachfrau - Abwasser",
            "male": "Entsorgungs- und Recyclingfachmann - Abwasser",
        },
        {"neutral": "Entsorgungstechniker*in", "female": "Entsorgungstechnikerin", "male": "Entsorgungstechniker"},
        {"neutral": "Entspannungstrainer*in", "female": "Entspannungstrainerin", "male": "Entspannungstrainer"},
        {
            "neutral": "Entwickler*in für maschinelles Lernen",
            "female": "Entwicklerin für maschinelles Lernen",
            "male": "Entwickler für maschinelles Lernen",
        },
        {"neutral": "Entwicklungshelfer*in", "female": "Entwicklungshelferin", "male": "Entwicklungshelfer"},
        {"neutral": "Entwicklungsleiter*in", "female": "Entwicklungsleiterin", "male": "Entwicklungsleiter"},
        {"neutral": "Entwicklungsökonom*in", "female": "Entwicklungsökonomin", "male": "Entwicklungsökonom"},
        {"neutral": "Erdarbeiter*in", "female": "Erdarbeiterin", "male": "Erdarbeiter"},
        {"neutral": "Erdwissenschafter*in", "female": "Erdwissenschafterin", "male": "Erdwissenschafter"},
        {"neutral": "Erdölchemiker*in", "female": "Erdölchemikerin", "male": "Erdölchemiker"},
        {"neutral": "Erdölingenieur*in", "female": "Erdölingenieurin", "male": "Erdölingenieur"},
        {"neutral": "Erdöltechniker*in", "female": "Erdöltechnikerin", "male": "Erdöltechniker"},
        {"neutral": "Ergonom*in", "female": "Ergonomin", "male": "Ergonom"},
        {"neutral": "Ergotherapeut*in", "female": "Ergotherapeutin", "male": "Ergotherapeut"},
        {
            "neutral": "Ergotherapiegehilfe / Ergotherapiegehilfin",
            "female": "Ergotherapiegehilfin",
            "male": "Ergotherapiegehilfe",
        },
        {
            "neutral": "Ernährungscoach (w./m./d.)",
            "female": "Ernährungscoach (w./m./d.)",
            "male": "Ernährungscoach (w./m./d.)",
        },
        {"neutral": "Ernährungstrainer*in", "female": "Ernährungstrainerin", "male": "Ernährungstrainer"},
        {
            "neutral": "Ernährungswissenschafter*in",
            "female": "Ernährungswissenschafterin",
            "male": "Ernährungswissenschafter",
        },
        {"neutral": "Erwachsenenbildner*in", "female": "Erwachsenenbildnerin", "male": "Erwachsenenbildner"},
        {"neutral": "Erzieher*in", "female": "Erzieherin", "male": "Erzieher"},
        {
            "neutral": "Erziehungswissenschafter*in",
            "female": "Erziehungswissenschafterin",
            "male": "Erziehungswissenschafter",
        },
        {"neutral": "Essenszusteller*in", "female": "Essenszustellerin", "male": "Essenszusteller"},
        {"neutral": "Essenzusteller*in", "female": "Essenzustellerin", "male": "Essenzusteller"},
        {"neutral": "Ethical Hacker", "female": "Ethical Hacker", "male": "Ethical Hacker"},
        {
            "neutral": "Ethnologe / Ethnologin (Völkerkundler*in)",
            "female": "Ethnologin (Völkerkundlerin)",
            "male": "Ethnologe (Völkerkundler)",
        },
        {"neutral": "Ethologe / Ethologin", "female": "Ethologin", "male": "Ethologe"},
        {
            "neutral": "Etui- und Kassettenerzeuger*in",
            "female": "Etui- und Kassettenerzeugerin",
            "male": "Etui- und Kassettenerzeuger",
        },
        {"neutral": "Europa Assistent*in", "female": "Europa Assistentin", "male": "Europa Assistent"},
        {"neutral": "Eventkaufmann / Eventkauffrau", "female": "Eventkauffrau", "male": "Eventkaufmann"},
        {"neutral": "Eventmanager*in", "female": "Eventmanagerin", "male": "Eventmanager"},
        {"neutral": "Eventveranstalter*in", "female": "Eventveranstalterin", "male": "Eventveranstalter"},
        {
            "neutral": "Exekutivbedienstete*r im Justizwachdienst",
            "female": "Exekutivbedienstete im Justizwachdienst",
            "male": "Exekutivbediensteter im Justizwachdienst",
        },
        {
            "neutral": "Exekutivbedienstete*r im Polizeidienst",
            "female": "Exekutivbedienstete im Polizeidienst",
            "male": "Exekutivbediensteter im Polizeidienst",
        },
        {"neutral": "Exportkaufmann / Exportkauffrau", "female": "Exportkauffrau", "male": "Exportkaufmann"},
        {
            "neutral": "Fach- und Diplom-Sozialbetreuer*in für Altenarbeit",
            "female": "Fach- und Diplom-Sozialbetreuerin für Altenarbeit",
            "male": "Fach- und Diplom-Sozialbetreuer für Altenarbeit",
        },
        {
            "neutral": "Fach- und Diplom-Sozialbetreuer*in für Behindertenarbeit (BA)",
            "female": "Fach- und Diplom-Sozialbetreuerin für Behindertenarbeit (BA)",
            "male": "Fach- und Diplom-Sozialbetreuer für Behindertenarbeit (BA)",
        },
        {
            "neutral": "Fach- und Diplom-Sozialbetreuer*in für Behindertenbegleitung (BB)",
            "female": "Fach- und Diplom-Sozialbetreuerin für Behindertenbegleitung (BB)",
            "male": "Fach- und Diplom-Sozialbetreuer für Behindertenbegleitung (BB)",
        },
        {
            "neutral": "Fach-Sozialbetreuer*in / Diplom-Sozialbetreuer*in",
            "female": "Fach-Sozialbetreuerin / Diplom-Sozialbetreuerin",
            "male": "Fach-Sozialbetreuer / Diplom-Sozialbetreuer",
        },
        {"neutral": "Fach-Sozialhelfer*in", "female": "Fach-Sozialhelferin", "male": "Fach-Sozialhelfer"},
        {"neutral": "Facharzt / Fachärztin", "female": "Fachärztin", "male": "Facharzt"},
        {
            "neutral": "Facharzt / Fachärztin für Allgemeinchirurgie",
            "female": "Fachärztin für Allgemeinchirurgie",
            "male": "Facharzt für Allgemeinchirurgie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Anatomie",
            "female": "Fachärztin für Anatomie",
            "male": "Facharzt für Anatomie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Anästhesiologie und Intensivmedizin",
            "female": "Fachärztin für Anästhesiologie und Intensivmedizin",
            "male": "Facharzt für Anästhesiologie und Intensivmedizin",
        },
        {
            "neutral": "Facharzt / Fachärztin für Arbeitsmedizin und angewandte Physiologie",
            "female": "Fachärztin für Arbeitsmedizin und angewandte Physiologie",
            "male": "Facharzt für Arbeitsmedizin und angewandte Physiologie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Augenheilkunde und Optometrie",
            "female": "Fachärztin für Augenheilkunde und Optometrie",
            "male": "Facharzt für Augenheilkunde und Optometrie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Frauenheilkunde und Geburtshilfe",
            "female": "Fachärztin für Frauenheilkunde und Geburtshilfe",
            "male": "Facharzt für Frauenheilkunde und Geburtshilfe",
        },
        {
            "neutral": "Facharzt / Fachärztin für Gerichtsmedizin",
            "female": "Fachärztin für Gerichtsmedizin",
            "male": "Facharzt für Gerichtsmedizin",
        },
        {
            "neutral": "Facharzt / Fachärztin für Hals-, Nasen- und Ohrenheilkunde",
            "female": "Fachärztin für Hals-, Nasen- und Ohrenheilkunde",
            "male": "Facharzt für Hals-, Nasen- und Ohrenheilkunde",
        },
        {
            "neutral": "Facharzt / Fachärztin für Haut- und Geschlechtskrankheiten",
            "female": "Fachärztin für Haut- und Geschlechtskrankheiten",
            "male": "Facharzt für Haut- und Geschlechtskrankheiten",
        },
        {
            "neutral": "Facharzt / Fachärztin für Herzchirurgie",
            "female": "Fachärztin für Herzchirurgie",
            "male": "Facharzt für Herzchirurgie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Histologie, Embryologie und Zellbiologie",
            "female": "Fachärztin für Histologie, Embryologie und Zellbiologie",
            "male": "Facharzt für Histologie, Embryologie und Zellbiologie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Immunologie und Spezifische Prophylaxe und Tropenmedizin",
            "female": "Fachärztin für Immunologie und Spezifische Prophylaxe und Tropenmedizin",
            "male": "Facharzt für Immunologie und Spezifische Prophylaxe und Tropenmedizin",
        },
        {
            "neutral": "Facharzt / Fachärztin für Innere Medizin",
            "female": "Fachärztin für Innere Medizin",
            "male": "Facharzt für Innere Medizin",
        },
        {
            "neutral": "Facharzt / Fachärztin für Kinder- und Jugendchirurgie",
            "female": "Fachärztin für Kinder- und Jugendchirurgie",
            "male": "Facharzt für Kinder- und Jugendchirurgie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Kinder- und Jugendheilkunde",
            "female": "Fachärztin für Kinder- und Jugendheilkunde",
            "male": "Facharzt für Kinder- und Jugendheilkunde",
        },
        {
            "neutral": "Facharzt / Fachärztin für Kinder- und Jugendpsychiatrie und Psychotherapeutische Medizin",
            "female": "Fachärztin für Kinder- und Jugendpsychiatrie und Psychotherapeutische Medizin",
            "male": "Facharzt für Kinder- und Jugendpsychiatrie und Psychotherapeutische Medizin",
        },
        {
            "neutral": "Facharzt / Fachärztin für Medizinische Genetik",
            "female": "Fachärztin für Medizinische Genetik",
            "male": "Facharzt für Medizinische Genetik",
        },
        {
            "neutral": "Facharzt / Fachärztin für Medizinische und Chemische Labordiagnostik",
            "female": "Fachärztin für Medizinische und Chemische Labordiagnostik",
            "male": "Facharzt für Medizinische und Chemische Labordiagnostik",
        },
        {
            "neutral": "Facharzt / Fachärztin für Mund-, Kiefer- und Gesichtschirurgie",
            "female": "Fachärztin für Mund-, Kiefer- und Gesichtschirurgie",
            "male": "Facharzt für Mund-, Kiefer- und Gesichtschirurgie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Neurochirurgie",
            "female": "Fachärztin für Neurochirurgie",
            "male": "Facharzt für Neurochirurgie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Neurologie",
            "female": "Fachärztin für Neurologie",
            "male": "Facharzt für Neurologie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Nuklearmedizin",
            "female": "Fachärztin für Nuklearmedizin",
            "male": "Facharzt für Nuklearmedizin",
        },
        {
            "neutral": "Facharzt / Fachärztin für Orthopädie und Traumatologie",
            "female": "Fachärztin für Orthopädie und Traumatologie",
            "male": "Facharzt für Orthopädie und Traumatologie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Pharmakologie und Toxikologie",
            "female": "Fachärztin für Pharmakologie und Toxikologie",
            "male": "Facharzt für Pharmakologie und Toxikologie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Physikalische Medizin und Allgemeine Rehabilitation",
            "female": "Fachärztin für Physikalische Medizin und Allgemeine Rehabilitation",
            "male": "Facharzt für Physikalische Medizin und Allgemeine Rehabilitation",
        },
        {
            "neutral": "Facharzt / Fachärztin für Physiologie und Pathophysiologie",
            "female": "Fachärztin für Physiologie und Pathophysiologie",
            "male": "Facharzt für Physiologie und Pathophysiologie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Plastische, Rekonstruktive und Ästhetische Chirurgie",
            "female": "Fachärztin für Plastische, Rekonstruktive und Ästhetische Chirurgie",
            "male": "Facharzt für Plastische, Rekonstruktive und Ästhetische Chirurgie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Psychiatrie und Psychotherapeutische Medizin",
            "female": "Fachärztin für Psychiatrie und Psychotherapeutische Medizin",
            "male": "Facharzt für Psychiatrie und Psychotherapeutische Medizin",
        },
        {
            "neutral": "Facharzt / Fachärztin für Public Health",
            "female": "Fachärztin für Public Health",
            "male": "Facharzt für Public Health",
        },
        {
            "neutral": "Facharzt / Fachärztin für Radiologie",
            "female": "Fachärztin für Radiologie",
            "male": "Facharzt für Radiologie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Strahlentherapie-Radioonkologie",
            "female": "Fachärztin für Strahlentherapie-Radioonkologie",
            "male": "Facharzt für Strahlentherapie-Radioonkologie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Thoraxchirurgie",
            "female": "Fachärztin für Thoraxchirurgie",
            "male": "Facharzt für Thoraxchirurgie",
        },
        {
            "neutral": "Facharzt / Fachärztin für Transfusionsmedizin",
            "female": "Fachärztin für Transfusionsmedizin",
            "male": "Facharzt für Transfusionsmedizin",
        },
        {
            "neutral": "Facharzt / Fachärztin für Urologie",
            "female": "Fachärztin für Urologie",
            "male": "Facharzt für Urologie",
        },
        {
            "neutral": "Facharzt / Fachärztin für klinische Immunologie",
            "female": "Fachärztin für klinische Immunologie",
            "male": "Facharzt für klinische Immunologie",
        },
        {
            "neutral": "Facharzt / Fachärztin für klinische Mikrobilogie und Virologie",
            "female": "Fachärztin für klinische Mikrobilogie und Virologie",
            "male": "Facharzt für klinische Mikrobilogie und Virologie",
        },
        {
            "neutral": "Facharzt / Fachärztin für klinische Mikrobiologie und Hygiene",
            "female": "Fachärztin für klinische Mikrobiologie und Hygiene",
            "male": "Facharzt für klinische Mikrobiologie und Hygiene",
        },
        {
            "neutral": "Facharzt / Fachärztin für klinische Pathologie und Molekularpathologie",
            "female": "Fachärztin für klinische Pathologie und Molekularpathologie",
            "male": "Facharzt für klinische Pathologie und Molekularpathologie",
        },
        {
            "neutral": "Facharzt / Fachärztin für klinische Pathologie und Neuropathologie",
            "female": "Fachärztin für klinische Pathologie und Neuropathologie",
            "male": "Facharzt für klinische Pathologie und Neuropathologie",
        },
        {"neutral": "Facility-Manager*in", "female": "Facility-Managerin", "male": "Facility-Manager"},
        {"neutral": "Fahrdienstleiter*in", "female": "Fahrdienstleiterin", "male": "Fahrdienstleiter"},
        {"neutral": "Fahrlehrer*in", "female": "Fahrlehrerin", "male": "Fahrlehrer"},
        {"neutral": "Fahrradbote/Fahrradbotin", "female": "Fahrradbotin", "male": "Fahrradbote"},
        {"neutral": "Fahrradmechaniker*in", "female": "Fahrradmechanikerin", "male": "Fahrradmechaniker"},
        {"neutral": "Fahrradmechatronik", "female": "Fahrradmechatronik", "male": "Fahrradmechatronik"},
        {"neutral": "Fahrschullehrer*in", "female": "Fahrschullehrerin", "male": "Fahrschullehrer"},
        {"neutral": "Fahrzeugbautechniker*in", "female": "Fahrzeugbautechnikerin", "male": "Fahrzeugbautechniker"},
        {"neutral": "Fahrzeugelektroniker*in", "female": "Fahrzeugelektronikerin", "male": "Fahrzeugelektroniker"},
        {"neutral": "Fahrzeugfertiger*in", "female": "Fahrzeugfertigerin", "male": "Fahrzeugfertiger"},
        {
            "neutral": "Fahrzeugtapezierer*in (Fahrzeugsattler*in)",
            "female": "Fahrzeugtapeziererin (Fahrzeugsattlerin)",
            "male": "Fahrzeugtapezierer (Fahrzeugsattler)",
        },
        {"neutral": "Fakturist*in", "female": "Fakturistin", "male": "Fakturist"},
        {"neutral": "Farb- und Typberater*in", "female": "Farb- und Typberaterin", "male": "Farb- und Typberater"},
        {"neutral": "Faserverbundtechnik", "female": "Faserverbundtechnik", "male": "Faserverbundtechnik"},
        {"neutral": "Fassader*in", "female": "Fassaderin", "male": "Fassader"},
        {"neutral": "Fassbinder*in", "female": "Fassbinderin", "male": "Fassbinder"},
        {"neutral": "Feinmechaniker*in", "female": "Feinmechanikerin", "male": "Feinmechaniker"},
        {"neutral": "Feinoptik", "female": "Feinoptik", "male": "Feinoptik"},
        {"neutral": "Feinwerktechniker*in", "female": "Feinwerktechnikerin", "male": "Feinwerktechniker"},
        {"neutral": "Feldgemüsebau", "female": "Feldgemüsebau", "male": "Feldgemüsebau"},
        {"neutral": "Feng Shui-Berater*in", "female": "Feng Shui-Beraterin", "male": "Feng Shui-Berater"},
        {"neutral": "Fensterputzer*in", "female": "Fensterputzerin", "male": "Fensterputzer"},
        {
            "neutral": "Fermentationstechniker*in",
            "female": "Fermentationstechnikerin",
            "male": "Fermentationstechniker",
        },
        {"neutral": "Fernlastfahrer*in", "female": "Fernlastfahrerin", "male": "Fernlastfahrer"},
        {"neutral": "Fernmeldebaumonteur*in", "female": "Fernmeldebaumonteurin", "male": "Fernmeldebaumonteur"},
        {"neutral": "Fernsehsprecher*in", "female": "Fernsehsprecherin", "male": "Fernsehsprecher"},
        {"neutral": "Fernwärmetechnik", "female": "Fernwärmetechnik", "male": "Fernwärmetechnik"},
        {"neutral": "Fertigteilhausbau", "female": "Fertigteilhausbau", "male": "Fertigteilhausbau"},
        {"neutral": "Fertigungsmesstechnik", "female": "Fertigungsmesstechnik", "male": "Fertigungsmesstechnik"},
        {
            "neutral": "Fertigungsmesstechnik - Produktionssteuerung",
            "female": "Fertigungsmesstechnik - Produktionssteuerung",
            "male": "Fertigungsmesstechnik - Produktionssteuerung",
        },
        {
            "neutral": "Fertigungsmesstechnik - Produktmessung",
            "female": "Fertigungsmesstechnik - Produktmessung",
            "male": "Fertigungsmesstechnik - Produktmessung",
        },
        {
            "neutral": "Fertigungstechniker*in - Produktionstechnik",
            "female": "Fertigungstechnikerin - Produktionstechnik",
            "male": "Fertigungstechniker - Produktionstechnik",
        },
        {
            "neutral": "Fertigungstechniker*in / Produktionstechniker*in",
            "female": "Fertigungstechnikerin / Produktionstechnikerin",
            "male": "Fertigungstechniker / Produktionstechniker",
        },
        {"neutral": "Fiaker*in / Kutscher*in", "female": "Fiakerin / Kutscherin", "male": "Fiaker / Kutscher"},
        {"neutral": "Field Consultant", "female": "Field Consultant", "male": "Field Consultant"},
        {"neutral": "Field Sales Trainer", "female": "Field Sales Trainer", "male": "Field Sales Trainer"},
        {"neutral": "Field Support", "female": "Field Support", "male": "Field Support"},
        {"neutral": "Figurant*in", "female": "Figurantin", "male": "Figurant"},
        {"neutral": "Filialleiter*in", "female": "Filialleiterin", "male": "Filialleiter"},
        {"neutral": "Film- und Videoeditor*in", "female": "Film- und Videoeditorin", "male": "Film- und Videoeditor"},
        {"neutral": "Filmaufnahmeleiter*in", "female": "Filmaufnahmeleiterin", "male": "Filmaufnahmeleiter"},
        {"neutral": "Filmemacher*in", "female": "Filmemacherin", "male": "Filmemacher"},
        {"neutral": "Filmregisseur*in", "female": "Filmregisseurin", "male": "Filmregisseur"},
        {
            "neutral": "Filmrestaurator*in (Archiv)",
            "female": "Filmrestauratorin (Archiv)",
            "male": "Filmrestaurator (Archiv)",
        },
        {"neutral": "Filmschnittmeister*in", "female": "Filmschnittmeisterin", "male": "Filmschnittmeister"},
        {"neutral": "Filmvorführer*in", "female": "Filmvorführerin", "male": "Filmvorführer"},
        {
            "neutral": "Finance Operations Betreuer*in",
            "female": "Finance Operations Betreuerin",
            "male": "Finance Operations Betreuer",
        },
        {
            "neutral": "Finanz- und Rechnungswesenassistenz",
            "female": "Finanz- und Rechnungswesenassistenz",
            "male": "Finanz- und Rechnungswesenassistenz",
        },
        {"neutral": "Finanzanalyst*in", "female": "Finanzanalystin", "male": "Finanzanalyst"},
        {"neutral": "Finanzbeamter / Finanzbeamtin", "female": "Finanzbeamtin", "male": "Finanzbeamter"},
        {"neutral": "Finanzberater*in", "female": "Finanzberaterin", "male": "Finanzberater"},
        {"neutral": "Finanzbuchhalter*in", "female": "Finanzbuchhalterin", "male": "Finanzbuchhalter"},
        {
            "neutral": "Finanzdienstleistungskaufmann / Finanzdienstleistungskauffrau",
            "female": "Finanzdienstleistungskauffrau",
            "male": "Finanzdienstleistungskaufmann",
        },
        {"neutral": "Fischereiwirtschaft", "female": "Fischereiwirtschaft", "male": "Fischereiwirtschaft"},
        {"neutral": "Fitnessbetreuung", "female": "Fitnessbetreuung", "male": "Fitnessbetreuung"},
        {"neutral": "Fitnesstrainer*in", "female": "Fitnesstrainerin", "male": "Fitnesstrainer"},
        {"neutral": "Flachdrucker*in", "female": "Flachdruckerin", "male": "Flachdrucker"},
        {"neutral": "Fleischer*in", "female": "Fleischerin", "male": "Fleischer"},
        {
            "neutral": "Fleischuntersucher*in und Trichinenschauer*in",
            "female": "Fleischuntersucherin und Trichinenschauerin",
            "male": "Fleischuntersucher und Trichinenschauer",
        },
        {"neutral": "Fleischverarbeitung", "female": "Fleischverarbeitung", "male": "Fleischverarbeitung"},
        {"neutral": "Fleischverkauf", "female": "Fleischverkauf", "male": "Fleischverkauf"},
        {"neutral": "Fleischwarenarbeiter*in", "female": "Fleischwarenarbeiterin", "male": "Fleischwarenarbeiter"},
        {"neutral": "Flight Engineer", "female": "Flight Engineer", "male": "Flight Engineer"},
        {"neutral": "Flight-Attendant", "female": "Flight-Attendant", "male": "Flight-Attendant"},
        {"neutral": "Florist*in", "female": "Floristin", "male": "Florist"},
        {"neutral": "Flugbegleiter*in", "female": "Flugbegleiterin", "male": "Flugbegleiter"},
        {"neutral": "Flughafenarbeiter*in", "female": "Flughafenarbeiterin", "male": "Flughafenarbeiter"},
        {"neutral": "Fluglehrer*in", "female": "Fluglehrerin", "male": "Fluglehrer"},
        {"neutral": "Fluglotse / Fluglotsin", "female": "Fluglotsin", "male": "Fluglotse"},
        {
            "neutral": "Flugsicherungsmechaniker*in",
            "female": "Flugsicherungsmechanikerin",
            "male": "Flugsicherungsmechaniker",
        },
        {"neutral": "Flugzeugbautechniker*in", "female": "Flugzeugbautechnikerin", "male": "Flugzeugbautechniker"},
        {"neutral": "Flugzeugspengler*in", "female": "Flugzeugspenglerin", "male": "Flugzeugspengler"},
        {"neutral": "Flüchtlingsbetreuer*in", "female": "Flüchtlingsbetreuerin", "male": "Flüchtlingsbetreuer"},
        {"neutral": "Fondsmanager*in", "female": "Fondsmanagerin", "male": "Fondsmanager"},
        {"neutral": "Fondsverwalter*in", "female": "Fondsverwalterin", "male": "Fondsverwalter"},
        {
            "neutral": "Food & Beverage Manager*in",
            "female": "Food & Beverage Managerin",
            "male": "Food & Beverage Manager",
        },
        {"neutral": "Food Blogger*in", "female": "Food Bloggerin", "male": "Food Blogger"},
        {"neutral": "Food Designer*in", "female": "Food Designerin", "male": "Food Designer"},
        {"neutral": "Foodstylist", "female": "Foodstylist", "male": "Foodstylist"},
        {"neutral": "Forensic Analyst", "female": "Forensic Analyst", "male": "Forensic Analyst"},
        {
            "neutral": "Forensiker*in (Spurensicherungsexpert*in)",
            "female": "Forensikerin (Spurensicherungsexpertin)",
            "male": "Forensiker (Spurensicherungsexpert)",
        },
        {
            "neutral": "Forensischer Anthropologe / Forensische Anthropologin",
            "female": "Forensische Anthropologin",
            "male": "Forensischer Anthropologe",
        },
        {
            "neutral": "Forensischer Biologe / Forensische Biologin",
            "female": "Forensische Biologin",
            "male": "Forensischer Biologe",
        },
        {
            "neutral": "Forensischer Psychologe / Forensische Psychologin",
            "female": "Forensische Psychologin",
            "male": "Forensischer Psychologe",
        },
        {"neutral": "Formenbauer*in", "female": "Formenbauerin", "male": "Formenbauer"},
        {
            "neutral": "Former*in und Gießer*in (Metall und Eisen)",
            "female": "Formerin und Gießerin (Metall und Eisen)",
            "male": "Former und Gießer (Metall und Eisen)",
        },
        {"neutral": "Forscher*in", "female": "Forscherin", "male": "Forscher"},
        {
            "neutral": "Forschungs- & Entwicklungstechniker*in",
            "female": "Forschungs- & Entwicklungstechnikerin",
            "male": "Forschungs- & Entwicklungstechniker",
        },
        {
            "neutral": "Forstgarten- und Forstpflegewirtschaft",
            "female": "Forstgarten- und Forstpflegewirtschaft",
            "male": "Forstgarten- und Forstpflegewirtschaft",
        },
        {"neutral": "Forsttechnik", "female": "Forsttechnik", "male": "Forsttechnik"},
        {"neutral": "Forstwart*in", "female": "Forstwartin", "male": "Forstwart"},
        {"neutral": "Forstwirt*in", "female": "Forstwirtin", "male": "Forstwirt"},
        {"neutral": "Forstwirtschaft", "female": "Forstwirtschaft", "male": "Forstwirtschaft"},
        {
            "neutral": "Foto- und Multimediakaufmann / Foto- und Multimediakauffrau",
            "female": "Foto- und Multimediakauffrau",
            "male": "Foto- und Multimediakaufmann",
        },
        {"neutral": "Fotograf*in", "female": "Fotografin", "male": "Fotograf"},
        {"neutral": "Fotograf*in (-Kunst)", "female": "Fotografin (-Kunst)", "male": "Fotograf (-Kunst)"},
        {"neutral": "Fotogravurzeichner*in", "female": "Fotogravurzeichnerin", "male": "Fotogravurzeichner"},
        {"neutral": "Fotojournalist*in", "female": "Fotojournalistin", "male": "Fotojournalist"},
        {"neutral": "Fotomodell", "female": "Fotomodell", "male": "Fotomodell"},
        {"neutral": "Fotoreporter*in", "female": "Fotoreporterin", "male": "Fotoreporter"},
        {"neutral": "Franchise-Unternehmer*in", "female": "Franchise-Unternehmerin", "male": "Franchise-Unternehmer"},
        {"neutral": "Fraud Analyst", "female": "Fraud Analyst", "male": "Fraud Analyst"},
        {"neutral": "Freizeitberater*in", "female": "Freizeitberaterin", "male": "Freizeitberater"},
        {"neutral": "Freizeitpädagoge / Freizeitpädagogin", "female": "Freizeitpädagogin", "male": "Freizeitpädagoge"},
        {"neutral": "Fremdenführer*in", "female": "Fremdenführerin", "male": "Fremdenführer"},
        {
            "neutral": "Fremdsprachenkorrespondent*in",
            "female": "Fremdsprachenkorrespondentin",
            "male": "Fremdsprachenkorrespondent",
        },
        {"neutral": "Fremdsprachensekretär*in", "female": "Fremdsprachensekretärin", "male": "Fremdsprachensekretär"},
        {
            "neutral": "Friedhofs- und Ziergärtner*in",
            "female": "Friedhofs- und Ziergärtnerin",
            "male": "Friedhofs- und Ziergärtner",
        },
        {"neutral": "Friedhofsaufseher*in", "female": "Friedhofsaufseherin", "male": "Friedhofsaufseher"},
        {"neutral": "Friseur*in (Stylist*in)", "female": "Friseurin (Stylistin)", "male": "Friseur (Stylist)"},
        {"neutral": "Frächter*in", "female": "Frächterin", "male": "Frächter"},
        {"neutral": "Fundraiser*in", "female": "Fundraiserin", "male": "Fundraiser"},
        {"neutral": "Fundraising Manager*in", "female": "Fundraising Managerin", "male": "Fundraising Manager"},
        {"neutral": "Fußballspieler*in", "female": "Fußballspielerin", "male": "Fußballspieler"},
        {"neutral": "Fußballtrainer*in", "female": "Fußballtrainerin", "male": "Fußballtrainer"},
        {"neutral": "Fußpflege (Podologie)", "female": "Fußpflege (Podologie)", "male": "Fußpflege (Podologie)"},
        {"neutral": "Fußpfleger*in", "female": "Fußpflegerin", "male": "Fußpfleger"},
        {"neutral": "Färber*in", "female": "Färberin", "male": "Färber"},
        {"neutral": "Förderungsmanager*in", "female": "Förderungsmanagerin", "male": "Förderungsmanager"},
        {"neutral": "Förster*in", "female": "Försterin", "male": "Förster"},
        {"neutral": "GIS-Techniker*in", "female": "GIS-Technikerin", "male": "GIS-Techniker"},
        {"neutral": "Gagschreiber*in", "female": "Gagschreiberin", "male": "Gagschreiber"},
        {"neutral": "Galanteriespengler*in", "female": "Galanteriespenglerin", "male": "Galanteriespengler"},
        {"neutral": "Galerist*in", "female": "Galeristin", "male": "Galerist"},
        {"neutral": "Game Developer", "female": "Game Developer", "male": "Game Developer"},
        {"neutral": "Garderobier / Garderobiere", "female": "Garderobiere", "male": "Garderobier"},
        {
            "neutral": "Garderobier / Garderobiere (Künstler-)",
            "female": "Garderobiere (Künstler-)",
            "male": "Garderobier (Künstler-)",
        },
        {
            "neutral": "Garten- und Grünflächengestaltung",
            "female": "Garten- und Grünflächengestaltung",
            "male": "Garten- und Grünflächengestaltung",
        },
        {
            "neutral": "Garten- und Grünflächengestaltung - Greenkeeping",
            "female": "Garten- und Grünflächengestaltung - Greenkeeping",
            "male": "Garten- und Grünflächengestaltung - Greenkeeping",
        },
        {
            "neutral": "Garten- und Grünflächengestaltung - Landschaftsgärtnerei",
            "female": "Garten- und Grünflächengestaltung - Landschaftsgärtnerei",
            "male": "Garten- und Grünflächengestaltung - Landschaftsgärtnerei",
        },
        {"neutral": "Gartenbau", "female": "Gartenbau", "male": "Gartenbau"},
        {"neutral": "Gartenbautechniker*in", "female": "Gartenbautechnikerin", "male": "Gartenbautechniker"},
        {
            "neutral": "Gartencenterkaufmann / Gartencenterkauffrau",
            "female": "Gartencenterkauffrau",
            "male": "Gartencenterkaufmann",
        },
        {
            "neutral": "Gas- und Wasserleitungsinstallateur*in",
            "female": "Gas- und Wasserleitungsinstallateurin",
            "male": "Gas- und Wasserleitungsinstallateur",
        },
        {"neutral": "Gastronom*in", "female": "Gastronomin", "male": "Gastronom"},
        {
            "neutral": "Gastronomiefachmann / Gastronomiefachfrau",
            "female": "Gastronomiefachfrau",
            "male": "Gastronomiefachmann",
        },
        {
            "neutral": "Gebärdensprachdolmetscher*in",
            "female": "Gebärdensprachdolmetscherin",
            "male": "Gebärdensprachdolmetscher",
        },
        {"neutral": "Gebäudetechniker*in", "female": "Gebäudetechnikerin", "male": "Gebäudetechniker"},
        {
            "neutral": "Gebäudetechniker*in (Smart Building)",
            "female": "Gebäudetechnikerin (Smart Building)",
            "male": "Gebäudetechniker (Smart Building)",
        },
        {"neutral": "Gefahrgutbeauftragte*r", "female": "Gefahrgutbeauftragte", "male": "Gefahrgutbeauftragter"},
        {"neutral": "Geflügelwirtschaft", "female": "Geflügelwirtschaft", "male": "Geflügelwirtschaft"},
        {"neutral": "Gehirnforscher*in", "female": "Gehirnforscherin", "male": "Gehirnforscher"},
        {"neutral": "Gemeindepädagoge / Gemeindepädagogin", "female": "Gemeindepädagogin", "male": "Gemeindepädagoge"},
        {"neutral": "Genealoge / Genealogin", "female": "Genealogin", "male": "Genealoge"},
        {"neutral": "Genetiker*in", "female": "Genetikerin", "male": "Genetiker"},
        {"neutral": "Gentechnologe / Gentechnologin", "female": "Gentechnologin", "male": "Gentechnologe"},
        {"neutral": "Geochemiker*in", "female": "Geochemikerin", "male": "Geochemiker"},
        {"neutral": "Geograf*in", "female": "Geografin", "male": "Geograf"},
        {"neutral": "Geoinformatiker*in", "female": "Geoinformatikerin", "male": "Geoinformatiker"},
        {"neutral": "Geoinformationstechnik", "female": "Geoinformationstechnik", "male": "Geoinformationstechnik"},
        {
            "neutral": "Geoinformationstechniker*in",
            "female": "Geoinformationstechnikerin",
            "male": "Geoinformationstechniker",
        },
        {"neutral": "Geologe / Geologin", "female": "Geologin", "male": "Geologe"},
        {"neutral": "Geophysiker*in", "female": "Geophysikerin", "male": "Geophysiker"},
        {"neutral": "Geotechniker*in", "female": "Geotechnikerin", "male": "Geotechniker"},
        {"neutral": "Geragoge / Geragogin", "female": "Geragogin", "male": "Geragoge"},
        {"neutral": "Gerberei", "female": "Gerberei", "male": "Gerberei"},
        {"neutral": "Gerichtsdolmetscher*in", "female": "Gerichtsdolmetscherin", "male": "Gerichtsdolmetscher"},
        {"neutral": "Gerichtsmediziner*in", "female": "Gerichtsmedizinerin", "male": "Gerichtsmediziner"},
        {"neutral": "Gerichtsvollzieher*in", "female": "Gerichtsvollzieherin", "male": "Gerichtsvollzieher"},
        {"neutral": "Germanist*in", "female": "Germanistin", "male": "Germanist"},
        {"neutral": "Gerontologe / Gerontologin", "female": "Gerontologin", "male": "Gerontologe"},
        {"neutral": "Gerüster*in", "female": "Gerüsterin", "male": "Gerüster"},
        {"neutral": "Gesangslehrer*in", "female": "Gesangslehrerin", "male": "Gesangslehrer"},
        {"neutral": "Geschirrkeramformer*in", "female": "Geschirrkeramformerin", "male": "Geschirrkeramformer"},
        {"neutral": "Geschäftsführer*in", "female": "Geschäftsführerin", "male": "Geschäftsführer"},
        {
            "neutral": "Gesteinshüttentechniker*in",
            "female": "Gesteinshüttentechnikerin",
            "male": "Gesteinshüttentechniker",
        },
        {
            "neutral": "Gesundheits- und Krankenschwester / Gesundheits- und Krankenpfleger",
            "female": "Gesundheits- und Krankenpfleger",
            "male": "Gesundheits- und Krankenschwester",
        },
        {"neutral": "Gesundheitscontroller*in", "female": "Gesundheitscontrollerin", "male": "Gesundheitscontroller"},
        {"neutral": "Gesundheitsmanager*in", "female": "Gesundheitsmanagerin", "male": "Gesundheitsmanager"},
        {
            "neutral": "Gesundheitspsychologe / Gesundheitspsychologin",
            "female": "Gesundheitspsychologin",
            "male": "Gesundheitspsychologe",
        },
        {"neutral": "Gesundheitstrainer*in", "female": "Gesundheitstrainerin", "male": "Gesundheitstrainer"},
        {"neutral": "Gesundheitsökonom*in", "female": "Gesundheitsökonomin", "male": "Gesundheitsökonom"},
        {"neutral": "Getreidemüller*in", "female": "Getreidemüllerin", "male": "Getreidemüller"},
        {"neutral": "Getränkehersteller*in", "female": "Getränkeherstellerin", "male": "Getränkehersteller"},
        {"neutral": "Ghostwriter", "female": "Ghostwriter", "male": "Ghostwriter"},
        {"neutral": "Gießereimechaniker*in", "female": "Gießereimechanikerin", "male": "Gießereimechaniker"},
        {"neutral": "Gießereitechnik", "female": "Gießereitechnik", "male": "Gießereitechnik"},
        {
            "neutral": "Gießereitechnik - Eisen- und Stahlguss",
            "female": "Gießereitechnik - Eisen- und Stahlguss",
            "male": "Gießereitechnik - Eisen- und Stahlguss",
        },
        {
            "neutral": "Gießereitechnik - Nichteisenmetallguss",
            "female": "Gießereitechnik - Nichteisenmetallguss",
            "male": "Gießereitechnik - Nichteisenmetallguss",
        },
        {"neutral": "Gießereitechniker*in", "female": "Gießereitechnikerin", "male": "Gießereitechniker"},
        {"neutral": "Gipsassistent*in", "female": "Gipsassistentin", "male": "Gipsassistent"},
        {"neutral": "Glasbautechnik", "female": "Glasbautechnik", "male": "Glasbautechnik"},
        {
            "neutral": "Glasbautechnik - Glasbau",
            "female": "Glasbautechnik - Glasbau",
            "male": "Glasbautechnik - Glasbau",
        },
        {
            "neutral": "Glasbautechnik - Glaskonstruktion",
            "female": "Glasbautechnik - Glaskonstruktion",
            "male": "Glasbautechnik - Glaskonstruktion",
        },
        {
            "neutral": "Glasbläser*in und Glasinstrumentenerzeuger*in",
            "female": "Glasbläserin und Glasinstrumentenerzeugerin",
            "male": "Glasbläser und Glasinstrumentenerzeuger",
        },
        {"neutral": "Glaser*in", "female": "Glaserin", "male": "Glaser"},
        {"neutral": "Glasgestalter*in", "female": "Glasgestalterin", "male": "Glasgestalter"},
        {"neutral": "Glasgraveur*in", "female": "Glasgraveurin", "male": "Glasgraveur"},
        {"neutral": "Glashüttentechniker*in", "female": "Glashüttentechnikerin", "male": "Glashüttentechniker"},
        {"neutral": "Glasmacherei", "female": "Glasmacherei", "male": "Glasmacherei"},
        {"neutral": "Glasmaler*in", "female": "Glasmalerin", "male": "Glasmaler"},
        {"neutral": "Glasverfahrenstechnik", "female": "Glasverfahrenstechnik", "male": "Glasverfahrenstechnik"},
        {
            "neutral": "Glasverfahrenstechnik - Flachglasveredelung",
            "female": "Glasverfahrenstechnik - Flachglasveredelung",
            "male": "Glasverfahrenstechnik - Flachglasveredelung",
        },
        {
            "neutral": "Glasverfahrenstechnik - Hohlglasproduktion",
            "female": "Glasverfahrenstechnik - Hohlglasproduktion",
            "male": "Glasverfahrenstechnik - Hohlglasproduktion",
        },
        {"neutral": "Gleisbautechnik", "female": "Gleisbautechnik", "male": "Gleisbautechnik"},
        {
            "neutral": "Gold- und Silberschmied*in und Juwelier*in",
            "female": "Gold- und Silberschmiedin und Juwelierin",
            "male": "Gold- und Silberschmied und Juwelier",
        },
        {
            "neutral": "Gold-, Silber- und Metallschläger*in",
            "female": "Gold-, Silber- und Metallschlägerin",
            "male": "Gold-, Silber- und Metallschläger",
        },
        {
            "neutral": "Gold-, Silber- und Perlensticker*in",
            "female": "Gold-, Silber- und Perlenstickerin",
            "male": "Gold-, Silber- und Perlensticker",
        },
        {"neutral": "Golflehrer*in", "female": "Golflehrerin", "male": "Golflehrer"},
        {"neutral": "Grafikdesigner*in", "female": "Grafikdesignerin", "male": "Grafikdesigner"},
        {"neutral": "Grafiker*in", "female": "Grafikerin", "male": "Grafiker"},
        {"neutral": "Grafiker*in (Kunst-)", "female": "Grafikerin (Kunst-)", "male": "Grafiker (Kunst-)"},
        {"neutral": "Graveur*in", "female": "Graveurin", "male": "Graveur"},
        {"neutral": "Ground Hostess / Ground Stewart", "female": "Ground Hostess", "male": "Ground Steward"},
        {"neutral": "Growth Manager*in", "female": "Growth Managerin", "male": "Growth Manager"},
        {
            "neutral": "Großhandelskaufmann / Großhandelskauffrau",
            "female": "Großhandelskauffrau",
            "male": "Großhandelskaufmann",
        },
        {"neutral": "Großmaschinsticker*in", "female": "Großmaschinstickerin", "male": "Großmaschinsticker"},
        {"neutral": "Gründungsberater*in", "female": "Gründungsberaterin", "male": "Gründungsberater"},
        {"neutral": "Gymnastiktrainer*in", "female": "Gymnastiktrainerin", "male": "Gymnastiktrainer"},
        {"neutral": "Gürtler*in", "female": "Gürtlerin", "male": "Gürtler"},
        {"neutral": "HR-Business-Partner*in", "female": "HR-Business-Partnerin", "male": "HR-Business-Partner"},
        {
            "neutral": "HR-Manager*in (Human Resources Manager*in)",
            "female": "HR-Managerin (Human Resources Managerin)",
            "male": "HR-Manager (Human Resources Manager)",
        },
        {"neutral": "Hafenmeister*in", "female": "Hafenmeisterin", "male": "Hafenmeister"},
        {"neutral": "Hafner*in", "female": "Hafnerin", "male": "Hafner"},
        {"neutral": "Handelsvertreter*in", "female": "Handelsvertreterin", "male": "Handelsvertreter"},
        {"neutral": "Handelswissenschafter*in", "female": "Handelswissenschafterin", "male": "Handelswissenschafter"},
        {"neutral": "Handschuhmacher*in", "female": "Handschuhmacherin", "male": "Handschuhmacher"},
        {"neutral": "Hardware-Entwickler*in", "female": "Hardware-Entwicklerin", "male": "Hardware-Entwickler"},
        {"neutral": "Harmonikamacher*in", "female": "Harmonikamacherin", "male": "Harmonikamacher"},
        {"neutral": "Hausbesorger*in", "female": "Hausbesorgerin", "male": "Hausbesorger"},
        {"neutral": "Hausdame / Hausherr im Hotel", "female": "Hausdame im Hotel", "male": "Hausherr im Hotel"},
        {"neutral": "Haushälter*in", "female": "Haushälterin", "male": "Haushälter"},
        {"neutral": "Haustechniker*in", "female": "Haustechnikerin", "male": "Haustechniker"},
        {"neutral": "Hausverwalter*in", "female": "Hausverwalterin", "male": "Hausverwalter"},
        {"neutral": "Hebamme", "female": "Hebamme", "male": "Hebamme"},
        {"neutral": "Heilbadegehilfe / Heilbadegehilfin", "female": "Heilbadegehilfin", "male": "Heilbadegehilfe"},
        {
            "neutral": "Heilbademeister*in / Heilbademasseur*in",
            "female": "Heilbademeisterin / Heilbademasseurin",
            "male": "Heilbademeister / Heilbademasseur",
        },
        {"neutral": "Heilmasseur*in", "female": "Heilmasseurin", "male": "Heilmasseur"},
        {
            "neutral": "Heilpädagogische*r Fachbetreuer*in",
            "female": "Heilpädagogische Fachbetreuerin",
            "male": "Heilpädagogischer Fachbetreuer",
        },
        {"neutral": "Heimhelfer*in", "female": "Heimhelferin", "male": "Heimhelfer"},
        {"neutral": "Heimleiter*in", "female": "Heimleiterin", "male": "Heimleiter"},
        {"neutral": "Helpdesk Agent", "female": "Helpdesk Agent", "male": "Helpdesk Agent"},
        {"neutral": "Heraldiker*in", "female": "Heraldikerin", "male": "Heraldiker"},
        {"neutral": "Herrenkleidermacher*in", "female": "Herrenkleidermacherin", "male": "Herrenkleidermacher"},
        {"neutral": "Hippotherapeut*in", "female": "Hippotherapeutin", "male": "Hippotherapeut"},
        {"neutral": "Hirte / Hirtin", "female": "Hirtin", "male": "Hirte"},
        {"neutral": "Historiker*in", "female": "Historikerin", "male": "Historiker"},
        {"neutral": "Hochbau", "female": "Hochbau", "male": "Hochbau"},
        {"neutral": "Hochbauspezialist*in", "female": "Hochbauspezialistin", "male": "Hochbauspezialist"},
        {
            "neutral": "Hochbauspezialist*in - Neubau",
            "female": "Hochbauspezialistin - Neubau",
            "male": "Hochbauspezialist - Neubau",
        },
        {
            "neutral": "Hochbauspezialist*in - Sanierung",
            "female": "Hochbauspezialistin - Sanierung",
            "male": "Hochbauspezialist - Sanierung",
        },
        {"neutral": "Hochbautechniker*in", "female": "Hochbautechnikerin", "male": "Hochbautechniker"},
        {"neutral": "Hofberater*in", "female": "Hofberaterin", "male": "Hofberater"},
        {
            "neutral": "Hohlglasschleifer*in- Kugeln",
            "female": "Hohlglasschleiferin- Kugeln",
            "male": "Hohlglasschleifer- Kugeln",
        },
        {"neutral": "Hohlglasveredler*in", "female": "Hohlglasveredlerin", "male": "Hohlglasveredler"},
        {
            "neutral": "Hohlglasveredler*in - Glasmalerei",
            "female": "Hohlglasveredlerin - Glasmalerei",
            "male": "Hohlglasveredler - Glasmalerei",
        },
        {
            "neutral": "Hohlglasveredler*in - Gravur",
            "female": "Hohlglasveredlerin - Gravur",
            "male": "Hohlglasveredler - Gravur",
        },
        {
            "neutral": "Hohlglasveredler*in - Kugeln",
            "female": "Hohlglasveredlerin - Kugeln",
            "male": "Hohlglasveredler - Kugeln",
        },
        {
            "neutral": "Holz- und Steinbildhauer*in",
            "female": "Holz- und Steinbildhauerin",
            "male": "Holz- und Steinbildhauer",
        },
        {"neutral": "Holz- und Sägetechnik", "female": "Holz- und Sägetechnik", "male": "Holz- und Sägetechnik"},
        {"neutral": "Holzbaukonstrukteur*in", "female": "Holzbaukonstrukteurin", "male": "Holzbaukonstrukteur"},
        {"neutral": "Holzbautechniker*in", "female": "Holzbautechnikerin", "male": "Holzbautechniker"},
        {
            "neutral": "Holzblasinstrumentenerzeugung",
            "female": "Holzblasinstrumentenerzeugung",
            "male": "Holzblasinstrumentenerzeugung",
        },
        {"neutral": "Holzdesigner*in", "female": "Holzdesignerin", "male": "Holzdesigner"},
        {"neutral": "Holzkaufmann / Holzkauffrau", "female": "Holzkauffrau", "male": "Holzkaufmann"},
        {"neutral": "Holzspielzeugmacher*in", "female": "Holzspielzeugmacherin", "male": "Holzspielzeugmacher"},
        {"neutral": "Holztechnik", "female": "Holztechnik", "male": "Holztechnik"},
        {
            "neutral": "Holztechnik - Fensterbautechnik",
            "female": "Holztechnik - Fensterbautechnik",
            "male": "Holztechnik - Fensterbautechnik",
        },
        {
            "neutral": "Holztechnik - Fertigteilproduktion",
            "female": "Holztechnik - Fertigteilproduktion",
            "male": "Holztechnik - Fertigteilproduktion",
        },
        {
            "neutral": "Holztechnik - Sägetechnik",
            "female": "Holztechnik - Sägetechnik",
            "male": "Holztechnik - Sägetechnik",
        },
        {
            "neutral": "Holztechnik - Werkstoffproduktion",
            "female": "Holztechnik - Werkstoffproduktion",
            "male": "Holztechnik - Werkstoffproduktion",
        },
        {"neutral": "Holztechniker*in", "female": "Holztechnikerin", "male": "Holztechniker"},
        {"neutral": "Holzwirt*in", "female": "Holzwirtin", "male": "Holzwirt"},
        {"neutral": "Home Stager", "female": "Home Stager", "male": "Home Stager"},
        {"neutral": "Hortpädagoge / Hortpädagogin", "female": "Hortpädagogin", "male": "Hortpädagoge"},
        {
            "neutral": "Hotel- und Gastgewerbeassistent*in",
            "female": "Hotel- und Gastgewerbeassistentin",
            "male": "Hotel- und Gastgewerbeassistent",
        },
        {
            "neutral": "Hotel- und Restaurantfachmann / Hotel- und Restaurantfachfrau",
            "female": "Hotel- und Restaurantfachfrau",
            "male": "Hotel- und Restaurantfachmann",
        },
        {"neutral": "Hotelassistent*in", "female": "Hotelassistentin", "male": "Hotelassistent"},
        {"neutral": "Hoteldirektor*in", "female": "Hoteldirektorin", "male": "Hoteldirektor"},
        {"neutral": "Hotelkaufmann / Hotelkauffrau", "female": "Hotelkauffrau", "male": "Hotelkaufmann"},
        {"neutral": "Hotelportier*in", "female": "Hotelportierin", "male": "Hotelportier"},
        {"neutral": "Hotelsekretär*in", "female": "Hotelsekretärin", "male": "Hotelsekretär"},
        {"neutral": "Housekeeper", "female": "Housekeeper", "male": "Housekeeper"},
        {"neutral": "Hubschrauberpilot*in", "female": "Hubschrauberpilotin", "male": "Hubschrauberpilot"},
        {"neutral": "Hufschmied*in", "female": "Hufschmiedin", "male": "Hufschmied"},
        {"neutral": "Humanbiologe / Humanbiologin", "female": "Humanbiologin", "male": "Humanbiologe"},
        {"neutral": "Hundeführer*in", "female": "Hundeführerin", "male": "Hundeführer"},
        {"neutral": "Hundekosmetiker*in", "female": "Hundekosmetikerin", "male": "Hundekosmetiker"},
        {"neutral": "Hundetrainer*in", "female": "Hundetrainerin", "male": "Hundetrainer"},
        {"neutral": "Hutmacher*in", "female": "Hutmacherin", "male": "Hutmacher"},
        {"neutral": "Höhlenführer*in", "female": "Höhlenführerin", "male": "Höhlenführer"},
        {"neutral": "Hörgeräteakustiker*in", "female": "Hörgeräteakustikerin", "male": "Hörgeräteakustiker"},
        {"neutral": "Hütteningenieur*in", "female": "Hütteningenieurin", "male": "Hütteningenieur"},
        {"neutral": "Hüttenwerkschlosser*in", "female": "Hüttenwerkschlosserin", "male": "Hüttenwerkschlosser"},
        {
            "neutral": "IC-Designer*in - Elektrotechnik",
            "female": "IC-Designerin - Elektrotechnik",
            "male": "IC-Designer - Elektrotechnik",
        },
        {"neutral": "IFRS Accountant", "female": "IFRS Accountant", "male": "IFRS Accountant"},
        {"neutral": "IT-Assistant", "female": "IT-Assistant", "male": "IT-Assistant"},
        {"neutral": "IT-Berater*in", "female": "IT-Beraterin", "male": "IT-Berater"},
        {"neutral": "IT-Betreuer*in", "female": "IT-Betreuerin", "male": "IT-Betreuer"},
        {"neutral": "IT-Consultant", "female": "IT-Consultant", "male": "IT-Consultant"},
        {"neutral": "IT-Elektronik", "female": "IT-Elektronik", "male": "IT-Elektronik"},
        {"neutral": "IT-Forensiker*in", "female": "IT-Forensikerin", "male": "IT-Forensiker"},
        {"neutral": "IT-Kaufmann / IT-Kauffrau", "female": "IT-Kauffrau", "male": "IT-Kaufmann"},
        {
            "neutral": "IT-Organisationsberater*in",
            "female": "IT-Organisationsberaterin",
            "male": "IT-Organisationsberater",
        },
        {"neutral": "IT-Projektmanager*in", "female": "IT-Projektmanagerin", "male": "IT-Projektmanager"},
        {"neutral": "IT-Sales-Manager*in", "female": "IT-Sales-Managerin", "male": "IT-Sales-Manager"},
        {"neutral": "IT-Security Manager*in", "female": "IT-Security Managerin", "male": "IT-Security Manager"},
        {"neutral": "IT-System-Engineer", "female": "IT-System-Engineer", "male": "IT-System-Engineer"},
        {
            "neutral": "IT-System-Kaufmann / IT-System-Kauffrau",
            "female": "IT-System-Kauffrau",
            "male": "IT-System-Kaufmann",
        },
        {
            "neutral": "IT-Systemadministrator*in",
            "female": "IT-Systemadministratorin",
            "male": "IT-Systemadministrator",
        },
        {"neutral": "IT-Systemanalytiker*in", "female": "IT-Systemanalytikerin", "male": "IT-Systemanalytiker"},
        {"neutral": "IT-Systemdesigner*in", "female": "IT-Systemdesignerin", "male": "IT-Systemdesigner"},
        {"neutral": "IT-Systemelektroniker*in", "female": "IT-Systemelektronikerin", "male": "IT-Systemelektroniker"},
        {
            "neutral": "IT-Systemelektroniker*in (Computersysteme)",
            "female": "IT-Systemelektronikerin (Computersysteme)",
            "male": "IT-Systemelektroniker (Computersysteme)",
        },
        {
            "neutral": "IT-Systemelektroniker*in (Endgeräte)",
            "female": "IT-Systemelektronikerin (Endgeräte)",
            "male": "IT-Systemelektroniker (Endgeräte)",
        },
        {
            "neutral": "IT-Systemelektroniker*in (Festnetze)",
            "female": "IT-Systemelektronikerin (Festnetze)",
            "male": "IT-Systemelektroniker (Festnetze)",
        },
        {
            "neutral": "IT-Systemelektroniker*in (Funknetze)",
            "female": "IT-Systemelektronikerin (Funknetze)",
            "male": "IT-Systemelektroniker (Funknetze)",
        },
        {
            "neutral": "IT-Systemelektroniker*in (Sicherheitssysteme)",
            "female": "IT-Systemelektronikerin (Sicherheitssysteme)",
            "male": "IT-Systemelektroniker (Sicherheitssysteme)",
        },
        {"neutral": "IT-Systemingenieur*in", "female": "IT-Systemingenieurin", "male": "IT-Systemingenieur"},
        {"neutral": "IT-Systemmanager*in", "female": "IT-Systemmanagerin", "male": "IT-Systemmanager"},
        {"neutral": "IT-Systemtechniker*in", "female": "IT-Systemtechnikerin", "male": "IT-Systemtechniker"},
        {"neutral": "IT-Trainer*in", "female": "IT-Trainerin", "male": "IT-Trainer"},
        {"neutral": "Illustrator*in", "female": "Illustratorin", "male": "Illustrator"},
        {"neutral": "Imam", "female": "Imam", "male": "Imam"},
        {
            "neutral": "Immobilienkaufmann / Immobilienkauffrau",
            "female": "Immobilienkauffrau",
            "male": "Immobilienkaufmann",
        },
        {"neutral": "Immobilienmakler*in", "female": "Immobilienmaklerin", "male": "Immobilienmakler"},
        {"neutral": "Immobilientreuhänder*in", "female": "Immobilientreuhänderin", "male": "Immobilientreuhänder"},
        {"neutral": "Immobilienverwalter*in", "female": "Immobilienverwalterin", "male": "Immobilienverwalter"},
        {"neutral": "Indologe / Indologin", "female": "Indologin", "male": "Indologe"},
        {"neutral": "Industrial-Designer*in", "female": "Industrial-Designerin", "male": "Industrial-Designer"},
        {
            "neutral": "Industriekaufmann / Industriekauffrau",
            "female": "Industriekauffrau",
            "male": "Industriekaufmann",
        },
        {
            "neutral": "Industriekletterer / Industriekletterin",
            "female": "Industriekletterin",
            "male": "Industriekletterer",
        },
        {"neutral": "Industrielogistiker*in", "female": "Industrielogistikerin", "male": "Industrielogistiker"},
        {"neutral": "Industrietaucher*in", "female": "Industrietaucherin", "male": "Industrietaucher"},
        {"neutral": "Industrietechniker*in", "female": "Industrietechnikerin", "male": "Industrietechniker"},
        {"neutral": "Influencer", "female": "Influencer", "male": "Influencer"},
        {"neutral": "Infografiker*in", "female": "Infografikerin", "male": "Infografiker"},
        {"neutral": "Informatik", "female": "Informatik", "male": "Informatik"},
        {"neutral": "Informatiker*in", "female": "Informatikerin", "male": "Informatiker"},
        {
            "neutral": "Informatiker*in (Digitale Industrie)",
            "female": "Informatikerin (Digitale Industrie)",
            "male": "Informatiker (Digitale Industrie)",
        },
        {
            "neutral": "Informatikkaufmann / Informatikkauffrau",
            "female": "Informatikkauffrau",
            "male": "Informatikkaufmann",
        },
        {"neutral": "Informationsbroker", "female": "Informationsbroker", "male": "Informationsbroker"},
        {"neutral": "Informationsdesigner*in", "female": "Informationsdesignerin", "male": "Informationsdesigner"},
        {"neutral": "Informationsmanager*in", "female": "Informationsmanagerin", "male": "Informationsmanager"},
        {"neutral": "Informationsoffizier*in", "female": "Informationsoffizierin", "male": "Informationsoffizier"},
        {"neutral": "Informationstechniker*in", "female": "Informationstechnikerin", "male": "Informationstechniker"},
        {"neutral": "Informationstechnologie", "female": "Informationstechnologie", "male": "Informationstechnologie"},
        {
            "neutral": "Informationstechnologie - Betriebstechnik",
            "female": "Informationstechnologie - Betriebstechnik",
            "male": "Informationstechnologie - Betriebstechnik",
        },
        {
            "neutral": "Informationstechnologie - Informatik",
            "female": "Informationstechnologie - Informatik",
            "male": "Informationstechnologie - Informatik",
        },
        {
            "neutral": "Informationstechnologie - Systemtechnik",
            "female": "Informationstechnologie - Systemtechnik",
            "male": "Informationstechnologie - Systemtechnik",
        },
        {
            "neutral": "Informationstechnologie - Technik",
            "female": "Informationstechnologie - Technik",
            "male": "Informationstechnologie - Technik",
        },
        {"neutral": "Ingenieurkonsulent*in", "female": "Ingenieurkonsulentin", "male": "Ingenieurkonsulent"},
        {"neutral": "Innenarchitekt*in", "female": "Innenarchitektin", "male": "Innenarchitekt"},
        {"neutral": "Innenausbauer*in", "female": "Innenausbauerin", "male": "Innenausbauer"},
        {"neutral": "Innenrequisiteur*in", "female": "Innenrequisiteurin", "male": "Innenrequisiteur"},
        {"neutral": "Innovationsmanager*in", "female": "Innovationsmanagerin", "male": "Innovationsmanager"},
        {"neutral": "Innovationstechniker*in", "female": "Innovationstechnikerin", "male": "Innovationstechniker"},
        {"neutral": "Inspizient*in", "female": "Inspizientin", "male": "Inspizient"},
        {"neutral": "Instagrammer", "female": "Instagrammer", "male": "Instagrammer"},
        {"neutral": "Installateur*in", "female": "Installateurin", "male": "Installateur"},
        {
            "neutral": "Installations- und Gebäudetechnik",
            "female": "Installations- und Gebäudetechnik",
            "male": "Installations- und Gebäudetechnik",
        },
        {
            "neutral": "Installations- und Gebäudetechnik - Gas- und Sanitärtechnik",
            "female": "Installations- und Gebäudetechnik - Gas- und Sanitärtechnik",
            "male": "Installations- und Gebäudetechnik - Gas- und Sanitärtechnik",
        },
        {
            "neutral": "Installations- und Gebäudetechnik - Heizungstechnik",
            "female": "Installations- und Gebäudetechnik - Heizungstechnik",
            "male": "Installations- und Gebäudetechnik - Heizungstechnik",
        },
        {
            "neutral": "Installations- und Gebäudetechnik - Lüftungstechnik",
            "female": "Installations- und Gebäudetechnik - Lüftungstechnik",
            "male": "Installations- und Gebäudetechnik - Lüftungstechnik",
        },
        {"neutral": "Installationskünstler*in", "female": "Installationskünstlerin", "male": "Installationskünstler"},
        {
            "neutral": "Instandhaltungstechniker*in",
            "female": "Instandhaltungstechnikerin",
            "male": "Instandhaltungstechniker",
        },
        {
            "neutral": "Instruktor*in (Lehrwart*in)",
            "female": "Instruktorin (Lehrwartin)",
            "male": "Instruktor (Lehrwart)",
        },
        {
            "neutral": "Instrumental- und Gesangspädagoge / Instrumental- und Gesangspädagogin",
            "female": "Instrumental- und Gesangspädagogin",
            "male": "Instrumental- und Gesangspädagoge",
        },
        {"neutral": "Instrumentalmusiker*in", "female": "Instrumentalmusikerin", "male": "Instrumentalmusiker"},
        {"neutral": "Integrationsbegleiter*in", "female": "Integrationsbegleiterin", "male": "Integrationsbegleiter"},
        {"neutral": "Intendant*in", "female": "Intendantin", "male": "Intendant"},
        {"neutral": "Interface-Designer*in", "female": "Interface-Designerin", "male": "Interface-Designer"},
        {
            "neutral": "Interkulturelle*r Trainer*in",
            "female": "Interkulturelle Trainerin",
            "male": "Interkultureller Trainer",
        },
        {
            "neutral": "Internationale*r Steuerberater*in",
            "female": "Internationale Steuerberaterin",
            "male": "Internationaler Steuerberater",
        },
        {
            "neutral": "Internationale*r Wirtschaftsprüfer*in",
            "female": "Internationale Wirtschaftsprüferin",
            "male": "Internationaler Wirtschaftsprüfer",
        },
        {
            "neutral": "Internet-/Intranet-Redakteur*in",
            "female": "Internet-/Intranet-Redakteurin",
            "male": "Internet-/Intranet-Redakteur",
        },
        {"neutral": "Internet-Scout", "female": "Internet-Scout", "male": "Internet-Scout"},
        {
            "neutral": "Internet-Systembetreuer*in",
            "female": "Internet-Systembetreuerin",
            "male": "Internet-Systembetreuer",
        },
        {"neutral": "Interviewer*in", "female": "Interviewerin", "male": "Interviewer"},
        {"neutral": "Investment Analyst*in", "female": "Investment Analystin", "male": "Investment Analyst"},
        {"neutral": "Investment Banker", "female": "Investment Banker", "male": "Investment Banker"},
        {
            "neutral": "Investor Relations Manager*in",
            "female": "Investor Relations Managerin",
            "male": "Investor Relations Manager",
        },
        {"neutral": "IoT-Entwickler*in", "female": "IoT-Entwicklerin", "male": "IoT-Entwickler"},
        {"neutral": "Isoliermonteur*in", "female": "Isoliermonteurin", "male": "Isoliermonteur"},
        {"neutral": "Job Broker", "female": "Job Broker", "male": "Job Broker"},
        {"neutral": "Jockey", "female": "Jockey", "male": "Jockey"},
        {"neutral": "Journalist*in", "female": "Journalistin", "male": "Journalist"},
        {"neutral": "Journalist*in (Kultur)", "female": "Journalistin (Kultur)", "male": "Journalist (Kultur)"},
        {"neutral": "Judaist*in", "female": "Judaistin", "male": "Judaist"},
        {"neutral": "Jugendbetreuer*in", "female": "Jugendbetreuerin", "male": "Jugendbetreuer"},
        {
            "neutral": "Junior Consultant E-Commerce",
            "female": "Junior Consultant E-Commerce",
            "male": "Junior Consultant E-Commerce",
        },
        {"neutral": "Junior Scientist", "female": "Junior Scientist", "male": "Junior Scientist"},
        {"neutral": "Jurist*in", "female": "Juristin", "male": "Jurist"},
        {
            "neutral": "Jurist*in (Arbeits- und Sozialrecht)",
            "female": "Juristin (Arbeits- und Sozialrecht)",
            "male": "Jurist (Arbeits- und Sozialrecht)",
        },
        {"neutral": "Jurist*in (Europarecht)", "female": "Juristin (Europarecht)", "male": "Jurist (Europarecht)"},
        {
            "neutral": "Jurist*in (Internationales Recht)",
            "female": "Juristin (Internationales Recht)",
            "male": "Jurist (Internationales Recht)",
        },
        {"neutral": "Jurist*in (Steuerrecht)", "female": "Juristin (Steuerrecht)", "male": "Jurist (Steuerrecht)"},
        {"neutral": "Jurist*in (Strafrecht)", "female": "Juristin (Strafrecht)", "male": "Jurist (Strafrecht)"},
        {"neutral": "Jurist*in (Umweltrecht)", "female": "Juristin (Umweltrecht)", "male": "Jurist (Umweltrecht)"},
        {
            "neutral": "Jurist*in (Wirtschaftsrecht)",
            "female": "Juristin (Wirtschaftsrecht)",
            "male": "Jurist (Wirtschaftsrecht)",
        },
        {"neutral": "Jurist*in (Zivilrecht)", "female": "Juristin (Zivilrecht)", "male": "Jurist (Zivilrecht)"},
        {"neutral": "KI-Prompter", "female": "KI-Prompter", "male": "KI-Prompter"},
        {"neutral": "KI-Trainer*in", "female": "KI-Trainerin", "male": "KI-Trainer"},
        {"neutral": "Kabarettist*in", "female": "Kabarettistin", "male": "Kabarettist"},
        {"neutral": "Kaffeeröster*in", "female": "Kaffeerösterin", "male": "Kaffeeröster"},
        {"neutral": "Kameramann / Kamerafrau", "female": "Kamerafrau", "male": "Kameramann"},
        {"neutral": "Kanalfacharbeiter*in", "female": "Kanalfacharbeiterin", "male": "Kanalfacharbeiter"},
        {"neutral": "Kantineur*in", "female": "Kantineurin", "male": "Kantineur"},
        {"neutral": "Kanzleiassistent*in", "female": "Kanzleiassistentin", "male": "Kanzleiassistent"},
        {
            "neutral": "Kanzleiassistent*in - Notariatskanzlei",
            "female": "Kanzleiassistentin - Notariatskanzlei",
            "male": "Kanzleiassistent - Notariatskanzlei",
        },
        {
            "neutral": "Kanzleiassistent*in - Rechtsanwaltskanzlei",
            "female": "Kanzleiassistentin - Rechtsanwaltskanzlei",
            "male": "Kanzleiassistent - Rechtsanwaltskanzlei",
        },
        {"neutral": "Kappenmacher*in", "female": "Kappenmacherin", "male": "Kappenmacher"},
        {"neutral": "Kardiotechniker*in", "female": "Kardiotechnikerin", "male": "Kardiotechniker"},
        {"neutral": "Karikaturist*in", "female": "Karikaturistin", "male": "Karikaturist"},
        {"neutral": "Karosseriebautechnik", "female": "Karosseriebautechnik", "male": "Karosseriebautechnik"},
        {"neutral": "Karosseur*in", "female": "Karosseurin", "male": "Karosseur"},
        {"neutral": "Kartograf*in", "female": "Kartografin", "male": "Kartograf"},
        {
            "neutral": "Kartonagewarenerzeuger*in",
            "female": "Kartonagewarenerzeugerin",
            "male": "Kartonagewarenerzeuger",
        },
        {
            "neutral": "Kassier*in - Einzelhandel",
            "female": "Kassierin - Einzelhandel",
            "male": "Kassier - Einzelhandel",
        },
        {"neutral": "Katastrophenmanager*in", "female": "Katastrophenmanagerin", "male": "Katastrophenmanager"},
        {"neutral": "Kaufhausdetektiv*in", "female": "Kaufhausdetektivin", "male": "Kaufhausdetektiv"},
        {
            "neutral": "Kaufmann / Kauffrau - Kurierdienste",
            "female": "Kauffrau - Kurierdienste",
            "male": "Kaufmann - Kurierdienste",
        },
        {"neutral": "Kellner*in", "female": "Kellnerin", "male": "Kellner"},
        {"neutral": "Keltologe / Keltologin", "female": "Keltologin", "male": "Keltologe"},
        {"neutral": "Keramiker*in", "female": "Keramikerin", "male": "Keramiker"},
        {
            "neutral": "Keramiker*in - Baukeramik",
            "female": "Keramikerin - Baukeramik",
            "male": "Keramiker - Baukeramik",
        },
        {
            "neutral": "Keramiker*in - Gebrauchskeramik",
            "female": "Keramikerin - Gebrauchskeramik",
            "male": "Keramiker - Gebrauchskeramik",
        },
        {
            "neutral": "Keramiker*in - Industriekeramik",
            "female": "Keramikerin - Industriekeramik",
            "male": "Keramiker - Industriekeramik",
        },
        {"neutral": "Kerammaler*in", "female": "Kerammalerin", "male": "Kerammaler"},
        {"neutral": "Kerammodelleur*in", "female": "Kerammodelleurin", "male": "Kerammodelleur"},
        {
            "neutral": "Key Account Manager*in / Account Manager*in",
            "female": "Key Account Managerin / Account Managerin",
            "male": "Key Account Manager / Account Manager",
        },
        {"neutral": "Key Influencer", "female": "Key Influencer", "male": "Key Influencer"},
        {
            "neutral": "Kfz-Sachverständiger / Kfz-Sachverständige",
            "female": "Kfz-Sachverständige",
            "male": "Kfz-Sachverständiger",
        },
        {
            "neutral": "Kinder- und Jugendberater*in",
            "female": "Kinder- und Jugendberaterin",
            "male": "Kinder- und Jugendberater",
        },
        {"neutral": "Kinderbetreuer*in", "female": "Kinderbetreuerin", "male": "Kinderbetreuer"},
        {"neutral": "Kinderdorfhelfer*in", "female": "Kinderdorfhelferin", "male": "Kinderdorfhelfer"},
        {"neutral": "Kinderdorfmutter / Kinderdorfvater", "female": "Kinderdorfvater", "male": "Kinderdorfmutter"},
        {"neutral": "Kindergartenassistent*in", "female": "Kindergartenassistentin", "male": "Kindergartenassistent"},
        {
            "neutral": "Kindergesundheitstrainer*in",
            "female": "Kindergesundheitstrainerin",
            "male": "Kindergesundheitstrainer",
        },
        {"neutral": "Kindergruppenbetreuer*in", "female": "Kindergruppenbetreuerin", "male": "Kindergruppenbetreuer"},
        {
            "neutral": "Kindergärtner*in / Kindergartenpädagoge / Kindergartenpädagogin",
            "female": "Kindergärtnerin / Kindergartenpädagogin",
            "male": "Kindergärtner / Kindergartenpädagoge",
        },
        {"neutral": "Kinderkrankenpfleger*in", "female": "Kinderkrankenpflegerin", "male": "Kinderkrankenpfleger"},
        {"neutral": "Kinesiologe / Kinesiologin", "female": "Kinesiologin", "male": "Kinesiologe"},
        {"neutral": "Kirchenmusiker*in", "female": "Kirchenmusikerin", "male": "Kirchenmusiker"},
        {"neutral": "Klavierbau", "female": "Klavierbau", "male": "Klavierbau"},
        {"neutral": "Klaviermacher*in", "female": "Klaviermacherin", "male": "Klaviermacher"},
        {
            "neutral": "Kleinkindpädagoge / Kleinkindpädagogin",
            "female": "Kleinkindpädagogin",
            "male": "Kleinkindpädagoge",
        },
        {"neutral": "Klimagärtnerin / Klimagärtner", "female": "Klimagärtner", "male": "Klimagärtnerin"},
        {
            "neutral": "Klimatechniker*in und Heizungstechniker*in",
            "female": "Klimatechnikerin und Heizungstechnikerin",
            "male": "Klimatechniker und Heizungstechniker",
        },
        {"neutral": "Klimatologe / Klimatologin", "female": "Klimatologin", "male": "Klimatologe"},
        {
            "neutral": "Klinischer Linguist / Klinische Linguistin",
            "female": "Klinische Linguistin",
            "male": "Klinischer Linguist",
        },
        {
            "neutral": "Klinischer Psychologe / Klinische Psychologin",
            "female": "Klinische Psychologin",
            "male": "Klinischer Psychologe",
        },
        {"neutral": "Klärwart*in", "female": "Klärwartin", "male": "Klärwart"},
        {"neutral": "Koch / Köchin", "female": "Köchin", "male": "Koch"},
        {
            "neutral": "Kognitionswissenschafter*in",
            "female": "Kognitionswissenschafterin",
            "male": "Kognitionswissenschafter",
        },
        {"neutral": "Kolumnist*in", "female": "Kolumnistin", "male": "Kolumnist"},
        {"neutral": "Kommandant*in", "female": "Kommandantin", "male": "Kommandant"},
        {"neutral": "Kommerzkundenbetreuer*in", "female": "Kommerzkundenbetreuerin", "male": "Kommerzkundenbetreuer"},
        {"neutral": "Kommissionierer*in", "female": "Kommissioniererin", "male": "Kommissionierer"},
        {"neutral": "Kommunikationsmanager*in", "female": "Kommunikationsmanagerin", "male": "Kommunikationsmanager"},
        {
            "neutral": "Kommunikationstechniker*in",
            "female": "Kommunikationstechnikerin",
            "male": "Kommunikationstechniker",
        },
        {
            "neutral": "Kommunikationstechniker*in - Audio- und Videoelektronik",
            "female": "Kommunikationstechnikerin - Audio- und Videoelektronik",
            "male": "Kommunikationstechniker - Audio- und Videoelektronik",
        },
        {
            "neutral": "Kommunikationstechniker*in - Bürokommunikation",
            "female": "Kommunikationstechnikerin - Bürokommunikation",
            "male": "Kommunikationstechniker - Bürokommunikation",
        },
        {
            "neutral": "Kommunikationstechniker*in - Elektronische Datenverarbeitung und Telekommunikation",
            "female": "Kommunikationstechnikerin - Elektronische Datenverarbeitung und Telekommunikation",
            "male": "Kommunikationstechniker - Elektronische Datenverarbeitung und Telekommunikation",
        },
        {
            "neutral": "Kommunikationstechniker*in - Nachrichtenelektronik",
            "female": "Kommunikationstechnikerin - Nachrichtenelektronik",
            "male": "Kommunikationstechniker - Nachrichtenelektronik",
        },
        {
            "neutral": "Kommunikationswissenschafter*in",
            "female": "Kommunikationswissenschafterin",
            "male": "Kommunikationswissenschafter",
        },
        {"neutral": "Komplementärmediziner*in", "female": "Komplementärmedizinerin", "male": "Komplementärmediziner"},
        {"neutral": "Komponist*in", "female": "Komponistin", "male": "Komponist"},
        {
            "neutral": "Konditor*in (Zuckerbäcker*in)",
            "female": "Konditorin (Zuckerbäckerin)",
            "male": "Konditor (Zuckerbäcker)",
        },
        {
            "neutral": "Konditorei (Zuckerbäckerei)",
            "female": "Konditorei (Zuckerbäckerei)",
            "male": "Konditorei (Zuckerbäckerei)",
        },
        {
            "neutral": "Konditorei (Zuckerbäckerei) - Allgemeine Konditorei",
            "female": "Konditorei (Zuckerbäckerei) - Allgemeine Konditorei",
            "male": "Konditorei (Zuckerbäckerei) - Allgemeine Konditorei",
        },
        {
            "neutral": "Konditorei (Zuckerbäckerei) - Patisserie",
            "female": "Konditorei (Zuckerbäckerei) - Patisserie",
            "male": "Konditorei (Zuckerbäckerei) - Patisserie",
        },
        {"neutral": "Konferenzdolmetscher*in", "female": "Konferenzdolmetscherin", "male": "Konferenzdolmetscher"},
        {
            "neutral": "Kongress- und Konferenzmanager*in",
            "female": "Kongress- und Konferenzmanagerin",
            "male": "Kongress- und Konferenzmanager",
        },
        {"neutral": "Konstrukteur*in", "female": "Konstrukteurin", "male": "Konstrukteur"},
        {
            "neutral": "Konstrukteur*in - Elektroinstallationstechnik",
            "female": "Konstrukteurin - Elektroinstallationstechnik",
            "male": "Konstrukteur - Elektroinstallationstechnik",
        },
        {
            "neutral": "Konstrukteur*in - Installations- und Gebäudetechnik",
            "female": "Konstrukteurin - Installations- und Gebäudetechnik",
            "male": "Konstrukteur - Installations- und Gebäudetechnik",
        },
        {
            "neutral": "Konstrukteur*in - Maschinenbautechnik",
            "female": "Konstrukteurin - Maschinenbautechnik",
            "male": "Konstrukteur - Maschinenbautechnik",
        },
        {
            "neutral": "Konstrukteur*in - Metallbautechnik",
            "female": "Konstrukteurin - Metallbautechnik",
            "male": "Konstrukteur - Metallbautechnik",
        },
        {
            "neutral": "Konstrukteur*in - Stahlbautechnik",
            "female": "Konstrukteurin - Stahlbautechnik",
            "male": "Konstrukteur - Stahlbautechnik",
        },
        {
            "neutral": "Konstrukteur*in - Werkzeugbautechnik",
            "female": "Konstrukteurin - Werkzeugbautechnik",
            "male": "Konstrukteur - Werkzeugbautechnik",
        },
        {
            "neutral": "Konstrukteur*in im Fahrzeugbau",
            "female": "Konstrukteurin im Fahrzeugbau",
            "male": "Konstrukteur im Fahrzeugbau",
        },
        {
            "neutral": "Konstruktionstechniker*in",
            "female": "Konstruktionstechnikerin",
            "male": "Konstruktionstechniker",
        },
        {"neutral": "Konsumentenberater*in", "female": "Konsumentenberaterin", "male": "Konsumentenberater"},
        {"neutral": "Kontakter*in", "female": "Kontakterin", "male": "Kontakter"},
        {"neutral": "Konzeptkünstler*in", "female": "Konzeptkünstlerin", "male": "Konzeptkünstler"},
        {
            "neutral": "Korb- und Möbelflechter*in",
            "female": "Korb- und Möbelflechterin",
            "male": "Korb- und Möbelflechter",
        },
        {"neutral": "Korrektor*in", "female": "Korrektorin", "male": "Korrektor"},
        {"neutral": "Korrespondent*in", "female": "Korrespondentin", "male": "Korrespondent"},
        {"neutral": "Kosmetik (Kosmetologie)", "female": "Kosmetik (Kosmetologie)", "male": "Kosmetik (Kosmetologie)"},
        {
            "neutral": "Kosmetik (Kosmetologie) / Fußpflege (Podologie)",
            "female": "Kosmetik (Kosmetologie) / Fußpflege (Podologie)",
            "male": "Kosmetik (Kosmetologie) / Fußpflege (Podologie)",
        },
        {"neutral": "Kosmetiker*in", "female": "Kosmetikerin", "male": "Kosmetiker"},
        {"neutral": "Kosmologe / Kosmologin", "female": "Kosmologin", "male": "Kosmologe"},
        {"neutral": "Kostenrechner*in", "female": "Kostenrechnerin", "male": "Kostenrechner"},
        {"neutral": "Kostümbildner*in", "female": "Kostümbildnerin", "male": "Kostümbildner"},
        {
            "neutral": "Kraftfahrzeugelektriker*in",
            "female": "Kraftfahrzeugelektrikerin",
            "male": "Kraftfahrzeugelektriker",
        },
        {
            "neutral": "Kraftfahrzeugmechaniker*in",
            "female": "Kraftfahrzeugmechanikerin",
            "male": "Kraftfahrzeugmechaniker",
        },
        {"neutral": "Kraftfahrzeugtechnik", "female": "Kraftfahrzeugtechnik", "male": "Kraftfahrzeugtechnik"},
        {
            "neutral": "Kraftfahrzeugtechnik - Motorradtechnik",
            "female": "Kraftfahrzeugtechnik - Motorradtechnik",
            "male": "Kraftfahrzeugtechnik - Motorradtechnik",
        },
        {
            "neutral": "Kraftfahrzeugtechnik - Nutzfahrzeugtechnik",
            "female": "Kraftfahrzeugtechnik - Nutzfahrzeugtechnik",
            "male": "Kraftfahrzeugtechnik - Nutzfahrzeugtechnik",
        },
        {
            "neutral": "Kraftfahrzeugtechnik - Personenkraftwagentechnik",
            "female": "Kraftfahrzeugtechnik - Personenkraftwagentechnik",
            "male": "Kraftfahrzeugtechnik - Personenkraftwagentechnik",
        },
        {"neutral": "Kranführer*in", "female": "Kranführerin", "male": "Kranführer"},
        {"neutral": "Krankenhausmanager*in", "female": "Krankenhausmanagerin", "male": "Krankenhausmanager"},
        {"neutral": "Krankenhausreferent*in", "female": "Krankenhausreferentin", "male": "Krankenhausreferent"},
        {"neutral": "Krankenpfleger*in", "female": "Krankenpflegerin", "male": "Krankenpfleger"},
        {"neutral": "Kranmonteur*in", "female": "Kranmonteurin", "male": "Kranmonteur"},
        {"neutral": "Kreditprüfer*in", "female": "Kreditprüferin", "male": "Kreditprüfer"},
        {"neutral": "Kreditreferent*in", "female": "Kreditreferentin", "male": "Kreditreferent"},
        {"neutral": "Kreditrevisor*in", "female": "Kreditrevisorin", "male": "Kreditrevisor"},
        {"neutral": "Kriminalanalytiker*in", "female": "Kriminalanalytikerin", "male": "Kriminalanalytiker"},
        {"neutral": "Kriminalbeamter / Kriminalbeamtin", "female": "Kriminalbeamtin", "male": "Kriminalbeamter"},
        {"neutral": "Kriminaltechniker*in", "female": "Kriminaltechnikerin", "male": "Kriminaltechniker"},
        {"neutral": "Kriminologe / Kriminologin", "female": "Kriminologin", "male": "Kriminologe"},
        {"neutral": "Kristallschleiftechnik", "female": "Kristallschleiftechnik", "male": "Kristallschleiftechnik"},
        {"neutral": "Kräuterpädagoge / Kräuterpädagogin", "female": "Kräuterpädagogin", "male": "Kräuterpädagoge"},
        {
            "neutral": "Kultur- und Sozialanthropolog*in",
            "female": "Kultur- und Sozialanthropologin",
            "male": "Kultur- und Sozialanthropolog",
        },
        {"neutral": "Kulturmanager*in", "female": "Kulturmanagerin", "male": "Kulturmanager"},
        {"neutral": "Kulturtechniker*in", "female": "Kulturtechnikerin", "male": "Kulturtechniker"},
        {"neutral": "Kulturvermittler*in", "female": "Kulturvermittlerin", "male": "Kulturvermittler"},
        {"neutral": "Kulturwissenschafter*in", "female": "Kulturwissenschafterin", "male": "Kulturwissenschafter"},
        {"neutral": "Kund*innenbetreuer*in", "female": "Kundinnenbetreuerin", "male": "Kundnenbetreuer"},
        {"neutral": "Kunstberater*in", "female": "Kunstberaterin", "male": "Kunstberater"},
        {"neutral": "Kunsthistoriker*in", "female": "Kunsthistorikerin", "male": "Kunsthistoriker"},
        {"neutral": "Kunsthändler*in", "female": "Kunsthändlerin", "male": "Kunsthändler"},
        {"neutral": "Kunstkritiker*in", "female": "Kunstkritikerin", "male": "Kunstkritiker"},
        {"neutral": "Kunststeinerzeuger*in", "female": "Kunststeinerzeugerin", "male": "Kunststeinerzeuger"},
        {"neutral": "Kunststoffformgebung", "female": "Kunststoffformgebung", "male": "Kunststoffformgebung"},
        {"neutral": "Kunststofftechnik", "female": "Kunststofftechnik", "male": "Kunststofftechnik"},
        {"neutral": "Kunststofftechniker*in", "female": "Kunststofftechnikerin", "male": "Kunststofftechniker"},
        {"neutral": "Kunststofftechnologie", "female": "Kunststofftechnologie", "male": "Kunststofftechnologie"},
        {"neutral": "Kunststoffverarbeitung", "female": "Kunststoffverarbeitung", "male": "Kunststoffverarbeitung"},
        {
            "neutral": "Kunststoffverfahrenstechnik",
            "female": "Kunststoffverfahrenstechnik",
            "male": "Kunststoffverfahrenstechnik",
        },
        {"neutral": "Kunsttherapeut*in", "female": "Kunsttherapeutin", "male": "Kunsttherapeut"},
        {"neutral": "Kunsttischler*in", "female": "Kunsttischlerin", "male": "Kunsttischler"},
        {"neutral": "Kupferdrucker*in", "female": "Kupferdruckerin", "male": "Kupferdrucker"},
        {"neutral": "Kupferschmied*in", "female": "Kupferschmiedin", "male": "Kupferschmied"},
        {"neutral": "Kurator*in (Museum)", "female": "Kuratorin (Museum)", "male": "Kurator (Museum)"},
        {
            "neutral": "Kurator*in (Veranstaltungen)",
            "female": "Kuratorin (Veranstaltungen)",
            "male": "Kurator (Veranstaltungen)",
        },
        {"neutral": "Kybernetiker*in", "female": "Kybernetikerin", "male": "Kybernetiker"},
        {"neutral": "Kälteanlagentechnik", "female": "Kälteanlagentechnik", "male": "Kälteanlagentechnik"},
        {"neutral": "Küchenchef*in", "female": "Küchenchefin", "male": "Küchenchef"},
        {"neutral": "Küchengehilfe / Küchengehilfin", "female": "Küchengehilfin", "male": "Küchengehilfe"},
        {"neutral": "Küchenplaner*in", "female": "Küchenplanerin", "male": "Küchenplaner"},
        {"neutral": "Künstleragent*in", "female": "Künstleragentin", "male": "Künstleragent"},
        {"neutral": "Kürschner*in", "female": "Kürschnerin", "male": "Kürschner"},
        {"neutral": "LKW-Fahrer*in", "female": "LKW-Fahrerin", "male": "LKW-Fahrer"},
        {"neutral": "Labelmanager*in", "female": "Labelmanagerin", "male": "Labelmanager"},
        {
            "neutral": "Laborassistent*in (medizinisch)",
            "female": "Laborassistentin (medizinisch)",
            "male": "Laborassistent (medizinisch)",
        },
        {
            "neutral": "Laborgehilfe / Laborgehilfin (Sanitätsdienst)",
            "female": "Laborgehilfin (Sanitätsdienst)",
            "male": "Laborgehilfe (Sanitätsdienst)",
        },
        {"neutral": "Labortechnik", "female": "Labortechnik", "male": "Labortechnik"},
        {
            "neutral": "Labortechnik - Biochemie",
            "female": "Labortechnik - Biochemie",
            "male": "Labortechnik - Biochemie",
        },
        {"neutral": "Labortechnik - Chemie", "female": "Labortechnik - Chemie", "male": "Labortechnik - Chemie"},
        {
            "neutral": "Labortechnik - Lack- und Anstrichmittel",
            "female": "Labortechnik - Lack- und Anstrichmittel",
            "male": "Labortechnik - Lack- und Anstrichmittel",
        },
        {"neutral": "Lackiertechnik", "female": "Lackiertechnik", "male": "Lackiertechnik"},
        {"neutral": "Ladenkassier*in", "female": "Ladenkassierin", "male": "Ladenkassier"},
        {"neutral": "Lagerarbeiter*in", "female": "Lagerarbeiterin", "male": "Lagerarbeiter"},
        {"neutral": "Lagerlogistik", "female": "Lagerlogistik", "male": "Lagerlogistik"},
        {
            "neutral": "Land- und Baumaschinentechnik",
            "female": "Land- und Baumaschinentechnik",
            "male": "Land- und Baumaschinentechnik",
        },
        {
            "neutral": "Land- und Baumaschinentechnik - Baumaschinen",
            "female": "Land- und Baumaschinentechnik - Baumaschinen",
            "male": "Land- und Baumaschinentechnik - Baumaschinen",
        },
        {
            "neutral": "Land- und Baumaschinentechnik - Landmaschinen",
            "female": "Land- und Baumaschinentechnik - Landmaschinen",
            "male": "Land- und Baumaschinentechnik - Landmaschinen",
        },
        {
            "neutral": "Landmaschinentechniker*in",
            "female": "Landmaschinentechnikerin",
            "male": "Landmaschinentechniker",
        },
        {
            "neutral": "Landschaftsgärtner*in (Garten- und Grünflächengestaltung)",
            "female": "Landschaftsgärtnerin (Garten- und Grünflächengestaltung)",
            "male": "Landschaftsgärtner (Garten- und Grünflächengestaltung)",
        },
        {"neutral": "Landschaftsplaner*in", "female": "Landschaftsplanerin", "male": "Landschaftsplaner"},
        {"neutral": "Landwirt*in", "female": "Landwirtin", "male": "Landwirt"},
        {"neutral": "Landwirtschaft", "female": "Landwirtschaft", "male": "Landwirtschaft"},
        {
            "neutral": "Landwirtschaftliche Lagerhaltung",
            "female": "Landwirtschaftliche Lagerhaltung",
            "male": "Landwirtschaftliche Lagerhaltung",
        },
        {
            "neutral": "Landwirtschaftliche*r Berater*in",
            "female": "Landwirtschaftliche Beraterin",
            "male": "Landwirtschaftlicher Berater",
        },
        {
            "neutral": "Landwirtschaftliche*r Facharbeiter*in",
            "female": "Landwirtschaftliche Facharbeiterin",
            "male": "Landwirtschaftlicher Facharbeiter",
        },
        {
            "neutral": "Landwirtschaftliche*r Haushaltsberater*in",
            "female": "Landwirtschaftliche Haushaltsberaterin",
            "male": "Landwirtschaftlicher Haushaltsberater",
        },
        {
            "neutral": "Landwirtschaftstechniker*in",
            "female": "Landwirtschaftstechnikerin",
            "male": "Landwirtschaftstechniker",
        },
        {"neutral": "Laserchirug*in", "female": "Laserchirugin", "male": "Laserchirug"},
        {"neutral": "Layouter*in", "female": "Layouterin", "male": "Layouter"},
        {"neutral": "Leasingspezialist*in", "female": "Leasingspezialistin", "male": "Leasingspezialist"},
        {
            "neutral": "Lebens- und Sozialberater*in",
            "female": "Lebens- und Sozialberaterin",
            "male": "Lebens- und Sozialberater",
        },
        {
            "neutral": "Lebensmittelaufsichtsorgan",
            "female": "Lebensmittelaufsichtsorgan",
            "male": "Lebensmittelaufsichtsorgan",
        },
        {"neutral": "Lebensmitteltechnik", "female": "Lebensmitteltechnik", "male": "Lebensmitteltechnik"},
        {"neutral": "Lebensmitteltechniker*in", "female": "Lebensmitteltechnikerin", "male": "Lebensmitteltechniker"},
        {
            "neutral": "Lebzelter*in und Wachszieher*in",
            "female": "Lebzelterin und Wachszieherin",
            "male": "Lebzelter und Wachszieher",
        },
        {
            "neutral": "Ledergalanteriewarenerzeuger*in und Taschner*in",
            "female": "Ledergalanteriewarenerzeugerin und Taschnerin",
            "male": "Ledergalanteriewarenerzeuger und Taschner",
        },
        {
            "neutral": "Legasthenie- und Dyskalkulietrainer*in",
            "female": "Legasthenie- und Dyskalkulietrainerin",
            "male": "Legasthenie- und Dyskalkulietrainer",
        },
        {
            "neutral": "Lehrer*in / Trainer*in für Deutsch als Fremdsprache oder Zweitsprache (DaF/DaZ-Lektor*in)",
            "female": "Lehrerin / Trainerin für Deutsch als Fremdsprache oder Zweitsprache (DaF/DaZ-Lektorin)",
            "male": "Lehrer / Trainer für Deutsch als Fremdsprache oder Zweitsprache (DaF/DaZ-Lektor)",
        },
        {
            "neutral": "Lehrer*in an Allgemeinbildenden Höheren Schulen (AHS)",
            "female": "Lehrerin an Allgemeinbildenden Höheren Schulen (AHS)",
            "male": "Lehrer an Allgemeinbildenden Höheren Schulen (AHS)",
        },
        {
            "neutral": "Lehrer*in an Berufsbildenden Mittleren und Höheren Schulen (BMHS)",
            "female": "Lehrerin an Berufsbildenden Mittleren und Höheren Schulen (BMHS)",
            "male": "Lehrer an Berufsbildenden Mittleren und Höheren Schulen (BMHS)",
        },
        {
            "neutral": "Lehrer*in an Land- und forstwirtschaftlichen Schulen",
            "female": "Lehrerin an Land- und forstwirtschaftlichen Schulen",
            "male": "Lehrer an Land- und forstwirtschaftlichen Schulen",
        },
        {
            "neutral": "Lehrer*in an Mittelschulen",
            "female": "Lehrerin an Mittelschulen",
            "male": "Lehrer an Mittelschulen",
        },
        {
            "neutral": "Lehrer*in an Polytechnischen Schulen",
            "female": "Lehrerin an Polytechnischen Schulen",
            "male": "Lehrer an Polytechnischen Schulen",
        },
        {
            "neutral": "Lehrer*in an allgemeinen Pflichtschulen",
            "female": "Lehrerin an allgemeinen Pflichtschulen",
            "male": "Lehrer an allgemeinen Pflichtschulen",
        },
        {
            "neutral": "Lehrer*in für Bewegung und Sport (Pflichtschulen)",
            "female": "Lehrerin für Bewegung und Sport (Pflichtschulen)",
            "male": "Lehrer für Bewegung und Sport (Pflichtschulen)",
        },
        {
            "neutral": "Lehrer*in für Bewegung und Sport (an Höherbildenden Schulen)",
            "female": "Lehrerin für Bewegung und Sport (an Höherbildenden Schulen)",
            "male": "Lehrer für Bewegung und Sport (an Höherbildenden Schulen)",
        },
        {
            "neutral": "Lehrer*in für Bildnerische Erziehung und Werkerziehung",
            "female": "Lehrerin für Bildnerische Erziehung und Werkerziehung",
            "male": "Lehrer für Bildnerische Erziehung und Werkerziehung",
        },
        {
            "neutral": "Lehrer*in für Darstellende Kunst (Schauspiellehrer*in)",
            "female": "Lehrerin für Darstellende Kunst (Schauspiellehrerin)",
            "male": "Lehrer für Darstellende Kunst (Schauspiellehrer)",
        },
        {
            "neutral": "Lehrer*in für Gesundheits- und Krankenpflege",
            "female": "Lehrerin für Gesundheits- und Krankenpflege",
            "male": "Lehrer für Gesundheits- und Krankenpflege",
        },
        {
            "neutral": "Lehrer*in für Information und Kommunikation",
            "female": "Lehrerin für Information und Kommunikation",
            "male": "Lehrer für Information und Kommunikation",
        },
        {
            "neutral": "Lehrer*in für Inklusiv- und Sonderpädagogik",
            "female": "Lehrerin für Inklusiv- und Sonderpädagogik",
            "male": "Lehrer für Inklusiv- und Sonderpädagogik",
        },
        {
            "neutral": "Lehrer*in für Sozialarbeit",
            "female": "Lehrerin für Sozialarbeit",
            "male": "Lehrer für Sozialarbeit",
        },
        {
            "neutral": "Lehrer*in für Textiles Gestalten und Werkerziehung",
            "female": "Lehrerin für Textiles Gestalten und Werkerziehung",
            "male": "Lehrer für Textiles Gestalten und Werkerziehung",
        },
        {
            "neutral": "Lehrer*in für den Technischen und Gewerblichen Fachunterricht",
            "female": "Lehrerin für den Technischen und Gewerblichen Fachunterricht",
            "male": "Lehrer für den Technischen und Gewerblichen Fachunterricht",
        },
        {
            "neutral": "Lehrer*in für den ernährungswirtschaftlichen und haushaltsökonomischen Fachunterricht",
            "female": "Lehrerin für den ernährungswirtschaftlichen und haushaltsökonomischen Fachunterricht",
            "male": "Lehrer für den ernährungswirtschaftlichen und haushaltsökonomischen Fachunterricht",
        },
        {
            "neutral": "Lehrer*in für die Primarstufe",
            "female": "Lehrerin für die Primarstufe",
            "male": "Lehrer für die Primarstufe",
        },
        {
            "neutral": "Lehrer*in für die Sekundarstufe - Allgemeinbildung",
            "female": "Lehrerin für die Sekundarstufe - Allgemeinbildung",
            "male": "Lehrer für die Sekundarstufe - Allgemeinbildung",
        },
        {
            "neutral": "Lehrer*in für die Sekundarstufe - Berufsbildung",
            "female": "Lehrerin für die Sekundarstufe - Berufsbildung",
            "male": "Lehrer für die Sekundarstufe - Berufsbildung",
        },
        {
            "neutral": "Lehrer*in für elementare Musik- u. Bewegungserziehung",
            "female": "Lehrerin für elementare Musik- u. Bewegungserziehung",
            "male": "Lehrer für elementare Musik- u. Bewegungserziehung",
        },
        {"neutral": "Lehrhebamme", "female": "Lehrhebamme", "male": "Lehrhebamme"},
        {"neutral": "Lehrlingsausbilder*in", "female": "Lehrlingsausbilderin", "male": "Lehrlingsausbilder"},
        {"neutral": "Leichtflugzeugbauer*in", "female": "Leichtflugzeugbauerin", "male": "Leichtflugzeugbauer"},
        {"neutral": "Leistungssportler*in", "female": "Leistungssportlerin", "male": "Leistungssportler"},
        {"neutral": "Leitartikler*in", "female": "Leitartiklerin", "male": "Leitartikler"},
        {
            "neutral": "Leiter*in des technischen Kundendienstes",
            "female": "Leiterin des technischen Kundendienstes",
            "male": "Leiter des technischen Kundendienstes",
        },
        {"neutral": "Lektor*in (Uni, FH)", "female": "Lektorin (Uni, FH)", "male": "Lektor (Uni, FH)"},
        {"neutral": "Lerncoach", "female": "Lerncoach", "male": "Lerncoach"},
        {"neutral": "Lerntheoretiker*in", "female": "Lerntheoretikerin", "male": "Lerntheoretiker"},
        {"neutral": "Lerntherapeut*in", "female": "Lerntherapeutin", "male": "Lerntherapeut"},
        {"neutral": "Let's Player", "female": "Let's Player", "male": "Let's Player"},
        {"neutral": "Librettist*in", "female": "Librettistin", "male": "Librettist"},
        {"neutral": "Lichttechniker*in", "female": "Lichttechnikerin", "male": "Lichttechniker"},
        {"neutral": "Liftwart*in", "female": "Liftwartin", "male": "Liftwart"},
        {"neutral": "Linguist*in", "female": "Linguistin", "male": "Linguist"},
        {"neutral": "Listbroker", "female": "Listbroker", "male": "Listbroker"},
        {
            "neutral": "Literaturwissenschafter*in",
            "female": "Literaturwissenschafterin",
            "male": "Literaturwissenschafter",
        },
        {"neutral": "Lithograf*in", "female": "Lithografin", "male": "Lithograf"},
        {"neutral": "Lobbyist*in", "female": "Lobbyistin", "male": "Lobbyist"},
        {"neutral": "Logistiker*in", "female": "Logistikerin", "male": "Logistiker"},
        {"neutral": "Logopäde / Logopädin", "female": "Logopädin", "male": "Logopäde"},
        {"neutral": "Lohnverrechner*in", "female": "Lohnverrechnerin", "male": "Lohnverrechner"},
        {"neutral": "Luftfahrzeugtechnik", "female": "Luftfahrzeugtechnik", "male": "Luftfahrzeugtechnik"},
        {
            "neutral": "Luftfahrzeugtechnik - Flugzeuge mit Kolbentriebwerken",
            "female": "Luftfahrzeugtechnik - Flugzeuge mit Kolbentriebwerken",
            "male": "Luftfahrzeugtechnik - Flugzeuge mit Kolbentriebwerken",
        },
        {
            "neutral": "Luftfahrzeugtechnik - Flugzeuge mit Turbinentriebwerken",
            "female": "Luftfahrzeugtechnik - Flugzeuge mit Turbinentriebwerken",
            "male": "Luftfahrzeugtechnik - Flugzeuge mit Turbinentriebwerken",
        },
        {
            "neutral": "Luftfahrzeugtechnik - Hubschrauber",
            "female": "Luftfahrzeugtechnik - Hubschrauber",
            "male": "Luftfahrzeugtechnik - Hubschrauber",
        },
        {
            "neutral": "Luftfahrzeugtechniker*in - Wartungstechnik",
            "female": "Luftfahrzeugtechnikerin - Wartungstechnik",
            "male": "Luftfahrzeugtechniker - Wartungstechnik",
        },
        {
            "neutral": "Ländliches Betriebs- und Haushaltsmanagement",
            "female": "Ländliches Betriebs- und Haushaltsmanagement",
            "male": "Ländliches Betriebs- und Haushaltsmanagement",
        },
        {"neutral": "Magazineur*in", "female": "Magazineurin", "male": "Magazineur"},
        {"neutral": "Maler*in (Kunst-)", "female": "Malerin (Kunst-)", "male": "Maler (Kunst-)"},
        {
            "neutral": "Maler*in und Anstreicher*in",
            "female": "Malerin und Anstreicherin",
            "male": "Maler und Anstreicher",
        },
        {
            "neutral": "Maler*in und Beschichtungstechniker*in",
            "female": "Malerin und Beschichtungstechnikerin",
            "male": "Maler und Beschichtungstechniker",
        },
        {
            "neutral": "Maler*in und Beschichtungstechniker*in - Dekormaltechnik",
            "female": "Malerin und Beschichtungstechnikerin - Dekormaltechnik",
            "male": "Maler und Beschichtungstechniker - Dekormaltechnik",
        },
        {
            "neutral": "Maler*in und Beschichtungstechniker*in - Funktionsbeschichtungen",
            "female": "Malerin und Beschichtungstechnikerin - Funktionsbeschichtungen",
            "male": "Maler und Beschichtungstechniker - Funktionsbeschichtungen",
        },
        {
            "neutral": "Maler*in und Beschichtungstechniker*in - Historische Maltechnik",
            "female": "Malerin und Beschichtungstechnikerin - Historische Maltechnik",
            "male": "Maler und Beschichtungstechniker - Historische Maltechnik",
        },
        {
            "neutral": "Maler*in und Beschichtungstechniker*in - Korrosionsschutz",
            "female": "Malerin und Beschichtungstechnikerin - Korrosionsschutz",
            "male": "Maler und Beschichtungstechniker - Korrosionsschutz",
        },
        {"neutral": "Management-Accountant", "female": "Management-Accountant", "male": "Management-Accountant"},
        {"neutral": "Managementassistent*in", "female": "Managementassistentin", "male": "Managementassistent"},
        {"neutral": "Manager*in", "female": "Managerin", "male": "Manager"},
        {"neutral": "Manager*in (Controlling)", "female": "Managerin (Controlling)", "male": "Manager (Controlling)"},
        {
            "neutral": "Manager*in (Einkauf, Beschaffung)",
            "female": "Managerin (Einkauf, Beschaffung)",
            "male": "Manager (Einkauf, Beschaffung)",
        },
        {"neutral": "Manager*in (Export)", "female": "Managerin (Export)", "male": "Manager (Export)"},
        {
            "neutral": "Manager*in (Investitionsplanung)",
            "female": "Managerin (Investitionsplanung)",
            "male": "Manager (Investitionsplanung)",
        },
        {"neutral": "Manager*in (Krankenhaus)", "female": "Managerin (Krankenhaus)", "male": "Manager (Krankenhaus)"},
        {"neutral": "Manager*in (Logistik)", "female": "Managerin (Logistik)", "male": "Manager (Logistik)"},
        {"neutral": "Manager*in (Marketing)", "female": "Managerin (Marketing)", "male": "Manager (Marketing)"},
        {
            "neutral": "Manager*in (Materialwirtschaft)",
            "female": "Managerin (Materialwirtschaft)",
            "male": "Manager (Materialwirtschaft)",
        },
        {"neutral": "Manager*in (Produktion)", "female": "Managerin (Produktion)", "male": "Manager (Produktion)"},
        {"neutral": "Manager*in (Verkauf)", "female": "Managerin (Verkauf)", "male": "Manager (Verkauf)"},
        {"neutral": "Manager*in (Vertrieb)", "female": "Managerin (Vertrieb)", "male": "Manager (Vertrieb)"},
        {"neutral": "Mannequin / Dressman", "female": "Dressman", "male": "Mannequin"},
        {
            "neutral": "Marionettenspieler*in / Puppenspieler*in",
            "female": "Marionettenspielerin / Puppenspielerin",
            "male": "Marionettenspieler / Puppenspieler",
        },
        {
            "neutral": "Marketingfachmann / Marketingfachfrau",
            "female": "Marketingfachfrau",
            "male": "Marketingfachmann",
        },
        {"neutral": "Markscheider*in", "female": "Markscheiderin", "male": "Markscheider"},
        {
            "neutral": "Markt- und Meinungsforscher*in",
            "female": "Markt- und Meinungsforscherin",
            "male": "Markt- und Meinungsforscher",
        },
        {"neutral": "Marktaufsichtsorgan", "female": "Marktaufsichtsorgan", "male": "Marktaufsichtsorgan"},
        {
            "neutral": "Maschinenbau- und Anlagenkonstrukteur*in",
            "female": "Maschinenbau- und Anlagenkonstrukteurin",
            "male": "Maschinenbau- und Anlagenkonstrukteur",
        },
        {"neutral": "Maschinenbauingenieur*in", "female": "Maschinenbauingenieurin", "male": "Maschinenbauingenieur"},
        {"neutral": "Maschinenbautechnik", "female": "Maschinenbautechnik", "male": "Maschinenbautechnik"},
        {"neutral": "Maschinenbautechniker*in", "female": "Maschinenbautechnikerin", "male": "Maschinenbautechniker"},
        {"neutral": "Maschinenbediener*in", "female": "Maschinenbedienerin", "male": "Maschinenbediener"},
        {
            "neutral": "Maschinenfertigungstechnik",
            "female": "Maschinenfertigungstechnik",
            "male": "Maschinenfertigungstechnik",
        },
        {"neutral": "Maschinenmechanik", "female": "Maschinenmechanik", "male": "Maschinenmechanik"},
        {"neutral": "Maschinennäher*in", "female": "Maschinennäherin", "male": "Maschinennäher"},
        {"neutral": "Maschinenschlosser*in", "female": "Maschinenschlosserin", "male": "Maschinenschlosser"},
        {"neutral": "Maschinsticker*in", "female": "Maschinstickerin", "male": "Maschinsticker"},
        {"neutral": "Maskenbildner*in", "female": "Maskenbildnerin", "male": "Maskenbildner"},
        {"neutral": "Masseur*in", "female": "Masseurin", "male": "Masseur"},
        {
            "neutral": "Material- und Verarbeitungstechniker*in",
            "female": "Material- und Verarbeitungstechnikerin",
            "male": "Material- und Verarbeitungstechniker",
        },
        {"neutral": "Materialprüfer*in", "female": "Materialprüferin", "male": "Materialprüfer"},
        {"neutral": "Mathematiker*in", "female": "Mathematikerin", "male": "Mathematiker"},
        {
            "neutral": "Mathematiker*in (Informations- und Datenverarbeitung)",
            "female": "Mathematikerin (Informations- und Datenverarbeitung)",
            "male": "Mathematiker (Informations- und Datenverarbeitung)",
        },
        {
            "neutral": "Mathematiker*in für Technische Mathematik",
            "female": "Mathematikerin für Technische Mathematik",
            "male": "Mathematiker für Technische Mathematik",
        },
        {"neutral": "Matrose / Matrosin", "female": "Matrosin", "male": "Matrose"},
        {
            "neutral": "Matrose / Matrosin für Binnenschifffahrt",
            "female": "Matrosin für Binnenschifffahrt",
            "male": "Matrose für Binnenschifffahrt",
        },
        {"neutral": "Maurer*in", "female": "Maurerin", "male": "Maurer"},
        {"neutral": "Mechaniker*in", "female": "Mechanikerin", "male": "Mechaniker"},
        {"neutral": "Mechatronik", "female": "Mechatronik", "male": "Mechatronik"},
        {
            "neutral": "Mechatronik - Alternative Antriebstechnik",
            "female": "Mechatronik - Alternative Antriebstechnik",
            "male": "Mechatronik - Alternative Antriebstechnik",
        },
        {
            "neutral": "Mechatronik - Automatisierungstechnik",
            "female": "Mechatronik - Automatisierungstechnik",
            "male": "Mechatronik - Automatisierungstechnik",
        },
        {
            "neutral": "Mechatronik - Elektromaschinentechnik",
            "female": "Mechatronik - Elektromaschinentechnik",
            "male": "Mechatronik - Elektromaschinentechnik",
        },
        {
            "neutral": "Mechatronik - Fertigungstechnik",
            "female": "Mechatronik - Fertigungstechnik",
            "male": "Mechatronik - Fertigungstechnik",
        },
        {
            "neutral": "Mechatronik - IT-, Digitalsystem- und Netzwerktechnik",
            "female": "Mechatronik - IT-, Digitalsystem- und Netzwerktechnik",
            "male": "Mechatronik - IT-, Digitalsystem- und Netzwerktechnik",
        },
        {
            "neutral": "Mechatronik - Medizingerätetechnik",
            "female": "Mechatronik - Medizingerätetechnik",
            "male": "Mechatronik - Medizingerätetechnik",
        },
        {"neutral": "Mechatroniker*in", "female": "Mechatronikerin", "male": "Mechatroniker"},
        {
            "neutral": "Mechatroniker*in (Robotik)",
            "female": "Mechatronikerin (Robotik)",
            "male": "Mechatroniker (Robotik)",
        },
        {"neutral": "Mediaberater*in", "female": "Mediaberaterin", "male": "Mediaberater"},
        {"neutral": "Mediafachmann / Mediafachfrau", "female": "Mediafachfrau", "male": "Mediafachmann"},
        {"neutral": "Mediaplaner*in", "female": "Mediaplanerin", "male": "Mediaplaner"},
        {"neutral": "Mediator*in", "female": "Mediatorin", "male": "Mediator"},
        {"neutral": "Medical Writer", "female": "Medical Writer", "male": "Medical Writer"},
        {"neutral": "Medienarchivar*in", "female": "Medienarchivarin", "male": "Medienarchivar"},
        {"neutral": "Mediendidaktiker*in", "female": "Mediendidaktikerin", "male": "Mediendidaktiker"},
        {"neutral": "Medienfachmann / Medienfachfrau", "female": "Medienfachfrau", "male": "Medienfachmann"},
        {
            "neutral": "Mediengestalter*in (Bild und Ton)",
            "female": "Mediengestalterin (Bild und Ton)",
            "male": "Mediengestalter (Bild und Ton)",
        },
        {
            "neutral": "Mediengestalter*in (Digital- und Printmedien)",
            "female": "Mediengestalterin (Digital- und Printmedien)",
            "male": "Mediengestalter (Digital- und Printmedien)",
        },
        {
            "neutral": "Mediengestalter*in (Visuelle Medien)",
            "female": "Mediengestalterin (Visuelle Medien)",
            "male": "Mediengestalter (Visuelle Medien)",
        },
        {"neutral": "Medieninformatiker*in", "female": "Medieninformatikerin", "male": "Medieninformatiker"},
        {"neutral": "Medienkomponist*in", "female": "Medienkomponistin", "male": "Medienkomponist"},
        {"neutral": "Medienmanager*in", "female": "Medienmanagerin", "male": "Medienmanager"},
        {"neutral": "Mediensprecher*in", "female": "Mediensprecherin", "male": "Mediensprecher"},
        {"neutral": "Medizininformatiker*in", "female": "Medizininformatikerin", "male": "Medizininformatiker"},
        {
            "neutral": "Medizinisch-pharmazeutische/r Fachberater*in",
            "female": "Medizinisch-pharmazeutische Fachberaterin",
            "male": "Medizinisch-pharmazeutischer Fachberater",
        },
        {
            "neutral": "Medizinische*r Biometriker*in",
            "female": "Medizinische Biometrikerin",
            "male": "Medizinischer Biometriker",
        },
        {
            "neutral": "Medizinische*r Dokumentar*in",
            "female": "Medizinische Dokumentarin",
            "male": "Medizinischer Dokumentar",
        },
        {
            "neutral": "Medizinische*r Fachassistent*in (MFA)",
            "female": "Medizinische Fachassistentin (MFA)",
            "male": "Medizinischer Fachassistent (MFA)",
        },
        {"neutral": "Medizinische*r Masseur*in", "female": "Medizinische Masseurin", "male": "Medizinischer Masseur"},
        {
            "neutral": "Medizinprodukteberater*in",
            "female": "Medizinprodukteberaterin",
            "male": "Medizinprodukteberater",
        },
        {
            "neutral": "Medizinproduktekaufmann / Medizinproduktekauffrau",
            "female": "Medizinproduktekauffrau",
            "male": "Medizinproduktekaufmann",
        },
        {"neutral": "Medizintechniker*in", "female": "Medizintechnikerin", "male": "Medizintechniker"},
        {
            "neutral": "Medizintechnische*r Fachberater*in",
            "female": "Medizintechnische Fachberaterin",
            "male": "Medizintechnischer Fachberater",
        },
        {"neutral": "Meeresbiologe / Meeresbiologin", "female": "Meeresbiologin", "male": "Meeresbiologe"},
        {"neutral": "Meeresforscher*in", "female": "Meeresforscherin", "male": "Meeresforscher"},
        {"neutral": "Meinungsforscher*in", "female": "Meinungsforscherin", "male": "Meinungsforscher"},
        {"neutral": "Mentaltrainer*in", "female": "Mentaltrainerin", "male": "Mentaltrainer"},
        {"neutral": "Merchandiser", "female": "Merchandiser", "male": "Merchandiser"},
        {
            "neutral": "Mergers & Acquisitions Manager*in",
            "female": "Mergers & Acquisitions Managerin",
            "male": "Mergers & Acquisitions Manager",
        },
        {
            "neutral": "Messe- u. Ausstellungsgestalter*in",
            "female": "Messe- u. Ausstellungsgestalterin",
            "male": "Messe- u. Ausstellungsgestalter",
        },
        {"neutral": "Messerschmied*in", "female": "Messerschmiedin", "male": "Messerschmied"},
        {"neutral": "Messtechniker*in", "female": "Messtechnikerin", "male": "Messtechniker"},
        {"neutral": "Metallbaukonstrukteur*in", "female": "Metallbaukonstrukteurin", "male": "Metallbaukonstrukteur"},
        {"neutral": "Metallbearbeitung", "female": "Metallbearbeitung", "male": "Metallbearbeitung"},
        {"neutral": "Metalldesign", "female": "Metalldesign", "male": "Metalldesign"},
        {"neutral": "Metalldesign - Gravur", "female": "Metalldesign - Gravur", "male": "Metalldesign - Gravur"},
        {
            "neutral": "Metalldesign - Gürtlerei",
            "female": "Metalldesign - Gürtlerei",
            "male": "Metalldesign - Gürtlerei",
        },
        {
            "neutral": "Metalldesign - Metalldrückerei",
            "female": "Metalldesign - Metalldrückerei",
            "male": "Metalldesign - Metalldrückerei",
        },
        {"neutral": "Metalldrücker*in", "female": "Metalldrückerin", "male": "Metalldrücker"},
        {"neutral": "Metallgestalter*in", "female": "Metallgestalterin", "male": "Metallgestalter"},
        {"neutral": "Metallgießer*in", "female": "Metallgießerin", "male": "Metallgießer"},
        {
            "neutral": "Metallschleifer*in und Galvaniseur*in",
            "female": "Metallschleiferin und Galvaniseurin",
            "male": "Metallschleifer und Galvaniseur",
        },
        {"neutral": "Metalltechnik", "female": "Metalltechnik", "male": "Metalltechnik"},
        {
            "neutral": "Metalltechnik - Blechtechnik",
            "female": "Metalltechnik - Blechtechnik",
            "male": "Metalltechnik - Blechtechnik",
        },
        {
            "neutral": "Metalltechnik - Fahrzeugbautechnik",
            "female": "Metalltechnik - Fahrzeugbautechnik",
            "male": "Metalltechnik - Fahrzeugbautechnik",
        },
        {
            "neutral": "Metalltechnik - Maschinenbautechnik",
            "female": "Metalltechnik - Maschinenbautechnik",
            "male": "Metalltechnik - Maschinenbautechnik",
        },
        {
            "neutral": "Metalltechnik - Metallbau- und Blechtechnik",
            "female": "Metalltechnik - Metallbau- und Blechtechnik",
            "male": "Metalltechnik - Metallbau- und Blechtechnik",
        },
        {
            "neutral": "Metalltechnik - Metallbautechnik",
            "female": "Metalltechnik - Metallbautechnik",
            "male": "Metalltechnik - Metallbautechnik",
        },
        {
            "neutral": "Metalltechnik - Metallbearbeitungstechnik",
            "female": "Metalltechnik - Metallbearbeitungstechnik",
            "male": "Metalltechnik - Metallbearbeitungstechnik",
        },
        {
            "neutral": "Metalltechnik - Schmiedetechnik",
            "female": "Metalltechnik - Schmiedetechnik",
            "male": "Metalltechnik - Schmiedetechnik",
        },
        {
            "neutral": "Metalltechnik - Schweißtechnik",
            "female": "Metalltechnik - Schweißtechnik",
            "male": "Metalltechnik - Schweißtechnik",
        },
        {
            "neutral": "Metalltechnik - Sicherheitstechnik",
            "female": "Metalltechnik - Sicherheitstechnik",
            "male": "Metalltechnik - Sicherheitstechnik",
        },
        {
            "neutral": "Metalltechnik - Stahlbautechnik",
            "female": "Metalltechnik - Stahlbautechnik",
            "male": "Metalltechnik - Stahlbautechnik",
        },
        {
            "neutral": "Metalltechnik - Werkzeugbautechnik",
            "female": "Metalltechnik - Werkzeugbautechnik",
            "male": "Metalltechnik - Werkzeugbautechnik",
        },
        {
            "neutral": "Metalltechnik - Zerspanungstechnik",
            "female": "Metalltechnik - Zerspanungstechnik",
            "male": "Metalltechnik - Zerspanungstechnik",
        },
        {"neutral": "Metallurg*in", "female": "Metallurgin", "male": "Metallurg"},
        {
            "neutral": "Metallurgie und Umformtechnik",
            "female": "Metallurgie und Umformtechnik",
            "male": "Metallurgie und Umformtechnik",
        },
        {
            "neutral": "Metallverfahrenstechniker*in",
            "female": "Metallverfahrenstechnikerin",
            "male": "Metallverfahrenstechniker",
        },
        {"neutral": "Meteorologe / Meteorologin", "female": "Meteorologin", "male": "Meteorologe"},
        {"neutral": "Methodiker*in", "female": "Methodikerin", "male": "Methodiker"},
        {"neutral": "Miedererzeuger*in", "female": "Miedererzeugerin", "male": "Miedererzeuger"},
        {"neutral": "Mikrobiologe / Mikrobiologin", "female": "Mikrobiologin", "male": "Mikrobiologe"},
        {"neutral": "Mikroelektroniker*in", "female": "Mikroelektronikerin", "male": "Mikroelektroniker"},
        {"neutral": "Mikrotechnik", "female": "Mikrotechnik", "male": "Mikrotechnik"},
        {
            "neutral": "Mikrotechniker*in - Medizintechnik",
            "female": "Mikrotechnikerin - Medizintechnik",
            "male": "Mikrotechniker - Medizintechnik",
        },
        {
            "neutral": "Mikrotechniker*in - Mikrocomputertechnik",
            "female": "Mikrotechnikerin - Mikrocomputertechnik",
            "male": "Mikrotechniker - Mikrocomputertechnik",
        },
        {
            "neutral": "Mikrotechniker*in - Mikromechanik",
            "female": "Mikrotechnikerin - Mikromechanik",
            "male": "Mikrotechniker - Mikromechanik",
        },
        {
            "neutral": "Mikrotechniker*in - Nanotechnik",
            "female": "Mikrotechnikerin - Nanotechnik",
            "male": "Mikrotechniker - Nanotechnik",
        },
        {
            "neutral": "Mikrotechniker*in / Mikrosystemtechniker*in",
            "female": "Mikrotechnikerin / Mikrosystemtechnikerin",
            "male": "Mikrotechniker / Mikrosystemtechniker",
        },
        {"neutral": "Milchtechnologie", "female": "Milchtechnologie", "male": "Milchtechnologie"},
        {"neutral": "Militärstreife", "female": "Militärstreife", "male": "Militärstreife"},
        {"neutral": "Mineraloge / Mineralogin", "female": "Mineralogin", "male": "Mineraloge"},
        {"neutral": "Mineur*in", "female": "Mineurin", "male": "Mineur"},
        {"neutral": "Mobile Developer*in", "female": "Mobile Developerin", "male": "Mobile Developer"},
        {"neutral": "Mobilitätsberater*in", "female": "Mobilitätsberaterin", "male": "Mobilitätsberater"},
        {"neutral": "Mobilitätsservice", "female": "Mobilitätsservice", "male": "Mobilitätsservice"},
        {"neutral": "Modedesigner*in", "female": "Modedesignerin", "male": "Modedesigner"},
        {"neutral": "Modegrafiker*in", "female": "Modegrafikerin", "male": "Modegrafiker"},
        {"neutral": "Modehändler*in", "female": "Modehändlerin", "male": "Modehändler"},
        {"neutral": "Modellbauer*in", "female": "Modellbauerin", "male": "Modellbauer"},
        {"neutral": "Modellschlosser*in", "female": "Modellschlosserin", "male": "Modellschlosser"},
        {"neutral": "Modelltischler*in", "female": "Modelltischlerin", "male": "Modelltischler"},
        {"neutral": "Moderator*in", "female": "Moderatorin", "male": "Moderator"},
        {"neutral": "Modist*in", "female": "Modistin", "male": "Modist"},
        {"neutral": "Molekularbiologe / Molekularbiologin", "female": "Molekularbiologin", "male": "Molekularbiologe"},
        {"neutral": "Molekularmediziner*in", "female": "Molekularmedizinerin", "male": "Molekularmediziner"},
        {"neutral": "Molekulartechniker*in", "female": "Molekulartechnikerin", "male": "Molekulartechniker"},
        {
            "neutral": "Molkerei- und Käsereiwirtschaft",
            "female": "Molkerei- und Käsereiwirtschaft",
            "male": "Molkerei- und Käsereiwirtschaft",
        },
        {"neutral": "Molkereifachmann / Molkereifachfrau", "female": "Molkereifachfrau", "male": "Molkereifachmann"},
        {
            "neutral": "Montanmaschinenbautechniker*in",
            "female": "Montanmaschinenbautechnikerin",
            "male": "Montanmaschinenbautechniker",
        },
        {"neutral": "Motorradtechniker*in", "female": "Motorradtechnikerin", "male": "Motorradtechniker"},
        {
            "neutral": "Mountainbike- und Touringguide",
            "female": "Mountainbike- und Touringguide",
            "male": "Mountainbike- und Touringguide",
        },
        {"neutral": "Multimedia-Designer*in", "female": "Multimedia-Designerin", "male": "Multimedia-Designer"},
        {
            "neutral": "Multimedia-Informatiker*in",
            "female": "Multimedia-Informatikerin",
            "male": "Multimedia-Informatiker",
        },
        {"neutral": "Multimedia-Ingenieur*in", "female": "Multimedia-Ingenieurin", "male": "Multimedia-Ingenieur"},
        {
            "neutral": "Multimedia-Konzeptionist*in",
            "female": "Multimedia-Konzeptionistin",
            "male": "Multimedia-Konzeptionist",
        },
        {"neutral": "Multimedia-Künstler*in", "female": "Multimedia-Künstlerin", "male": "Multimedia-Künstler"},
        {"neutral": "Multimedia-Producer", "female": "Multimedia-Producer", "male": "Multimedia-Producer"},
        {
            "neutral": "Multimedia-Programmierer*in",
            "female": "Multimedia-Programmiererin",
            "male": "Multimedia-Programmierer",
        },
        {
            "neutral": "Multimedia-Projektleiter*in",
            "female": "Multimedia-Projektleiterin",
            "male": "Multimedia-Projektleiter",
        },
        {
            "neutral": "Multimedia-Projektmanager*in",
            "female": "Multimedia-Projektmanagerin",
            "male": "Multimedia-Projektmanager",
        },
        {"neutral": "Multimedia-Redakteur*in", "female": "Multimedia-Redakteurin", "male": "Multimedia-Redakteur"},
        {
            "neutral": "Multimedia-Software-Entwickler*in",
            "female": "Multimedia-Software-Entwicklerin",
            "male": "Multimedia-Software-Entwickler",
        },
        {"neutral": "Museumsaufseher*in", "female": "Museumsaufseherin", "male": "Museumsaufseher"},
        {"neutral": "Museumsdidaktiker*in", "female": "Museumsdidaktikerin", "male": "Museumsdidaktiker"},
        {"neutral": "Museumsdirektor*in", "female": "Museumsdirektorin", "male": "Museumsdirektor"},
        {"neutral": "Museumsführer*in", "female": "Museumsführerin", "male": "Museumsführer"},
        {"neutral": "Museumspädagoge / Museumspädagogin", "female": "Museumspädagogin", "male": "Museumspädagoge"},
        {"neutral": "Musicaldarsteller*in", "female": "Musicaldarstellerin", "male": "Musicaldarsteller"},
        {"neutral": "Musikagent*in", "female": "Musikagentin", "male": "Musikagent"},
        {"neutral": "Musikalienhändler*in", "female": "Musikalienhändlerin", "male": "Musikalienhändler"},
        {"neutral": "Musiker*in", "female": "Musikerin", "male": "Musiker"},
        {"neutral": "Musiklehrer*in", "female": "Musiklehrerin", "male": "Musiklehrer"},
        {"neutral": "Musikmanager*in", "female": "Musikmanagerin", "male": "Musikmanager"},
        {"neutral": "Musikproduzent*in", "female": "Musikproduzentin", "male": "Musikproduzent"},
        {"neutral": "Musiktherapeut*in", "female": "Musiktherapeutin", "male": "Musiktherapeut"},
        {"neutral": "Musikwissenschafter*in", "female": "Musikwissenschafterin", "male": "Musikwissenschafter"},
        {"neutral": "Möbelbautechniker*in", "female": "Möbelbautechnikerin", "male": "Möbelbautechniker"},
        {"neutral": "Möbelmonteur*in", "female": "Möbelmonteurin", "male": "Möbelmonteur"},
        {"neutral": "Müllaufleger*in", "female": "Müllauflegerin", "male": "Müllaufleger"},
        {"neutral": "Münzenhändler*in", "female": "Münzenhändlerin", "male": "Münzenhändler"},
        {
            "neutral": "Nachhaltigkeitsmanager*in",
            "female": "Nachhaltigkeitsmanagerin",
            "male": "Nachhaltigkeitsmanager",
        },
        {
            "neutral": "Nachrichtenelektroniker*in",
            "female": "Nachrichtenelektronikerin",
            "male": "Nachrichtenelektroniker",
        },
        {"neutral": "Nachrichtentechniker*in", "female": "Nachrichtentechnikerin", "male": "Nachrichtentechniker"},
        {"neutral": "Nachtportier*in", "female": "Nachtportierin", "male": "Nachtportier"},
        {
            "neutral": "Nah- und Distributionslogistik",
            "female": "Nah- und Distributionslogistik",
            "male": "Nah- und Distributionslogistik",
        },
        {
            "neutral": "Nahrungsmittelanalytiker*in",
            "female": "Nahrungsmittelanalytikerin",
            "male": "Nahrungsmittelanalytiker",
        },
        {
            "neutral": "Nanobiotechnologe / Nanobiotechnologin",
            "female": "Nanobiotechnologin",
            "male": "Nanobiotechnologe",
        },
        {"neutral": "Nanotechniker*in", "female": "Nanotechnikerin", "male": "Nanotechniker"},
        {"neutral": "Nanotechnologe / Nanotechnologin", "female": "Nanotechnologin", "male": "Nanotechnologe"},
        {"neutral": "Nationalpark-Ranger", "female": "Nationalpark-Ranger", "male": "Nationalpark-Ranger"},
        {
            "neutral": "Natur- und Erlebnispädagoge / Natur- und Erlebnispädagogin",
            "female": "Natur- und Erlebnispädagogin",
            "male": "Natur- und Erlebnispädagoge",
        },
        {
            "neutral": "Natural Language Processing Expert*in",
            "female": "Natural Language Processing Expertin",
            "male": "Natural Language Processing Expert",
        },
        {"neutral": "Netzwerkadministrator*in", "female": "Netzwerkadministratorin", "male": "Netzwerkadministrator"},
        {"neutral": "Netzwerkarchitekt*in", "female": "Netzwerkarchitektin", "male": "Netzwerkarchitekt"},
        {"neutral": "Netzwerkbetreuer*in", "female": "Netzwerkbetreuerin", "male": "Netzwerkbetreuer"},
        {"neutral": "Netzwerkdesigner*in", "female": "Netzwerkdesignerin", "male": "Netzwerkdesigner"},
        {"neutral": "Netzwerkexpert*in", "female": "Netzwerkexpertin", "male": "Netzwerkexpert"},
        {"neutral": "Netzwerkmanager*in", "female": "Netzwerkmanagerin", "male": "Netzwerkmanager"},
        {
            "neutral": "Netzwerktechniker*in (Computersysteme)",
            "female": "Netzwerktechnikerin (Computersysteme)",
            "male": "Netzwerktechniker (Computersysteme)",
        },
        {"neutral": "Netzwerkverwalter*in", "female": "Netzwerkverwalterin", "male": "Netzwerkverwalter"},
        {"neutral": "Neurolinguist*in", "female": "Neurolinguistin", "male": "Neurolinguist"},
        {"neutral": "Neurowissenschafter*in", "female": "Neurowissenschafterin", "male": "Neurowissenschafter"},
        {"neutral": "New Media Consultant", "female": "New Media Consultant", "male": "New Media Consultant"},
        {"neutral": "Night Auditor", "female": "Night Auditor", "male": "Night Auditor"},
        {"neutral": "Notar*in", "female": "Notarin", "male": "Notar"},
        {"neutral": "Notfallsanitäter*in", "female": "Notfallsanitäterin", "male": "Notfallsanitäter"},
        {"neutral": "Numismatiker*in", "female": "Numismatikerin", "male": "Numismatiker"},
        {"neutral": "Obduktionsassistent*in", "female": "Obduktionsassistentin", "male": "Obduktionsassistent"},
        {"neutral": "Oberflächentechnik", "female": "Oberflächentechnik", "male": "Oberflächentechnik"},
        {
            "neutral": "Oberflächentechnik - Dünnschicht- und Plasmatechnik",
            "female": "Oberflächentechnik - Dünnschicht- und Plasmatechnik",
            "male": "Oberflächentechnik - Dünnschicht- und Plasmatechnik",
        },
        {
            "neutral": "Oberflächentechnik - Emailtechnik",
            "female": "Oberflächentechnik - Emailtechnik",
            "male": "Oberflächentechnik - Emailtechnik",
        },
        {
            "neutral": "Oberflächentechnik - Feuerverzinkung",
            "female": "Oberflächentechnik - Feuerverzinkung",
            "male": "Oberflächentechnik - Feuerverzinkung",
        },
        {
            "neutral": "Oberflächentechnik - Galvanik",
            "female": "Oberflächentechnik - Galvanik",
            "male": "Oberflächentechnik - Galvanik",
        },
        {
            "neutral": "Oberflächentechnik - Mechanische Oberflächentechnik",
            "female": "Oberflächentechnik - Mechanische Oberflächentechnik",
            "male": "Oberflächentechnik - Mechanische Oberflächentechnik",
        },
        {
            "neutral": "Oberflächentechnik - Pulverbeschichtung",
            "female": "Oberflächentechnik - Pulverbeschichtung",
            "male": "Oberflächentechnik - Pulverbeschichtung",
        },
        {"neutral": "Oberflächentechniker*in", "female": "Oberflächentechnikerin", "male": "Oberflächentechniker"},
        {"neutral": "Oberteilherrichter*in", "female": "Oberteilherrichterin", "male": "Oberteilherrichter"},
        {
            "neutral": "Obst- und Gemüsekonservierer*in",
            "female": "Obst- und Gemüsekonserviererin",
            "male": "Obst- und Gemüsekonservierer",
        },
        {
            "neutral": "Obstbau und Obstverwertung",
            "female": "Obstbau und Obstverwertung",
            "male": "Obstbau und Obstverwertung",
        },
        {"neutral": "Ocularist*in", "female": "Ocularistin", "male": "Ocularist"},
        {
            "neutral": "Ofenbau- und Verlegetechnik",
            "female": "Ofenbau- und Verlegetechnik",
            "male": "Ofenbau- und Verlegetechnik",
        },
        {"neutral": "Office Manager*in", "female": "Office Managerin", "male": "Office Manager"},
        {
            "neutral": "Offizier*in des Generalstabsdienstes",
            "female": "Offizierin des Generalstabsdienstes",
            "male": "Offizier des Generalstabsdienstes",
        },
        {
            "neutral": "Offizier*in des Wirtschaftsdienstes",
            "female": "Offizierin des Wirtschaftsdienstes",
            "male": "Offizier des Wirtschaftsdienstes",
        },
        {
            "neutral": "Offizier*in des technischen Dienstes",
            "female": "Offizierin des technischen Dienstes",
            "male": "Offizier des technischen Dienstes",
        },
        {"neutral": "Online Content Creator", "female": "Online Content Creator", "male": "Online Content Creator"},
        {"neutral": "Online Editor", "female": "Online Editor", "male": "Online Editor"},
        {
            "neutral": "Online Marketing Specialist",
            "female": "Online Marketing Specialist",
            "male": "Online Marketing Specialist",
        },
        {"neutral": "Onlinejournalist*in", "female": "Onlinejournalistin", "male": "Onlinejournalist"},
        {"neutral": "Onlineredakteur*in", "female": "Onlineredakteurin", "male": "Onlineredakteur"},
        {
            "neutral": "Operations Controller  - Flugverkehr",
            "female": "Operations Controller  - Flugverkehr",
            "male": "Operations Controller  - Flugverkehr",
        },
        {"neutral": "Operationsassistent*in", "female": "Operationsassistentin", "male": "Operationsassistent"},
        {
            "neutral": "Operationsgehilfe / Operationsgehilfin",
            "female": "Operationsgehilfin",
            "male": "Operationsgehilfe",
        },
        {
            "neutral": "Operationstechnische Assistenz",
            "female": "Operationstechnische Assistenz",
            "male": "Operationstechnische Assistenz",
        },
        {"neutral": "Optiker*in", "female": "Optikerin", "male": "Optiker"},
        {
            "neutral": "Optischer Elektroniker / Optische Elektronikerin",
            "female": "Optische Elektronikerin",
            "male": "Optischer Elektroniker",
        },
        {"neutral": "Optometrist*in", "female": "Optometristin", "male": "Optometrist"},
        {"neutral": "Optotechniker*in", "female": "Optotechnikerin", "male": "Optotechniker"},
        {"neutral": "Ordensfrau", "female": "Ordensfrau", "male": "Ordensfrau"},
        {"neutral": "Ordensmann", "female": "Ordensmann", "male": "Ordensmann"},
        {"neutral": "Ordinationsassistent*in", "female": "Ordinationsassistentin", "male": "Ordinationsassistent"},
        {
            "neutral": "Ordinationsgehilfe / Ordinationsgehilfin",
            "female": "Ordinationsgehilfin",
            "male": "Ordinationsgehilfe",
        },
        {"neutral": "Organisationsberater*in", "female": "Organisationsberaterin", "male": "Organisationsberater"},
        {"neutral": "Orgelbau", "female": "Orgelbau", "male": "Orgelbau"},
        {"neutral": "Orgelbauer*in", "female": "Orgelbauerin", "male": "Orgelbauer"},
        {"neutral": "Orthoptist*in", "female": "Orthoptistin", "male": "Orthoptist"},
        {"neutral": "Orthopädiemechaniker*in", "female": "Orthopädiemechanikerin", "male": "Orthopädiemechaniker"},
        {"neutral": "Orthopädieschuhmacher*in", "female": "Orthopädieschuhmacherin", "male": "Orthopädieschuhmacher"},
        {"neutral": "Orthopädietechnik", "female": "Orthopädietechnik", "male": "Orthopädietechnik"},
        {
            "neutral": "Orthopädietechnik - Orthesentechnik",
            "female": "Orthopädietechnik - Orthesentechnik",
            "male": "Orthopädietechnik - Orthesentechnik",
        },
        {
            "neutral": "Orthopädietechnik - Prothesentechnik",
            "female": "Orthopädietechnik - Prothesentechnik",
            "male": "Orthopädietechnik - Prothesentechnik",
        },
        {
            "neutral": "Orthopädietechnik - Rehabilitationstechnik",
            "female": "Orthopädietechnik - Rehabilitationstechnik",
            "male": "Orthopädietechnik - Rehabilitationstechnik",
        },
        {"neutral": "Osteopath*in", "female": "Osteopathin", "male": "Osteopath"},
        {"neutral": "Outdoor-Trainer*in", "female": "Outdoor-Trainerin", "male": "Outdoor-Trainer"},
        {"neutral": "Outdoorpädagoge / Outdoorpädagogin", "female": "Outdoorpädagogin", "male": "Outdoorpädagoge"},
        {"neutral": "Outplacer", "female": "Outplacer", "male": "Outplacer"},
        {"neutral": "Ozeanograf*in", "female": "Ozeanografin", "male": "Ozeanograf"},
        {"neutral": "PR-Berater*in", "female": "PR-Beraterin", "male": "PR-Berater"},
        {"neutral": "Page", "female": "Page", "male": "Page"},
        {"neutral": "Paläograf*in", "female": "Paläografin", "male": "Paläograf"},
        {"neutral": "Paläontologe / Paläontologin", "female": "Paläontologin", "male": "Paläontologe"},
        {"neutral": "Pannenfahrer*in", "female": "Pannenfahrerin", "male": "Pannenfahrer"},
        {"neutral": "Pantomimenspieler*in", "female": "Pantomimenspielerin", "male": "Pantomimenspieler"},
        {
            "neutral": "Papiermaschinenarbeiter*in",
            "female": "Papiermaschinenarbeiterin",
            "male": "Papiermaschinenarbeiter",
        },
        {"neutral": "Papiertechnik", "female": "Papiertechnik", "male": "Papiertechnik"},
        {"neutral": "Parkraumüberwacher*in", "female": "Parkraumüberwacherin", "male": "Parkraumüberwacher"},
        {"neutral": "Partnervermittler*in", "female": "Partnervermittlerin", "male": "Partnervermittler"},
        {"neutral": "Partyveranstalter*in", "female": "Partyveranstalterin", "male": "Partyveranstalter"},
        {"neutral": "Pastoralassistent*in", "female": "Pastoralassistentin", "male": "Pastoralassistent"},
        {"neutral": "Patent Professional", "female": "Patent Professional", "male": "Patent Professional"},
        {"neutral": "Patentanwalt / Patentanwältin", "female": "Patentanwältin", "male": "Patentanwalt"},
        {"neutral": "Patissier*in", "female": "Patissierin", "male": "Patissier"},
        {"neutral": "Peer Influencer", "female": "Peer Influencer", "male": "Peer Influencer"},
        {"neutral": "Performancekünstler*in", "female": "Performancekünstlerin", "male": "Performancekünstler"},
        {"neutral": "Personal Consultant", "female": "Personal Consultant", "male": "Personal Consultant"},
        {"neutral": "Personal Shopper", "female": "Personal Shopper", "male": "Personal Shopper"},
        {"neutral": "Personal Trainer", "female": "Personal Trainer", "male": "Personal Trainer"},
        {"neutral": "Personalberater*in", "female": "Personalberaterin", "male": "Personalberater"},
        {"neutral": "Personaldienstleistung", "female": "Personaldienstleistung", "male": "Personaldienstleistung"},
        {"neutral": "Personalentwickler*in", "female": "Personalentwicklerin", "male": "Personalentwickler"},
        {"neutral": "Personalleiter*in", "female": "Personalleiterin", "male": "Personalleiter"},
        {
            "neutral": "Personalsachbearbeiter*in",
            "female": "Personalsachbearbeiterin",
            "male": "Personalsachbearbeiter",
        },
        {"neutral": "Personalverrechner*in", "female": "Personalverrechnerin", "male": "Personalverrechner"},
        {"neutral": "Personenbetreuer*in", "female": "Personenbetreuerin", "male": "Personenbetreuer"},
        {"neutral": "Personenschützer*in", "female": "Personenschützerin", "male": "Personenschützer"},
        {"neutral": "Petrochemiker*in", "female": "Petrochemikerin", "male": "Petrochemiker"},
        {"neutral": "Pfandleiher*in", "female": "Pfandleiherin", "male": "Pfandleiher"},
        {"neutral": "Pfarrer*in (evang.)", "female": "Pfarrerin (evang.)", "male": "Pfarrer (evang.)"},
        {"neutral": "Pferdepfleger*in", "female": "Pferdepflegerin", "male": "Pferdepfleger"},
        {"neutral": "Pferdewirt*in", "female": "Pferdewirtin", "male": "Pferdewirt"},
        {"neutral": "Pferdewirtschaft", "female": "Pferdewirtschaft", "male": "Pferdewirtschaft"},
        {"neutral": "Pflanzenschutzberater*in", "female": "Pflanzenschutzberaterin", "male": "Pflanzenschutzberater"},
        {
            "neutral": "Pflanzenwissenschafter*in",
            "female": "Pflanzenwissenschafterin",
            "male": "Pflanzenwissenschafter",
        },
        {"neutral": "Pflasterer / Pflasterin", "female": "Pflasterin", "male": "Pflasterer"},
        {"neutral": "Pflegeassistent*in", "female": "Pflegeassistentin", "male": "Pflegeassistent"},
        {"neutral": "Pflegeassistenz", "female": "Pflegeassistenz", "male": "Pflegeassistenz"},
        {"neutral": "Pflegefachassistent*in", "female": "Pflegefachassistentin", "male": "Pflegefachassistent"},
        {"neutral": "Pflegefachassistenz", "female": "Pflegefachassistenz", "male": "Pflegefachassistenz"},
        {"neutral": "Pflegefachkraft", "female": "Pflegefachkraft", "male": "Pflegefachkraft"},
        {"neutral": "Pflegehelfer*in", "female": "Pflegehelferin", "male": "Pflegehelfer"},
        {"neutral": "Pharmakologe / Pharmakologin", "female": "Pharmakologin", "male": "Pharmakologe"},
        {"neutral": "Pharmareferent*in", "female": "Pharmareferentin", "male": "Pharmareferent"},
        {"neutral": "Pharmatechnologie", "female": "Pharmatechnologie", "male": "Pharmatechnologie"},
        {"neutral": "Pharmazeut*in", "female": "Pharmazeutin", "male": "Pharmazeut"},
        {
            "neutral": "Pharmazeutisch-kaufmännische Assistenz",
            "female": "Pharmazeutisch-kaufmännische Assistenz",
            "male": "Pharmazeutisch-kaufmännische Assistenz",
        },
        {"neutral": "Philologe / Philologin", "female": "Philologin", "male": "Philologe"},
        {"neutral": "Philosoph*in", "female": "Philosophin", "male": "Philosoph"},
        {"neutral": "Physiker*in", "female": "Physikerin", "male": "Physiker"},
        {
            "neutral": "Physiker*in für Medizinphysik",
            "female": "Physikerin für Medizinphysik",
            "male": "Physiker für Medizinphysik",
        },
        {
            "neutral": "Physiker*in für Technische Physik",
            "female": "Physikerin für Technische Physik",
            "male": "Physiker für Technische Physik",
        },
        {"neutral": "Physiklaborant*in", "female": "Physiklaborantin", "male": "Physiklaborant"},
        {"neutral": "Physiotherapeut*in", "female": "Physiotherapeutin", "male": "Physiotherapeut"},
        {"neutral": "Pilatestrainer*in", "female": "Pilatestrainerin", "male": "Pilatestrainer"},
        {"neutral": "Pilot*in", "female": "Pilotin", "male": "Pilot"},
        {"neutral": "Plakatierer*in", "female": "Plakatiererin", "male": "Plakatierer"},
        {"neutral": "Planungskoordinator*in", "female": "Planungskoordinatorin", "male": "Planungskoordinator"},
        {
            "neutral": "Platten- und Fliesenleger*in",
            "female": "Platten- und Fliesenlegerin",
            "male": "Platten- und Fliesenleger",
        },
        {"neutral": "Platzmeister*in (Bau)", "female": "Platzmeisterin (Bau)", "male": "Platzmeister (Bau)"},
        {
            "neutral": "Platzwart*in (Campingplatz, Sportplatz)",
            "female": "Platzwartin (Campingplatz, Sportplatz)",
            "male": "Platzwart (Campingplatz, Sportplatz)",
        },
        {"neutral": "Podologe / Podologin", "female": "Podologin", "male": "Podologe"},
        {
            "neutral": "Podologische*r Fußpfleger*in",
            "female": "Podologische Fußpflegerin",
            "male": "Podologischer Fußpfleger",
        },
        {"neutral": "Polier*in", "female": "Polierin", "male": "Polier"},
        {"neutral": "Politiker*in", "female": "Politikerin", "male": "Politiker"},
        {"neutral": "Politologe / Politologin", "female": "Politologin", "male": "Politologe"},
        {
            "neutral": "Polizeilicher Fallanalytiker / Polizeiliche Fallanalytikerin",
            "female": "Polizeiliche Fallanalytikerin",
            "male": "Polizeilicher Fallanalytiker",
        },
        {"neutral": "Polizist*in", "female": "Polizistin", "male": "Polizist"},
        {"neutral": "Polsterer / Polsterin", "female": "Polsterin", "male": "Polsterer"},
        {"neutral": "Polymerchemiker*in", "female": "Polymerchemikerin", "male": "Polymerchemiker"},
        {"neutral": "Popmusiker*in", "female": "Popmusikerin", "male": "Popmusiker"},
        {"neutral": "Portfoliomanager*in", "female": "Portfoliomanagerin", "male": "Portfoliomanager"},
        {"neutral": "Portier*in", "female": "Portierin", "male": "Portier"},
        {"neutral": "Porzellanformer*in", "female": "Porzellanformerin", "male": "Porzellanformer"},
        {"neutral": "Porzellanmaler*in", "female": "Porzellanmalerin", "male": "Porzellanmaler"},
        {"neutral": "Posamentierer*in", "female": "Posamentiererin", "male": "Posamentierer"},
        {
            "neutral": "Post-Doc Universitätsassistent*in",
            "female": "Post-Doc Universitätsassistentin",
            "male": "Post-Doc Universitätsassistent",
        },
        {"neutral": "Postbediensteter / Postbedienstete", "female": "Postbedienstete", "male": "Postbediensteter"},
        {
            "neutral": "Pre-Doc Universitätsassistent*in",
            "female": "Pre-Doc Universitätsassistentin",
            "male": "Pre-Doc Universitätsassistent",
        },
        {"neutral": "Pre-Sales Manager*in", "female": "Pre-Sales Managerin", "male": "Pre-Sales Manager"},
        {"neutral": "Pre-Sales-Consultant", "female": "Pre-Sales-Consultant", "male": "Pre-Sales-Consultant"},
        {"neutral": "Pressefotograf*in", "female": "Pressefotografin", "male": "Pressefotograf"},
        {"neutral": "Pressesprecher*in", "female": "Pressesprecherin", "male": "Pressesprecher"},
        {"neutral": "Priester*in", "female": "Priesterin", "male": "Priester"},
        {"neutral": "Primarstufenlehrer*in", "female": "Primarstufenlehrerin", "male": "Primarstufenlehrer"},
        {
            "neutral": "Principal Investigator (PI)",
            "female": "Principal Investigator (PI)",
            "male": "Principal Investigator (PI)",
        },
        {"neutral": "Private Banker", "female": "Private Banker", "male": "Private Banker"},
        {"neutral": "Privatkoch / Privatköchin", "female": "Privatköchin", "male": "Privatkoch"},
        {"neutral": "Privatkundenbetreuer*in", "female": "Privatkundenbetreuerin", "male": "Privatkundenbetreuer"},
        {"neutral": "Produktdesigner*in", "female": "Produktdesignerin", "male": "Produktdesigner"},
        {"neutral": "Produktentwickler*in", "female": "Produktentwicklerin", "male": "Produktentwickler"},
        {"neutral": "Produktionsleiter*in", "female": "Produktionsleiterin", "male": "Produktionsleiter"},
        {
            "neutral": "Produktionsleiter*in (Fernsehen, Film, Radio, Theater)",
            "female": "Produktionsleiterin (Fernsehen, Film, Radio, Theater)",
            "male": "Produktionsleiter (Fernsehen, Film, Radio, Theater)",
        },
        {"neutral": "Produktionsmanager*in", "female": "Produktionsmanagerin", "male": "Produktionsmanager"},
        {"neutral": "Produktionstechniker*in", "female": "Produktionstechnikerin", "male": "Produktionstechniker"},
        {"neutral": "Produktmanager*in", "female": "Produktmanagerin", "male": "Produktmanager"},
        {"neutral": "Produzent*in", "female": "Produzentin", "male": "Produzent"},
        {"neutral": "Profiler*in", "female": "Profilerin", "male": "Profiler"},
        {"neutral": "Projektassistent*in", "female": "Projektassistentin", "male": "Projektassistent"},
        {"neutral": "Projektleiter*in", "female": "Projektleiterin", "male": "Projektleiter"},
        {"neutral": "Projektmanager*in", "female": "Projektmanagerin", "male": "Projektmanager"},
        {"neutral": "Prosekturgehilfe / Prosekturgehilfin", "female": "Prosekturgehilfin", "male": "Prosekturgehilfe"},
        {"neutral": "Prozessleittechniker*in", "female": "Prozessleittechnikerin", "male": "Prozessleittechniker"},
        {"neutral": "Prozessmanager*in", "female": "Prozessmanagerin", "male": "Prozessmanager"},
        {"neutral": "Prozessplaner*in", "female": "Prozessplanerin", "male": "Prozessplaner"},
        {"neutral": "Prozesstechnik", "female": "Prozesstechnik", "male": "Prozesstechnik"},
        {"neutral": "Prozesstechniker*in", "female": "Prozesstechnikerin", "male": "Prozesstechniker"},
        {"neutral": "Präparator*in", "female": "Präparatorin", "male": "Präparator"},
        {
            "neutral": "Präventions- und Rehabilitationstrainer*in",
            "female": "Präventions- und Rehabilitationstrainerin",
            "male": "Präventions- und Rehabilitationstrainer",
        },
        {
            "neutral": "Präzisionswerkzeugschleiftechnik",
            "female": "Präzisionswerkzeugschleiftechnik",
            "male": "Präzisionswerkzeugschleiftechnik",
        },
        {"neutral": "Prüftechnik", "female": "Prüftechnik", "male": "Prüftechnik"},
        {"neutral": "Prüftechnik - Baustoffe", "female": "Prüftechnik - Baustoffe", "male": "Prüftechnik - Baustoffe"},
        {"neutral": "Prüftechnik - Physik", "female": "Prüftechnik - Physik", "male": "Prüftechnik - Physik"},
        {"neutral": "Prüftechniker*in", "female": "Prüftechnikerin", "male": "Prüftechniker"},
        {
            "neutral": "Psychiatrische*r Gesundheits- und Krankenpfleger*in",
            "female": "Psychiatrische Gesundheits- und Krankenpflegerin",
            "male": "Psychiatrischer Gesundheits- und Krankenpfleger",
        },
        {"neutral": "Psychologe / Psychologin", "female": "Psychologin", "male": "Psychologe"},
        {"neutral": "Psychotherapeut*in", "female": "Psychotherapeutin", "male": "Psychotherapeut"},
        {"neutral": "Publizist*in", "female": "Publizistin", "male": "Publizist"},
        {"neutral": "Pyrotechniker*in", "female": "Pyrotechnikerin", "male": "Pyrotechniker"},
        {"neutral": "Pädagoge / Pädagogin", "female": "Pädagogin", "male": "Pädagoge"},
        {
            "neutral": "Pädagogischer Assistent / Pädagogische Assistentin (PA)",
            "female": "Pädagogische Assistentin (PA)",
            "male": "Pädagogischer Assistent (PA)",
        },
        {"neutral": "Qi-Gong-Lehrer*in", "female": "Qi-Gong-Lehrerin", "male": "Qi-Gong-Lehrer"},
        {"neutral": "Qualitätsmanager*in", "female": "Qualitätsmanagerin", "male": "Qualitätsmanager"},
        {
            "neutral": "Qualitätssicherungstechniker*in",
            "female": "Qualitätssicherungstechnikerin",
            "male": "Qualitätssicherungstechniker",
        },
        {
            "neutral": "Qualitätstechniker*in im Fahrzeugbau",
            "female": "Qualitätstechnikerin im Fahrzeugbau",
            "male": "Qualitätstechniker im Fahrzeugbau",
        },
        {"neutral": "Quantenphysiker*in", "female": "Quantenphysikerin", "male": "Quantenphysiker"},
        {"neutral": "Quantentechniker*in", "female": "Quantentechnikerin", "male": "Quantentechniker"},
        {"neutral": "REFA-Techniker*in", "female": "REFA-Technikerin", "male": "REFA-Techniker"},
        {"neutral": "Rabbiner*in", "female": "Rabbinerin", "male": "Rabbiner"},
        {
            "neutral": "Radio- und Fernsehredakteur*in",
            "female": "Radio- und Fernsehredakteurin",
            "male": "Radio- und Fernsehredakteur",
        },
        {
            "neutral": "Radiologietechnologe / Radiologietechnologin",
            "female": "Radiologietechnologin",
            "male": "Radiologietechnologe",
        },
        {"neutral": "Radiosprecher*in", "female": "Radiosprecherin", "male": "Radiosprecher"},
        {"neutral": "Ramp Agent", "female": "Ramp Agent", "male": "Ramp Agent"},
        {"neutral": "Rating-Analyst*in", "female": "Rating-Analystin", "male": "Rating-Analyst"},
        {"neutral": "Rauchfangkehrer*in", "female": "Rauchfangkehrerin", "male": "Rauchfangkehrer"},
        {"neutral": "Raumgestalter*in", "female": "Raumgestalterin", "male": "Raumgestalter"},
        {"neutral": "Raumpfleger*in", "female": "Raumpflegerin", "male": "Raumpfleger"},
        {"neutral": "Raumplaner*in", "female": "Raumplanerin", "male": "Raumplaner"},
        {"neutral": "Rauwarenzurichter*in", "female": "Rauwarenzurichterin", "male": "Rauwarenzurichter"},
        {"neutral": "Rechtsanwalt / Rechtsanwältin", "female": "Rechtsanwältin", "male": "Rechtsanwalt"},
        {
            "neutral": "Rechtskanzleiassistent*in",
            "female": "Rechtskanzleiassistentin",
            "male": "Rechtskanzleiassistent",
        },
        {"neutral": "Rechtswissenschafter*in", "female": "Rechtswissenschafterin", "male": "Rechtswissenschafter"},
        {"neutral": "Recording Engineer", "female": "Recording Engineer", "male": "Recording Engineer"},
        {"neutral": "Recruiter", "female": "Recruiter", "male": "Recruiter"},
        {"neutral": "Recyclingtechniker*in", "female": "Recyclingtechnikerin", "male": "Recyclingtechniker"},
        {"neutral": "Redakteur*in", "female": "Redakteurin", "male": "Redakteur"},
        {"neutral": "Redesigner*in", "female": "Redesignerin", "male": "Redesigner"},
        {"neutral": "Referent*in", "female": "Referentin", "male": "Referent"},
        {"neutral": "Regalbetreuer*in", "female": "Regalbetreuerin", "male": "Regalbetreuer"},
        {
            "neutral": "Regelungs- und Automatisierungstechniker*in",
            "female": "Regelungs- und Automatisierungstechnikerin",
            "male": "Regelungs- und Automatisierungstechniker",
        },
        {"neutral": "Regieassistent*in", "female": "Regieassistentin", "male": "Regieassistent"},
        {"neutral": "Regionalberater*in", "female": "Regionalberaterin", "male": "Regionalberater"},
        {"neutral": "Regisseur*in", "female": "Regisseurin", "male": "Regisseur"},
        {
            "neutral": "Reifen- und Vulkanisationstechnik",
            "female": "Reifen- und Vulkanisationstechnik",
            "male": "Reifen- und Vulkanisationstechnik",
        },
        {"neutral": "Reiki-Praktiker*in", "female": "Reiki-Praktikerin", "male": "Reiki-Praktiker"},
        {"neutral": "Reinigungstechnik", "female": "Reinigungstechnik", "male": "Reinigungstechnik"},
        {"neutral": "Reisebüroassistent*in", "female": "Reisebüroassistentin", "male": "Reisebüroassistent"},
        {"neutral": "Reiseleiter*in", "female": "Reiseleiterin", "male": "Reiseleiter"},
        {
            "neutral": "Reiseverkehrsfachmann / Reiseverkehrsfachfrau",
            "female": "Reiseverkehrsfachfrau",
            "male": "Reiseverkehrsfachmann",
        },
        {"neutral": "Reitlehrer*in", "female": "Reitlehrerin", "male": "Reitlehrer"},
        {
            "neutral": "Religionslehrer*in (Pflichtschulen)",
            "female": "Religionslehrerin (Pflichtschulen)",
            "male": "Religionslehrer (Pflichtschulen)",
        },
        {
            "neutral": "Religionslehrer*in (an Höherbildenden Schulen)",
            "female": "Religionslehrerin (an Höherbildenden Schulen)",
            "male": "Religionslehrer (an Höherbildenden Schulen)",
        },
        {
            "neutral": "Religionspädagoge / Religionspädagogin",
            "female": "Religionspädagogin",
            "male": "Religionspädagoge",
        },
        {
            "neutral": "Religionswissenschafter*in",
            "female": "Religionswissenschafterin",
            "male": "Religionswissenschafter",
        },
        {"neutral": "Reporter*in", "female": "Reporterin", "male": "Reporter"},
        {"neutral": "Reprografie", "female": "Reprografie", "male": "Reprografie"},
        {"neutral": "Requisiteur*in", "female": "Requisiteurin", "male": "Requisiteur"},
        {"neutral": "Resilienztrainer*in", "female": "Resilienztrainerin", "male": "Resilienztrainer"},
        {
            "neutral": "Restaurantfachmann / Restaurantfachfrau",
            "female": "Restaurantfachfrau",
            "male": "Restaurantfachmann",
        },
        {"neutral": "Restaurantmanager*in", "female": "Restaurantmanagerin", "male": "Restaurantmanager"},
        {"neutral": "Restaurator*in", "female": "Restauratorin", "male": "Restaurator"},
        {
            "neutral": "Restaurator*in (Möbel und Holz)",
            "female": "Restauratorin (Möbel und Holz)",
            "male": "Restaurator (Möbel und Holz)",
        },
        {"neutral": "Retail Manager*in", "female": "Retail Managerin", "male": "Retail Manager"},
        {"neutral": "Rettungsfahrer*in", "female": "Rettungsfahrerin", "male": "Rettungsfahrer"},
        {"neutral": "Rettungssanitäter*in", "female": "Rettungssanitäterin", "male": "Rettungssanitäter"},
        {"neutral": "Rettungstaucher*in", "female": "Rettungstaucherin", "male": "Rettungstaucher"},
        {"neutral": "Revisionsassistent*in", "female": "Revisionsassistentin", "male": "Revisionsassistent"},
        {"neutral": "Rezeptionist*in (Hotel)", "female": "Rezeptionistin (Hotel)", "male": "Rezeptionist (Hotel)"},
        {"neutral": "Rhythmiklehrer*in", "female": "Rhythmiklehrerin", "male": "Rhythmiklehrer"},
        {"neutral": "Richter*in", "female": "Richterin", "male": "Richter"},
        {"neutral": "Risk Manager*in", "female": "Risk Managerin", "male": "Risk Manager"},
        {
            "neutral": "Risk Manager*in (Credit Risk)",
            "female": "Risk Managerin (Credit Risk)",
            "male": "Risk Manager (Credit Risk)",
        },
        {
            "neutral": "Risk Manager*in (Operational Risk)",
            "female": "Risk Managerin (Operational Risk)",
            "male": "Risk Manager (Operational Risk)",
        },
        {
            "neutral": "Robotic Systems Engineer",
            "female": "Robotic Systems Engineer",
            "male": "Robotic Systems Engineer",
        },
        {"neutral": "Robotiktechniker*in", "female": "Robotiktechnikerin", "male": "Robotiktechniker"},
        {"neutral": "Rohrleitungsmonteur*in", "female": "Rohrleitungsmonteurin", "male": "Rohrleitungsmonteur"},
        {"neutral": "Romanist*in", "female": "Romanistin", "male": "Romanist"},
        {"neutral": "Rotgerber*in", "female": "Rotgerberin", "male": "Rotgerber"},
        {"neutral": "Röntgenassistent*in", "female": "Röntgenassistentin", "male": "Röntgenassistent"},
        {"neutral": "SAP-Berater*in", "female": "SAP-Beraterin", "male": "SAP-Berater"},
        {"neutral": "SEA-Manager*in", "female": "SEA-Managerin", "male": "SEA-Manager"},
        {"neutral": "SEO-Expert*in", "female": "SEO-Expertin", "male": "SEO-Expert"},
        {"neutral": "SFX Supervisor", "female": "SFX Supervisor", "male": "SFX Supervisor"},
        {"neutral": "SPS-Techniker*in", "female": "SPS-Technikerin", "male": "SPS-Techniker"},
        {"neutral": "Saatbautechniker*in", "female": "Saatbautechnikerin", "male": "Saatbautechniker"},
        {"neutral": "Saatgutanalytiker*in", "female": "Saatgutanalytikerin", "male": "Saatgutanalytiker"},
        {"neutral": "Sachbearbeiter*in", "female": "Sachbearbeiterin", "male": "Sachbearbeiter"},
        {
            "neutral": "Sachbearbeiter*in (Hoheitsverwaltung)",
            "female": "Sachbearbeiterin (Hoheitsverwaltung)",
            "male": "Sachbearbeiter (Hoheitsverwaltung)",
        },
        {
            "neutral": "Sachbearbeiter*in (Landesverwaltung)",
            "female": "Sachbearbeiterin (Landesverwaltung)",
            "male": "Sachbearbeiter (Landesverwaltung)",
        },
        {
            "neutral": "Sachbearbeiter*in (Wirtschaftsverwaltung)",
            "female": "Sachbearbeiterin (Wirtschaftsverwaltung)",
            "male": "Sachbearbeiter (Wirtschaftsverwaltung)",
        },
        {
            "neutral": "Sachbearbeiter*in (Öffentlicher Baudienst)",
            "female": "Sachbearbeiterin (Öffentlicher Baudienst)",
            "male": "Sachbearbeiter (Öffentlicher Baudienst)",
        },
        {"neutral": "Sachwalter*in", "female": "Sachwalterin", "male": "Sachwalter"},
        {"neutral": "Sales Manager*in", "female": "Sales Managerin", "male": "Sales Manager"},
        {
            "neutral": "Sanitär- und Klimatechnik - Gas- und Wasserinstallation",
            "female": "Sanitär- und Klimatechnik - Gas- und Wasserinstallation",
            "male": "Sanitär- und Klimatechnik - Gas- und Wasserinstallation",
        },
        {
            "neutral": "Sanitär- und Klimatechnik - Heizungsinstallation",
            "female": "Sanitär- und Klimatechnik - Heizungsinstallation",
            "male": "Sanitär- und Klimatechnik - Heizungsinstallation",
        },
        {
            "neutral": "Sanitär- und Klimatechnik - Lüftungsinstallation",
            "female": "Sanitär- und Klimatechnik - Lüftungsinstallation",
            "male": "Sanitär- und Klimatechnik - Lüftungsinstallation",
        },
        {
            "neutral": "Sanitär- und Klimatechnik - Ökoenergieinstallation",
            "female": "Sanitär- und Klimatechnik - Ökoenergieinstallation",
            "male": "Sanitär- und Klimatechnik - Ökoenergieinstallation",
        },
        {"neutral": "Sanitäter*in", "female": "Sanitäterin", "male": "Sanitäter"},
        {"neutral": "Sanitätsgehilfe / Sanitätsgehilfin", "female": "Sanitätsgehilfin", "male": "Sanitätsgehilfe"},
        {"neutral": "Sattler*in und Riemer*in", "female": "Sattlerin und Riemerin", "male": "Sattler und Riemer"},
        {"neutral": "Sattlerei", "female": "Sattlerei", "male": "Sattlerei"},
        {
            "neutral": "Sattlerei - Fahrzeugsattlerei",
            "female": "Sattlerei - Fahrzeugsattlerei",
            "male": "Sattlerei - Fahrzeugsattlerei",
        },
        {
            "neutral": "Sattlerei - Reitsportsattlerei",
            "female": "Sattlerei - Reitsportsattlerei",
            "male": "Sattlerei - Reitsportsattlerei",
        },
        {"neutral": "Sattlerei - Taschnerei", "female": "Sattlerei - Taschnerei", "male": "Sattlerei - Taschnerei"},
        {"neutral": "Schadensgutachter*in", "female": "Schadensgutachterin", "male": "Schadensgutachter"},
        {"neutral": "Schaler*in", "female": "Schalerin", "male": "Schaler"},
        {"neutral": "Schaltungstechniker*in", "female": "Schaltungstechnikerin", "male": "Schaltungstechniker"},
        {"neutral": "Schalungsbau", "female": "Schalungsbau", "male": "Schalungsbau"},
        {"neutral": "Schaufenstergestalter*in", "female": "Schaufenstergestalterin", "male": "Schaufenstergestalter"},
        {"neutral": "Schauspieler*in", "female": "Schauspielerin", "male": "Schauspieler"},
        {"neutral": "Schiffbauer*in", "female": "Schiffbauerin", "male": "Schiffbauer"},
        {"neutral": "Schiffsbautechniker*in", "female": "Schiffsbautechnikerin", "male": "Schiffsbautechniker"},
        {"neutral": "Schiffskapitän*in", "female": "Schiffskapitänin", "male": "Schiffskapitän"},
        {"neutral": "Schiffsmaschinist*in", "female": "Schiffsmaschinistin", "male": "Schiffsmaschinist"},
        {
            "neutral": "Schiffssteuermann / Schiffssteuerfrau",
            "female": "Schiffssteuerfrau",
            "male": "Schiffssteuermann",
        },
        {"neutral": "Schilderherstellung", "female": "Schilderherstellung", "male": "Schilderherstellung"},
        {"neutral": "Schilehrer*in", "female": "Schilehrerin", "male": "Schilehrer"},
        {"neutral": "Schirmmacher*in", "female": "Schirmmacherin", "male": "Schirmmacher"},
        {"neutral": "Schlosser*in", "female": "Schlosserin", "male": "Schlosser"},
        {"neutral": "Schmerztherapeut*in", "female": "Schmerztherapeutin", "male": "Schmerztherapeut"},
        {"neutral": "Schmied*in", "female": "Schmiedin", "male": "Schmied"},
        {"neutral": "Schmuckdesigner*in", "female": "Schmuckdesignerin", "male": "Schmuckdesigner"},
        {"neutral": "Schneider*in", "female": "Schneiderin", "male": "Schneider"},
        {"neutral": "Schornsteinfeger*in", "female": "Schornsteinfegerin", "male": "Schornsteinfeger"},
        {"neutral": "Schreiner*in", "female": "Schreinerin", "male": "Schreiner"},
        {"neutral": "Schriftdesigner*in", "female": "Schriftdesignerin", "male": "Schriftdesigner"},
        {"neutral": "Schriftsteller*in", "female": "Schriftstellerin", "male": "Schriftsteller"},
        {"neutral": "Schrotthändler*in", "female": "Schrotthändlerin", "male": "Schrotthändler"},
        {"neutral": "Schuharbeiter*in", "female": "Schuharbeiterin", "male": "Schuharbeiter"},
        {"neutral": "Schuhfertigung", "female": "Schuhfertigung", "male": "Schuhfertigung"},
        {"neutral": "Schuhmacher*in", "female": "Schuhmacherin", "male": "Schuhmacher"},
        {"neutral": "Schuldnerberater*in", "female": "Schuldnerberaterin", "male": "Schuldnerberater"},
        {"neutral": "Schulpsychologe / Schulpsychologin", "female": "Schulpsychologin", "male": "Schulpsychologe"},
        {"neutral": "Schulsozialarbeiter*in", "female": "Schulsozialarbeiterin", "male": "Schulsozialarbeiter"},
        {"neutral": "Schulwart*in", "female": "Schulwartin", "male": "Schulwart"},
        {"neutral": "Schuster*in", "female": "Schusterin", "male": "Schuster"},
        {"neutral": "Schwarzdecker*in", "female": "Schwarzdeckerin", "male": "Schwarzdecker"},
        {"neutral": "Schweißer*in", "female": "Schweißerin", "male": "Schweißer"},
        {"neutral": "Schwimmlehrer*in", "female": "Schwimmlehrerin", "male": "Schwimmlehrer"},
        {"neutral": "Schädlingsbekämpfer*in", "female": "Schädlingsbekämpferin", "male": "Schädlingsbekämpfer"},
        {"neutral": "Schätzmeister*in", "female": "Schätzmeisterin", "male": "Schätzmeister"},
        {"neutral": "Schönheitspfleger*in", "female": "Schönheitspflegerin", "male": "Schönheitspfleger"},
        {"neutral": "Screen-Designer*in", "female": "Screen-Designerin", "male": "Screen-Designer"},
        {"neutral": "Segellehrer*in", "female": "Segellehrerin", "male": "Segellehrer"},
        {"neutral": "Segelmacher*in", "female": "Segelmacherin", "male": "Segelmacher"},
        {"neutral": "Seilbahntechnik", "female": "Seilbahntechnik", "male": "Seilbahntechnik"},
        {"neutral": "Seiler*in", "female": "Seilerin", "male": "Seiler"},
        {"neutral": "Sekretär*in", "female": "Sekretärin", "male": "Sekretär"},
        {"neutral": "Senior Lecturer", "female": "Senior Lecturer", "male": "Senior Lecturer"},
        {"neutral": "Senior Scientist", "female": "Senior Scientist", "male": "Senior Scientist"},
        {"neutral": "Seniorenbetreuer*in", "female": "Seniorenbetreuerin", "male": "Seniorenbetreuer"},
        {"neutral": "Senn / Sennerin", "female": "Sennerin", "male": "Senn"},
        {"neutral": "Sensal*in", "female": "Sensalin", "male": "Sensal"},
        {"neutral": "Sensortechniker*in", "female": "Sensortechnikerin", "male": "Sensortechniker"},
        {"neutral": "Servicetechniker*in", "female": "Servicetechnikerin", "male": "Servicetechniker"},
        {"neutral": "Servierkraft", "female": "Servierkraft", "male": "Servierkraft"},
        {"neutral": "Set Designer*in", "female": "Set Designerin", "male": "Set Designer"},
        {"neutral": "Sexualpädagoge / Sexualpädagogin", "female": "Sexualpädagogin", "male": "Sexualpädagoge"},
        {"neutral": "Shaper", "female": "Shaper", "male": "Shaper"},
        {"neutral": "Shiatsu-Praktiker*in", "female": "Shiatsu-Praktikerin", "male": "Shiatsu-Praktiker"},
        {"neutral": "Shop-Betreuer*in", "female": "Shop-Betreuerin", "male": "Shop-Betreuer"},
        {"neutral": "Sicherheitsfachkraft", "female": "Sicherheitsfachkraft", "male": "Sicherheitsfachkraft"},
        {"neutral": "Siebdrucker*in", "female": "Siebdruckerin", "male": "Siebdrucker"},
        {"neutral": "Signaltechniker*in", "female": "Signaltechnikerin", "male": "Signaltechniker"},
        {"neutral": "Single-Berater*in", "female": "Single-Beraterin", "male": "Single-Berater"},
        {"neutral": "Sinologe / Sinologin", "female": "Sinologin", "male": "Sinologe"},
        {"neutral": "Skibautechnik", "female": "Skibautechnik", "male": "Skibautechnik"},
        {"neutral": "Skierzeuger*in", "female": "Skierzeugerin", "male": "Skierzeuger"},
        {"neutral": "Skript Consultant", "female": "Skript Consultant", "male": "Skript Consultant"},
        {"neutral": "Slawist*in", "female": "Slawistin", "male": "Slawist"},
        {"neutral": "Snowboardlehrer*in", "female": "Snowboardlehrerin", "male": "Snowboardlehrer"},
        {
            "neutral": "Social Media Experte / Social Media Expertin",
            "female": "Social Media Expertin",
            "male": "Social Media Experte",
        },
        {"neutral": "Sodawassererzeuger*in", "female": "Sodawassererzeugerin", "male": "Sodawassererzeuger"},
        {"neutral": "Software Developer", "female": "Software Developer", "male": "Software Developer"},
        {"neutral": "Software Engineer", "female": "Software Engineer", "male": "Software Engineer"},
        {"neutral": "Software-Consultant", "female": "Software-Consultant", "male": "Software-Consultant"},
        {"neutral": "Softwarearchitekt*in", "female": "Softwarearchitektin", "male": "Softwarearchitekt"},
        {"neutral": "Softwarebetreuer*in", "female": "Softwarebetreuerin", "male": "Softwarebetreuer"},
        {"neutral": "Softwaredesigner*in", "female": "Softwaredesignerin", "male": "Softwaredesigner"},
        {"neutral": "Softwareentwickler*in", "female": "Softwareentwicklerin", "male": "Softwareentwickler"},
        {"neutral": "Softwareingenieur*in", "female": "Softwareingenieurin", "male": "Softwareingenieur"},
        {"neutral": "Softwarelektor*in", "female": "Softwarelektorin", "male": "Softwarelektor"},
        {"neutral": "Softwareprogrammierer*in", "female": "Softwareprogrammiererin", "male": "Softwareprogrammierer"},
        {"neutral": "Softwaretechniker*in", "female": "Softwaretechnikerin", "male": "Softwaretechniker"},
        {"neutral": "Softwaretester*in", "female": "Softwaretesterin", "male": "Softwaretester"},
        {"neutral": "Solartechniker*in", "female": "Solartechnikerin", "male": "Solartechniker"},
        {"neutral": "Solosänger*in", "female": "Solosängerin", "male": "Solosänger"},
        {"neutral": "Sommelier / Sommelière", "female": "Sommelière", "male": "Sommelier"},
        {"neutral": "Sonderpädagoge / Sonderpädagogin", "female": "Sonderpädagogin", "male": "Sonderpädagoge"},
        {"neutral": "Songwriter", "female": "Songwriter", "male": "Songwriter"},
        {"neutral": "Sonnenschutztechnik", "female": "Sonnenschutztechnik", "male": "Sonnenschutztechnik"},
        {"neutral": "Sortimentsmanager*in", "female": "Sortimentsmanagerin", "male": "Sortimentsmanager"},
        {"neutral": "Souffleur / Souffleuse", "female": "Souffleuse", "male": "Souffleur"},
        {"neutral": "Sound Designer*in", "female": "Sound Designerin", "male": "Sound Designer"},
        {
            "neutral": "Sozial- und Wirtschaftsstatistiker*in",
            "female": "Sozial- und Wirtschaftsstatistikerin",
            "male": "Sozial- und Wirtschaftsstatistiker",
        },
        {"neutral": "Sozialarbeiter*in", "female": "Sozialarbeiterin", "male": "Sozialarbeiter"},
        {"neutral": "Sozialforscher*in", "female": "Sozialforscherin", "male": "Sozialforscher"},
        {"neutral": "Sozialhelfer*in", "female": "Sozialhelferin", "male": "Sozialhelfer"},
        {"neutral": "Sozialmanager*in", "female": "Sozialmanagerin", "male": "Sozialmanager"},
        {"neutral": "Sozialpädagoge / Sozialpädagogin", "female": "Sozialpädagogin", "male": "Sozialpädagoge"},
        {"neutral": "Sozialwirt*in", "female": "Sozialwirtin", "male": "Sozialwirt"},
        {"neutral": "Soziologe / Soziologin", "female": "Soziologin", "male": "Soziologe"},
        {"neutral": "Speaker", "female": "Speaker", "male": "Speaker"},
        {"neutral": "Spediteur*in", "female": "Spediteurin", "male": "Spediteur"},
        {
            "neutral": "Speditionskaufmann / Speditionskauffrau",
            "female": "Speditionskauffrau",
            "male": "Speditionskaufmann",
        },
        {"neutral": "Speditionslogistik", "female": "Speditionslogistik", "male": "Speditionslogistik"},
        {"neutral": "Speiseeiserzeuger*in", "female": "Speiseeiserzeugerin", "male": "Speiseeiserzeuger"},
        {"neutral": "Spengler*in", "female": "Spenglerin", "male": "Spengler"},
        {"neutral": "Sportadministration", "female": "Sportadministration", "male": "Sportadministration"},
        {"neutral": "Sportgerätefachkraft", "female": "Sportgerätefachkraft", "male": "Sportgerätefachkraft"},
        {
            "neutral": "Sportgerätehersteller*in und Sportgerätemonteur*in",
            "female": "Sportgeräteherstellerin und Sportgerätemonteurin",
            "male": "Sportgerätehersteller und Sportgerätemonteur",
        },
        {"neutral": "Sportgerätetechniker*in", "female": "Sportgerätetechnikerin", "male": "Sportgerätetechniker"},
        {"neutral": "Sportlehrer*in", "female": "Sportlehrerin", "male": "Sportlehrer"},
        {"neutral": "Sportmanager*in", "female": "Sportmanagerin", "male": "Sportmanager"},
        {"neutral": "Sporttechnologe / Sporttechnologin", "female": "Sporttechnologin", "male": "Sporttechnologe"},
        {"neutral": "Sporttherapeut*in", "female": "Sporttherapeutin", "male": "Sporttherapeut"},
        {"neutral": "Sportwissenschafter*in", "female": "Sportwissenschafterin", "male": "Sportwissenschafter"},
        {"neutral": "Sprachlehrer*in", "female": "Sprachlehrerin", "male": "Sprachlehrer"},
        {"neutral": "Sprachwissenschafter*in", "female": "Sprachwissenschafterin", "male": "Sprachwissenschafter"},
        {"neutral": "Sprecher*in", "female": "Sprecherin", "male": "Sprecher"},
        {"neutral": "Sprengbefugte*r", "female": "Sprengbefugte", "male": "Sprengbefugter"},
        {"neutral": "Staatsanwalt / Staatsanwältin", "female": "Staatsanwältin", "male": "Staatsanwalt"},
        {
            "neutral": "Stadt- und Regionalplaner*in",
            "female": "Stadt- und Regionalplanerin",
            "male": "Stadt- und Regionalplaner",
        },
        {"neutral": "Stahlbauschlosser*in", "female": "Stahlbauschlosserin", "male": "Stahlbauschlosser"},
        {"neutral": "Standesbeamter / Standesbeamtin", "female": "Standesbeamtin", "male": "Standesbeamter"},
        {"neutral": "Staplerfahrer*in", "female": "Staplerfahrerin", "male": "Staplerfahrer"},
        {"neutral": "Starkstrommonteur*in", "female": "Starkstrommonteurin", "male": "Starkstrommonteur"},
        {"neutral": "Starkstromtechniker*in", "female": "Starkstromtechnikerin", "male": "Starkstromtechniker"},
        {"neutral": "Statiker*in", "female": "Statikerin", "male": "Statiker"},
        {"neutral": "Stationsassistent*in", "female": "Stationsassistentin", "male": "Stationsassistent"},
        {"neutral": "Statist*in", "female": "Statistin", "male": "Statist"},
        {"neutral": "Statistiker*in", "female": "Statistikerin", "male": "Statistiker"},
        {"neutral": "Steingutdesigner*in", "female": "Steingutdesignerin", "male": "Steingutdesigner"},
        {"neutral": "Steinmetz*in", "female": "Steinmetzin", "male": "Steinmetz"},
        {"neutral": "Steinmetztechnik", "female": "Steinmetztechnik", "male": "Steinmetztechnik"},
        {"neutral": "Stellwerksmitarbeiter*in", "female": "Stellwerksmitarbeiterin", "male": "Stellwerksmitarbeiter"},
        {
            "neutral": "Stempelerzeuger*in und Flexograf*in",
            "female": "Stempelerzeugerin und Flexografin",
            "male": "Stempelerzeuger und Flexograf",
        },
        {
            "neutral": "Stenotypist*in / Phonotypist*in",
            "female": "Stenotypistin / Phonotypistin",
            "male": "Stenotypist / Phonotypist",
        },
        {
            "neutral": "Steuer- und Wirtschaftsprüfer*in",
            "female": "Steuer- und Wirtschaftsprüferin",
            "male": "Steuer- und Wirtschaftsprüfer",
        },
        {"neutral": "Steuerassistenz", "female": "Steuerassistenz", "male": "Steuerassistenz"},
        {"neutral": "Steuerberater*in", "female": "Steuerberaterin", "male": "Steuerberater"},
        {
            "neutral": "Steuerungs- und Regelungstechniker*in",
            "female": "Steuerungs- und Regelungstechnikerin",
            "male": "Steuerungs- und Regelungstechniker",
        },
        {"neutral": "Stewardess / Steward", "female": "Stewardess", "male": "Steward"},
        {"neutral": "Stickereizeichner*in", "female": "Stickereizeichnerin", "male": "Stickereizeichner"},
        {"neutral": "Stoffdrucker*in", "female": "Stoffdruckerin", "male": "Stoffdrucker"},
        {"neutral": "Straßenbahnfahrer*in", "female": "Straßenbahnfahrerin", "male": "Straßenbahnfahrer"},
        {"neutral": "Straßenbauarbeiter*in", "female": "Straßenbauarbeiterin", "male": "Straßenbauarbeiter"},
        {
            "neutral": "Straßenerhaltungsfachmann / Straßenerhaltungsfachfrau",
            "female": "Straßenerhaltungsfachfrau",
            "male": "Straßenerhaltungsfachmann",
        },
        {"neutral": "Straßenplaner*in", "female": "Straßenplanerin", "male": "Straßenplaner"},
        {"neutral": "Straßenreiniger*in", "female": "Straßenreinigerin", "male": "Straßenreiniger"},
        {"neutral": "Straßenwärter*in", "female": "Straßenwärterin", "male": "Straßenwärter"},
        {"neutral": "Streetworker*in", "female": "Streetworkerin", "male": "Streetworker"},
        {
            "neutral": "Streich- und Saiteninstrumentenbau",
            "female": "Streich- und Saiteninstrumentenbau",
            "male": "Streich- und Saiteninstrumentenbau",
        },
        {
            "neutral": "Streich- und Saiteninstrumentenbau - Bogen",
            "female": "Streich- und Saiteninstrumentenbau - Bogen",
            "male": "Streich- und Saiteninstrumentenbau - Bogen",
        },
        {
            "neutral": "Streich- und Saiteninstrumentenbau - Streichinstrumente",
            "female": "Streich- und Saiteninstrumentenbau - Streichinstrumente",
            "male": "Streich- und Saiteninstrumentenbau - Streichinstrumente",
        },
        {
            "neutral": "Streich- und Saiteninstrumentenbau - Zupfinstrumente",
            "female": "Streich- und Saiteninstrumentenbau - Zupfinstrumente",
            "male": "Streich- und Saiteninstrumentenbau - Zupfinstrumente",
        },
        {
            "neutral": "Strickmaschineneinrichter*in",
            "female": "Strickmaschineneinrichterin",
            "male": "Strickmaschineneinrichter",
        },
        {"neutral": "Strickwarenerzeuger*in", "female": "Strickwarenerzeugerin", "male": "Strickwarenerzeuger"},
        {
            "neutral": "Stuckateur*in und Trockenausbauer*in",
            "female": "Stuckateurin und Trockenausbauerin",
            "male": "Stuckateur und Trockenausbauer",
        },
        {"neutral": "Studiotechniker*in", "female": "Studiotechnikerin", "male": "Studiotechniker"},
        {"neutral": "Stuntman / Stuntwoman", "female": "Stuntwoman", "male": "Stuntman"},
        {"neutral": "Stylist*in", "female": "Stylistin", "male": "Stylist"},
        {
            "neutral": "Städteplaner*in - Smart City & E-Mobility",
            "female": "Städteplanerin - Smart City & E-Mobility",
            "male": "Städteplaner - Smart City & E-Mobility",
        },
        {"neutral": "Suchtberater*in", "female": "Suchtberaterin", "male": "Suchtberater"},
        {"neutral": "Supervisor*in", "female": "Supervisorin", "male": "Supervisor"},
        {"neutral": "Supply Chain Manager*in", "female": "Supply Chain Managerin", "male": "Supply Chain Manager"},
        {"neutral": "Surflehrer*in", "female": "Surflehrerin", "male": "Surflehrer"},
        {"neutral": "Synchronsprecher*in", "female": "Synchronsprecherin", "male": "Synchronsprecher"},
        {"neutral": "Systemadministrator*in", "female": "Systemadministratorin", "male": "Systemadministrator"},
        {"neutral": "Systemanalytiker*in", "female": "Systemanalytikerin", "male": "Systemanalytiker"},
        {
            "neutral": "Systementwickler*in für Multimedia (Hard- und Software)",
            "female": "Systementwicklerin für Multimedia (Hard- und Software)",
            "male": "Systementwickler für Multimedia (Hard- und Software)",
        },
        {
            "neutral": "Systemgastronomiefachkraft",
            "female": "Systemgastronomiefachkraft",
            "male": "Systemgastronomiefachkraft",
        },
        {"neutral": "Systemwissenschafter*in", "female": "Systemwissenschafterin", "male": "Systemwissenschafter"},
        {"neutral": "Szenenbildner*in", "female": "Szenenbildnerin", "male": "Szenenbildner"},
        {
            "neutral": "Säckler*in (Lederbekleidungserzeuger*in)",
            "female": "Säcklerin (Lederbekleidungserzeugerin)",
            "male": "Säckler (Lederbekleidungserzeuger)",
        },
        {"neutral": "Sägetechniker*in", "female": "Sägetechnikerin", "male": "Sägetechniker"},
        {"neutral": "Sänger*in", "female": "Sängerin", "male": "Sänger"},
        {
            "neutral": "Säuglingsschwester / Säuglingspfleger",
            "female": "Säuglingsschwester",
            "male": "Säuglingspfleger",
        },
        {"neutral": "Süßwarenhersteller*in", "female": "Süßwarenherstellerin", "male": "Süßwarenhersteller"},
        {"neutral": "Tabakarbeiter*in", "female": "Tabakarbeiterin", "male": "Tabakarbeiter"},
        {"neutral": "Tagesmutter / Tagesvater", "female": "Tagesmutter", "male": "Tagesvater"},
        {"neutral": "Tagungsveranstalter*in", "female": "Tagungsveranstalterin", "male": "Tagungsveranstalter"},
        {"neutral": "Tai Chi Lehrer*in", "female": "Tai Chi Lehrerin", "male": "Tai Chi Lehrer"},
        {"neutral": "Tankwagenfahrer*in", "female": "Tankwagenfahrerin", "male": "Tankwagenfahrer"},
        {"neutral": "Tankwart*in", "female": "Tankwartin", "male": "Tankwart"},
        {"neutral": "Tanzlehrer*in", "female": "Tanzlehrerin", "male": "Tanzlehrer"},
        {"neutral": "Tanzpädagoge / Tanzpädagogin", "female": "Tanzpädagogin", "male": "Tanzpädagoge"},
        {
            "neutral": "Tapezierer*in und Bettwarenerzeuger*in",
            "female": "Tapeziererin und Bettwarenerzeugerin",
            "male": "Tapezierer und Bettwarenerzeuger",
        },
        {
            "neutral": "Tapezierer*in und Dekorateur*in",
            "female": "Tapeziererin und Dekorateurin",
            "male": "Tapezierer und Dekorateur",
        },
        {"neutral": "Tatortreiniger*in", "female": "Tatortreinigerin", "male": "Tatortreiniger"},
        {"neutral": "Tauchlehrer*in", "female": "Tauchlehrerin", "male": "Tauchlehrer"},
        {"neutral": "Taxifahrer*in", "female": "Taxifahrerin", "male": "Taxifahrer"},
        {"neutral": "Teamassistent*in", "female": "Teamassistentin", "male": "Teamassistent"},
        {
            "neutral": "Technical Support Engineer",
            "female": "Technical Support Engineer",
            "male": "Technical Support Engineer",
        },
        {"neutral": "Technical Writer", "female": "Technical Writer", "male": "Technical Writer"},
        {"neutral": "Technik Consultant", "female": "Technik Consultant", "male": "Technik Consultant"},
        {"neutral": "Technische*r Manager*in", "female": "Technische Managerin", "male": "Technischer Manager"},
        {
            "neutral": "Technische*r Projektmanager*in",
            "female": "Technische Projektmanagerin",
            "male": "Technischer Projektmanager",
        },
        {
            "neutral": "Technischer Lektor / Technische Lektorin",
            "female": "Technische Lektorin",
            "male": "Technischer Lektor",
        },
        {
            "neutral": "Technischer Offizier / Technische Offizierin",
            "female": "Technische Offizierin",
            "male": "Technischer Offizier",
        },
        {
            "neutral": "Technischer Redakteur / Technische Redakteurin",
            "female": "Technische Redakteurin",
            "male": "Technischer Redakteur",
        },
        {
            "neutral": "Technischer Zeichner / Technische Zeichnerin",
            "female": "Technische Zeichnerin",
            "male": "Technischer Zeichner",
        },
        {"neutral": "Technokeramformer*in", "female": "Technokeramformerin", "male": "Technokeramformer"},
        {"neutral": "Tele-Tutor", "female": "Tele-Tutor", "male": "Tele-Tutor"},
        {"neutral": "Telefonist*in", "female": "Telefonistin", "male": "Telefonist"},
        {"neutral": "Telematiker*in", "female": "Telematikerin", "male": "Telematiker"},
        {"neutral": "Tennislehrer*in", "female": "Tennislehrerin", "male": "Tennislehrer"},
        {"neutral": "Terminal Guide", "female": "Terminal Guide", "male": "Terminal Guide"},
        {"neutral": "Terrazzomacher*in", "female": "Terrazzomacherin", "male": "Terrazzomacher"},
        {"neutral": "Textautor*in", "female": "Textautorin", "male": "Textautor"},
        {"neutral": "Textilchemie", "female": "Textilchemie", "male": "Textilchemie"},
        {"neutral": "Textildesigner*in", "female": "Textildesignerin", "male": "Textildesigner"},
        {"neutral": "Textilgestaltung", "female": "Textilgestaltung", "male": "Textilgestaltung"},
        {
            "neutral": "Textilgestaltung - Posamentiererei",
            "female": "Textilgestaltung - Posamentiererei",
            "male": "Textilgestaltung - Posamentiererei",
        },
        {
            "neutral": "Textilgestaltung - Stickerei",
            "female": "Textilgestaltung - Stickerei",
            "male": "Textilgestaltung - Stickerei",
        },
        {
            "neutral": "Textilgestaltung - Strickwaren",
            "female": "Textilgestaltung - Strickwaren",
            "male": "Textilgestaltung - Strickwaren",
        },
        {
            "neutral": "Textilgestaltung - Weberei",
            "female": "Textilgestaltung - Weberei",
            "male": "Textilgestaltung - Weberei",
        },
        {"neutral": "Textilkaufmann / Textilkauffrau", "female": "Textilkauffrau", "male": "Textilkaufmann"},
        {"neutral": "Textilmechanik", "female": "Textilmechanik", "male": "Textilmechanik"},
        {"neutral": "Textilmusterzeichner*in", "female": "Textilmusterzeichnerin", "male": "Textilmusterzeichner"},
        {"neutral": "Textilreiniger*in", "female": "Textilreinigerin", "male": "Textilreiniger"},
        {
            "neutral": "Textiltechnik - Maschentechnik",
            "female": "Textiltechnik - Maschentechnik",
            "male": "Textiltechnik - Maschentechnik",
        },
        {
            "neutral": "Textiltechnik - Webtechnik",
            "female": "Textiltechnik - Webtechnik",
            "male": "Textiltechnik - Webtechnik",
        },
        {"neutral": "Textiltechniker*in", "female": "Textiltechnikerin", "male": "Textiltechniker"},
        {"neutral": "Textiltechnologie", "female": "Textiltechnologie", "male": "Textiltechnologie"},
        {"neutral": "Textilveredler*in", "female": "Textilveredlerin", "male": "Textilveredler"},
        {"neutral": "Theaterwissenschafter*in", "female": "Theaterwissenschafterin", "male": "Theaterwissenschafter"},
        {"neutral": "Theologe / Theologin", "female": "Theologin", "male": "Theologe"},
        {"neutral": "Third Age Coach", "female": "Third Age Coach", "male": "Third Age Coach"},
        {"neutral": "Ticketing Agent", "female": "Ticketing Agent", "male": "Ticketing Agent"},
        {"neutral": "Tiefbau", "female": "Tiefbau", "male": "Tiefbau"},
        {"neutral": "Tiefbauer*in", "female": "Tiefbauerin", "male": "Tiefbauer"},
        {"neutral": "Tiefbauspezialist*in", "female": "Tiefbauspezialistin", "male": "Tiefbauspezialist"},
        {
            "neutral": "Tiefbauspezialist*in - Baumaschinenbetrieb",
            "female": "Tiefbauspezialistin - Baumaschinenbetrieb",
            "male": "Tiefbauspezialist - Baumaschinenbetrieb",
        },
        {
            "neutral": "Tiefbauspezialist*in - Siedlungswasserbau",
            "female": "Tiefbauspezialistin - Siedlungswasserbau",
            "male": "Tiefbauspezialist - Siedlungswasserbau",
        },
        {
            "neutral": "Tiefbauspezialist*in - Tunnelbautechnik",
            "female": "Tiefbauspezialistin - Tunnelbautechnik",
            "male": "Tiefbauspezialist - Tunnelbautechnik",
        },
        {
            "neutral": "Tiefbauspezialist*in - Verkehrswegebau",
            "female": "Tiefbauspezialistin - Verkehrswegebau",
            "male": "Tiefbauspezialist - Verkehrswegebau",
        },
        {"neutral": "Tiefbautechniker*in", "female": "Tiefbautechnikerin", "male": "Tiefbautechniker"},
        {
            "neutral": "Tiefdruckformenhersteller*in",
            "female": "Tiefdruckformenherstellerin",
            "male": "Tiefdruckformenhersteller",
        },
        {"neutral": "Tier-Physiotherapeut*in", "female": "Tier-Physiotherapeutin", "male": "Tier-Physiotherapeut"},
        {"neutral": "Tierarzt / Tierärztin", "female": "Tierärztin", "male": "Tierarzt"},
        {"neutral": "Tierarzthelfer*in", "female": "Tierarzthelferin", "male": "Tierarzthelfer"},
        {"neutral": "Tierhändler*in", "female": "Tierhändlerin", "male": "Tierhändler"},
        {"neutral": "Tierpfleger*in", "female": "Tierpflegerin", "male": "Tierpfleger"},
        {
            "neutral": "Tierpfleger*in (Forschung und Klinik)",
            "female": "Tierpflegerin (Forschung und Klinik)",
            "male": "Tierpfleger (Forschung und Klinik)",
        },
        {
            "neutral": "Tierpfleger*in (Tierheime)",
            "female": "Tierpflegerin (Tierheime)",
            "male": "Tierpfleger (Tierheime)",
        },
        {"neutral": "Tierpfleger*in (Zoo)", "female": "Tierpflegerin (Zoo)", "male": "Tierpfleger (Zoo)"},
        {"neutral": "Tierpsychologe / Tierpsychologin", "female": "Tierpsychologin", "male": "Tierpsychologe"},
        {
            "neutral": "Tierärztliche Ordinationsassistenz",
            "female": "Tierärztliche Ordinationsassistenz",
            "male": "Tierärztliche Ordinationsassistenz",
        },
        {"neutral": "Tischlerei", "female": "Tischlerei", "male": "Tischlerei"},
        {
            "neutral": "Tischlerei - Allgemeine Tischlerei",
            "female": "Tischlerei - Allgemeine Tischlerei",
            "male": "Tischlerei - Allgemeine Tischlerei",
        },
        {
            "neutral": "Tischlerei - Drechslerei",
            "female": "Tischlerei - Drechslerei",
            "male": "Tischlerei - Drechslerei",
        },
        {"neutral": "Tischlereitechnik", "female": "Tischlereitechnik", "male": "Tischlereitechnik"},
        {
            "neutral": "Tischlereitechnik - Modell- und Formenbau",
            "female": "Tischlereitechnik - Modell- und Formenbau",
            "male": "Tischlereitechnik - Modell- und Formenbau",
        },
        {
            "neutral": "Tischlereitechnik - Planung",
            "female": "Tischlereitechnik - Planung",
            "male": "Tischlereitechnik - Planung",
        },
        {
            "neutral": "Tischlereitechnik - Produktion",
            "female": "Tischlereitechnik - Produktion",
            "male": "Tischlereitechnik - Produktion",
        },
        {"neutral": "Tissue Engineer", "female": "Tissue Engineer", "male": "Tissue Engineer"},
        {"neutral": "Toningenieur*in", "female": "Toningenieurin", "male": "Toningenieur"},
        {"neutral": "Tonmeister*in", "female": "Tonmeisterin", "male": "Tonmeister"},
        {"neutral": "Tontechniker*in", "female": "Tontechnikerin", "male": "Tontechniker"},
        {
            "neutral": "Tontechniker*in (Aufnahmeleitung)",
            "female": "Tontechnikerin (Aufnahmeleitung)",
            "male": "Tontechniker (Aufnahmeleitung)",
        },
        {"neutral": "Tontechniker*in (Film)", "female": "Tontechnikerin (Film)", "male": "Tontechniker (Film)"},
        {
            "neutral": "Tontechniker*in (Live-Tontechnik)",
            "female": "Tontechnikerin (Live-Tontechnik)",
            "male": "Tontechniker (Live-Tontechnik)",
        },
        {
            "neutral": "Tontechniker*in (Rundfunk)",
            "female": "Tontechnikerin (Rundfunk)",
            "male": "Tontechniker (Rundfunk)",
        },
        {
            "neutral": "Tontechniker*in (Theater)",
            "female": "Tontechnikerin (Theater)",
            "male": "Tontechniker (Theater)",
        },
        {"neutral": "Tourismusassistent*in", "female": "Tourismusassistentin", "male": "Tourismusassistent"},
        {"neutral": "Tourismusberater*in", "female": "Tourismusberaterin", "male": "Tourismusberater"},
        {
            "neutral": "Tourismuskaufmann / Tourismuskauffrau",
            "female": "Tourismuskauffrau",
            "male": "Tourismuskaufmann",
        },
        {"neutral": "Tourismusmanager*in", "female": "Tourismusmanagerin", "male": "Tourismusmanager"},
        {"neutral": "Toxikologe / Toxikologin", "female": "Toxikologin", "male": "Toxikologe"},
        {"neutral": "Traffic-Clerk", "female": "Traffic-Clerk", "male": "Traffic-Clerk"},
        {"neutral": "Trafikant*in", "female": "Trafikantin", "male": "Trafikant"},
        {"neutral": "Trainer*in", "female": "Trainerin", "male": "Trainer"},
        {"neutral": "Trainer*in (Sport)", "female": "Trainerin (Sport)", "male": "Trainer (Sport)"},
        {"neutral": "Transportarbeiter*in", "female": "Transportarbeiterin", "male": "Transportarbeiter"},
        {"neutral": "Transportbetontechnik", "female": "Transportbetontechnik", "male": "Transportbetontechnik"},
        {
            "neutral": "Trauerredner*in und Ritualbegleiter*in",
            "female": "Trauerrednerin und Ritualbegleiterin",
            "male": "Trauerredner und Ritualbegleiter",
        },
        {"neutral": "Treasury Manager*in", "female": "Treasury Managerin", "male": "Treasury Manager"},
        {"neutral": "Trendscout", "female": "Trendscout", "male": "Trendscout"},
        {"neutral": "Treuhandassistent*in", "female": "Treuhandassistentin", "male": "Treuhandassistent"},
        {
            "neutral": "Trickfilmzeichner*in / Comic Zeichner*in",
            "female": "Trickfilmzeichnerin / Comic Zeichnerin",
            "male": "Trickfilmzeichner / Comic Zeichner",
        },
        {"neutral": "Triebfahrzeugführer*in", "female": "Triebfahrzeugführerin", "male": "Triebfahrzeugführer"},
        {"neutral": "Triebwagenführer*in", "female": "Triebwagenführerin", "male": "Triebwagenführer"},
        {
            "neutral": "Tuning & Monitoring Engineer",
            "female": "Tuning & Monitoring Engineer",
            "male": "Tuning & Monitoring Engineer",
        },
        {"neutral": "Tunnelbautechniker*in", "female": "Tunnelbautechnikerin", "male": "Tunnelbautechniker"},
        {"neutral": "Turkologe / Turkologin", "female": "Turkologin", "male": "Turkologe"},
        {"neutral": "Tänzer*in", "female": "Tänzerin", "male": "Tänzer"},
        {
            "neutral": "Tätowierer*in und Piercer*in",
            "female": "Tätowiererin und Piercerin",
            "male": "Tätowierer und Piercer",
        },
        {"neutral": "U-Bahn-Fahrer*in", "female": "U-Bahn-Fahrerin", "male": "U-Bahn-Fahrer"},
        {
            "neutral": "Uhrmacher*in - Zeitmesstechniker*in",
            "female": "Uhrmacherin - Zeitmesstechnikerin",
            "male": "Uhrmacher - Zeitmesstechniker",
        },
        {
            "neutral": "Umwelt- und Nachhaltigkeitsmanager*in",
            "female": "Umwelt- und Nachhaltigkeitsmanagerin",
            "male": "Umwelt- und Nachhaltigkeitsmanager",
        },
        {"neutral": "Umweltanalytiker*in", "female": "Umweltanalytikerin", "male": "Umweltanalytiker"},
        {"neutral": "Umweltbautechniker*in", "female": "Umweltbautechnikerin", "male": "Umweltbautechniker"},
        {
            "neutral": "Umweltbeauftragter / Umweltbeauftragte",
            "female": "Umweltbeauftragte",
            "male": "Umweltbeauftragter",
        },
        {"neutral": "Umweltberater*in", "female": "Umweltberaterin", "male": "Umweltberater"},
        {"neutral": "Umweltgutachter*in", "female": "Umweltgutachterin", "male": "Umweltgutachter"},
        {"neutral": "Umweltingenieur*in", "female": "Umweltingenieurin", "male": "Umweltingenieur"},
        {"neutral": "Umweltmesstechniker*in", "female": "Umweltmesstechnikerin", "male": "Umweltmesstechniker"},
        {
            "neutral": "Umweltsystemwissenschafter*in",
            "female": "Umweltsystemwissenschafterin",
            "male": "Umweltsystemwissenschafter",
        },
        {"neutral": "Umwelttechniker*in", "female": "Umwelttechnikerin", "male": "Umwelttechniker"},
        {
            "neutral": "Umweltverfahrenstechniker*in",
            "female": "Umweltverfahrenstechnikerin",
            "male": "Umweltverfahrenstechniker",
        },
        {"neutral": "Universalhärter*in", "female": "Universalhärterin", "male": "Universalhärter"},
        {"neutral": "Universalschweißer*in", "female": "Universalschweißerin", "male": "Universalschweißer"},
        {"neutral": "Universitätsassistent*in", "female": "Universitätsassistentin", "male": "Universitätsassistent"},
        {"neutral": "Universitätsdozent*in", "female": "Universitätsdozentin", "male": "Universitätsdozent"},
        {"neutral": "Universitätslektor*in", "female": "Universitätslektorin", "male": "Universitätslektor"},
        {"neutral": "Universitätsprofessor*in", "female": "Universitätsprofessorin", "male": "Universitätsprofessor"},
        {"neutral": "Unternehmensberater*in", "female": "Unternehmensberaterin", "male": "Unternehmensberater"},
        {"neutral": "Unternehmer*in", "female": "Unternehmerin", "male": "Unternehmer"},
        {"neutral": "Unteroffizier*in", "female": "Unteroffizierin", "male": "Unteroffizier"},
        {"neutral": "Usability Engineer", "female": "Usability Engineer", "male": "Usability Engineer"},
        {
            "neutral": "User Experience Designer*in (UX-Designer*in)",
            "female": "User Experience Designerin (UX-Designerin)",
            "male": "User Experience Designer (UX-Designer)",
        },
        {
            "neutral": "User Interface Designer*in (UI-Designer*in)",
            "female": "User Interface Designerin (UI-Designerin)",
            "male": "User Interface Designer (UI-Designer)",
        },
        {"neutral": "VFX Supervisor", "female": "VFX Supervisor", "male": "VFX Supervisor"},
        {"neutral": "Veranstaltungstechnik", "female": "Veranstaltungstechnik", "male": "Veranstaltungstechnik"},
        {"neutral": "Verbandstoffarbeiter*in", "female": "Verbandstoffarbeiterin", "male": "Verbandstoffarbeiter"},
        {"neutral": "Verbundstofftechniker*in", "female": "Verbundstofftechnikerin", "male": "Verbundstofftechniker"},
        {
            "neutral": "Verfahrenstechnik für die Getreidewirtschaft",
            "female": "Verfahrenstechnik für die Getreidewirtschaft",
            "male": "Verfahrenstechnik für die Getreidewirtschaft",
        },
        {
            "neutral": "Verfahrenstechnik für die Getreidewirtschaft - Backmittelherstellung",
            "female": "Verfahrenstechnik für die Getreidewirtschaft - Backmittelherstellung",
            "male": "Verfahrenstechnik für die Getreidewirtschaft - Backmittelherstellung",
        },
        {
            "neutral": "Verfahrenstechnik für die Getreidewirtschaft - Futtermittelherstellung",
            "female": "Verfahrenstechnik für die Getreidewirtschaft - Futtermittelherstellung",
            "male": "Verfahrenstechnik für die Getreidewirtschaft - Futtermittelherstellung",
        },
        {
            "neutral": "Verfahrenstechnik für die Getreidewirtschaft - Getreidemüller*in",
            "female": "Verfahrenstechnik für die Getreidewirtschaft - Getreidemüllerin",
            "male": "Verfahrenstechnik für die Getreidewirtschaft - Getreidemüller",
        },
        {"neutral": "Verfahrenstechniker*in", "female": "Verfahrenstechnikerin", "male": "Verfahrenstechniker"},
        {
            "neutral": "Vergolden und Staffieren",
            "female": "Vergolden und Staffieren",
            "male": "Vergolden und Staffieren",
        },
        {"neutral": "Vergolder*in", "female": "Vergolderin", "male": "Vergolder"},
        {"neutral": "Verhaltensforscher*in", "female": "Verhaltensforscherin", "male": "Verhaltensforscher"},
        {
            "neutral": "Verkaufstechniker*in / Vertriebstechniker*in",
            "female": "Verkaufstechnikerin / Vertriebstechnikerin",
            "male": "Verkaufstechniker / Vertriebstechniker",
        },
        {"neutral": "Verkehrsplaner*in", "female": "Verkehrsplanerin", "male": "Verkehrsplaner"},
        {
            "neutral": "Verkehrspsychologe / Verkehrspsychologin",
            "female": "Verkehrspsychologin",
            "male": "Verkehrspsychologe",
        },
        {"neutral": "Verkehrstechniker*in", "female": "Verkehrstechnikerin", "male": "Verkehrstechniker"},
        {"neutral": "Verkehrstelematiker*in", "female": "Verkehrstelematikerin", "male": "Verkehrstelematiker"},
        {"neutral": "Verkehrswirtschafter*in", "female": "Verkehrswirtschafterin", "male": "Verkehrswirtschafter"},
        {"neutral": "Verkehrsökonom*in", "female": "Verkehrsökonomin", "male": "Verkehrsökonom"},
        {"neutral": "Verkäufer*in", "female": "Verkäuferin", "male": "Verkäufer"},
        {"neutral": "Verlagslektor*in", "female": "Verlagslektorin", "male": "Verlagslektor"},
        {"neutral": "Verleger*in", "female": "Verlegerin", "male": "Verleger"},
        {
            "neutral": "Vermessungs- und Geoinformationstechnik",
            "female": "Vermessungs- und Geoinformationstechnik",
            "male": "Vermessungs- und Geoinformationstechnik",
        },
        {
            "neutral": "Vermessungs- und Geoinformationstechnik - Geoinformationstechnik",
            "female": "Vermessungs- und Geoinformationstechnik - Geoinformationstechnik",
            "male": "Vermessungs- und Geoinformationstechnik - Geoinformationstechnik",
        },
        {
            "neutral": "Vermessungs- und Geoinformationstechnik - Vermessungstechnik",
            "female": "Vermessungs- und Geoinformationstechnik - Vermessungstechnik",
            "male": "Vermessungs- und Geoinformationstechnik - Vermessungstechnik",
        },
        {
            "neutral": "Vermessungsgehilfe / Vermessungsgehilfin",
            "female": "Vermessungsgehilfin",
            "male": "Vermessungsgehilfe",
        },
        {"neutral": "Vermessungstechnik", "female": "Vermessungstechnik", "male": "Vermessungstechnik"},
        {"neutral": "Vermessungstechniker*in", "female": "Vermessungstechnikerin", "male": "Vermessungstechniker"},
        {"neutral": "Vermögensberater*in", "female": "Vermögensberaterin", "male": "Vermögensberater"},
        {"neutral": "Verpackungstechnik", "female": "Verpackungstechnik", "male": "Verpackungstechnik"},
        {"neutral": "Verschieber*in", "female": "Verschieberin", "male": "Verschieber"},
        {
            "neutral": "Verschlüsselungstechniker*in (Kryptograf*in)",
            "female": "Verschlüsselungstechnikerin (Kryptografin)",
            "male": "Verschlüsselungstechniker (Kryptograf)",
        },
        {"neutral": "Versicherungsagent*in", "female": "Versicherungsagentin", "male": "Versicherungsagent"},
        {"neutral": "Versicherungsberater*in", "female": "Versicherungsberaterin", "male": "Versicherungsberater"},
        {
            "neutral": "Versicherungsfachmann / Versicherungsfachfrau",
            "female": "Versicherungsfachfrau",
            "male": "Versicherungsfachmann",
        },
        {
            "neutral": "Versicherungskaufmann / Versicherungskauffrau",
            "female": "Versicherungskauffrau",
            "male": "Versicherungskaufmann",
        },
        {"neutral": "Versicherungsmakler*in", "female": "Versicherungsmaklerin", "male": "Versicherungsmakler"},
        {
            "neutral": "Versicherungsmathematiker*in",
            "female": "Versicherungsmathematikerin",
            "male": "Versicherungsmathematiker",
        },
        {
            "neutral": "Versicherungsstatistiker*in",
            "female": "Versicherungsstatistikerin",
            "male": "Versicherungsstatistiker",
        },
        {
            "neutral": "Versicherungsvermittler*in",
            "female": "Versicherungsvermittlerin",
            "male": "Versicherungsvermittler",
        },
        {
            "neutral": "Versicherungsvertreter*in",
            "female": "Versicherungsvertreterin",
            "male": "Versicherungsvertreter",
        },
        {"neutral": "Versorgungstechniker*in", "female": "Versorgungstechnikerin", "male": "Versorgungstechniker"},
        {"neutral": "Vertriebsingenieur*in", "female": "Vertriebsingenieurin", "male": "Vertriebsingenieur"},
        {"neutral": "Vertriebstechniker*in", "female": "Vertriebstechnikerin", "male": "Vertriebstechniker"},
        {"neutral": "Vertriebswirt*in", "female": "Vertriebswirtin", "male": "Vertriebswirt"},
        {
            "neutral": "Vertriebswirt*in (Vertriebsaußendienst)",
            "female": "Vertriebswirtin (Vertriebsaußendienst)",
            "male": "Vertriebswirt (Vertriebsaußendienst)",
        },
        {
            "neutral": "Vertriebswirt*in (Vertriebsinnendienst)",
            "female": "Vertriebswirtin (Vertriebsinnendienst)",
            "male": "Vertriebswirt (Vertriebsinnendienst)",
        },
        {"neutral": "Verwaltungsassistent*in", "female": "Verwaltungsassistentin", "male": "Verwaltungsassistent"},
        {
            "neutral": "Verwaltungsfachbeamter / Verwaltungsfachbeamtin",
            "female": "Verwaltungsfachbeamtin",
            "male": "Verwaltungsfachbeamter",
        },
        {"neutral": "Verwaltungsjurist*in", "female": "Verwaltungsjuristin", "male": "Verwaltungsjurist"},
        {"neutral": "Veterinärmediziner*in", "female": "Veterinärmedizinerin", "male": "Veterinärmediziner"},
        {"neutral": "Videojournalist*in", "female": "Videojournalistin", "male": "Videojournalist"},
        {"neutral": "Viehhändler*in", "female": "Viehhändlerin", "male": "Viehhändler"},
        {"neutral": "Virtual Assistant", "female": "Virtual Assistant", "male": "Virtual Assistant"},
        {"neutral": "Visagist*in", "female": "Visagistin", "male": "Visagist"},
        {"neutral": "Visual Effects Artist", "female": "Visual Effects Artist", "male": "Visual Effects Artist"},
        {"neutral": "Vitaltrainer*in", "female": "Vitaltrainerin", "male": "Vitaltrainer"},
        {"neutral": "Volkskundler*in", "female": "Volkskundlerin", "male": "Volkskundler"},
        {"neutral": "Volksschullehrer*in", "female": "Volksschullehrerin", "male": "Volksschullehrer"},
        {"neutral": "Volkswirt*in", "female": "Volkswirtin", "male": "Volkswirt"},
        {"neutral": "Vollzeit-Betreuer*in", "female": "Vollzeit-Betreuerin", "male": "Vollzeit-Betreuer"},
        {"neutral": "Vorarbeiter*in", "female": "Vorarbeiterin", "male": "Vorarbeiter"},
        {"neutral": "Vulkanisierung", "female": "Vulkanisierung", "male": "Vulkanisierung"},
        {"neutral": "Völkerkundler*in", "female": "Völkerkundlerin", "male": "Völkerkundler"},
        {"neutral": "Waagenhersteller*in", "female": "Waagenherstellerin", "male": "Waagenhersteller"},
        {"neutral": "Waffelbäcker*in", "female": "Waffelbäckerin", "male": "Waffelbäcker"},
        {
            "neutral": "Waffen- und Munitionshändler*in",
            "female": "Waffen- und Munitionshändlerin",
            "male": "Waffen- und Munitionshändler",
        },
        {"neutral": "Waffenbautechniker*in", "female": "Waffenbautechnikerin", "male": "Waffenbautechniker"},
        {"neutral": "Waffenmechaniker*in", "female": "Waffenmechanikerin", "male": "Waffenmechaniker"},
        {"neutral": "Wagner*in", "female": "Wagnerin", "male": "Wagner"},
        {"neutral": "Waldpädagoge / Waldpädagogin", "female": "Waldpädagogin", "male": "Waldpädagoge"},
        {"neutral": "Wasserbautechniker*in", "female": "Wasserbautechnikerin", "male": "Wasserbautechniker"},
        {
            "neutral": "Wasserleitungsinstallateur*in",
            "female": "Wasserleitungsinstallateurin",
            "male": "Wasserleitungsinstallateur",
        },
        {"neutral": "Wasserschilehrer*in", "female": "Wasserschilehrerin", "male": "Wasserschilehrer"},
        {"neutral": "Web Content Manager*in", "female": "Web Content Managerin", "male": "Web Content Manager"},
        {"neutral": "Web Developer", "female": "Web Developer", "male": "Web Developer"},
        {"neutral": "Webdesigner*in", "female": "Webdesignerin", "male": "Webdesigner"},
        {"neutral": "Weber*in", "female": "Weberin", "male": "Weber"},
        {"neutral": "Webmaster", "female": "Webmaster", "male": "Webmaster"},
        {"neutral": "Webshopbetreuer*in", "female": "Webshopbetreuerin", "male": "Webshopbetreuer"},
        {"neutral": "Webshopmanager*in", "female": "Webshopmanagerin", "male": "Webshopmanager"},
        {"neutral": "Webshopverkäufer*in", "female": "Webshopverkäuferin", "male": "Webshopverkäufer"},
        {"neutral": "Websitegestalter*in", "female": "Websitegestalterin", "male": "Websitegestalter"},
        {"neutral": "Websiteprogrammierer*in", "female": "Websiteprogrammiererin", "male": "Websiteprogrammierer"},
        {
            "neutral": "Weinbau und Kellerwirtschaft",
            "female": "Weinbau und Kellerwirtschaft",
            "male": "Weinbau und Kellerwirtschaft",
        },
        {"neutral": "Weinbauer / Weinbäuerin", "female": "Weinbäuerin", "male": "Weinbauer"},
        {"neutral": "Weinbautechniker*in", "female": "Weinbautechnikerin", "male": "Weinbautechniker"},
        {"neutral": "Weingartenarbeiter*in", "female": "Weingartenarbeiterin", "male": "Weingartenarbeiter"},
        {"neutral": "Weinhändler*in", "female": "Weinhändlerin", "male": "Weinhändler"},
        {
            "neutral": "Weiß- und Sämischgerber*in",
            "female": "Weiß- und Sämischgerberin",
            "male": "Weiß- und Sämischgerber",
        },
        {"neutral": "Wellnesstrainer*in", "female": "Wellnesstrainerin", "male": "Wellnesstrainer"},
        {
            "neutral": "Werbe- und Medienvorlagenhersteller*in",
            "female": "Werbe- und Medienvorlagenherstellerin",
            "male": "Werbe- und Medienvorlagenhersteller",
        },
        {"neutral": "Werbeberater*in", "female": "Werbeberaterin", "male": "Werbeberater"},
        {"neutral": "Werbefachmann / Werbefachfrau", "female": "Werbefachfrau", "male": "Werbefachmann"},
        {"neutral": "Werbefotograf*in", "female": "Werbefotografin", "male": "Werbefotograf"},
        {"neutral": "Werbegestalter*in", "female": "Werbegestalterin", "male": "Werbegestalter"},
        {"neutral": "Werbegrafikdesigner*in", "female": "Werbegrafikdesignerin", "male": "Werbegrafikdesigner"},
        {"neutral": "Werbemittler*in", "female": "Werbemittlerin", "male": "Werbemittler"},
        {"neutral": "Werbetexter*in", "female": "Werbetexterin", "male": "Werbetexter"},
        {"neutral": "Werkmeister*in", "female": "Werkmeisterin", "male": "Werkmeister"},
        {"neutral": "Werkstoffingenieur*in", "female": "Werkstoffingenieurin", "male": "Werkstoffingenieur"},
        {"neutral": "Werkstofftechnik", "female": "Werkstofftechnik", "male": "Werkstofftechnik"},
        {
            "neutral": "Werkstofftechnik - Werkstoffprüfung",
            "female": "Werkstofftechnik - Werkstoffprüfung",
            "male": "Werkstofftechnik - Werkstoffprüfung",
        },
        {"neutral": "Werkstofftechniker*in", "female": "Werkstofftechnikerin", "male": "Werkstofftechniker"},
        {
            "neutral": "Werkstofftechniker*in - Schwerpunkt Verbundstoffe",
            "female": "Werkstofftechnikerin - Schwerpunkt Verbundstoffe",
            "male": "Werkstofftechniker - Schwerpunkt Verbundstoffe",
        },
        {"neutral": "Werkstättenleiter*in", "female": "Werkstättenleiterin", "male": "Werkstättenleiter"},
        {"neutral": "Werkzeugbautechnik", "female": "Werkzeugbautechnik", "male": "Werkzeugbautechnik"},
        {"neutral": "Werkzeugkonstrukteur*in", "female": "Werkzeugkonstrukteurin", "male": "Werkzeugkonstrukteur"},
        {"neutral": "Werkzeugmacher*in", "female": "Werkzeugmacherin", "male": "Werkzeugmacher"},
        {"neutral": "Werkzeugmaschineur*in", "female": "Werkzeugmaschineurin", "male": "Werkzeugmaschineur"},
        {"neutral": "Werkzeugmechanik", "female": "Werkzeugmechanik", "male": "Werkzeugmechanik"},
        {"neutral": "Wertpapieranalyst*in", "female": "Wertpapieranalystin", "male": "Wertpapieranalyst"},
        {"neutral": "Wertpapierberater*in", "female": "Wertpapierberaterin", "male": "Wertpapierberater"},
        {"neutral": "Wertpapierhändler*in", "female": "Wertpapierhändlerin", "male": "Wertpapierhändler"},
        {"neutral": "Wettannehmer*in", "female": "Wettannehmerin", "male": "Wettannehmer"},
        {"neutral": "Winzer*in", "female": "Winzerin", "male": "Winzer"},
        {"neutral": "Wirbelsäulentrainer*in", "female": "Wirbelsäulentrainerin", "male": "Wirbelsäulentrainer"},
        {"neutral": "Wirkwarenerzeuger*in", "female": "Wirkwarenerzeugerin", "male": "Wirkwarenerzeuger"},
        {
            "neutral": "Wirtschafter*in (Gastgewerbe)",
            "female": "Wirtschafterin (Gastgewerbe)",
            "male": "Wirtschafter (Gastgewerbe)",
        },
        {
            "neutral": "Wirtschafts- und Agrarfachkraft",
            "female": "Wirtschafts- und Agrarfachkraft",
            "male": "Wirtschafts- und Agrarfachkraft",
        },
        {"neutral": "Wirtschaftsberater*in", "female": "Wirtschaftsberaterin", "male": "Wirtschaftsberater"},
        {"neutral": "Wirtschaftscoach", "female": "Wirtschaftscoach", "male": "Wirtschaftscoach"},
        {"neutral": "Wirtschaftsforscher*in", "female": "Wirtschaftsforscherin", "male": "Wirtschaftsforscher"},
        {"neutral": "Wirtschaftsgeograf*in", "female": "Wirtschaftsgeografin", "male": "Wirtschaftsgeograf"},
        {
            "neutral": "Wirtschaftsinformatiker*in",
            "female": "Wirtschaftsinformatikerin",
            "male": "Wirtschaftsinformatiker",
        },
        {"neutral": "Wirtschaftsingenieur*in", "female": "Wirtschaftsingenieurin", "male": "Wirtschaftsingenieur"},
        {
            "neutral": "Wirtschaftsmathematiker*in (Operations Research)",
            "female": "Wirtschaftsmathematikerin (Operations Research)",
            "male": "Wirtschaftsmathematiker (Operations Research)",
        },
        {"neutral": "Wirtschaftsprüfer*in", "female": "Wirtschaftsprüferin", "male": "Wirtschaftsprüfer"},
        {
            "neutral": "Wirtschaftspädagoge / Wirtschaftspädagogin",
            "female": "Wirtschaftspädagogin",
            "male": "Wirtschaftspädagoge",
        },
        {
            "neutral": "Wirtschaftsstatistiker*in",
            "female": "Wirtschaftsstatistikerin",
            "male": "Wirtschaftsstatistiker",
        },
        {"neutral": "Wirtschaftstechniker*in", "female": "Wirtschaftstechnikerin", "male": "Wirtschaftstechniker"},
        {"neutral": "Wirtschaftstreuhänder*in", "female": "Wirtschaftstreuhänderin", "male": "Wirtschaftstreuhänder"},
        {
            "neutral": "Wissenschaftshistoriker*in",
            "female": "Wissenschaftshistorikerin",
            "male": "Wissenschaftshistoriker",
        },
        {
            "neutral": "Wissenschaftsjournalist*in",
            "female": "Wissenschaftsjournalistin",
            "male": "Wissenschaftsjournalist",
        },
        {
            "neutral": "Wissenschaftstheoretiker*in",
            "female": "Wissenschaftstheoretikerin",
            "male": "Wissenschaftstheoretiker",
        },
        {"neutral": "Wissensmanager*in", "female": "Wissensmanagerin", "male": "Wissensmanager"},
        {
            "neutral": "Wärme-, Kälte-, Schall- und Brandschutztechnik",
            "female": "Wärme-, Kälte-, Schall- und Brandschutztechnik",
            "male": "Wärme-, Kälte-, Schall- und Brandschutztechnik",
        },
        {"neutral": "Wärmebehandlungstechnik", "female": "Wärmebehandlungstechnik", "male": "Wärmebehandlungstechnik"},
        {"neutral": "Wäschenäher*in", "female": "Wäschenäherin", "male": "Wäschenäher"},
        {
            "neutral": "Wäscher*in und Wäschebügler*in",
            "female": "Wäscherin und Wäschebüglerin",
            "male": "Wäscher und Wäschebügler",
        },
        {"neutral": "Wäschewarenerzeuger*in", "female": "Wäschewarenerzeugerin", "male": "Wäschewarenerzeuger"},
        {"neutral": "Yoga Lehrer*in", "female": "Yoga Lehrerin", "male": "Yoga Lehrer"},
        {"neutral": "Youtuber", "female": "Youtuber", "male": "Youtuber"},
        {"neutral": "Zahnarzt / Zahnärztin", "female": "Zahnärztin", "male": "Zahnarzt"},
        {"neutral": "Zahnarzthelfer*in", "female": "Zahnarzthelferin", "male": "Zahnarzthelfer"},
        {"neutral": "Zahntechnik", "female": "Zahntechnik", "male": "Zahntechnik"},
        {
            "neutral": "Zahntechnische Fachassistenz",
            "female": "Zahntechnische Fachassistenz",
            "male": "Zahntechnische Fachassistenz",
        },
        {
            "neutral": "Zahntechnischer Laborant / Zahntechnische Laborantin",
            "female": "Zahntechnische Laborantin",
            "male": "Zahntechnischer Laborant",
        },
        {
            "neutral": "Zahnärztliche Fachassistenz",
            "female": "Zahnärztliche Fachassistenz",
            "male": "Zahnärztliche Fachassistenz",
        },
        {
            "neutral": "Zahnärztlicher Assistent / Zahnärztliche Assistentin",
            "female": "Zahnärztliche Assistentin",
            "male": "Zahnärztlicher Assistent",
        },
        {"neutral": "Zauberkünstler*in", "female": "Zauberkünstlerin", "male": "Zauberkünstler"},
        {"neutral": "Zeitungszusteller*in", "female": "Zeitungszustellerin", "male": "Zeitungszusteller"},
        {"neutral": "Zellstoffhersteller*in", "female": "Zellstoffherstellerin", "male": "Zellstoffhersteller"},
        {"neutral": "Zellstofftechniker*in", "female": "Zellstofftechnikerin", "male": "Zellstofftechniker"},
        {"neutral": "Zentralheizungsbauer*in", "female": "Zentralheizungsbauerin", "male": "Zentralheizungsbauer"},
        {"neutral": "Zerspanungstechnik", "female": "Zerspanungstechnik", "male": "Zerspanungstechnik"},
        {"neutral": "Zimmerei", "female": "Zimmerei", "male": "Zimmerei"},
        {"neutral": "Zimmereitechnik", "female": "Zimmereitechnik", "male": "Zimmereitechnik"},
        {"neutral": "Zimmerer*in", "female": "Zimmererin", "male": "Zimmerer"},
        {"neutral": "Zimmermädchen / Roomboy", "female": "Zimmermädchen", "male": "Roomboy"},
        {"neutral": "Zinngießer*in", "female": "Zinngießerin", "male": "Zinngießer"},
        {"neutral": "Ziviltechniker*in", "female": "Ziviltechnikerin", "male": "Ziviltechniker"},
        {"neutral": "Zollbeamter / Zollbeamtin", "female": "Zollbeamtin", "male": "Zollbeamter"},
        {"neutral": "Zolldeklarant*in", "female": "Zolldeklarantin", "male": "Zolldeklarant"},
        {"neutral": "Zollfahnder*in", "female": "Zollfahnderin", "male": "Zollfahnder"},
        {"neutral": "Zoofachhändler*in", "female": "Zoofachhändlerin", "male": "Zoofachhändler"},
        {"neutral": "Zoologe / Zoologin", "female": "Zoologin", "male": "Zoologe"},
        {"neutral": "Zugbegleiter*in", "female": "Zugbegleiterin", "male": "Zugbegleiter"},
        {"neutral": "Zugrevisor*in", "female": "Zugrevisorin", "male": "Zugrevisor"},
        {"neutral": "Zweiradtechniker*in", "female": "Zweiradtechnikerin", "male": "Zweiradtechniker"},
        {"neutral": "Übersetzer*in", "female": "Übersetzerin", "male": "Übersetzer"},
        {"neutral": "Übungsschullehrer*in", "female": "Übungsschullehrerin", "male": "Übungsschullehrer"},
        {"neutral": "Öko-Auditor*in", "female": "Öko-Auditorin", "male": "Öko-Auditor"},
        {"neutral": "Öko-Consultant", "female": "Öko-Consultant", "male": "Öko-Consultant"},
        {"neutral": "Öko-Designer*in", "female": "Öko-Designerin", "male": "Öko-Designer"},
        {"neutral": "Ökobaumeister*in", "female": "Ökobaumeisterin", "male": "Ökobaumeister"},
        {
            "neutral": "Ökoenergieinstallationstechniker*in",
            "female": "Ökoenergieinstallationstechnikerin",
            "male": "Ökoenergieinstallationstechniker",
        },
        {"neutral": "Ökologe / Ökologin", "female": "Ökologin", "male": "Ökologe"},
        {"neutral": "Ökologieberater*in", "female": "Ökologieberaterin", "male": "Ökologieberater"},
        {
            "neutral": "Ökosystemwissenschafter*in",
            "female": "Ökosystemwissenschafterin",
            "male": "Ökosystemwissenschafter",
        },
        {"neutral": "Ägyptologe / Ägyptologin", "female": "Ägyptologin", "male": "Ägyptologe"},
        {"neutral": "Änderungsschneider*in", "female": "Änderungsschneiderin", "male": "Änderungsschneider"},
    )

    jobs: ElementsType[str] = [job["neutral"] for job in jobs_dict]
    jobs_female: ElementsType[str] = [job["female"] for job in jobs_dict]
    jobs_male: ElementsType[str] = [job["male"] for job in jobs_dict]

    def job(self) -> str:
        return self.random_element(self.jobs)
