// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file XtypesTestsType1TypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "XtypesTestsType1TypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "XtypesTestsType1.hpp"


using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_Type1_type_identifier(
        TypeIdentifierPair& type_ids_Type1)
{

    ReturnCode_t return_code_Type1 {eprosima::fastdds::dds::RETCODE_OK};
    return_code_Type1 =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "Type1", type_ids_Type1);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_Type1)
    {
        StructTypeFlag struct_flags_Type1 = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_Type1 = "Type1";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Type1;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Type1;
        CompleteTypeDetail detail_Type1 = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Type1, ann_custom_Type1, type_name_Type1.to_string());
        CompleteStructHeader header_Type1;
        header_Type1 = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_Type1);
        CompleteStructMemberSeq member_seq_Type1;
        {
            TypeIdentifierPair type_ids_content;
            ReturnCode_t return_code_content {eprosima::fastdds::dds::RETCODE_OK};
            return_code_content =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_content);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_content)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_content))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_content = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_content = 0x00000000;
            bool common_content_ec {false};
            CommonStructMember common_content {TypeObjectUtils::build_common_struct_member(member_id_content, member_flags_content, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_content, common_content_ec))};
            if (!common_content_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure content member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_content = "content";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_content;
            ann_custom_Type1.reset();
            CompleteMemberDetail detail_content = TypeObjectUtils::build_complete_member_detail(name_content, member_ann_builtin_content, ann_custom_Type1);
            CompleteStructMember member_content = TypeObjectUtils::build_complete_struct_member(common_content, detail_content);
            TypeObjectUtils::add_complete_struct_member(member_seq_Type1, member_content);
        }
        CompleteStructType struct_type_Type1 = TypeObjectUtils::build_complete_struct_type(struct_flags_Type1, header_Type1, member_seq_Type1);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_Type1, type_name_Type1.to_string(), type_ids_Type1))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Type1 already registered in TypeObjectRegistry for a different type.");
        }
    }
}

