/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// stdlib includes
#include <limits>


/////////////////////// Qt includes
#include <QDialog>
#include <QPlainTextEdit>


/////////////////////// pappsomspp includes
#include <pappsomspp/core/trace/trace.h>
#include <pappsomspp/core/trace/maptrace.h>
#include <pappsomspp/core/processing/combiners/mzintegrationparams.h>

/////////////////////// libXpertMassCore includes
#include "MsXpS/libXpertMassCore/jsclassregistrar.h"
#include "MsXpS/libXpertMassCore/MassPeakShaperConfig.hpp"
#include "MsXpS/libXpertMassCore/MassPeakShaper.hpp"


/////////////////////// libXpertMassGUI includes
#include "MsXpS/libXpertMassGui/MassPeakShaperConfigWidget.hpp"

/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

namespace Ui
{
class MassPeakShaperConfigDlg;
}

namespace MsXpS
{

namespace libXpertMassGui
{


/*  BEGIN CLASS JS REFERENCE
 *  namespace: MsXpS::libXpertMassGui
 *  class name: MassPeakShaperConfigDlg
 */

class DECLSPEC MassPeakShaperConfigDlg: public QDialog
{
  Q_OBJECT

  public:
  MassPeakShaperConfigDlg(QWidget *program_window_p,
                          const QString &applicationName,
                          const QString &description);

  virtual ~MassPeakShaperConfigDlg();

  void writeSettings(const QString &configSettingsFilePath);
  void readSettings(const QString &configSettingsFilePath);

  // The normalizing intensity usually is the greatest intensity in the cluster
  // centroids that is to be used for normalization of the peaks in the cluster.
  // Q_INVOKABLE void setNormalizingIntensity(double new_max_intensity);

  Q_INVOKABLE void
  setParameters(double reference_peak_mz,
                int point_count,
                libXpertMassCore::Enums::MassPeakShapeType mass_peak_shape_type,
                double resolution,
                double fwhm,
                int bin_size_divisor    = 6,
                bool should_create_bins = true);

  Q_INVOKABLE MassPeakShaperConfigWidget *getConfigWidget();

  static void registerJsConstructor(QJSEngine *engine);

  protected:
  Ui::MassPeakShaperConfigDlg *mp_ui;
  MassPeakShaperConfigWidget *mp_massPeakShaperConfigWidget = nullptr;

  QWidget *mp_parent = nullptr;

  QString m_applicationName;

  libXpertMassCore::MassPeakShaperConfig m_config;

  void closeEvent(QCloseEvent *event);

  void setupDialog();

  signals:

  void updatedMassPeakShaperConfigSignal(
    const libXpertMassCore::MassPeakShaperConfig &config);
};

/*  END CLASS JS REFERENCE
 *  namespace: MsXpS::libXpertMassGui
 *  class name: MassPeakShaperConfigDlg
 */

MSXPS_REGISTER_JS_CLASS(MsXpS::libXpertMassGui, MassPeakShaperConfigDlg)

} // namespace libXpertMassGui
} // namespace MsXpS
