# Contributing to gulp-load-plugins

Firstly, contributions are hugely welcomed and much appreciated!

__If you've never contributed to an open source project before, please don't let that put you off!__ I am more than happy to help with PRs, etc, please ping [me](https://github.com/jackfranklin) or [Jameel](https://github.com/jameelmoses) on GitHub.

### Working on an issue

Before you start working on an idea, make sure:

- If you're working to fix an [outstanding issue](https://github.com/jackfranklin/gulp-load-plugins/issues), please leave a comment that you're working on it so that we don't end up with duplicated effort.
- If you have an idea for a new feature, please raise it as an [issue](https://github.com/jackfranklin/gulp-load-plugins/issues) so we can make sure the feature is right for the plugin, and you don't end up wasting effort.
- If you're working on a bug fix, make sure you're running the latest version of gulp-load-plugins, in case the bug has since been fixed in a newer version.

### Writing the code

- Follow the code standards of the existing project. We use ESLint to keep our code formatted, and running `yarn test` will first run `eslint` before the tests so you can ensure you've followed the style.
- Be sure to add yourself as a contributor to the [package.json](https://github.com/jackfranklin/gulp-load-plugins/blob/master/package.json) file.
- If possible, write a test that covers the bug fix / feature addition that you're making. If you're unsure how to write the test, open your PR first and someone will help you.
- If you have any questions at all, please don't hesitate to get in touch. We're here to help :)
