/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Integer square root.
*
* @module @stdlib/math/base/special/fast/uint32-sqrt
*
* @example
* var sqrtUint32 = require( '@stdlib/math/base/special/fast/uint32-sqrt' );
*
* var v = sqrtUint32( 9 >>> 0 );
* // returns 3
*
* v = sqrtUint32( 2 >>> 0 );
* // returns 1
*
* v = sqrtUint32( 3 >>> 0 );
* // returns 1
*
* v = sqrtUint32( 0 >>> 0 );
* // returns 0
*/

// MODULES //

var sqrtUint32 = require( './sqrt.js' );


// EXPORTS //

module.exports = sqrtUint32;
