# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers.aio import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPIAppResiliencyOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_app_resiliency_create_or_update(self, resource_group):
        response = await self.client.app_resiliency.create_or_update(
            resource_group_name=resource_group.name,
            app_name="str",
            name="str",
            resiliency_envelope={
                "circuitBreakerPolicy": {"consecutiveErrors": 0, "intervalInSeconds": 0, "maxEjectionPercent": 0},
                "httpConnectionPool": {"http1MaxPendingRequests": 0, "http2MaxRequests": 0},
                "httpRetryPolicy": {
                    "errors": ["str"],
                    "headers": [
                        {
                            "exactMatch": "str",
                            "header": "str",
                            "prefixMatch": "str",
                            "regexMatch": "str",
                            "suffixMatch": "str",
                        }
                    ],
                    "httpStatusCodes": [0],
                    "initialDelayInMilliseconds": 0,
                    "maxIntervalInMilliseconds": 0,
                    "maxRetries": 0,
                },
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tcpConnectionPool": {"maxConnections": 0},
                "tcpRetryPolicy": {"maxConnectAttempts": 0},
                "timeoutPolicy": {"connectionTimeoutInSeconds": 0, "responseTimeoutInSeconds": 0},
                "type": "str",
            },
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_app_resiliency_update(self, resource_group):
        response = await self.client.app_resiliency.update(
            resource_group_name=resource_group.name,
            app_name="str",
            name="str",
            resiliency_envelope={
                "circuitBreakerPolicy": {"consecutiveErrors": 0, "intervalInSeconds": 0, "maxEjectionPercent": 0},
                "httpConnectionPool": {"http1MaxPendingRequests": 0, "http2MaxRequests": 0},
                "httpRetryPolicy": {
                    "errors": ["str"],
                    "headers": [
                        {
                            "exactMatch": "str",
                            "header": "str",
                            "prefixMatch": "str",
                            "regexMatch": "str",
                            "suffixMatch": "str",
                        }
                    ],
                    "httpStatusCodes": [0],
                    "initialDelayInMilliseconds": 0,
                    "maxIntervalInMilliseconds": 0,
                    "maxRetries": 0,
                },
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tcpConnectionPool": {"maxConnections": 0},
                "tcpRetryPolicy": {"maxConnectAttempts": 0},
                "timeoutPolicy": {"connectionTimeoutInSeconds": 0, "responseTimeoutInSeconds": 0},
                "type": "str",
            },
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_app_resiliency_delete(self, resource_group):
        response = await self.client.app_resiliency.delete(
            resource_group_name=resource_group.name,
            app_name="str",
            name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_app_resiliency_get(self, resource_group):
        response = await self.client.app_resiliency.get(
            resource_group_name=resource_group.name,
            app_name="str",
            name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_app_resiliency_list(self, resource_group):
        response = self.client.app_resiliency.list(
            resource_group_name=resource_group.name,
            app_name="str",
            api_version="2025-02-02-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
