# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AggregationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Aggregation type."""

    AVG = "Avg"
    """Average"""
    SUM = "Sum"
    """Sum"""
    MIN = "Min"
    """Minimum"""
    MAX = "Max"
    """Maximum"""


class CollectionConfigurationErrorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Collection configuration error type reported by the client SDK."""

    UNKNOWN = "Unknown"
    """Unknown error type."""
    PERFORMANCE_COUNTER_PARSING = "PerformanceCounterParsing"
    """Performance counter parsing error."""
    PERFORMANCE_COUNTER_UNEXPECTED = "PerformanceCounterUnexpected"
    """Performance counter unexpected error."""
    PERFORMANCE_COUNTER_DUPLICATE_IDS = "PerformanceCounterDuplicateIds"
    """Performance counter duplicate ids."""
    DOCUMENT_STREAM_DUPLICATE_IDS = "DocumentStreamDuplicateIds"
    """Document stream duplication ids."""
    DOCUMENT_STREAM_FAILURE_TO_CREATE = "DocumentStreamFailureToCreate"
    """Document stream failed to create."""
    DOCUMENT_STREAM_FAILURE_TO_CREATE_FILTER_UNEXPECTED = "DocumentStreamFailureToCreateFilterUnexpected"
    """Document stream failed to create filter unexpectedly."""
    METRIC_DUPLICATE_IDS = "MetricDuplicateIds"
    """Metric duplicate ids."""
    METRIC_TELEMETRY_TYPE_UNSUPPORTED = "MetricTelemetryTypeUnsupported"
    """Metric telemetry type unsupported."""
    METRIC_FAILURE_TO_CREATE = "MetricFailureToCreate"
    """Metric failed to create."""
    METRIC_FAILURE_TO_CREATE_FILTER_UNEXPECTED = "MetricFailureToCreateFilterUnexpected"
    """Metric failed to create filter unexpectedly."""
    FILTER_FAILURE_TO_CREATE_UNEXPECTED = "FilterFailureToCreateUnexpected"
    """Filter failed to create unexpectedly."""
    COLLECTION_CONFIGURATION_FAILURE_TO_CREATE_UNEXPECTED = "CollectionConfigurationFailureToCreateUnexpected"
    """Collection configuration failed to create unexpectedly."""


class DocumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Document type."""

    REQUEST = "Request"
    """Represents a request telemetry type."""
    REMOTE_DEPENDENCY = "RemoteDependency"
    """Represents a remote dependency telemetry type."""
    EXCEPTION = "Exception"
    """Represents an exception telemetry type."""
    EVENT = "Event"
    """Represents an event telemetry type."""
    TRACE = "Trace"
    """Represents a trace telemetry type."""
    UNKNOWN = "Unknown"
    """Represents an unknown telemetry type."""


class PredicateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum representing the different types of predicates."""

    EQUAL = "Equal"
    """Represents an equality predicate."""
    NOT_EQUAL = "NotEqual"
    """Represents a not-equal predicate."""
    LESS_THAN = "LessThan"
    """Represents a less-than predicate."""
    GREATER_THAN = "GreaterThan"
    """Represents a greater-than predicate."""
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    """Represents a less-than-or-equal predicate."""
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    """Represents a greater-than-or-equal predicate."""
    CONTAINS = "Contains"
    """Represents a contains predicate."""
    DOES_NOT_CONTAIN = "DoesNotContain"
    """Represents a does-not-contain predicate."""


class TelemetryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Telemetry type."""

    REQUEST = "Request"
    """Represents a request telemetry type."""
    DEPENDENCY = "Dependency"
    """Represents a dependency telemetry type."""
    EXCEPTION = "Exception"
    """Represents an exception telemetry type."""
    EVENT = "Event"
    """Represents an event telemetry type."""
    METRIC = "Metric"
    """Represents a metric telemetry type."""
    PERFORMANCE_COUNTER = "PerformanceCounter"
    """Represents a performance counter telemetry type."""
    TRACE = "Trace"
    """Represents a trace telemetry type."""
