# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from ..._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ...indexes.models._enums import KnowledgeSourceKind, VectorSearchVectorizerKind
from ._enums import (
    KnowledgeBaseActivityRecordType,
    KnowledgeBaseMessageContentType,
    KnowledgeBaseReferenceType,
    KnowledgeRetrievalIntentType,
    KnowledgeRetrievalReasoningEffortKind,
)

if TYPE_CHECKING:
    from .. import models as _models
    from ...indexes import models as _indexes_models3


class AIServices(_Model):
    """Parameters for AI Services.

    :ivar uri: The URI of the AI Services endpoint. Required.
    :vartype uri: str
    :ivar api_key: The API key for accessing AI Services.
    :vartype api_key: str
    """

    uri: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URI of the AI Services endpoint. Required."""
    api_key: Optional[str] = rest_field(name="apiKey", visibility=["read", "create", "update", "delete", "query"])
    """The API key for accessing AI Services."""

    @overload
    def __init__(
        self,
        *,
        uri: str,
        api_key: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeSourceParams(_Model):
    """Base type for knowledge source runtime parameters.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBlobKnowledgeSourceParams, IndexedOneLakeKnowledgeSourceParams,
    IndexedSharePointKnowledgeSourceParams, RemoteSharePointKnowledgeSourceParams,
    SearchIndexKnowledgeSourceParams, WebKnowledgeSourceParams

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The type of the knowledge source. Required. Known values are: "searchIndex",
     "azureBlob", "indexedSharePoint", "indexedOneLake", "web", and "remoteSharePoint".
    :vartype kind: str or ~azure.search.documents.indexes.models.KnowledgeSourceKind
    """

    __mapping__: dict[str, _Model] = {}
    knowledge_source_name: str = rest_field(
        name="knowledgeSourceName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the index the params apply to. Required."""
    include_references: Optional[bool] = rest_field(
        name="includeReferences", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether references should be included for data retrieved from this source."""
    include_reference_source_data: Optional[bool] = rest_field(
        name="includeReferenceSourceData", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether references should include the structured data obtained during retrieval in
     their payload."""
    always_query_source: Optional[bool] = rest_field(
        name="alwaysQuerySource", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates that this knowledge source should bypass source selection and always be queried at
     retrieval time."""
    reranker_threshold: Optional[float] = rest_field(
        name="rerankerThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reranker threshold all retrieved documents must meet to be included in the response."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The type of the knowledge source. Required. Known values are: \"searchIndex\", \"azureBlob\",
     \"indexedSharePoint\", \"indexedOneLake\", \"web\", and \"remoteSharePoint\"."""

    @overload
    def __init__(
        self,
        *,
        knowledge_source_name: str,
        kind: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureBlobKnowledgeSourceParams(KnowledgeSourceParams, discriminator="azureBlob"):
    """Specifies runtime parameters for a azure blob knowledge source.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The discriminator value. Required. A knowledge source that read and ingest data
     from Azure Blob Storage to a Search Index.
    :vartype kind: str or ~azure.search.documents.indexes.models.AZURE_BLOB
    """

    kind: Literal[KnowledgeSourceKind.AZURE_BLOB] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. A knowledge source that read and ingest data from Azure Blob
     Storage to a Search Index."""

    @overload
    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.AZURE_BLOB  # type: ignore


class CompletedSynchronizationState(_Model):
    """Represents the completed state of the last synchronization.

    :ivar start_time: The start time of the last completed synchronization. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the last completed synchronization. Required.
    :vartype end_time: ~datetime.datetime
    :ivar items_updates_processed: The number of item updates successfully processed in the last
     synchronization. Required.
    :vartype items_updates_processed: int
    :ivar items_updates_failed: The number of item updates that failed in the last synchronization.
     Required.
    :vartype items_updates_failed: int
    :ivar items_skipped: The number of items skipped in the last synchronization. Required.
    :vartype items_skipped: int
    """

    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the last completed synchronization. Required."""
    end_time: datetime.datetime = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The end time of the last completed synchronization. Required."""
    items_updates_processed: int = rest_field(
        name="itemsUpdatesProcessed", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of item updates successfully processed in the last synchronization. Required."""
    items_updates_failed: int = rest_field(
        name="itemsUpdatesFailed", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of item updates that failed in the last synchronization. Required."""
    items_skipped: int = rest_field(name="itemsSkipped", visibility=["read", "create", "update", "delete", "query"])
    """The number of items skipped in the last synchronization. Required."""

    @overload
    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        items_updates_processed: int,
        items_updates_failed: int,
        items_skipped: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IndexedOneLakeKnowledgeSourceParams(KnowledgeSourceParams, discriminator="indexedOneLake"):
    """Specifies runtime parameters for a indexed OneLake knowledge source.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The discriminator value. Required. A knowledge source that reads data from indexed
     OneLake.
    :vartype kind: str or ~azure.search.documents.indexes.models.INDEXED_ONE_LAKE
    """

    kind: Literal[KnowledgeSourceKind.INDEXED_ONE_LAKE] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. A knowledge source that reads data from indexed OneLake."""

    @overload
    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.INDEXED_ONE_LAKE  # type: ignore


class IndexedSharePointKnowledgeSourceParams(KnowledgeSourceParams, discriminator="indexedSharePoint"):
    """Specifies runtime parameters for a indexed SharePoint knowledge source.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The discriminator value. Required. A knowledge source that reads data from indexed
     SharePoint.
    :vartype kind: str or ~azure.search.documents.indexes.models.INDEXED_SHARE_POINT
    """

    kind: Literal[KnowledgeSourceKind.INDEXED_SHARE_POINT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. A knowledge source that reads data from indexed SharePoint."""

    @overload
    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.INDEXED_SHARE_POINT  # type: ignore


class KnowledgeBaseActivityRecord(_Model):
    """Base type for activity records. Tracks execution details, timing, and errors for knowledge base
    operations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeBaseAgenticReasoningActivityRecord, KnowledgeBaseModelAnswerSynthesisActivityRecord,
    KnowledgeBaseModelQueryPlanningActivityRecord

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required. Known values are: "searchIndex",
     "azureBlob", "indexedSharePoint", "indexedOneLake", "web", "remoteSharePoint",
     "modelQueryPlanning", "modelAnswerSynthesis", and "agenticReasoning".
    :vartype type: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeBaseActivityRecordType
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    """

    __mapping__: dict[str, _Model] = {}
    id: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the activity record. Required."""
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of the activity record. Required. Known values are: \"searchIndex\", \"azureBlob\",
     \"indexedSharePoint\", \"indexedOneLake\", \"web\", \"remoteSharePoint\",
     \"modelQueryPlanning\", \"modelAnswerSynthesis\", and \"agenticReasoning\"."""
    elapsed_ms: Optional[int] = rest_field(name="elapsedMs", visibility=["read", "create", "update", "delete", "query"])
    """The elapsed time in milliseconds for the retrieval activity."""
    error: Optional["_models.KnowledgeBaseErrorDetail"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The error detail explaining why the operation failed. This property is only included when the
     activity does not succeed."""

    @overload
    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        type: str,
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseAgenticReasoningActivityRecord(
    KnowledgeBaseActivityRecord, discriminator="agenticReasoning"
):  # pylint: disable=name-too-long
    """Represents an agentic reasoning activity record.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar type: The discriminator value. Required. Agentic reasoning activity.
    :vartype type: str or ~azure.search.documents.knowledgebases.models.AGENTIC_REASONING
    :ivar reasoning_tokens: The number of input tokens for agentic reasoning.
    :vartype reasoning_tokens: int
    :ivar retrieval_reasoning_effort: The retrieval reasoning effort configuration.
    :vartype retrieval_reasoning_effort:
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalReasoningEffort
    """

    type: Literal[KnowledgeBaseActivityRecordType.AGENTIC_REASONING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Agentic reasoning activity."""
    reasoning_tokens: Optional[int] = rest_field(
        name="reasoningTokens", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of input tokens for agentic reasoning."""
    retrieval_reasoning_effort: Optional["_models.KnowledgeRetrievalReasoningEffort"] = rest_field(
        name="retrievalReasoningEffort", visibility=["read", "create", "update", "delete", "query"]
    )
    """The retrieval reasoning effort configuration."""

    @overload
    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        reasoning_tokens: Optional[int] = None,
        retrieval_reasoning_effort: Optional["_models.KnowledgeRetrievalReasoningEffort"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = KnowledgeBaseActivityRecordType.AGENTIC_REASONING  # type: ignore


class KnowledgeBaseReference(_Model):
    """Base type for references.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeBaseAzureBlobReference, KnowledgeBaseIndexedOneLakeReference,
    KnowledgeBaseIndexedSharePointReference, KnowledgeBaseRemoteSharePointReference,
    KnowledgeBaseSearchIndexReference, KnowledgeBaseWebReference

    :ivar type: The type of the reference. Required. Known values are: "searchIndex", "azureBlob",
     "indexedSharePoint", "indexedOneLake", "web", and "remoteSharePoint".
    :vartype type: str or ~azure.search.documents.knowledgebases.models.KnowledgeBaseReferenceType
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: The source data for the reference.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of the reference. Required. Known values are: \"searchIndex\", \"azureBlob\",
     \"indexedSharePoint\", \"indexedOneLake\", \"web\", and \"remoteSharePoint\"."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the reference. Required."""
    activity_source: int = rest_field(name="activitySource", visibility=["read", "create", "update", "delete", "query"])
    """The source activity ID for the reference. Required."""
    source_data: Optional[dict[str, Any]] = rest_field(
        name="sourceData", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source data for the reference."""
    reranker_score: Optional[float] = rest_field(
        name="rerankerScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reranker score for the document reference."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseAzureBlobReference(KnowledgeBaseReference, discriminator="azureBlob"):
    """Represents an Azure Blob Storage document reference.

    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: The source data for the reference.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar type: The discriminator value. Required. Azure Blob document reference.
    :vartype type: str or ~azure.search.documents.knowledgebases.models.AZURE_BLOB
    :ivar blob_url: The blob URL for the reference.
    :vartype blob_url: str
    """

    type: Literal[KnowledgeBaseReferenceType.AZURE_BLOB] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Azure Blob document reference."""
    blob_url: Optional[str] = rest_field(name="blobUrl", visibility=["read", "create", "update", "delete", "query"])
    """The blob URL for the reference."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        blob_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = KnowledgeBaseReferenceType.AZURE_BLOB  # type: ignore


class KnowledgeBaseErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: dict[str, any]
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[dict[str, Any]] = rest_field(visibility=["read"])
    """The additional info."""


class KnowledgeBaseErrorDetail(_Model):
    """The error details.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.KnowledgeBaseErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.KnowledgeBaseErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class KnowledgeBaseImageContent(_Model):
    """Image content.

    :ivar url: The url of the image. Required.
    :vartype url: str
    """

    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The url of the image. Required."""

    @overload
    def __init__(
        self,
        *,
        url: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseIndexedOneLakeReference(KnowledgeBaseReference, discriminator="indexedOneLake"):
    """Represents an indexed OneLake document reference.

    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: The source data for the reference.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar type: The discriminator value. Required. Indexed OneLake document reference.
    :vartype type: str or ~azure.search.documents.knowledgebases.models.INDEXED_ONE_LAKE
    :ivar doc_url: The document URL for the reference.
    :vartype doc_url: str
    """

    type: Literal[KnowledgeBaseReferenceType.INDEXED_ONE_LAKE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Indexed OneLake document reference."""
    doc_url: Optional[str] = rest_field(name="docUrl", visibility=["read", "create", "update", "delete", "query"])
    """The document URL for the reference."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        doc_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = KnowledgeBaseReferenceType.INDEXED_ONE_LAKE  # type: ignore


class KnowledgeBaseIndexedSharePointReference(KnowledgeBaseReference, discriminator="indexedSharePoint"):
    """Represents an indexed SharePoint document reference.

    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: The source data for the reference.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar type: The discriminator value. Required. Indexed SharePoint document reference.
    :vartype type: str or ~azure.search.documents.knowledgebases.models.INDEXED_SHARE_POINT
    :ivar doc_url: The document URL for the reference.
    :vartype doc_url: str
    """

    type: Literal[KnowledgeBaseReferenceType.INDEXED_SHARE_POINT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Indexed SharePoint document reference."""
    doc_url: Optional[str] = rest_field(name="docUrl", visibility=["read", "create", "update", "delete", "query"])
    """The document URL for the reference."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        doc_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = KnowledgeBaseReferenceType.INDEXED_SHARE_POINT  # type: ignore


class KnowledgeBaseMessage(_Model):
    """The natural language message style object.

    :ivar role: The role of the tool response.
    :vartype role: str
    :ivar content: The content of the message. Required.
    :vartype content:
     list[~azure.search.documents.knowledgebases.models.KnowledgeBaseMessageContent]
    """

    role: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The role of the tool response."""
    content: list["_models.KnowledgeBaseMessageContent"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The content of the message. Required."""

    @overload
    def __init__(
        self,
        *,
        content: list["_models.KnowledgeBaseMessageContent"],
        role: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseMessageContent(_Model):
    """Specifies the type of the message content.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeBaseMessageImageContent, KnowledgeBaseMessageTextContent

    :ivar type: The type of the message. Required. Known values are: "text" and "image".
    :vartype type: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeBaseMessageContentType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of the message. Required. Known values are: \"text\" and \"image\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseMessageImageContent(KnowledgeBaseMessageContent, discriminator="image"):
    """Image message type.

    :ivar type: The discriminator value. Required. Image message content kind.
    :vartype type: str or ~azure.search.documents.knowledgebases.models.IMAGE
    :ivar image: The image content. Required.
    :vartype image: ~azure.search.documents.knowledgebases.models.KnowledgeBaseImageContent
    """

    type: Literal[KnowledgeBaseMessageContentType.IMAGE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Image message content kind."""
    image: "_models.KnowledgeBaseImageContent" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The image content. Required."""

    @overload
    def __init__(
        self,
        *,
        image: "_models.KnowledgeBaseImageContent",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = KnowledgeBaseMessageContentType.IMAGE  # type: ignore


class KnowledgeBaseMessageTextContent(KnowledgeBaseMessageContent, discriminator="text"):
    """Text message type.

    :ivar type: The discriminator value. Required. Text message content kind.
    :vartype type: str or ~azure.search.documents.knowledgebases.models.TEXT
    :ivar text: The text content. Required.
    :vartype text: str
    """

    type: Literal[KnowledgeBaseMessageContentType.TEXT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Text message content kind."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text content. Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = KnowledgeBaseMessageContentType.TEXT  # type: ignore


class KnowledgeBaseModelAnswerSynthesisActivityRecord(
    KnowledgeBaseActivityRecord, discriminator="modelAnswerSynthesis"
):  # pylint: disable=name-too-long
    """Represents an LLM answer synthesis activity record.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar type: The discriminator value. Required. LLM answer synthesis activity.
    :vartype type: str or ~azure.search.documents.knowledgebases.models.MODEL_ANSWER_SYNTHESIS
    :ivar input_tokens: The number of input tokens for the LLM answer synthesis activity.
    :vartype input_tokens: int
    :ivar output_tokens: The number of output tokens for the LLM answer synthesis activity.
    :vartype output_tokens: int
    """

    type: Literal[KnowledgeBaseActivityRecordType.MODEL_ANSWER_SYNTHESIS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. LLM answer synthesis activity."""
    input_tokens: Optional[int] = rest_field(
        name="inputTokens", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of input tokens for the LLM answer synthesis activity."""
    output_tokens: Optional[int] = rest_field(
        name="outputTokens", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of output tokens for the LLM answer synthesis activity."""

    @overload
    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        input_tokens: Optional[int] = None,
        output_tokens: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = KnowledgeBaseActivityRecordType.MODEL_ANSWER_SYNTHESIS  # type: ignore


class KnowledgeBaseModelQueryPlanningActivityRecord(
    KnowledgeBaseActivityRecord, discriminator="modelQueryPlanning"
):  # pylint: disable=name-too-long
    """Represents an LLM query planning activity record.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar type: The discriminator value. Required. LLM query planning activity.
    :vartype type: str or ~azure.search.documents.knowledgebases.models.MODEL_QUERY_PLANNING
    :ivar input_tokens: The number of input tokens for the LLM query planning activity.
    :vartype input_tokens: int
    :ivar output_tokens: The number of output tokens for the LLM query planning activity.
    :vartype output_tokens: int
    """

    type: Literal[KnowledgeBaseActivityRecordType.MODEL_QUERY_PLANNING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. LLM query planning activity."""
    input_tokens: Optional[int] = rest_field(
        name="inputTokens", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of input tokens for the LLM query planning activity."""
    output_tokens: Optional[int] = rest_field(
        name="outputTokens", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of output tokens for the LLM query planning activity."""

    @overload
    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        input_tokens: Optional[int] = None,
        output_tokens: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = KnowledgeBaseActivityRecordType.MODEL_QUERY_PLANNING  # type: ignore


class KnowledgeBaseRemoteSharePointReference(KnowledgeBaseReference, discriminator="remoteSharePoint"):
    """Represents a remote SharePoint document reference.

    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: The source data for the reference.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar type: The discriminator value. Required. Remote SharePoint document reference.
    :vartype type: str or ~azure.search.documents.knowledgebases.models.REMOTE_SHARE_POINT
    :ivar web_url: The url the reference data originated from.
    :vartype web_url: str
    :ivar search_sensitivity_label_info: Information about the sensitivity label applied to the
     SharePoint document.
    :vartype search_sensitivity_label_info:
     ~azure.search.documents.knowledgebases.models.SharePointSensitivityLabelInfo
    """

    type: Literal[KnowledgeBaseReferenceType.REMOTE_SHARE_POINT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Remote SharePoint document reference."""
    web_url: Optional[str] = rest_field(name="webUrl", visibility=["read", "create", "update", "delete", "query"])
    """The url the reference data originated from."""
    search_sensitivity_label_info: Optional["_models.SharePointSensitivityLabelInfo"] = rest_field(
        name="searchSensitivityLabelInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Information about the sensitivity label applied to the SharePoint document."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        web_url: Optional[str] = None,
        search_sensitivity_label_info: Optional["_models.SharePointSensitivityLabelInfo"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = KnowledgeBaseReferenceType.REMOTE_SHARE_POINT  # type: ignore


class KnowledgeBaseRetrievalRequest(_Model):
    """The input contract for the retrieval request.

    :ivar messages: A list of chat message style input.
    :vartype messages: list[~azure.search.documents.knowledgebases.models.KnowledgeBaseMessage]
    :ivar intents: A list of intended queries to execute without model query planning.
    :vartype intents: list[~azure.search.documents.knowledgebases.models.KnowledgeRetrievalIntent]
    :ivar max_runtime_in_seconds: The maximum runtime in seconds.
    :vartype max_runtime_in_seconds: int
    :ivar max_output_size: Limits the maximum size of the content in the output.
    :vartype max_output_size: int
    :ivar retrieval_reasoning_effort: The retrieval reasoning effort configuration.
    :vartype retrieval_reasoning_effort:
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalReasoningEffort
    :ivar include_activity: Indicates retrieval results should include activity information.
    :vartype include_activity: bool
    :ivar output_mode: The output configuration for this retrieval. Known values are:
     "extractiveData" and "answerSynthesis".
    :vartype output_mode: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalOutputMode
    :ivar knowledge_source_params: A list of runtime parameters for the knowledge sources.
    :vartype knowledge_source_params:
     list[~azure.search.documents.knowledgebases.models.KnowledgeSourceParams]
    """

    messages: Optional[list["_models.KnowledgeBaseMessage"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of chat message style input."""
    intents: Optional[list["_models.KnowledgeRetrievalIntent"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of intended queries to execute without model query planning."""
    max_runtime_in_seconds: Optional[int] = rest_field(
        name="maxRuntimeInSeconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum runtime in seconds."""
    max_output_size: Optional[int] = rest_field(
        name="maxOutputSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Limits the maximum size of the content in the output."""
    retrieval_reasoning_effort: Optional["_models.KnowledgeRetrievalReasoningEffort"] = rest_field(
        name="retrievalReasoningEffort", visibility=["read", "create", "update", "delete", "query"]
    )
    """The retrieval reasoning effort configuration."""
    include_activity: Optional[bool] = rest_field(
        name="includeActivity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates retrieval results should include activity information."""
    output_mode: Optional[Union[str, "_models.KnowledgeRetrievalOutputMode"]] = rest_field(
        name="outputMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The output configuration for this retrieval. Known values are: \"extractiveData\" and
     \"answerSynthesis\"."""
    knowledge_source_params: Optional[list["_models.KnowledgeSourceParams"]] = rest_field(
        name="knowledgeSourceParams", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of runtime parameters for the knowledge sources."""

    @overload
    def __init__(
        self,
        *,
        messages: Optional[list["_models.KnowledgeBaseMessage"]] = None,
        intents: Optional[list["_models.KnowledgeRetrievalIntent"]] = None,
        max_runtime_in_seconds: Optional[int] = None,
        max_output_size: Optional[int] = None,
        retrieval_reasoning_effort: Optional["_models.KnowledgeRetrievalReasoningEffort"] = None,
        include_activity: Optional[bool] = None,
        output_mode: Optional[Union[str, "_models.KnowledgeRetrievalOutputMode"]] = None,
        knowledge_source_params: Optional[list["_models.KnowledgeSourceParams"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseRetrievalResponse(_Model):
    """The output contract for the retrieval response.

    :ivar response: The response messages.
    :vartype response: list[~azure.search.documents.knowledgebases.models.KnowledgeBaseMessage]
    :ivar activity: The activity records for tracking progress and billing implications.
    :vartype activity:
     list[~azure.search.documents.knowledgebases.models.KnowledgeBaseActivityRecord]
    :ivar references: The references for the retrieval data used in the response.
    :vartype references: list[~azure.search.documents.knowledgebases.models.KnowledgeBaseReference]
    """

    response: Optional[list["_models.KnowledgeBaseMessage"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The response messages."""
    activity: Optional[list["_models.KnowledgeBaseActivityRecord"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The activity records for tracking progress and billing implications."""
    references: Optional[list["_models.KnowledgeBaseReference"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The references for the retrieval data used in the response."""

    @overload
    def __init__(
        self,
        *,
        response: Optional[list["_models.KnowledgeBaseMessage"]] = None,
        activity: Optional[list["_models.KnowledgeBaseActivityRecord"]] = None,
        references: Optional[list["_models.KnowledgeBaseReference"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeBaseSearchIndexReference(KnowledgeBaseReference, discriminator="searchIndex"):
    """Represents an Azure Search document reference.

    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: The source data for the reference.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar type: The discriminator value. Required. Search index document reference.
    :vartype type: str or ~azure.search.documents.knowledgebases.models.SEARCH_INDEX
    :ivar doc_key: The document key for the reference.
    :vartype doc_key: str
    """

    type: Literal[KnowledgeBaseReferenceType.SEARCH_INDEX] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Search index document reference."""
    doc_key: Optional[str] = rest_field(name="docKey", visibility=["read", "create", "update", "delete", "query"])
    """The document key for the reference."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        doc_key: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = KnowledgeBaseReferenceType.SEARCH_INDEX  # type: ignore


class KnowledgeBaseWebReference(KnowledgeBaseReference, discriminator="web"):
    """Represents a web document reference.

    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: The source data for the reference.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar type: The discriminator value. Required. Web document reference.
    :vartype type: str or ~azure.search.documents.knowledgebases.models.WEB
    :ivar url: The url the reference data originated from.
    :vartype url: str
    :ivar title: The title of the web document.
    :vartype title: str
    """

    type: Literal[KnowledgeBaseReferenceType.WEB] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Web document reference."""
    url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The url the reference data originated from."""
    title: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The title of the web document."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        url: Optional[str] = None,
        title: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = KnowledgeBaseReferenceType.WEB  # type: ignore


class KnowledgeRetrievalIntent(_Model):
    """An intended query to execute without model query planning.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeRetrievalSemanticIntent

    :ivar type: The type of the intent. Required. "semantic"
    :vartype type: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalIntentType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of the intent. Required. \"semantic\""""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeRetrievalReasoningEffort(_Model):
    """Base type for reasoning effort.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeRetrievalLowReasoningEffort, KnowledgeRetrievalMediumReasoningEffort,
    KnowledgeRetrievalMinimalReasoningEffort

    :ivar kind: The kind of reasoning effort. Required. Known values are: "minimal", "low", and
     "medium".
    :vartype kind: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalReasoningEffortKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The kind of reasoning effort. Required. Known values are: \"minimal\", \"low\", and \"medium\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeRetrievalLowReasoningEffort(KnowledgeRetrievalReasoningEffort, discriminator="low"):
    """Run knowledge retrieval with low reasoning effort.

    :ivar kind: The discriminator value. Required. Use low reasoning during retrieval.
    :vartype kind: str or ~azure.search.documents.knowledgebases.models.LOW
    """

    kind: Literal[KnowledgeRetrievalReasoningEffortKind.LOW] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Use low reasoning during retrieval."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeRetrievalReasoningEffortKind.LOW  # type: ignore


class KnowledgeRetrievalMediumReasoningEffort(KnowledgeRetrievalReasoningEffort, discriminator="medium"):
    """Run knowledge retrieval with medium reasoning effort.

    :ivar kind: The discriminator value. Required. Use a moderate amount of reasoning during
     retrieval.
    :vartype kind: str or ~azure.search.documents.knowledgebases.models.MEDIUM
    """

    kind: Literal[KnowledgeRetrievalReasoningEffortKind.MEDIUM] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Use a moderate amount of reasoning during retrieval."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeRetrievalReasoningEffortKind.MEDIUM  # type: ignore


class KnowledgeRetrievalMinimalReasoningEffort(KnowledgeRetrievalReasoningEffort, discriminator="minimal"):
    """Run knowledge retrieval with minimal reasoning effort.

    :ivar kind: The discriminator value. Required. Does not perform any source selections, query
     planning, or iterative search.
    :vartype kind: str or ~azure.search.documents.knowledgebases.models.MINIMAL
    """

    kind: Literal[KnowledgeRetrievalReasoningEffortKind.MINIMAL] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Does not perform any source selections, query planning, or
     iterative search."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeRetrievalReasoningEffortKind.MINIMAL  # type: ignore


class KnowledgeRetrievalSemanticIntent(KnowledgeRetrievalIntent, discriminator="semantic"):
    """A semantic query intent.

    :ivar type: The discriminator value. Required. A natural language semantic query intent.
    :vartype type: str or ~azure.search.documents.knowledgebases.models.SEMANTIC
    :ivar search: The semantic query to execute. Required.
    :vartype search: str
    """

    type: Literal[KnowledgeRetrievalIntentType.SEMANTIC] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. A natural language semantic query intent."""
    search: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The semantic query to execute. Required."""

    @overload
    def __init__(
        self,
        *,
        search: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = KnowledgeRetrievalIntentType.SEMANTIC  # type: ignore


class KnowledgeSourceVectorizer(_Model):
    """Specifies the vectorization method to be used for knowledge source embedding model.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeSourceAzureOpenAIVectorizer

    :ivar kind: The name of the kind of vectorization method being configured for use with vector
     search. Required. Known values are: "azureOpenAI", "customWebApi", "aiServicesVision", and
     "aml".
    :vartype kind: str or ~azure.search.documents.indexes.models.VectorSearchVectorizerKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The name of the kind of vectorization method being configured for use with vector search.
     Required. Known values are: \"azureOpenAI\", \"customWebApi\", \"aiServicesVision\", and
     \"aml\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeSourceAzureOpenAIVectorizer(KnowledgeSourceVectorizer, discriminator="azureOpenAI"):
    """Specifies the Azure OpenAI resource used to vectorize a query string.

    :ivar kind: The discriminator value. Required. Generate embeddings using an Azure OpenAI
     resource at query time.
    :vartype kind: str or ~azure.search.documents.indexes.models.AZURE_OPEN_AI
    :ivar azure_open_ai_parameters: Contains the parameters specific to Azure OpenAI embedding
     vectorization.
    :vartype azure_open_ai_parameters:
     ~azure.search.documents.indexes.models.AzureOpenAIVectorizerParameters
    """

    kind: Literal[VectorSearchVectorizerKind.AZURE_OPEN_AI] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. Generate embeddings using an Azure OpenAI resource at query
     time."""
    azure_open_ai_parameters: Optional["_indexes_models3.AzureOpenAIVectorizerParameters"] = rest_field(
        name="azureOpenAIParameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the parameters specific to Azure OpenAI embedding vectorization."""

    @overload
    def __init__(
        self,
        *,
        azure_open_ai_parameters: Optional["_indexes_models3.AzureOpenAIVectorizerParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = VectorSearchVectorizerKind.AZURE_OPEN_AI  # type: ignore


class KnowledgeSourceIngestionParameters(_Model):
    """Consolidates all general ingestion settings for knowledge sources.

    :ivar identity: An explicit identity to use for this knowledge source.
    :vartype identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    :ivar embedding_model: Optional vectorizer configuration for vectorizing content.
    :vartype embedding_model:
     ~azure.search.documents.knowledgebases.models.KnowledgeSourceVectorizer
    :ivar chat_completion_model: Optional chat completion model for image verbalization or context
     extraction.
    :vartype chat_completion_model: ~azure.search.documents.indexes.models.KnowledgeBaseModel
    :ivar disable_image_verbalization: Indicates whether image verbalization should be disabled.
     Default is false.
    :vartype disable_image_verbalization: bool
    :ivar ingestion_schedule: Optional schedule for data ingestion.
    :vartype ingestion_schedule: ~azure.search.documents.indexes.models.IndexingSchedule
    :ivar ingestion_permission_options: Optional list of permission types to ingest together with
     document content. If specified, it will set the indexer permission options for the data source.
    :vartype ingestion_permission_options: list[str or
     ~azure.search.documents.indexes.models.KnowledgeSourceIngestionPermissionOption]
    :ivar content_extraction_mode: Optional content extraction mode. Default is 'minimal'. Known
     values are: "minimal" and "standard".
    :vartype content_extraction_mode: str or
     ~azure.search.documents.indexes.models.KnowledgeSourceContentExtractionMode
    :ivar ai_services: Optional AI Services configuration for content processing.
    :vartype ai_services: ~azure.search.documents.knowledgebases.models.AIServices
    """

    identity: Optional["_indexes_models3.SearchIndexerDataIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An explicit identity to use for this knowledge source."""
    embedding_model: Optional["_models.KnowledgeSourceVectorizer"] = rest_field(
        name="embeddingModel", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional vectorizer configuration for vectorizing content."""
    chat_completion_model: Optional["_indexes_models3.KnowledgeBaseModel"] = rest_field(
        name="chatCompletionModel", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional chat completion model for image verbalization or context extraction."""
    disable_image_verbalization: Optional[bool] = rest_field(
        name="disableImageVerbalization", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether image verbalization should be disabled. Default is false."""
    ingestion_schedule: Optional["_indexes_models3.IndexingSchedule"] = rest_field(
        name="ingestionSchedule", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional schedule for data ingestion."""
    ingestion_permission_options: Optional[
        list[Union[str, "_indexes_models3.KnowledgeSourceIngestionPermissionOption"]]
    ] = rest_field(name="ingestionPermissionOptions", visibility=["read", "create", "update", "delete", "query"])
    """Optional list of permission types to ingest together with document content. If specified, it
     will set the indexer permission options for the data source."""
    content_extraction_mode: Optional[Union[str, "_indexes_models3.KnowledgeSourceContentExtractionMode"]] = rest_field(
        name="contentExtractionMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional content extraction mode. Default is 'minimal'. Known values are: \"minimal\" and
     \"standard\"."""
    ai_services: Optional["_models.AIServices"] = rest_field(
        name="aiServices", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional AI Services configuration for content processing."""

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_indexes_models3.SearchIndexerDataIdentity"] = None,
        embedding_model: Optional["_models.KnowledgeSourceVectorizer"] = None,
        chat_completion_model: Optional["_indexes_models3.KnowledgeBaseModel"] = None,
        disable_image_verbalization: Optional[bool] = None,
        ingestion_schedule: Optional["_indexes_models3.IndexingSchedule"] = None,
        ingestion_permission_options: Optional[
            list[Union[str, "_indexes_models3.KnowledgeSourceIngestionPermissionOption"]]
        ] = None,
        content_extraction_mode: Optional[Union[str, "_indexes_models3.KnowledgeSourceContentExtractionMode"]] = None,
        ai_services: Optional["_models.AIServices"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeSourceStatistics(_Model):
    """Statistical information about knowledge source synchronization history.

    :ivar total_synchronization: Total number of synchronizations. Required.
    :vartype total_synchronization: int
    :ivar average_synchronization_duration: Average synchronization duration in HH:MM:SS format.
     Required.
    :vartype average_synchronization_duration: str
    :ivar average_items_processed_per_synchronization: Average items processed per synchronization.
     Required.
    :vartype average_items_processed_per_synchronization: int
    """

    total_synchronization: int = rest_field(
        name="totalSynchronization", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of synchronizations. Required."""
    average_synchronization_duration: str = rest_field(
        name="averageSynchronizationDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Average synchronization duration in HH:MM:SS format. Required."""
    average_items_processed_per_synchronization: int = rest_field(
        name="averageItemsProcessedPerSynchronization", visibility=["read", "create", "update", "delete", "query"]
    )
    """Average items processed per synchronization. Required."""

    @overload
    def __init__(
        self,
        *,
        total_synchronization: int,
        average_synchronization_duration: str,
        average_items_processed_per_synchronization: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KnowledgeSourceStatus(_Model):
    """Represents the status and synchronization history of a knowledge source.

    :ivar synchronization_status: The current synchronization status. Required. Known values are:
     "creating", "active", and "deleting".
    :vartype synchronization_status: str or
     ~azure.search.documents.indexes.models.KnowledgeSourceSynchronizationStatus
    :ivar synchronization_interval: The synchronization interval (e.g., '1d' for daily). Null if no
     schedule is configured.
    :vartype synchronization_interval: str
    :ivar current_synchronization_state: Current synchronization state that spans multiple indexer
     runs.
    :vartype current_synchronization_state:
     ~azure.search.documents.knowledgebases.models.SynchronizationState
    :ivar last_synchronization_state: Details of the last completed synchronization. Null on first
     sync.
    :vartype last_synchronization_state:
     ~azure.search.documents.knowledgebases.models.CompletedSynchronizationState
    :ivar statistics: Statistical information about the knowledge source synchronization history.
     Null on first sync.
    :vartype statistics: ~azure.search.documents.knowledgebases.models.KnowledgeSourceStatistics
    """

    synchronization_status: Union[str, "_indexes_models3.KnowledgeSourceSynchronizationStatus"] = rest_field(
        name="synchronizationStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """The current synchronization status. Required. Known values are: \"creating\", \"active\", and
     \"deleting\"."""
    synchronization_interval: Optional[str] = rest_field(
        name="synchronizationInterval", visibility=["read", "create", "update", "delete", "query"]
    )
    """The synchronization interval (e.g., '1d' for daily). Null if no schedule is configured."""
    current_synchronization_state: Optional["_models.SynchronizationState"] = rest_field(
        name="currentSynchronizationState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Current synchronization state that spans multiple indexer runs."""
    last_synchronization_state: Optional["_models.CompletedSynchronizationState"] = rest_field(
        name="lastSynchronizationState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Details of the last completed synchronization. Null on first sync."""
    statistics: Optional["_models.KnowledgeSourceStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Statistical information about the knowledge source synchronization history. Null on first sync."""

    @overload
    def __init__(
        self,
        *,
        synchronization_status: Union[str, "_indexes_models3.KnowledgeSourceSynchronizationStatus"],
        synchronization_interval: Optional[str] = None,
        current_synchronization_state: Optional["_models.SynchronizationState"] = None,
        last_synchronization_state: Optional["_models.CompletedSynchronizationState"] = None,
        statistics: Optional["_models.KnowledgeSourceStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RemoteSharePointKnowledgeSourceParams(KnowledgeSourceParams, discriminator="remoteSharePoint"):
    """Specifies runtime parameters for a remote SharePoint knowledge source.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The discriminator value. Required. A knowledge source that reads data from remote
     SharePoint.
    :vartype kind: str or ~azure.search.documents.indexes.models.REMOTE_SHARE_POINT
    :ivar filter_expression_add_on: A filter condition applied to the SharePoint data source. It
     must be specified in the Keyword Query Language syntax. It will be combined as a conjunction
     with the filter expression specified in the knowledge source definition.
    :vartype filter_expression_add_on: str
    """

    kind: Literal[KnowledgeSourceKind.REMOTE_SHARE_POINT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. A knowledge source that reads data from remote SharePoint."""
    filter_expression_add_on: Optional[str] = rest_field(
        name="filterExpressionAddOn", visibility=["read", "create", "update", "delete", "query"]
    )
    """A filter condition applied to the SharePoint data source. It must be specified in the Keyword
     Query Language syntax. It will be combined as a conjunction with the filter expression
     specified in the knowledge source definition."""

    @overload
    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
        filter_expression_add_on: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.REMOTE_SHARE_POINT  # type: ignore


class SearchIndexKnowledgeSourceParams(KnowledgeSourceParams, discriminator="searchIndex"):
    """Specifies runtime parameters for a search index knowledge source.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The discriminator value. Required. A knowledge source that reads data from a Search
     Index.
    :vartype kind: str or ~azure.search.documents.indexes.models.SEARCH_INDEX
    :ivar filter_add_on: A filter condition applied to the index (e.g., 'State eq VA').
    :vartype filter_add_on: str
    """

    kind: Literal[KnowledgeSourceKind.SEARCH_INDEX] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. A knowledge source that reads data from a Search Index."""
    filter_add_on: Optional[str] = rest_field(
        name="filterAddOn", visibility=["read", "create", "update", "delete", "query"]
    )
    """A filter condition applied to the index (e.g., 'State eq VA')."""

    @overload
    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
        filter_add_on: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.SEARCH_INDEX  # type: ignore


class SharePointSensitivityLabelInfo(_Model):
    """Information about the sensitivity label applied to a SharePoint document.

    :ivar display_name: The display name for the sensitivity label.
    :vartype display_name: str
    :ivar sensitivity_label_id: The ID of the sensitivity label.
    :vartype sensitivity_label_id: str
    :ivar tooltip: The tooltip that should be displayed for the label in a UI.
    :vartype tooltip: str
    :ivar priority: The priority in which the sensitivity label is applied.
    :vartype priority: int
    :ivar color: The color that the UI should display for the label, if configured.
    :vartype color: str
    :ivar is_encrypted: Indicates whether the sensitivity label enforces encryption.
    :vartype is_encrypted: bool
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The display name for the sensitivity label."""
    sensitivity_label_id: Optional[str] = rest_field(
        name="sensitivityLabelId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The ID of the sensitivity label."""
    tooltip: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tooltip that should be displayed for the label in a UI."""
    priority: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The priority in which the sensitivity label is applied."""
    color: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The color that the UI should display for the label, if configured."""
    is_encrypted: Optional[bool] = rest_field(
        name="isEncrypted", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the sensitivity label enforces encryption."""

    @overload
    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        sensitivity_label_id: Optional[str] = None,
        tooltip: Optional[str] = None,
        priority: Optional[int] = None,
        color: Optional[str] = None,
        is_encrypted: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SynchronizationState(_Model):
    """Represents the current state of an ongoing synchronization that spans multiple indexer runs.

    :ivar start_time: The start time of the current synchronization. Required.
    :vartype start_time: ~datetime.datetime
    :ivar items_updates_processed: The number of item updates successfully processed in the current
     synchronization. Required.
    :vartype items_updates_processed: int
    :ivar items_updates_failed: The number of item updates that failed in the current
     synchronization. Required.
    :vartype items_updates_failed: int
    :ivar items_skipped: The number of items skipped in the current synchronization. Required.
    :vartype items_skipped: int
    """

    start_time: datetime.datetime = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the current synchronization. Required."""
    items_updates_processed: int = rest_field(
        name="itemsUpdatesProcessed", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of item updates successfully processed in the current synchronization. Required."""
    items_updates_failed: int = rest_field(
        name="itemsUpdatesFailed", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of item updates that failed in the current synchronization. Required."""
    items_skipped: int = rest_field(name="itemsSkipped", visibility=["read", "create", "update", "delete", "query"])
    """The number of items skipped in the current synchronization. Required."""

    @overload
    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        items_updates_processed: int,
        items_updates_failed: int,
        items_skipped: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WebKnowledgeSourceParams(KnowledgeSourceParams, discriminator="web"):
    """Specifies runtime parameters for a web knowledge source.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The discriminator value. Required. A knowledge source that reads data from the web.
    :vartype kind: str or ~azure.search.documents.indexes.models.WEB
    :ivar language: The language of the web results.
    :vartype language: str
    :ivar market: The market of the web results.
    :vartype market: str
    :ivar count: The number of web results to return.
    :vartype count: int
    :ivar freshness: The freshness of web results.
    :vartype freshness: str
    """

    kind: Literal[KnowledgeSourceKind.WEB] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The discriminator value. Required. A knowledge source that reads data from the web."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The language of the web results."""
    market: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The market of the web results."""
    count: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of web results to return."""
    freshness: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The freshness of web results."""

    @overload
    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
        language: Optional[str] = None,
        market: Optional[str] = None,
        count: Optional[int] = None,
        freshness: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = KnowledgeSourceKind.WEB  # type: ignore
