# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=wrong-import-position

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ._patch import *  # pylint: disable=unused-wildcard-import


from ._models import (  # type: ignore
    AutocompleteItem,
    DebugInfo,
    DocumentDebugInfo,
    ErrorAdditionalInfo,
    ErrorDetail,
    ErrorResponse,
    FacetResult,
    HybridSearch,
    IndexAction,
    IndexDocumentsBatch,
    IndexingResult,
    LookupDocument,
    QueryAnswerResult,
    QueryCaptionResult,
    QueryResultDocumentInnerHit,
    QueryResultDocumentRerankerInput,
    QueryResultDocumentSemanticField,
    QueryResultDocumentSubscores,
    QueryRewritesDebugInfo,
    QueryRewritesValuesDebugInfo,
    SearchDocumentsResult,
    SearchRequest,
    SearchResult,
    SearchScoreThreshold,
    SemanticDebugInfo,
    SingleVectorFieldResult,
    SuggestResult,
    TextResult,
    VectorQuery,
    VectorSimilarityThreshold,
    VectorThreshold,
    VectorizableImageBinaryQuery,
    VectorizableImageUrlQuery,
    VectorizableTextQuery,
    VectorizedQuery,
    VectorsDebugInfo,
)

from ._enums import (  # type: ignore
    AutocompleteMode,
    HybridCountAndFacetMode,
    IndexActionType,
    QueryAnswerType,
    QueryCaptionType,
    QueryDebugMode,
    QueryLanguage,
    QueryRewritesType,
    QuerySpellerType,
    QueryType,
    ScoringStatistics,
    SearchMode,
    SemanticErrorMode,
    SemanticErrorReason,
    SemanticFieldState,
    SemanticQueryRewritesResultType,
    SemanticSearchResultsType,
    VectorFilterMode,
    VectorQueryKind,
    VectorThresholdKind,
)
from ._patch import __all__ as _patch_all
from ._patch import *
from ._patch import patch_sdk as _patch_sdk

__all__ = [
    "AutocompleteItem",
    "DebugInfo",
    "DocumentDebugInfo",
    "ErrorAdditionalInfo",
    "ErrorDetail",
    "ErrorResponse",
    "FacetResult",
    "HybridSearch",
    "IndexAction",
    "IndexDocumentsBatch",
    "IndexingResult",
    "LookupDocument",
    "QueryAnswerResult",
    "QueryCaptionResult",
    "QueryResultDocumentInnerHit",
    "QueryResultDocumentRerankerInput",
    "QueryResultDocumentSemanticField",
    "QueryResultDocumentSubscores",
    "QueryRewritesDebugInfo",
    "QueryRewritesValuesDebugInfo",
    "SearchDocumentsResult",
    "SearchRequest",
    "SearchResult",
    "SearchScoreThreshold",
    "SemanticDebugInfo",
    "SingleVectorFieldResult",
    "SuggestResult",
    "TextResult",
    "VectorQuery",
    "VectorSimilarityThreshold",
    "VectorThreshold",
    "VectorizableImageBinaryQuery",
    "VectorizableImageUrlQuery",
    "VectorizableTextQuery",
    "VectorizedQuery",
    "VectorsDebugInfo",
    "AutocompleteMode",
    "HybridCountAndFacetMode",
    "IndexActionType",
    "QueryAnswerType",
    "QueryCaptionType",
    "QueryDebugMode",
    "QueryLanguage",
    "QueryRewritesType",
    "QuerySpellerType",
    "QueryType",
    "ScoringStatistics",
    "SearchMode",
    "SemanticErrorMode",
    "SemanticErrorReason",
    "SemanticFieldState",
    "SemanticQueryRewritesResultType",
    "SemanticSearchResultsType",
    "VectorFilterMode",
    "VectorQueryKind",
    "VectorThresholdKind",
]
__all__.extend([p for p in _patch_all if p not in __all__])  # pyright: ignore
_patch_sdk()
