
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <IVtkOCC_SelectableObject.hxx>
#include <IVtkOCC_Shape.hxx>
#include <IVtkOCC_ShapeMesher.hxx>
#include <IVtkOCC_ShapePickerAlgo.hxx>
#include <IVtkOCC_ViewerSelector.hxx>

// template related includes

// ./opencascade/IVtkOCC_ShapeMesher.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/IVtkOCC_ShapeMesher.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_IVtkOCC(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("IVtkOCC"));
py::object klass;

//Python trampoline classes

// classes

    // Class IVtkOCC_SelectableObject from ./opencascade/IVtkOCC_SelectableObject.hxx
    klass = m.attr("IVtkOCC_SelectableObject");


    // nested enums

    static_cast<py::class_<IVtkOCC_SelectableObject ,opencascade::handle<IVtkOCC_SelectableObject>  , SelectMgr_SelectableObject >>(klass)
    // constructors
        .def(py::init<  const typename IVtkOCC_Shape::Handle & >()  , py::arg("theShape") )
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetShape",
             (void (IVtkOCC_SelectableObject::*)(  const typename IVtkOCC_Shape::Handle &  ) ) static_cast<void (IVtkOCC_SelectableObject::*)(  const typename IVtkOCC_Shape::Handle &  ) >(&IVtkOCC_SelectableObject::SetShape),
             R"#(Sets the selectable shape)#"  , py::arg("theShape")
          )
        .def("BoundingBox",
             (void (IVtkOCC_SelectableObject::*)( Bnd_Box &  ) ) static_cast<void (IVtkOCC_SelectableObject::*)( Bnd_Box &  ) >(&IVtkOCC_SelectableObject::BoundingBox),
             R"#(Returns bounding box of object)#"  , py::arg("theBndBox")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IVtkOCC_SelectableObject::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IVtkOCC_SelectableObject::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetShape",
             ( const typename IVtkOCC_Shape::Handle & (IVtkOCC_SelectableObject::*)() const) static_cast< const typename IVtkOCC_Shape::Handle & (IVtkOCC_SelectableObject::*)() const>(&IVtkOCC_SelectableObject::GetShape),
             R"#()#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (IVtkOCC_SelectableObject::*)() const) static_cast< const handle<Standard_Type> & (IVtkOCC_SelectableObject::*)() const>(&IVtkOCC_SelectableObject::DynamicType),
             R"#()#"
             
         )
;

    // Class IVtkOCC_Shape from ./opencascade/IVtkOCC_Shape.hxx
    klass = m.attr("IVtkOCC_Shape");


    // nested enums

    static_cast<py::class_<IVtkOCC_Shape ,opencascade::handle<IVtkOCC_Shape>  , IVtk_IShape >>(klass)
    // constructors
        .def(py::init<  const TopoDS_Shape &, const handle<Prs3d_Drawer> & >()  , py::arg("theShape"),  py::arg("theDrawerLink")=static_cast< const handle<Prs3d_Drawer> &>(Handle ( Prs3d_Drawer ) ( )) )
    // custom constructors
    // methods
        .def("GetSubShapeId",
             (IVtk_IdType (IVtkOCC_Shape::*)(  const TopoDS_Shape &  ) const) static_cast<IVtk_IdType (IVtkOCC_Shape::*)(  const TopoDS_Shape &  ) const>(&IVtkOCC_Shape::GetSubShapeId),
             R"#(Get local ID of a sub-shape.)#"  , py::arg("theSubShape")
          )
        .def("GetSubIds",
             (IVtk_ShapeIdList (IVtkOCC_Shape::*)(  const IVtk_IdType  ) const) static_cast<IVtk_ShapeIdList (IVtkOCC_Shape::*)(  const IVtk_IdType  ) const>(&IVtkOCC_Shape::GetSubIds),
             R"#(Get ids of sub-shapes composing a sub-shape with the given id)#"  , py::arg("arg0")
          )
        .def("GetSubShape",
             ( const TopoDS_Shape & (IVtkOCC_Shape::*)(  const IVtk_IdType  ) const) static_cast< const TopoDS_Shape & (IVtkOCC_Shape::*)(  const IVtk_IdType  ) const>(&IVtkOCC_Shape::GetSubShape),
             R"#(Get a sub-shape by its local ID.)#"  , py::arg("theId")
          )
        .def("SetSelectableObject",
             (void (IVtkOCC_Shape::*)(  const handle<SelectMgr_SelectableObject> &  ) ) static_cast<void (IVtkOCC_Shape::*)(  const handle<SelectMgr_SelectableObject> &  ) >(&IVtkOCC_Shape::SetSelectableObject),
             R"#(Stores a handle to selectable object used by OCCT selection algorithm in a data field. This object internally caches selection data so it should be stored until the shape is no longer selectable. Note that the selectable object keeps a pointer to OccShape.)#"  , py::arg("theSelObj")
          )
        .def("SetAttributes",
             (void (IVtkOCC_Shape::*)(  const handle<Prs3d_Drawer> &  ) ) static_cast<void (IVtkOCC_Shape::*)(  const handle<Prs3d_Drawer> &  ) >(&IVtkOCC_Shape::SetAttributes),
             R"#(Set presentation attributes.)#"  , py::arg("theDrawer")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IVtkOCC_Shape::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IVtkOCC_Shape::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IVtkOCC_Shape::*)() const) static_cast< const handle<Standard_Type> & (IVtkOCC_Shape::*)() const>(&IVtkOCC_Shape::DynamicType),
             R"#()#"
             
         )
       .def("GetShape",
             ( const TopoDS_Shape & (IVtkOCC_Shape::*)() const) static_cast< const TopoDS_Shape & (IVtkOCC_Shape::*)() const>(&IVtkOCC_Shape::GetShape),
             R"#(Get the wrapped original OCCT shape)#"
             
         )
       .def("GetSelectableObject",
             ( const handle<SelectMgr_SelectableObject> & (IVtkOCC_Shape::*)() const) static_cast< const handle<SelectMgr_SelectableObject> & (IVtkOCC_Shape::*)() const>(&IVtkOCC_Shape::GetSelectableObject),
             R"#(Returns Handle to the selectable object for this shape.)#"
             
         )
       .def("Attributes",
             ( const handle<Prs3d_Drawer> & (IVtkOCC_Shape::*)() const) static_cast< const handle<Prs3d_Drawer> & (IVtkOCC_Shape::*)() const>(&IVtkOCC_Shape::Attributes),
             R"#(Return presentation attributes.)#"
             
         )
;

    // Class IVtkOCC_ShapeMesher from ./opencascade/IVtkOCC_ShapeMesher.hxx
    klass = m.attr("IVtkOCC_ShapeMesher");


    // nested enums

    static_cast<py::class_<IVtkOCC_ShapeMesher ,opencascade::handle<IVtkOCC_ShapeMesher>  , IVtk_IShapeMesher >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("GetDeflection",
             (Standard_Real (IVtkOCC_ShapeMesher::*)() const) static_cast<Standard_Real (IVtkOCC_ShapeMesher::*)() const>(&IVtkOCC_ShapeMesher::GetDeflection),
             R"#(Returns absolute deflection used by this algorithm. This value is calculated on the basis of the shape's bounding box. Zero might be returned in case if the underlying OCCT shape is empty or invalid. Thus check the returned value before passing it to OCCT meshing algorithms!)#" 
          )
        .def("GetDeviationCoeff",
             (Standard_Real (IVtkOCC_ShapeMesher::*)() const) static_cast<Standard_Real (IVtkOCC_ShapeMesher::*)() const>(&IVtkOCC_ShapeMesher::GetDeviationCoeff),
             R"#(Returns relative deviation coefficient used by this algorithm.)#" 
          )
        .def("GetDeviationAngle",
             (Standard_Real (IVtkOCC_ShapeMesher::*)() const) static_cast<Standard_Real (IVtkOCC_ShapeMesher::*)() const>(&IVtkOCC_ShapeMesher::GetDeviationAngle),
             R"#(Returns deviation angle used by this algorithm. This is the maximum allowed angle between the normals to the curve/surface and the normals to polyline/faceted representation.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IVtkOCC_ShapeMesher::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IVtkOCC_ShapeMesher::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IVtkOCC_ShapeMesher::*)() const) static_cast< const handle<Standard_Type> & (IVtkOCC_ShapeMesher::*)() const>(&IVtkOCC_ShapeMesher::DynamicType),
             R"#()#"
             
         )
;

    // Class IVtkOCC_ShapePickerAlgo from ./opencascade/IVtkOCC_ShapePickerAlgo.hxx
    klass = m.attr("IVtkOCC_ShapePickerAlgo");


    // nested enums

    static_cast<py::class_<IVtkOCC_ShapePickerAlgo ,opencascade::handle<IVtkOCC_ShapePickerAlgo>  >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetView",
             (void (IVtkOCC_ShapePickerAlgo::*)(  const typename IVtk_IView::Handle &  ) ) static_cast<void (IVtkOCC_ShapePickerAlgo::*)(  const typename IVtk_IView::Handle &  ) >(&IVtkOCC_ShapePickerAlgo::SetView),
             R"#(Sets the picker's view interface. The picker uses the view to obtain parameters of the 3D view projection.)#"  , py::arg("theView")
          )
        .def("NbPicked",
             (int (IVtkOCC_ShapePickerAlgo::*)() ) static_cast<int (IVtkOCC_ShapePickerAlgo::*)() >(&IVtkOCC_ShapePickerAlgo::NbPicked),
             R"#(Get number of picked entities.)#" 
          )
        .def("GetSelectionModes",
             (IVtk_SelectionModeList (IVtkOCC_ShapePickerAlgo::*)(  const typename IVtk_IShape::Handle &  ) const) static_cast<IVtk_SelectionModeList (IVtkOCC_ShapePickerAlgo::*)(  const typename IVtk_IShape::Handle &  ) const>(&IVtkOCC_ShapePickerAlgo::GetSelectionModes),
             R"#(Get activated selection modes for a shape.)#"  , py::arg("theShape")
          )
        .def("SetSelectionMode",
             (void (IVtkOCC_ShapePickerAlgo::*)(  const typename IVtk_IShape::Handle & ,   const IVtk_SelectionMode ,   const bool  ) ) static_cast<void (IVtkOCC_ShapePickerAlgo::*)(  const typename IVtk_IShape::Handle & ,   const IVtk_SelectionMode ,   const bool  ) >(&IVtkOCC_ShapePickerAlgo::SetSelectionMode),
             R"#(Activates/deactivates the given selection mode for the shape. If mode == SM_None, the shape becomes non-selectable and is removed from the internal selection data.)#"  , py::arg("theShape"),  py::arg("theMode"),  py::arg("theIsTurnOn")=static_cast< const bool>(true)
          )
        .def("SetSelectionMode",
             (void (IVtkOCC_ShapePickerAlgo::*)(  const IVtk_ShapePtrList & ,   const IVtk_SelectionMode ,   const bool  ) ) static_cast<void (IVtkOCC_ShapePickerAlgo::*)(  const IVtk_ShapePtrList & ,   const IVtk_SelectionMode ,   const bool  ) >(&IVtkOCC_ShapePickerAlgo::SetSelectionMode),
             R"#(Activates/deactivates the given selection mode for the shape. If mode == SM_None, the shape becomes non-selectable and is removed from the internal selection data.)#"  , py::arg("theShapes"),  py::arg("theMode"),  py::arg("theIsTurnOn")=static_cast< const bool>(true)
          )
        .def("SubShapesPicked",
             (void (IVtkOCC_ShapePickerAlgo::*)(  const IVtk_IdType ,  IVtk_ShapeIdList &  ) const) static_cast<void (IVtkOCC_ShapePickerAlgo::*)(  const IVtk_IdType ,  IVtk_ShapeIdList &  ) const>(&IVtkOCC_ShapePickerAlgo::SubShapesPicked),
             R"#()#"  , py::arg("theId"),  py::arg("theShapeList")
          )
        .def("RemoveSelectableObject",
             (void (IVtkOCC_ShapePickerAlgo::*)(  const typename IVtk_IShape::Handle &  ) ) static_cast<void (IVtkOCC_ShapePickerAlgo::*)(  const typename IVtk_IShape::Handle &  ) >(&IVtkOCC_ShapePickerAlgo::RemoveSelectableObject),
             R"#(Remove selectable object from the picker (from internal maps).)#"  , py::arg("theShape")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IVtkOCC_ShapePickerAlgo::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IVtkOCC_ShapePickerAlgo::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ShapesPicked",
             ( const IVtk_ShapeIdList & (IVtkOCC_ShapePickerAlgo::*)() const) static_cast< const IVtk_ShapeIdList & (IVtkOCC_ShapePickerAlgo::*)() const>(&IVtkOCC_ShapePickerAlgo::ShapesPicked),
             R"#(Returns the list of picked top-level shape IDs, in the order of increasing depth (the ID of the shape closest to the eye is the first in the list))#"
             
         )
       .def("TopPickedPoint",
             ( const gp_Pnt & (IVtkOCC_ShapePickerAlgo::*)() const) static_cast< const gp_Pnt & (IVtkOCC_ShapePickerAlgo::*)() const>(&IVtkOCC_ShapePickerAlgo::TopPickedPoint),
             R"#(Return topmost picked 3D point or (Inf, Inf, Inf) if undefined.)#"
             
         )
       .def("DynamicType",
             ( const handle<Standard_Type> & (IVtkOCC_ShapePickerAlgo::*)() const) static_cast< const handle<Standard_Type> & (IVtkOCC_ShapePickerAlgo::*)() const>(&IVtkOCC_ShapePickerAlgo::DynamicType),
             R"#()#"
             
         )
;

    // Class IVtkOCC_ViewerSelector from ./opencascade/IVtkOCC_ViewerSelector.hxx
    klass = m.attr("IVtkOCC_ViewerSelector");


    // nested enums

    static_cast<py::class_<IVtkOCC_ViewerSelector ,opencascade::handle<IVtkOCC_ViewerSelector>  , SelectMgr_ViewerSelector >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Activate",
             (void (IVtkOCC_ViewerSelector::*)(  const handle<SelectMgr_Selection> &  ) ) static_cast<void (IVtkOCC_ViewerSelector::*)(  const handle<SelectMgr_Selection> &  ) >(&IVtkOCC_ViewerSelector::Activate),
             R"#(Activates the given selection)#"  , py::arg("theSelection")
          )
        .def("Deactivate",
             (void (IVtkOCC_ViewerSelector::*)(  const handle<SelectMgr_Selection> &  ) ) static_cast<void (IVtkOCC_ViewerSelector::*)(  const handle<SelectMgr_Selection> &  ) >(&IVtkOCC_ViewerSelector::Deactivate),
             R"#(Deactivate the given selection)#"  , py::arg("theSelection")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("ConvertVtkToOccCamera_s",
                    (handle<Graphic3d_Camera> (*)(  const typename IVtk_IView::Handle &  ) ) static_cast<handle<Graphic3d_Camera> (*)(  const typename IVtk_IView::Handle &  ) >(&IVtkOCC_ViewerSelector::ConvertVtkToOccCamera),
                    R"#(Converts VTK camera defined for input view to OCC camera)#"  , py::arg("theView")
          )
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&IVtkOCC_ViewerSelector::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&IVtkOCC_ViewerSelector::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (IVtkOCC_ViewerSelector::*)() const) static_cast< const handle<Standard_Type> & (IVtkOCC_ViewerSelector::*)() const>(&IVtkOCC_ViewerSelector::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/IVtkOCC_SelectableObject.hxx
// ./opencascade/IVtkOCC_Shape.hxx
// ./opencascade/IVtkOCC_ShapeMesher.hxx
// ./opencascade/IVtkOCC_ShapePickerAlgo.hxx
// ./opencascade/IVtkOCC_ViewerSelector.hxx

// Additional functions


// operators

// register typdefs
    register_template_NCollection_DataMap<TopoDS_Shape, IVtk_MeshType, TopTools_ShapeMapHasher>(m,"IVtk_ShapeTypeMap");
    register_template_NCollection_List<IVtk_Polyline>(m,"IVtk_PolylineList");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
