
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <UnitsMethods.hxx>
#include <UnitsMethods_LengthUnit.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_UnitsMethods_enums(py::module &main_module) {


py::module m = main_module.def_submodule("UnitsMethods", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    py::enum_<UnitsMethods_LengthUnit>(m, "UnitsMethods_LengthUnit",R"#(The Enumeration describes possible values for length units)#")
        .value("UnitsMethods_LengthUnit_Undefined",UnitsMethods_LengthUnit::UnitsMethods_LengthUnit_Undefined)
        .value("UnitsMethods_LengthUnit_Inch",UnitsMethods_LengthUnit::UnitsMethods_LengthUnit_Inch)
        .value("UnitsMethods_LengthUnit_Millimeter",UnitsMethods_LengthUnit::UnitsMethods_LengthUnit_Millimeter)
        .value("UnitsMethods_LengthUnit_Foot",UnitsMethods_LengthUnit::UnitsMethods_LengthUnit_Foot)
        .value("UnitsMethods_LengthUnit_Mile",UnitsMethods_LengthUnit::UnitsMethods_LengthUnit_Mile)
        .value("UnitsMethods_LengthUnit_Meter",UnitsMethods_LengthUnit::UnitsMethods_LengthUnit_Meter)
        .value("UnitsMethods_LengthUnit_Kilometer",UnitsMethods_LengthUnit::UnitsMethods_LengthUnit_Kilometer)
        .value("UnitsMethods_LengthUnit_Mil",UnitsMethods_LengthUnit::UnitsMethods_LengthUnit_Mil)
        .value("UnitsMethods_LengthUnit_Micron",UnitsMethods_LengthUnit::UnitsMethods_LengthUnit_Micron)
        .value("UnitsMethods_LengthUnit_Centimeter",UnitsMethods_LengthUnit::UnitsMethods_LengthUnit_Centimeter)
        .value("UnitsMethods_LengthUnit_Microinch",UnitsMethods_LengthUnit::UnitsMethods_LengthUnit_Microinch).export_values();

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<UnitsMethods , shared_ptr<UnitsMethods>  >(m,"UnitsMethods",R"#(Class for using global units variables)#");

};

// user-defined post-inclusion per module

// user-defined post
