---
layout: post
title: Polyglot 1.12 - リダイレクト改善とコミュニティ貢献
lang: jp
description: Jekyll Polyglot 1.12.0は、サブ言語の改善されたリダイレクトサポート、フォールバックページ検出、新しいサイト言語サポートを提供します
---

Jekyll-Polyglot `1.12.0`がリリースされました！このリリースはリダイレクト処理の改善に焦点を当てており、複数のコミュニティ貢献を含んでいます。

## リダイレクト改善

このリリースには、Polyglotでリダイレクトがどのように機能するかについての重要な改善が含まれています：

- **PR #275**：リダイレクトでのアンカータグの保持 - [@GruberMarkus](https://github.com/GruberMarkus)のソリューションのおかげで、リダイレクトURLがアンカータグを正しく保持するようになり、ユーザーが意図した場所に正確に到達できるようになりました。

- **PR #293**：jekyll-redirect-fromプラグインのサブ言語リダイレクトサポート - [@rathboma](https://github.com/rathboma)の提案により、Polyglotはサブ言語間で`redirect_from`フロントマターを正しくスコープするようになり、重複リダイレクトを防ぎ、デフォルト以外の言語ページの適切なルーティングを保証します。

## page.rendered_langでフォールバックページを検出

- **PR #283**：新しい`page.rendered_lang`変数 - [@rathboma](https://github.com/rathboma)による貢献で、この新しいliquid変数を使用すると、ページがフォールバックとしてレンダリングされているときに検出できます。`page.rendered_lang != site.active_lang`の場合、ページコンテンツがまだ翻訳されていないことがわかります。

[/about](/about)ページは、この`page.rendered_lang`便利なliquid変数の使用方法についての説明で更新されました。

## 新しい言語サポート

- **PR #280**：イタリア語とトルコ語のサポートがPolyglotドキュメントサイトに追加され、多言語対応が拡大しました。

## コミュニティ貢献

複数のコミュニティメンバーがプロジェクトに改善を貢献しました：

- **PR #277**：サイドバーのリッチテキスト定義が更新され、サイトの多言語プレゼンテーションが改善されました。

- **PR #288**：[@manabu-nakamura](https://github.com/manabu-nakamura)による日本語リッチテキスト文字列の貢献で、日本語体験が向上しました。

人気のMinimal MistakesテーマとPolyglotを統合する方法を示す[jekyll-minimal-mistakes-polyglot](https://github.com/PanderMusubi/jekyll-minimal-mistakes-polyglot)デモを提供してくれた[@PanderMusubi](https://github.com/PanderMusubi)に特別な感謝を。

このリリースを可能にしてくれたすべての貢献者に感謝します！
