---
layout: post
title: Polyglot 1.12 - 重定向改进和社区贡献
lang: zh-CN
description: Jekyll Polyglot 1.12.0 带来了改进的子语言重定向支持、回退页面检测和新的站点语言支持
---

Jekyll-Polyglot `1.12.0` 已发布！此版本专注于改进重定向处理，并包含多项社区贡献。

## 重定向改进

此版本包含了 Polyglot 重定向工作方式的重要改进：

- **PR #275**：重定向中的锚点标签保留 - 感谢 [@GruberMarkus](https://github.com/GruberMarkus) 的解决方案，重定向 URL 现在可以正确保留锚点标签，确保用户准确到达他们想要的位置。

- **PR #293**：jekyll-redirect-from 插件的子语言重定向支持 - 由 [@rathboma](https://github.com/rathboma) 建议，Polyglot 现在可以正确地在子语言之间限定 `redirect_from` frontmatter 的范围，防止重复重定向并确保非默认语言页面的正确路由。

## 使用 page.rendered_lang 检测回退页面

- **PR #283**：新的 `page.rendered_lang` 变量 - 由 [@rathboma](https://github.com/rathboma) 贡献，这个新的 liquid 变量可以让您检测页面何时作为回退呈现。当 `page.rendered_lang != site.active_lang` 时，您知道页面内容尚未翻译。

[/about](/about) 页面已更新，提供了如何最好地使用这个 `page.rendered_lang` 便利 liquid 变量的说明。

## 新语言支持

- **PR #280**：意大利语和土耳其语支持已添加到 Polyglot 文档站点，扩展了我们的多语言覆盖范围。

## 社区贡献

多位社区成员为项目贡献了改进：

- **PR #277**：更新了侧边栏富文本定义，改善了站点的多语言展示。

- **PR #288**：[@manabu-nakamura](https://github.com/manabu-nakamura) 贡献了日语富文本字符串，增强了日语体验。

特别感谢 [@PanderMusubi](https://github.com/PanderMusubi) 提供的 [jekyll-minimal-mistakes-polyglot](https://github.com/PanderMusubi/jekyll-minimal-mistakes-polyglot) 演示，展示了如何将 Polyglot 与流行的 Minimal Mistakes 主题集成。

感谢所有使此版本成为可能的贡献者！
