# 2024-06-18 Triage Log

Regressions outnumbered the improvements this week, but most of the regressions were deemed worth it for one reason or another. Overall, compiler performance didn't end up changing very much.

Triage done by **@rylev**.
Revision range: [b5b13568..c2932aaf](https://perf.rust-lang.org/?start=b5b13568fb5da4ac988bde370008d6134d3dfe6c&end=c2932aaf9d20acbc9259c762f1a06f8767c6f13f&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.0%]   | 63    |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.2%, 2.4%]   | 70    |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.2%, -0.2%] | 8     |
| Improvements ✅ <br /> (secondary) | -1.1% | [-5.2%, -0.2%] | 7     |
| All ❌✅ (primary)                 | 0.3%  | [-1.2%, 1.0%]  | 71    |


5 Regressions, 2 Improvements, 7 Mixed; 2 of them in rollups
58 artifact comparisons made in total

#### Regressions

Print `token::Interpolated` with token stream pretty printing. [#125174](https://github.com/rust-lang/rust/pull/125174) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3ea5e236ecb4c5f22437059f82d3915d311e4ec0&end=d0227c6a19c2d6e8dceb87c7a2776dc2b10d2a04&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.4%] | 9     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.4%] | 9     |
- No discussion of the perf run done before merging, so I asked the author/reviewer for their thoughts.
- It seems like most libc benchmarks were negatively impacted while no other benchmarks were. I'm not quite sure why that would be.


Add `TyCtxt::is_lang_item`, use it in the compiler [#126491](https://github.com/rust-lang/rust/pull/126491) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9239d3eb2b08bfdff30c86cdd9ce32687e488f5d&end=8217b412a235407243f2516ebc859e7b3af8345a&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.4%] | 10    |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.4%] | 10    |
- The change was deemed worth it despite the perf regression.


Indicate in `non_local_defs` lint that the macro needs to change [#125722](https://github.com/rust-lang/rust/pull/125722) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8217b412a235407243f2516ebc859e7b3af8345a&end=1d1356d0f67131f97b4f1631a24cd10d7dbcca42&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.2%] | 6     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.2%] | 6     |
- Only the diesel benchmark is affected, which is somewhat expected as it triggers the lint many many times (over 150 times).


Rollup of 6 pull requests [#126605](https://github.com/rust-lang/rust/pull/126605) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=11380368dc53d0b2fc3a627408818eff1973ce9a&end=04ab7b2be0db3e6787f5303285c6b2ee6279868d&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.3%, 0.4%] | 6     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.3%, 0.4%] | 6     |
- The benchmarks impacted seem to now swing wildly back and forth with every run so this isn't a perf regression per say.


Migrate `inaccessible-temp-dir`, `output-with-hyphens` and `issue-10971-temps-dir` `run-make` tests to `rmake` [#126279](https://github.com/rust-lang/rust/pull/126279) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=59e2c01c2217a01546222e4d9ff4e6695ee8a1db&end=c2932aaf9d20acbc9259c762f1a06f8767c6f13f&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.3%, 0.3%] | 6     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.3%, 0.3%] | 6     |
- This has to be noise, this PR only modified tests.


#### Improvements

Migrate `link-arg`, `link-dedup` and `issue-26092` `run-make` tests to `rmake` format [#125500](https://github.com/rust-lang/rust/pull/125500) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=04ab7b2be0db3e6787f5303285c6b2ee6279868d&end=59e2c01c2217a01546222e4d9ff4e6695ee8a1db&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-0.4%, -0.3%] | 6     |


Migrate `extern-flag-fun`, `incremental-debugger-visualiser` and `incremental-session-fail` `run-make` tests to `rmake.rs` [#126490](https://github.com/rust-lang/rust/pull/126490) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c2932aaf9d20acbc9259c762f1a06f8767c6f13f&end=67cfc3a558a54e351d14120099bf3158812b4130&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.3%] | 6     |


#### Mixed

Add `SingleUseConsts` mir-opt pass [#125910](https://github.com/rust-lang/rust/pull/125910) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b5b13568fb5da4ac988bde370008d6134d3dfe6c&end=fa1681c9f6a66f0240c46c98bfef6209c9d6df23&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -2.3% | [-2.9%, -1.7%] | 2     |
| All ❌✅ (primary)                 | -0.1% | [-0.4%, 0.4%]  | 6     |
- Wash on instruction counts, but nice binary size wins. The cycles improvements on tt-muncher is noise returning back to normal.


Make `ObligationEmittingRelation`s emit `Goal` rather than `Obligation` [#126130](https://github.com/rust-lang/rust/pull/126130) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9a7bf4ae947feddac27007cbe26d161f4ff5a910&end=76c73827dcd0b363e60b22c3cef64bde4171bf17&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 0.6%]   | 14    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 1     |
-  I'm asssuming the perf regression was deemed acceptable since these only occurred in stress tests?


Tait must be constrained if in sig [#113169](https://github.com/rust-lang/rust/pull/113169) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bdb1b7f5d9715cc96cb437134eff93fa229defd1&end=02c7a5921e3de5c2b3ecb2e0082c1dafce0729a1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.7%, 0.7%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.0% | [-0.4%, 0.7%]  | 3     |
- Probably noise + we need the fix 


Extend SCC construction to enable extra functionality  [#125069](https://github.com/rust-lang/rust/pull/125069) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8337ba9189de188e2ed417018af2bf17a57d51ac&end=8cf5101d77cd9eeb12751c563d8098aba2c604d0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.3%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.1%, 1.0%]   | 10    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.3%]   | 6     |
- The perf regressions were brought down since the first perf run, but there's still instruction count regressions in primary benchmarks here (albeit not large ones). I asked the author/reviewer for thoughts.


Remove superfluous UbChecks from `SliceIndex` methods [#126299](https://github.com/rust-lang/rust/pull/126299) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bc3618f31ea3866e6abea6995ec3979d12ffc65d&end=cd0c944b0750db887291bc25f20a05f8f31a8195&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.6%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.5%, 1.3%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.8%, -0.4%] | 7     |
| All ❌✅ (primary)                 | 0.1%  | [-0.6%, 0.6%]  | 7     |
- Perf is largely a wash and was expected to have far reach consequences since it changes how slices are codegened.


rustc_span: Optimize more hygiene operations using `Span::map_ctxt` [#126543](https://github.com/rust-lang/rust/pull/126543) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d7f6ebacee13b6c03623c4b74197280454ede8de&end=6b65c30f8e0f6c18aa5f32cbad869b1d036c7851&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 3     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.4%, -0.3%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.2%] | 3     |
| All ❌✅ (primary)                 | -0.8% | [-1.4%, 0.2%]  | 5     |
- Improvements outweigh the regressions which all seemed to be reversed sometime soon after this landed. 


Rollup of 3 pull requests [#126581](https://github.com/rust-lang/rust/pull/126581) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e23ae72ac7a393961886ea62df065ebb6def7d51&end=3baa20b783474330adb7ba7b3ddb02ac9facdf49&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.3%  | [1.3%, 1.3%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 6     |
- Regression might be noise (and isn't big enough to care about even if it isn't)

