#!/usr/bin/perl

use 5.010;
use strict;
use warnings;

use ExtUtils::MakeMaker;
use Dpkg::Changelog::Parse qw(changelog_parse);

my $dchfile = 'debian/changelog';
my $changelog = changelog_parse(file => $dchfile);
my $VERSION=$changelog->{Version};

$VERSION =~ s/~deb(.*)//;

WriteMakefile (
    'NAME' =>       'debian-security-support',
    'AUTHOR' =>     'Christoph Biedl <debian.axhn@manchmal.in-ulm.de>',
    'VERSION' =>    $VERSION,
    'EXE_FILES' =>  [ qw(
        check-support-status
        check-support-status.hook
    ) ],
);

sub MY::postamble {
    return <<__EOS__;

check-support-status: check-support-status.in
	TPAGERC=template-vars tpage --define VERSION=$VERSION check-support-status.in >check-support-status

__EOS__
}
