module Bench.Reverse
  ( benchReverse
  ) where

import Data.Bit
import qualified Data.Bit.ThreadSafe as TS
import Data.Bits
import qualified Data.Vector.Unboxed as U
import Test.Tasty.Bench

import Bench.Common

benchReverse :: Int -> Benchmark
benchReverse k = bgroup (show (1 `shiftL` k :: Int))
  [ bench labelBit    $ nf reverseBits    (randomVec Bit k)
  , bench labelBitTS  $ nf TS.reverseBits (randomVec TS.Bit k)
  , bench labelVector $ nf U.reverse      (randomVec id k)
  ]
