/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.URIResolver;
import jd.util.Arguments;
import jd.util.BadArgException;
import jd.util.StringUtil;
import jd.xml.util.UriResolver;
import jd.xml.util.XmlSource;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.model.build.ModelBuilderFactory;
import jd.xml.xpath.model.parse.ParseHandlerFactory;
import jd.xml.xpath.object.XObject;
import jd.xml.xslt.MessageListener;
import jd.xml.xslt.Transformation;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.XsltSecurityManager;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.parser.XsltParseException;
import jd.xml.xslt.trax.UriResolverAdapter;
import jd.xml.xslt.util.AssocStylesheetBuilder;
import jd.xml.xslt.util.VerboseLog;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class CommandLine {
    public static final int EXIT_OK = 0;
    public static final int EXIT_INCORRECT_USAGE = 1;
    public static final int EXIT_PARSE_ERROR = 2;
    public static final int EXIT_STYLESHEET_ERROR = 3;
    public static final int EXIT_RUNTIME_ERROR = 4;
    public static final String URI_STDIN = "-";
    public static final String URI_IDENTITY = "urn:jdxslt:identity";
    public static final String URI_MEMORY = "urn:jdxslt:memory";
    public static final String MBF_BIG = "jd.xml.xpath.model.build.big.BigModelBuilderFactory";
    public static final String MBF_NORMAL = "jd.xml.xpath.model.build.normal.NormalModelBuilderFactory";
    private int exitCode_ = 0;
    private int repeat_ = 1;
    private int warningLevel_ = 1;
    private boolean trace_;
    private boolean showErrorStack_;
    private boolean validate_;
    private String outfile_;
    private String inputSourceUri_;
    private Vector styleSourceUris_ = new Vector();
    private String proxyUrl_;
    private Hashtable params_;
    private UriResolver uriResolver_;
    private EntityResolver entityResolver_;
    private XsltSecurityManager securityMgr_;
    private MessageListener messageListener_;
    private Object inputParser_;
    private Object styleParser_;
    private VerboseLog verboseLog_;
    private OutputFormat outputFormat_;
    private String title_;
    private String media_;

    public void evaluateAndExit(String[] stringArray) {
        try {
            this.evaluate(stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(this.getExitCode());
    }

    public synchronized void evaluate(String[] stringArray) throws Exception {
        try {
            Arguments arguments = new Arguments(stringArray);
            if (arguments.hasMore() && this.parse(arguments)) {
                this.transform();
            } else {
                this.printHelp();
            }
        }
        catch (BadArgException badArgException) {
            this.exitCode_ = 1;
            System.err.println();
            System.err.println(badArgException.getMessage());
            System.err.println();
            if (badArgException.getException() != null) {
                badArgException.getException().printStackTrace();
            }
            throw badArgException;
        }
        catch (Exception exception) {
            Exception exception2;
            this.exitCode_ = 4;
            System.err.println();
            System.err.println("Transformation aborted.");
            System.err.println();
            if (exception instanceof SAXException) {
                SAXException sAXException;
                this.exitCode_ = 2;
                System.err.println("XML Parser error: " + exception.getMessage());
                if (exception instanceof SAXParseException) {
                    sAXException = (SAXParseException)exception;
                    this.printErrorInfo("uri", ((SAXParseException)sAXException).getSystemId());
                    this.printErrorInfo("line", String.valueOf(((SAXParseException)sAXException).getLineNumber()));
                    this.printErrorInfo("column", String.valueOf(((SAXParseException)sAXException).getColumnNumber()));
                }
                if ((sAXException = (SAXException)exception).getException() != null) {
                    exception2 = sAXException.getException();
                }
            } else if (exception instanceof XsltParseException) {
                this.exitCode_ = 3;
                XsltParseException xsltParseException = (XsltParseException)exception;
                System.err.println("XSLT Parser error: " + xsltParseException.getParserMessage());
                if (xsltParseException.getBaseUri() != null) {
                    this.printErrorInfo("uri", xsltParseException.getBaseUri());
                }
                if (xsltParseException.getNode() != null) {
                    this.printErrorNode(xsltParseException, xsltParseException.getNode());
                }
                if (xsltParseException.getException() != null) {
                    this.printErrorInfo("details", xsltParseException.getException().toString());
                }
            } else if (exception instanceof XsltException) {
                System.err.print("Stylesheet error: " + exception.getMessage());
                XsltException xsltException = (XsltException)exception;
                if (xsltException.getException() != null) {
                    System.err.print(" - " + this.getErrorMessage(xsltException.getException()));
                }
                System.err.println();
            } else if (exception instanceof FileNotFoundException) {
                System.err.println("File not found: " + exception.getMessage() + ".");
            } else if (exception instanceof IOException) {
                System.err.println("I/O Error: " + exception.getClass().getName() + " - " + this.getErrorMessage(exception));
            } else {
                System.err.println("Error: " + exception.getMessage());
            }
            System.err.println();
            System.err.println();
            if (this.showErrorStack_) {
                exception2.printStackTrace();
            }
            throw exception2;
        }
    }

    public int getExitCode() {
        return this.exitCode_;
    }

    private void printErrorNode(XsltParseException xsltParseException, XPathNode xPathNode) {
        if (xPathNode.getType() == 2) {
            this.printErrorNode(xsltParseException, xPathNode.getParent());
        }
        this.printErrorInfo(xPathNode.getTypeName().toLowerCase(), xsltParseException.getNodeInfo(xPathNode));
    }

    private void printErrorInfo(String string, String string2) {
        System.err.print("- ");
        System.err.print(StringUtil.fillupRight(string, 10));
        System.err.print("= ");
        System.err.println(string2);
    }

    private String getErrorMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = throwable.toString();
        }
        return string;
    }

    private boolean parse(Arguments arguments) throws BadArgException {
        boolean bl = true;
        boolean bl2 = false;
        while (arguments.hasMore()) {
            String string = arguments.next();
            if (string.charAt(0) == '-' && string.length() > 1) {
                if (!bl) {
                    throw new BadArgException("option '" + string + "' unexpected at this position");
                }
                if (this.parseOption(string, arguments)) continue;
                return false;
            }
            if (bl) {
                this.inputSourceUri_ = string;
                bl = false;
                bl2 = true;
                continue;
            }
            if (!bl2) continue;
            this.styleSourceUris_.addElement(string);
        }
        if (this.inputSourceUri_ == null) {
            throw new BadArgException("no input xml document specified");
        }
        return true;
    }

    private boolean parseOption(String string, Arguments arguments) {
        if (string.equalsIgnoreCase("-trace")) {
            this.trace_ = true;
        } else if (string.equalsIgnoreCase("-verbose")) {
            this.verboseLog_ = new VerboseLog();
        } else if (string.equalsIgnoreCase("-out")) {
            this.outfile_ = arguments.next("no output file specified");
        } else if (string.startsWith("-out:") && string.length() > 5) {
            String string2 = string.substring(5);
            String string3 = arguments.next("no value for output property specified");
            if (this.outputFormat_ == null) {
                this.outputFormat_ = new OutputFormat();
            }
            this.outputFormat_.setOption(string2, string3);
        } else if (string.equalsIgnoreCase("-param")) {
            String string4 = arguments.next("parameter name not specified");
            String string5 = arguments.next("parameter value not specified");
            if (this.params_ == null) {
                this.params_ = new Hashtable(10);
            }
            this.params_.put(string4, string5.trim());
        } else if (string.equalsIgnoreCase("-errorstack")) {
            this.showErrorStack_ = true;
        } else if (string.equalsIgnoreCase("-uriresolver")) {
            this.uriResolver_ = this.getUriResolver(arguments.next("class of UriResolver not specified"));
        } else if (string.equalsIgnoreCase("-entityresolver")) {
            this.entityResolver_ = this.getEntityResolver(arguments.next("class of EntityResolver not specified"));
        } else if (string.equalsIgnoreCase("-security")) {
            this.securityMgr_ = this.getSecurityManager(arguments.next("class of SecurityManager not specified"));
        } else if (string.equalsIgnoreCase("-parser") || string.equalsIgnoreCase("-parserxml") || string.equalsIgnoreCase("-parserxsl")) {
            Object object = this.getParser(arguments.next("class of parser not specified"));
            if (string.equalsIgnoreCase("-parserxml")) {
                this.inputParser_ = object;
            } else if (string.equalsIgnoreCase("-parserxsl")) {
                this.styleParser_ = object;
            } else {
                if (this.inputParser_ == null) {
                    this.inputParser_ = object;
                }
                if (this.styleParser_ == null) {
                    this.styleParser_ = object;
                }
            }
        } else if (string.equalsIgnoreCase("-media")) {
            this.media_ = arguments.next("media value not specified");
        } else if (string.equalsIgnoreCase("-msglistener")) {
            this.messageListener_ = this.getMessageListener(arguments.next("class of MessageListener not specified"));
        } else if (string.equalsIgnoreCase("-model")) {
            String string6 = arguments.next("class of ModelBuilderFactory not specified");
            if ("big".equals(string6)) {
                string6 = MBF_BIG;
            } else if ("normal".equals(string6)) {
                string6 = MBF_NORMAL;
            }
            ModelBuilderFactory.setInstance(this.getModelBuilderFactory(string6));
        } else if (string.startsWith("-model:") && string.length() > 7) {
            String string7 = string.substring(7);
            String string8 = arguments.next("no value for factory property specified");
            ModelBuilderFactory.getInstance().setProperty(string7, string8);
        } else if (string.equalsIgnoreCase("-title")) {
            this.title_ = arguments.next("title value not specified");
        } else if (string.equalsIgnoreCase("-repeat")) {
            String string9 = arguments.next("repeat value not specified");
            try {
                this.repeat_ = Integer.parseInt(string9);
            }
            catch (Exception exception) {
                throw new BadArgException("repeat value is not an integer", exception);
            }
        } else if (string.equalsIgnoreCase("-proxy")) {
            this.setProxy(arguments.next("proxy url not specified"));
        } else if (string.equalsIgnoreCase("-w0")) {
            this.warningLevel_ = 0;
        } else if (string.equalsIgnoreCase("-w1")) {
            this.warningLevel_ = 1;
        } else if (string.equalsIgnoreCase("-w2")) {
            this.warningLevel_ = 2;
        } else if (string.equalsIgnoreCase("-validate")) {
            this.validate_ = true;
        } else {
            if (string.equalsIgnoreCase("-help") || string.equals("-?")) {
                return false;
            }
            throw new BadArgException("unknown option '" + string + "'");
        }
        return true;
    }

    private void transform() throws Exception {
        Object object;
        if (this.inputParser_ == null || this.styleParser_ == null) {
            object = ParseHandlerFactory.createDefaultParser();
            if (this.inputParser_ == null) {
                this.inputParser_ = object;
            }
            if (this.styleParser_ == null) {
                this.styleParser_ = object;
            }
        }
        if (this.verboseLog_ != null) {
            this.printVerboseIntro();
        }
        object = this.getTransformation(this.styleSourceUris_);
        if (this.params_ != null) {
            this.setParameters((Transformation)object);
        }
        XmlSource xmlSource = this.getInputSource();
        XsltResult xsltResult = this.getResult();
        ((Transformation)object).transform(xmlSource, xsltResult, this.repeat_);
        if (this.verboseLog_ != null) {
            this.verboseLog_.println();
        }
    }

    protected abstract Transformation getTransformation(Vector var1) throws Exception;

    protected void setTransformationOptions(Transformation transformation) {
        transformation.setVerboseLog(this.verboseLog_);
        transformation.setUriResolver(this.uriResolver_);
        transformation.setWarningLevel(this.warningLevel_);
        transformation.setValidate(this.validate_);
        transformation.setSecurityManager(this.securityMgr_);
        transformation.setEntityResolver(this.entityResolver_);
        transformation.setTrace(this.trace_);
        if (this.messageListener_ != null) {
            transformation.setMessageListener(this.messageListener_);
        }
        if (this.outputFormat_ != null) {
            transformation.getOutputFormat().copyFrom(this.outputFormat_);
        }
    }

    private XmlSource getInputSource() throws BadArgException, IOException {
        XmlSource xmlSource = this.inputSourceUri_.equals(URI_STDIN) ? new XmlSource("", System.in, false) : this.getSource(this.inputSourceUri_);
        xmlSource.setParser(this.inputParser_);
        return xmlSource;
    }

    protected XmlSource getAssocStylesheetSource() throws Exception {
        AssocStylesheetBuilder assocStylesheetBuilder = new AssocStylesheetBuilder(this.title_, this.media_, null);
        XmlSource xmlSource = assocStylesheetBuilder.getStylesheetSource(this.getInputSource());
        if (xmlSource == null) {
            throw new BadArgException(this.inputSourceUri_ + " does not contain any xml-stylesheet processing instructions");
        }
        xmlSource.setParser(this.styleParser_);
        return xmlSource;
    }

    protected XmlSource getSource(String string) throws IOException, BadArgException {
        XmlSource xmlSource = null;
        if (this.uriResolver_ != null) {
            xmlSource = this.uriResolver_.resolveUri(string, "");
        }
        if (xmlSource == null) {
            if (string.startsWith("file:") || string.indexOf("://") == -1) {
                File file = new File(string);
                if (!file.exists()) {
                    throw new BadArgException("file '" + string + "' not found");
                }
                try {
                    xmlSource = new XmlSource(file);
                }
                catch (IOException iOException) {
                    throw new BadArgException("cannot access file '" + string + "'");
                }
            }
            try {
                xmlSource = new XmlSource(new URL(string));
            }
            catch (IOException iOException) {
                throw new BadArgException("invalid URL '" + string + "'");
            }
        }
        return xmlSource;
    }

    private XsltResult getResult() throws IOException {
        if (this.outfile_ == null) {
            return new XsltResult("", System.out, false);
        }
        if (this.outfile_.equals(URI_MEMORY)) {
            return new XsltResult("", new ByteArrayOutputStream(), false);
        }
        return new XsltResult(this.outfile_);
    }

    private XsltSecurityManager getSecurityManager(String string) throws BadArgException {
        try {
            return (XsltSecurityManager)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new BadArgException("cannot create the SecurityManager (" + exception + ")", exception);
        }
    }

    private MessageListener getMessageListener(String string) throws BadArgException {
        try {
            return (MessageListener)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new BadArgException("cannot create the MessageListener (" + exception + ")", exception);
        }
    }

    private UriResolver getUriResolver(String string) {
        Object obj;
        try {
            obj = Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new BadArgException("cannot create the UriResolver (" + exception + ")", exception);
        }
        if (obj instanceof UriResolver) {
            return (UriResolver)obj;
        }
        if (obj instanceof URIResolver) {
            return new UriResolverAdapter((URIResolver)obj);
        }
        throw new BadArgException("'" + string + "' is not a uri resolver class");
    }

    private EntityResolver getEntityResolver(String string) {
        try {
            return (EntityResolver)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new BadArgException("cannot create the EntityResolver (" + exception + ")", exception);
        }
    }

    private ModelBuilderFactory getModelBuilderFactory(String string) {
        try {
            return (ModelBuilderFactory)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new BadArgException("cannot create the ModelBuilderFactory (" + exception + ")", exception);
        }
    }

    private Object getParser(String string) {
        try {
            return Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new BadArgException("cannot create the parser (" + this.getErrorMessage(exception) + ")", exception);
        }
    }

    private void setParameters(Transformation transformation) {
        Enumeration enumeration = this.params_.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.params_.get(string);
            try {
                XObject xObject = this.getParamExpressionValue(string2);
                if (transformation.setParameter(string, xObject)) continue;
                System.err.println("Warning: parameter '" + string + "' is not defined");
            }
            catch (Exception exception) {
                throw new BadArgException("cannot evaluate parameter expression '" + string2 + "': " + exception);
            }
        }
    }

    protected abstract XObject getParamExpressionValue(String var1);

    private void setProxy(String string) {
        String string2;
        String string3;
        this.proxyUrl_ = string;
        String string4 = null;
        int n = string.indexOf("://");
        if (n == -1) {
            string3 = "http";
            string2 = string;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 3);
        }
        n = string2.lastIndexOf(":");
        if (n != -1) {
            string4 = string2.substring(n + 1);
            string2 = string2.substring(0, n);
        }
        System.getProperties().put(string3 + ".proxyHost", string2);
        if (string4 != null) {
            System.getProperties().put(string3 + ".proxyPort", string4);
        }
    }

    private void printVerboseIntro() {
        this.verboseLog_.println();
        this.printTransformationInfo(this.verboseLog_);
        this.verboseLog_.println();
        this.verboseLog_.printMessage("java vm", System.getProperty("java.vendor") + ", " + System.getProperty("java.version"));
        if (this.inputParser_ == this.styleParser_) {
            this.verboseLog_.printObject("parser", this.inputParser_);
        } else {
            this.verboseLog_.printObject("input parser", this.inputParser_);
            this.verboseLog_.printObject("style parser", this.styleParser_);
        }
        ModelBuilderFactory modelBuilderFactory = ModelBuilderFactory.getInstance();
        if (modelBuilderFactory != null) {
            this.verboseLog_.printObject("model", modelBuilderFactory);
        }
        if (this.securityMgr_ != null) {
            this.verboseLog_.printObject("security manager", this.securityMgr_);
        }
        if (this.uriResolver_ != null) {
            Object object = this.uriResolver_;
            if (this.uriResolver_ instanceof UriResolverAdapter) {
                object = ((UriResolverAdapter)object).getTraxResolver();
            }
            this.verboseLog_.printObject("uri resolver", object);
        }
        if (this.entityResolver_ != null) {
            this.verboseLog_.printObject("entity resolver", this.entityResolver_);
        }
    }

    protected abstract void printTransformationInfo(VerboseLog var1);

    protected abstract void printHelp();

    protected void printOptionsHelp(boolean bl, boolean bl2) {
        Vector vector = new Vector();
        this.printHelpLine("options:", null);
        this.printHelpLine("-entityresolver <cls>", "set a sax EntityResolver");
        this.printHelpLine("-errorstack", "show the java call stack in case of an error");
        this.printHelpLine("-help | -?", "print this help message");
        if (bl) {
            this.printHelpLine("-media <media>", "filter associated stylesheets by their media attribute");
        }
        this.printHelpLine("-model <class>", "set a ModelBuilderFactory");
        this.printHelpLine("-model:<key> <value>", "set the value of ModelBuilderFactory property");
        this.printHelpLine("-msglistener <class>", "set a MessageListener");
        if (vector.size() > 1) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                String string2 = "use the " + string + " tree model" + (i == 0 ? " (default)" : "");
                this.printHelpLine("-model " + string, string2);
            }
        }
        this.printHelpLine("-out <file>", "write the output to the file (default is System.out)");
        this.printHelpLine("-out:<key> <value>", "set the value of a xsl:output property");
        this.printHelpLine("-param <name> <expr>", "set the value of a toplevel parameter (expr is a context-");
        this.printHelpLine(null, "free XPath expression). Multiple parameters are allowed");
        this.printHelpLine("-parser <class>", "set a parser");
        if (bl) {
            this.printHelpLine("-parserxml <class>", "set a parser for input xml documents");
            this.printHelpLine("-parserxsl <class>", "set a parser for the stylesheet");
        }
        this.printHelpLine("-proxy <url>", "set a proxy host");
        this.printHelpLine("-repeat <number>", "repeat the transformation n times");
        this.printHelpLine("-security <class>", "set a XsltSecurityManager");
        if (bl) {
            this.printHelpLine("-title <title>", "filter associated stylesheets by their title attribute");
        }
        if (bl2) {
            this.printHelpLine("-trace", "create trace output");
        }
        this.printHelpLine("-uriresolver <class>", "set a UriResolver");
        this.printHelpLine("-validate", "validate xml documents");
        this.printHelpLine("-verbose", "turn on verbose mode to display transformation info");
        this.printHelpLine("-w0", "recover silently from recoverable errors");
        this.printHelpLine("-w1", "report recoverable errors and continue (default)");
        this.printHelpLine("-w2", "treat recoverable errors as fatal");
        System.out.println();
    }

    protected void printHelpLine(String string, String string2) {
        int n;
        if (string != null) {
            System.out.print(string);
            n = string.length();
        } else {
            n = 0;
        }
        if (string2 != null) {
            for (int i = n; i < 22; ++i) {
                System.out.print(' ');
            }
            System.out.print(string2);
        }
        System.out.println();
    }
}

