/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Synthetic;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.generic.BranchHandle;
import org.aspectj.apache.bcel.generic.BranchInstruction;
import org.aspectj.apache.bcel.generic.CPInstruction;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.CodeExceptionGen;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.InstructionTargeter;
import org.aspectj.apache.bcel.generic.LineNumberGen;
import org.aspectj.apache.bcel.generic.LineNumberTag;
import org.aspectj.apache.bcel.generic.LocalVariableGen;
import org.aspectj.apache.bcel.generic.LocalVariableInstruction;
import org.aspectj.apache.bcel.generic.LocalVariableTag;
import org.aspectj.apache.bcel.generic.MethodGen;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.Select;
import org.aspectj.apache.bcel.generic.Tag;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.generic.annotation.AnnotationGen;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.MemberImpl;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelMethod;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.ExceptionRange;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.Range;
import org.aspectj.weaver.bcel.Utility;
import org.aspectj.weaver.tools.Traceable;

public final class LazyMethodGen
implements Traceable {
    private static final int ACC_SYNTHETIC = 4096;
    private int accessFlags;
    private Type returnType;
    private final String name;
    private Type[] argumentTypes;
    private String[] declaredExceptions;
    private InstructionList body;
    private Attribute[] attributes;
    private List newAnnotations;
    private final LazyClassGen enclosingClass;
    private BcelMethod memberView;
    private AjAttribute.EffectiveSignatureAttribute effectiveSignature;
    int highestLineNumber = 0;
    public static boolean avoidUseOfBcelGenObjects = true;
    public static boolean checkedXsetOption = false;
    String fromFilename = null;
    private int maxLocals;
    private boolean canInline = true;
    private boolean isSynthetic = false;
    List matchedShadows;
    List matchedShadowTests;
    public ResolvedType definingType = null;
    private Method savedMethod = null;

    public LazyMethodGen(int accessFlags, Type returnType, String name, Type[] paramTypes, String[] declaredExceptions, LazyClassGen enclosingClass) {
        this.memberView = null;
        this.accessFlags = accessFlags;
        this.returnType = returnType;
        this.name = name;
        this.argumentTypes = paramTypes;
        this.declaredExceptions = declaredExceptions;
        if (!Modifier.isAbstract(accessFlags)) {
            this.body = new InstructionList();
            this.setMaxLocals(this.calculateMaxLocals());
        } else {
            this.body = null;
        }
        this.attributes = new Attribute[0];
        this.enclosingClass = enclosingClass;
        this.assertGoodBody();
        if (this.memberView != null && this.isAdviceMethod() && enclosingClass.getType().isAnnotationStyleAspect()) {
            this.canInline = false;
        }
    }

    private int calculateMaxLocals() {
        int ret = 0;
        if (!Modifier.isStatic(this.accessFlags)) {
            ++ret;
        }
        int len = this.argumentTypes.length;
        for (int i = 0; i < len; ++i) {
            ret += this.argumentTypes[i].getSize();
        }
        return ret;
    }

    public LazyMethodGen(Method m, LazyClassGen enclosingClass) {
        this.savedMethod = m;
        this.enclosingClass = enclosingClass;
        if (!m.isAbstract() && !m.isNative() && m.getCode() == null) {
            throw new RuntimeException("bad non-abstract method with no code: " + m + " on " + enclosingClass);
        }
        if ((m.isAbstract() || m.isNative()) && m.getCode() != null) {
            throw new RuntimeException("bad abstract method with code: " + m + " on " + enclosingClass);
        }
        this.memberView = new BcelMethod(enclosingClass.getBcelObjectType(), m);
        this.accessFlags = m.getAccessFlags();
        this.name = m.getName();
        if (this.memberView != null && this.isAdviceMethod() && enclosingClass.getType().isAnnotationStyleAspect()) {
            this.canInline = false;
        }
    }

    public boolean hasDeclaredLineNumberInfo() {
        return this.memberView != null && this.memberView.hasDeclarationLineNumberInfo();
    }

    public int getDeclarationLineNumber() {
        if (this.hasDeclaredLineNumberInfo()) {
            return this.memberView.getDeclarationLineNumber();
        }
        return -1;
    }

    public int getDeclarationOffset() {
        if (this.hasDeclaredLineNumberInfo()) {
            return this.memberView.getDeclarationOffset();
        }
        return 0;
    }

    public void addAnnotation(AnnotationX ax) {
        this.initialize();
        if (this.memberView == null) {
            if (this.newAnnotations == null) {
                this.newAnnotations = new ArrayList();
            }
            this.newAnnotations.add(ax);
        } else {
            this.memberView.addAnnotation(ax);
        }
    }

    public boolean hasAnnotation(UnresolvedType annotationTypeX) {
        this.initialize();
        if (this.memberView == null) {
            if (this.newAnnotations != null) {
                Iterator iter = this.newAnnotations.iterator();
                while (iter.hasNext()) {
                    AnnotationX element = (AnnotationX)iter.next();
                    if (!element.getBcelAnnotation().getTypeName().equals(annotationTypeX.getName())) continue;
                    return true;
                }
            }
            this.memberView = new BcelMethod(this.getEnclosingClass().getBcelObjectType(), this.getMethod());
            return this.memberView.hasAnnotation(annotationTypeX);
        }
        return this.memberView.hasAnnotation(annotationTypeX);
    }

    private void initialize() {
        if (this.returnType != null) {
            return;
        }
        if (!checkedXsetOption) {
            String s;
            Properties p = this.enclosingClass.getWorld().getExtraConfiguration();
            if (p != null && !(avoidUseOfBcelGenObjects = (s = p.getProperty("optimizeWithTags", "true")).equalsIgnoreCase("true"))) {
                this.enclosingClass.getWorld().getMessageHandler().handleMessage(MessageUtil.info("[optimizeWithTags=false] Disabling optimization to use Tags rather than Gens"));
            }
            checkedXsetOption = true;
        }
        MethodGen gen = new MethodGen(this.savedMethod, this.enclosingClass.getName(), this.enclosingClass.getConstantPoolGen(), avoidUseOfBcelGenObjects);
        this.returnType = gen.getReturnType();
        this.argumentTypes = gen.getArgumentTypes();
        this.declaredExceptions = gen.getExceptions();
        this.attributes = gen.getAttributes();
        this.maxLocals = gen.getMaxLocals();
        if (gen.isAbstract() || gen.isNative()) {
            this.body = null;
        } else {
            this.body = gen.getInstructionList();
            this.unpackHandlers(gen);
            if (avoidUseOfBcelGenObjects) {
                this.ensureAllLineNumberSetup(gen);
                this.highestLineNumber = gen.getHighestlinenumber();
            } else {
                this.unpackLineNumbers(gen);
                this.unpackLocals(gen);
            }
        }
        this.assertGoodBody();
    }

    private void unpackHandlers(MethodGen gen) {
        CodeExceptionGen[] exns = gen.getExceptionHandlers();
        if (exns != null) {
            int len = exns.length;
            int priority = len - 1;
            int i = 0;
            while (i < len) {
                CodeExceptionGen exn = exns[i];
                InstructionHandle start = Range.genStart(this.body, this.getOutermostExceptionStart(exn.getStartPC()));
                InstructionHandle end = Range.genEnd(this.body, this.getOutermostExceptionEnd(exn.getEndPC()));
                ExceptionRange er = new ExceptionRange(this.body, exn.getCatchType() == null ? null : BcelWorld.fromBcel(exn.getCatchType()), priority);
                er.associateWithTargets(start, end, exn.getHandlerPC());
                exn.setStartPC(null);
                exn.setEndPC(null);
                exn.setHandlerPC(null);
                ++i;
                --priority;
            }
            gen.removeExceptionHandlers();
        }
    }

    private InstructionHandle getOutermostExceptionStart(InstructionHandle ih) {
        while (ExceptionRange.isExceptionStart(ih.getPrev())) {
            ih = ih.getPrev();
        }
        return ih;
    }

    private InstructionHandle getOutermostExceptionEnd(InstructionHandle ih) {
        while (ExceptionRange.isExceptionEnd(ih.getNext())) {
            ih = ih.getNext();
        }
        return ih;
    }

    private void unpackLineNumbers(MethodGen gen) {
        LineNumberTag lr = null;
        for (InstructionHandle ih = this.body.getStart(); ih != null; ih = ih.getNext()) {
            InstructionTargeter[] targeters = ih.getTargeters();
            if (targeters != null) {
                for (int i = targeters.length - 1; i >= 0; --i) {
                    InstructionTargeter targeter = targeters[i];
                    if (!(targeter instanceof LineNumberGen)) continue;
                    LineNumberGen lng = (LineNumberGen)targeter;
                    lng.updateTarget(ih, null);
                    int lineNumber = lng.getSourceLine();
                    if (this.highestLineNumber < lineNumber) {
                        this.highestLineNumber = lineNumber;
                    }
                    lr = new LineNumberTag(lineNumber);
                }
            }
            if (lr == null) continue;
            ih.addTargeter(lr);
        }
        gen.removeLineNumbers();
    }

    private void ensureAllLineNumberSetup(MethodGen gen) {
        LineNumberTag lr = null;
        boolean skip = false;
        for (InstructionHandle ih = this.body.getStart(); ih != null; ih = ih.getNext()) {
            InstructionTargeter[] targeters = ih.getTargeters();
            skip = false;
            if (targeters != null) {
                for (int i = targeters.length - 1; i >= 0; --i) {
                    InstructionTargeter targeter = targeters[i];
                    if (!(targeter instanceof LineNumberTag)) continue;
                    lr = (LineNumberTag)targeter;
                    skip = true;
                }
            }
            if (lr == null || skip) continue;
            ih.addTargeter(lr);
        }
    }

    private void unpackLocals(MethodGen gen) {
        HashSet<LocalVariableTag> locals = new HashSet<LocalVariableTag>();
        for (InstructionHandle ih = this.body.getStart(); ih != null; ih = ih.getNext()) {
            InstructionTargeter[] targeters = ih.getTargeters();
            ArrayList<LocalVariableTag> ends = new ArrayList<LocalVariableTag>(0);
            if (targeters != null) {
                for (int i = targeters.length - 1; i >= 0; --i) {
                    InstructionTargeter targeter = targeters[i];
                    if (!(targeter instanceof LocalVariableGen)) continue;
                    LocalVariableGen lng = (LocalVariableGen)targeter;
                    LocalVariableTag lr = new LocalVariableTag(lng.getType().getSignature(), lng.getName(), lng.getIndex(), lng.getStart().getPosition());
                    if (lng.getStart() == ih) {
                        locals.add(lr);
                        continue;
                    }
                    ends.add(lr);
                }
            }
            Iterator i = locals.iterator();
            while (i.hasNext()) {
                ih.addTargeter((LocalVariableTag)i.next());
            }
            locals.removeAll(ends);
        }
        gen.removeLocalVariables();
    }

    public int allocateLocal(Type type) {
        return this.allocateLocal(type.getSize());
    }

    public int allocateLocal(int slots) {
        int max = this.getMaxLocals();
        this.setMaxLocals(max + slots);
        return max;
    }

    public Method getMethod() {
        if (this.savedMethod != null) {
            return this.savedMethod;
        }
        try {
            MethodGen gen = this.pack();
            return gen.getMethod();
        }
        catch (ClassGenException e) {
            this.enclosingClass.getBcelObjectType().getResolvedTypeX().getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("problemGeneratingMethod", this.getClassName(), this.getName(), e.getMessage()), this.getMemberView() == null ? null : this.getMemberView().getSourceLocation(), null);
            this.body = null;
            MethodGen gen = this.pack();
            return gen.getMethod();
        }
    }

    public void markAsChanged() {
        this.initialize();
        this.savedMethod = null;
    }

    public String toString() {
        AjAttribute.WeaverVersionInfo weaverVersion = this.enclosingClass.getBcelObjectType().getWeaverVersionAttribute();
        return this.toLongString(weaverVersion);
    }

    public String toShortString() {
        int i;
        String access = org.aspectj.apache.bcel.classfile.Utility.accessToString(this.getAccessFlags());
        StringBuffer buf = new StringBuffer();
        if (!access.equals("")) {
            buf.append(access);
            buf.append(" ");
        }
        buf.append(org.aspectj.apache.bcel.classfile.Utility.signatureToString(this.getReturnType().getSignature(), true));
        buf.append(" ");
        buf.append(this.getName());
        buf.append("(");
        int len = this.argumentTypes.length;
        if (len > 0) {
            buf.append(org.aspectj.apache.bcel.classfile.Utility.signatureToString(this.argumentTypes[0].getSignature(), true));
            for (i = 1; i < this.argumentTypes.length; ++i) {
                buf.append(", ");
                buf.append(org.aspectj.apache.bcel.classfile.Utility.signatureToString(this.argumentTypes[i].getSignature(), true));
            }
        }
        buf.append(")");
        int n = len = this.declaredExceptions != null ? this.declaredExceptions.length : 0;
        if (len > 0) {
            buf.append(" throws ");
            buf.append(this.declaredExceptions[0]);
            for (i = 1; i < this.declaredExceptions.length; ++i) {
                buf.append(", ");
                buf.append(this.declaredExceptions[i]);
            }
        }
        return buf.toString();
    }

    public String toLongString(AjAttribute.WeaverVersionInfo weaverVersion) {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        this.print(new PrintStream(s), weaverVersion);
        return new String(s.toByteArray());
    }

    public void print(AjAttribute.WeaverVersionInfo weaverVersion) {
        this.print(System.out, weaverVersion);
    }

    public void print(PrintStream out, AjAttribute.WeaverVersionInfo weaverVersion) {
        out.print("  " + this.toShortString());
        this.printAspectAttributes(out, weaverVersion);
        InstructionList body = this.getBody();
        if (body == null) {
            out.println(";");
            return;
        }
        out.println(":");
        new BodyPrinter(out).run();
        out.println("  end " + this.toShortString());
    }

    private void printAspectAttributes(PrintStream out, AjAttribute.WeaverVersionInfo weaverVersion) {
        List as;
        ISourceContext context = null;
        if (this.enclosingClass != null && this.enclosingClass.getType() != null) {
            context = this.enclosingClass.getType().getSourceContext();
        }
        if (!(as = BcelAttributes.readAjAttributes(this.getClassName(), this.attributes, context, null, weaverVersion)).isEmpty()) {
            out.println("    " + as.get(0));
        }
    }

    static LocalVariableTag getLocalVariableTag(InstructionHandle ih, int index) {
        InstructionTargeter[] targeters = ih.getTargeters();
        if (targeters == null) {
            return null;
        }
        for (int i = targeters.length - 1; i >= 0; --i) {
            LocalVariableTag lvt;
            InstructionTargeter t = targeters[i];
            if (!(t instanceof LocalVariableTag) || (lvt = (LocalVariableTag)t).getSlot() != index) continue;
            return lvt;
        }
        return null;
    }

    static int getLineNumber(InstructionHandle ih, int prevLine) {
        InstructionTargeter[] targeters = ih.getTargeters();
        if (targeters == null) {
            return prevLine;
        }
        for (int i = targeters.length - 1; i >= 0; --i) {
            InstructionTargeter t = targeters[i];
            if (!(t instanceof LineNumberTag)) continue;
            return ((LineNumberTag)t).getLineNumber();
        }
        return prevLine;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getAccessFlags());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getAccessFlags());
    }

    public boolean isBridgeMethod() {
        return (this.getAccessFlags() & 0x40) != 0;
    }

    public void addExceptionHandler(InstructionHandle start, InstructionHandle end, InstructionHandle handlerStart, ObjectType catchType, boolean highPriority) {
        InstructionHandle start1 = Range.genStart(this.body, start);
        InstructionHandle end1 = Range.genEnd(this.body, end);
        ExceptionRange er = new ExceptionRange(this.body, catchType == null ? null : BcelWorld.fromBcel(catchType), highPriority);
        er.associateWithTargets(start1, end1, handlerStart);
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public int getAccessFlagsWithoutSynchronized() {
        if (this.isSynchronized()) {
            return this.accessFlags - 32;
        }
        return this.accessFlags;
    }

    public boolean isSynchronized() {
        return (this.accessFlags & 0x20) != 0;
    }

    public void setAccessFlags(int newFlags) {
        this.accessFlags = newFlags;
    }

    public Type[] getArgumentTypes() {
        this.initialize();
        return this.argumentTypes;
    }

    public LazyClassGen getEnclosingClass() {
        return this.enclosingClass;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public String getName() {
        return this.name;
    }

    public Type getReturnType() {
        this.initialize();
        return this.returnType;
    }

    public void setMaxLocals(int maxLocals) {
        this.maxLocals = maxLocals;
    }

    public InstructionList getBody() {
        this.markAsChanged();
        return this.body;
    }

    public boolean hasBody() {
        if (this.savedMethod != null) {
            return this.savedMethod.getCode() != null;
        }
        return this.body != null;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public String[] getDeclaredExceptions() {
        return this.declaredExceptions;
    }

    public String getClassName() {
        return this.enclosingClass.getName();
    }

    public MethodGen pack() {
        int i;
        this.forceSyntheticForAjcMagicMembers();
        int flags = this.getAccessFlags();
        if (this.enclosingClass.getWorld().isJoinpointSynchronizationEnabled() && this.enclosingClass.getWorld().areSynchronizationPointcutsInUse()) {
            flags = this.getAccessFlagsWithoutSynchronized();
        }
        MethodGen gen = new MethodGen(flags, this.getReturnType(), this.getArgumentTypes(), null, this.getName(), this.getEnclosingClass().getName(), new InstructionList(), this.getEnclosingClass().getConstantPoolGen());
        int len = this.declaredExceptions.length;
        for (i = 0; i < len; ++i) {
            gen.addException(this.declaredExceptions[i]);
        }
        len = this.attributes.length;
        for (i = 0; i < len; ++i) {
            gen.addAttribute(this.attributes[i]);
        }
        if (this.newAnnotations != null) {
            Iterator iter = this.newAnnotations.iterator();
            while (iter.hasNext()) {
                AnnotationX element = (AnnotationX)iter.next();
                gen.addAnnotation(new AnnotationGen(element.getBcelAnnotation(), gen.getConstantPool(), true));
            }
        }
        if (this.memberView != null && this.memberView.getAnnotations() != null && this.memberView.getAnnotations().length != 0) {
            AnnotationX[] ans = this.memberView.getAnnotations();
            int len2 = ans.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                Annotation a = ans[i2].getBcelAnnotation();
                gen.addAnnotation(new AnnotationGen(a, gen.getConstantPool(), true));
            }
        }
        if (this.isSynthetic) {
            if (this.enclosingClass.getWorld().isInJava5Mode()) {
                gen.setModifiers(gen.getModifiers() | 0x1000);
            }
            ConstantPoolGen cpg = gen.getConstantPool();
            int index = cpg.addUtf8("Synthetic");
            gen.addAttribute(new Synthetic(index, 0, new byte[0], cpg.getConstantPool()));
        }
        if (this.hasBody()) {
            this.packBody(gen);
            gen.setMaxLocals();
            gen.setMaxStack();
        } else {
            gen.setInstructionList(null);
        }
        return gen;
    }

    private void forceSyntheticForAjcMagicMembers() {
        if (NameMangler.isSyntheticMethod(this.getName(), this.inAspect())) {
            this.makeSynthetic();
        }
    }

    private boolean inAspect() {
        BcelObjectType objectType = this.enclosingClass.getBcelObjectType();
        return objectType == null ? false : objectType.isAspect();
    }

    public void makeSynthetic() {
        this.isSynthetic = true;
    }

    public void packBody(MethodGen gen) {
        int lineNumberOffset;
        InstructionList fresh = gen.getInstructionList();
        Map map = this.copyAllInstructionsExceptRangeInstructionsInto(fresh);
        InstructionHandle oldInstructionHandle = this.getBody().getStart();
        InstructionHandle newInstructionHandle = fresh.getStart();
        LinkedList exceptionList = new LinkedList();
        HashMap<LocalVariableTag, LVPosition> localVariables = new HashMap<LocalVariableTag, LVPosition>();
        int currLine = -1;
        int n = lineNumberOffset = this.fromFilename == null ? 0 : this.getEnclosingClass().getSourceDebugExtensionOffset(this.fromFilename);
        while (oldInstructionHandle != null) {
            InstructionTargeter[] targeters;
            if (map.get(oldInstructionHandle) == null) {
                this.handleRangeInstruction(oldInstructionHandle, exceptionList);
                oldInstructionHandle = oldInstructionHandle.getNext();
                continue;
            }
            Instruction oldInstruction = oldInstructionHandle.getInstruction();
            Instruction newInstruction = newInstructionHandle.getInstruction();
            if (oldInstruction instanceof BranchInstruction) {
                this.handleBranchInstruction(map, oldInstruction, newInstruction);
            }
            if ((targeters = oldInstructionHandle.getTargeters()) != null) {
                for (int k = targeters.length - 1; k >= 0; --k) {
                    InstructionTargeter targeter = targeters[k];
                    if (targeter instanceof LineNumberTag) {
                        int line = ((LineNumberTag)targeter).getLineNumber();
                        if (line == currLine) continue;
                        gen.addLineNumber(newInstructionHandle, line + lineNumberOffset);
                        currLine = line;
                        continue;
                    }
                    if (!(targeter instanceof LocalVariableTag)) continue;
                    LocalVariableTag lvt = (LocalVariableTag)targeter;
                    LVPosition p = (LVPosition)localVariables.get(lvt);
                    if (p == null) {
                        LVPosition newp = new LVPosition();
                        newp.start = newp.end = newInstructionHandle;
                        localVariables.put(lvt, newp);
                        continue;
                    }
                    p.end = newInstructionHandle;
                }
            }
            oldInstructionHandle = oldInstructionHandle.getNext();
            newInstructionHandle = newInstructionHandle.getNext();
        }
        this.addExceptionHandlers(gen, map, exceptionList);
        this.addLocalVariables(gen, localVariables);
        if (gen.getLineNumbers().length == 0) {
            gen.addLineNumber(gen.getInstructionList().getStart(), 1);
        }
    }

    private void addLocalVariables(MethodGen gen, Map localVariables) {
        gen.removeLocalVariables();
        HashMap duplicatedLocalMap = new HashMap();
        Iterator iter = localVariables.keySet().iterator();
        while (iter.hasNext()) {
            LocalVariableTag tag = (LocalVariableTag)iter.next();
            LVPosition lvpos = (LVPosition)localVariables.get(tag);
            InstructionHandle start = lvpos.start;
            HashSet<Integer> slots = (HashSet<Integer>)duplicatedLocalMap.get(start);
            if (slots == null) {
                slots = new HashSet<Integer>();
                duplicatedLocalMap.put(start, slots);
            } else if (slots.contains(new Integer(tag.getSlot()))) continue;
            slots.add(new Integer(tag.getSlot()));
            Type t = tag.getRealType();
            if (t == null) {
                t = BcelWorld.makeBcelType(UnresolvedType.forSignature(tag.getType()));
            }
            gen.addLocalVariable(tag.getName(), t, tag.getSlot(), start, lvpos.end);
        }
    }

    private void addExceptionHandlers(MethodGen gen, Map map, LinkedList exnList) {
        Iterator iter = exnList.iterator();
        while (iter.hasNext()) {
            ExceptionRange r = (ExceptionRange)iter.next();
            if (r.isEmpty()) continue;
            gen.addExceptionHandler(LazyMethodGen.remap(r.getRealStart(), map), LazyMethodGen.remap(r.getRealEnd(), map), LazyMethodGen.remap(r.getHandler(), map), r.getCatchType() == null ? null : (ObjectType)BcelWorld.makeBcelType(r.getCatchType()));
        }
    }

    private void handleBranchInstruction(Map map, Instruction oldInstruction, Instruction newInstruction) {
        BranchInstruction oldBranchInstruction = (BranchInstruction)oldInstruction;
        BranchInstruction newBranchInstruction = (BranchInstruction)newInstruction;
        InstructionHandle oldTarget = oldBranchInstruction.getTarget();
        newBranchInstruction.setTarget(LazyMethodGen.remap(oldTarget, map));
        if (oldBranchInstruction instanceof Select) {
            InstructionHandle[] oldTargets = ((Select)oldBranchInstruction).getTargets();
            InstructionHandle[] newTargets = ((Select)newBranchInstruction).getTargets();
            for (int k = oldTargets.length - 1; k >= 0; --k) {
                newTargets[k] = LazyMethodGen.remap(oldTargets[k], map);
                newTargets[k].addTargeter(newBranchInstruction);
            }
        }
    }

    private void handleRangeInstruction(InstructionHandle ih, LinkedList exnList) {
        ExceptionRange er;
        Range r = Range.getRange(ih);
        if (r instanceof ExceptionRange && (er = (ExceptionRange)r).getStart() == ih && !er.isEmpty()) {
            LazyMethodGen.insertHandler(er, exnList);
        }
    }

    private Map copyAllInstructionsExceptRangeInstructionsInto(InstructionList intoList) {
        HashMap<InstructionHandle, InstructionHandle> map = new HashMap<InstructionHandle, InstructionHandle>();
        for (InstructionHandle ih = this.getBody().getStart(); ih != null; ih = ih.getNext()) {
            if (Range.isRangeHandle(ih)) continue;
            Instruction i = ih.getInstruction();
            Instruction c = Utility.copyInstruction(i);
            if (c instanceof BranchInstruction) {
                map.put(ih, intoList.append((BranchInstruction)c));
                continue;
            }
            map.put(ih, intoList.append(c));
        }
        return map;
    }

    private static InstructionHandle remap(InstructionHandle ih, Map map) {
        Object ret;
        while ((ret = map.get(ih)) == null) {
            ih = ih.getNext();
        }
        return (InstructionHandle)ret;
    }

    static void insertHandler(ExceptionRange fresh, LinkedList l) {
        ListIterator<ExceptionRange> iter = l.listIterator();
        while (iter.hasNext()) {
            ExceptionRange r = (ExceptionRange)iter.next();
            if (fresh.getPriority() < r.getPriority()) continue;
            iter.previous();
            iter.add(fresh);
            return;
        }
        l.add(fresh);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getAccessFlags());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getAccessFlags());
    }

    public boolean isDefault() {
        return !this.isProtected() && !this.isPrivate() && !this.isPublic();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getAccessFlags());
    }

    public void assertGoodBody() {
    }

    public static void assertGoodBody(InstructionList il, String from) {
    }

    private static void assertGoodHandle(InstructionHandle ih, Set body, Stack ranges, String from) {
        Instruction inst = ih.getInstruction();
        if (inst instanceof BranchInstruction ^ ih instanceof BranchHandle) {
            throw new BCException("bad instruction/handle pair in " + from);
        }
        if (Range.isRangeHandle(ih)) {
            LazyMethodGen.assertGoodRangeHandle(ih, body, ranges, from);
        } else if (inst instanceof BranchInstruction) {
            LazyMethodGen.assertGoodBranchInstruction((BranchHandle)ih, (BranchInstruction)inst, body, ranges, from);
        }
    }

    private static void assertGoodBranchInstruction(BranchHandle ih, BranchInstruction inst, Set body, Stack ranges, String from) {
        if (ih.getTarget() != inst.getTarget()) {
            throw new BCException("bad branch instruction/handle pair in " + from);
        }
        InstructionHandle target = ih.getTarget();
        LazyMethodGen.assertInBody(target, body, from);
        LazyMethodGen.assertTargetedBy(target, inst, from);
        if (inst instanceof Select) {
            Select sel = (Select)inst;
            InstructionHandle[] itargets = sel.getTargets();
            for (int k = itargets.length - 1; k >= 0; --k) {
                LazyMethodGen.assertInBody(itargets[k], body, from);
                LazyMethodGen.assertTargetedBy(itargets[k], inst, from);
            }
        }
    }

    private static void assertInBody(Object ih, Set body, String from) {
        if (!body.contains(ih)) {
            throw new BCException("thing not in body in " + from);
        }
    }

    private static void assertGoodRangeHandle(InstructionHandle ih, Set body, Stack ranges, String from) {
        Range r = LazyMethodGen.getRangeAndAssertExactlyOne(ih, from);
        LazyMethodGen.assertGoodRange(r, body, from);
        if (r.getStart() == ih) {
            ranges.push(r);
        } else if (r.getEnd() == ih) {
            if (ranges.peek() != r) {
                throw new BCException("bad range inclusion in " + from);
            }
            ranges.pop();
        }
    }

    private static void assertGoodRange(Range r, Set body, String from) {
        LazyMethodGen.assertInBody(r.getStart(), body, from);
        LazyMethodGen.assertRangeHandle(r.getStart(), from);
        LazyMethodGen.assertTargetedBy(r.getStart(), r, from);
        LazyMethodGen.assertInBody(r.getEnd(), body, from);
        LazyMethodGen.assertRangeHandle(r.getEnd(), from);
        LazyMethodGen.assertTargetedBy(r.getEnd(), r, from);
        if (r instanceof ExceptionRange) {
            ExceptionRange er = (ExceptionRange)r;
            LazyMethodGen.assertInBody(er.getHandler(), body, from);
            LazyMethodGen.assertTargetedBy(er.getHandler(), r, from);
        }
    }

    private static void assertRangeHandle(InstructionHandle ih, String from) {
        if (!Range.isRangeHandle(ih)) {
            throw new BCException("bad range handle " + ih + " in " + from);
        }
    }

    private static void assertTargetedBy(InstructionHandle target, InstructionTargeter targeter, String from) {
        InstructionTargeter[] ts = target.getTargeters();
        if (ts == null) {
            throw new BCException("bad targeting relationship in " + from);
        }
        for (int i = ts.length - 1; i >= 0; --i) {
            if (ts[i] != targeter) continue;
            return;
        }
        throw new RuntimeException("bad targeting relationship in " + from);
    }

    private static void assertTargets(InstructionTargeter targeter, InstructionHandle target, String from) {
        if (targeter instanceof Range) {
            Range r = (Range)targeter;
            if (r.getStart() == target || r.getEnd() == target) {
                return;
            }
            if (r instanceof ExceptionRange && ((ExceptionRange)r).getHandler() == target) {
                return;
            }
        } else if (targeter instanceof BranchInstruction) {
            BranchInstruction bi = (BranchInstruction)targeter;
            if (bi.getTarget() == target) {
                return;
            }
            if (targeter instanceof Select) {
                Select sel = (Select)targeter;
                InstructionHandle[] itargets = sel.getTargets();
                for (int k = itargets.length - 1; k >= 0; --k) {
                    if (itargets[k] != target) continue;
                    return;
                }
            }
        } else if (targeter instanceof Tag) {
            return;
        }
        throw new BCException(targeter + " doesn't target " + target + " in " + from);
    }

    private static Range getRangeAndAssertExactlyOne(InstructionHandle ih, String from) {
        Range ret = null;
        InstructionTargeter[] ts = ih.getTargeters();
        if (ts == null) {
            throw new BCException("range handle with no range in " + from);
        }
        for (int i = ts.length - 1; i >= 0; --i) {
            if (!(ts[i] instanceof Range)) continue;
            if (ret != null) {
                throw new BCException("range handle with multiple ranges in " + from);
            }
            ret = (Range)ts[i];
        }
        if (ret == null) {
            throw new BCException("range handle with no range in " + from);
        }
        return ret;
    }

    private static void assertGoodTargeter(InstructionTargeter t, InstructionHandle ih, Set body, String from) {
        LazyMethodGen.assertTargets(t, ih, from);
        if (t instanceof Range) {
            LazyMethodGen.assertGoodRange((Range)t, body, from);
        } else if (t instanceof BranchInstruction) {
            LazyMethodGen.assertInBody(t, body, from);
        }
    }

    boolean isAdviceMethod() {
        return this.memberView.getAssociatedShadowMunger() != null;
    }

    boolean isAjSynthetic() {
        if (this.memberView == null) {
            return true;
        }
        return this.memberView.isAjSynthetic();
    }

    boolean isSynthetic() {
        if (this.memberView == null) {
            return false;
        }
        return this.memberView.isSynthetic();
    }

    public ISourceLocation getSourceLocation() {
        if (this.memberView != null) {
            return this.memberView.getSourceLocation();
        }
        return null;
    }

    public AjAttribute.EffectiveSignatureAttribute getEffectiveSignature() {
        if (this.effectiveSignature != null) {
            return this.effectiveSignature;
        }
        return this.memberView.getEffectiveSignature();
    }

    public void setEffectiveSignature(ResolvedMember member, Shadow.Kind kind, boolean shouldWeave) {
        this.effectiveSignature = new AjAttribute.EffectiveSignatureAttribute(member, kind, shouldWeave);
    }

    public String getSignature() {
        if (this.memberView != null) {
            return this.memberView.getSignature();
        }
        return MemberImpl.typesToSignature(BcelWorld.fromBcel(this.getReturnType()), BcelWorld.fromBcel(this.getArgumentTypes()), false);
    }

    public String getParameterSignature() {
        if (this.memberView != null) {
            return this.memberView.getParameterSignature();
        }
        return MemberImpl.typesToSignature(BcelWorld.fromBcel(this.getArgumentTypes()));
    }

    public BcelMethod getMemberView() {
        return this.memberView;
    }

    public void forcePublic() {
        this.markAsChanged();
        this.accessFlags = Utility.makePublic(this.accessFlags);
    }

    public boolean getCanInline() {
        return this.canInline;
    }

    public void setCanInline(boolean canInline) {
        this.canInline = canInline;
    }

    public void addAttribute(Attribute attr) {
        Attribute[] newAttributes = new Attribute[this.attributes.length + 1];
        System.arraycopy(this.attributes, 0, newAttributes, 0, this.attributes.length);
        newAttributes[this.attributes.length] = attr;
        this.attributes = newAttributes;
    }

    public String toTraceString() {
        return this.toShortString();
    }

    private static class LVPosition {
        InstructionHandle start = null;
        InstructionHandle end = null;

        private LVPosition() {
        }
    }

    private class BodyPrinter {
        Map prefixMap = new HashMap();
        Map suffixMap = new HashMap();
        Map labelMap = new HashMap();
        InstructionList body;
        PrintStream out;
        ConstantPool pool;
        List ranges;
        static final int BODY_INDENT = 4;
        static final int CODE_INDENT = 16;

        BodyPrinter(PrintStream out) {
            this.pool = LazyMethodGen.this.enclosingClass.getConstantPoolGen().getConstantPool();
            this.body = LazyMethodGen.this.getBody();
            this.out = out;
        }

        void run() {
            this.assignLabels();
            this.print();
        }

        void assignLabels() {
            LinkedList exnTable = new LinkedList();
            String pendingLabel = null;
            int lcounter = 0;
            for (InstructionHandle ih = this.body.getStart(); ih != null; ih = ih.getNext()) {
                InstructionTargeter[] targeters = ih.getTargeters();
                if (targeters != null) {
                    for (int i = targeters.length - 1; i >= 0; --i) {
                        InstructionTargeter t = targeters[i];
                        if (t instanceof ExceptionRange) {
                            ExceptionRange r = (ExceptionRange)t;
                            if (r.getStart() != ih) continue;
                            LazyMethodGen.insertHandler(r, exnTable);
                            continue;
                        }
                        if (!(t instanceof BranchInstruction) || pendingLabel != null) continue;
                        pendingLabel = "L" + lcounter++;
                    }
                }
                if (pendingLabel == null) continue;
                this.labelMap.put(ih, pendingLabel);
                if (Range.isRangeHandle(ih)) continue;
                pendingLabel = null;
            }
            int ecounter = 0;
            Iterator i = exnTable.iterator();
            while (i.hasNext()) {
                ExceptionRange er = (ExceptionRange)i.next();
                String exceptionLabel = "E" + ecounter++;
                this.labelMap.put(Range.getRealStart(er.getHandler()), exceptionLabel);
                this.labelMap.put(er.getHandler(), exceptionLabel);
            }
        }

        void print() {
            int depth = 0;
            int currLine = -1;
            block0: for (InstructionHandle ih = this.body.getStart(); ih != null; ih = ih.getNext()) {
                if (Range.isRangeHandle(ih)) {
                    Range r = Range.getRange(ih);
                    InstructionHandle xx = r.getStart();
                    while (Range.isRangeHandle(xx)) {
                        if (xx == r.getEnd()) continue block0;
                        xx = xx.getNext();
                    }
                    if (r.getStart() == ih) {
                        this.printRangeString(r, depth++);
                        continue;
                    }
                    if (r.getEnd() != ih) {
                        throw new RuntimeException("bad");
                    }
                    this.printRangeString(r, --depth);
                    continue;
                }
                this.printInstruction(ih, depth);
                int line = LazyMethodGen.getLineNumber(ih, currLine);
                if (line != currLine) {
                    currLine = line;
                    this.out.println("   (line " + line + ")");
                    continue;
                }
                this.out.println();
            }
        }

        void printRangeString(Range r, int depth) {
            this.printDepth(depth);
            this.out.println(this.getRangeString(r, this.labelMap));
        }

        String getRangeString(Range r, Map labelMap) {
            if (r instanceof ExceptionRange) {
                ExceptionRange er = (ExceptionRange)r;
                return er.toString() + " -> " + labelMap.get(er.getHandler());
            }
            return r.toString();
        }

        void printDepth(int depth) {
            this.pad(4);
            while (depth > 0) {
                this.out.print("| ");
                --depth;
            }
        }

        void printLabel(String s, int depth) {
            int space = Math.max(16 - depth * 2, 0);
            if (s == null) {
                this.pad(space);
            } else {
                space = Math.max(space - (s.length() + 2), 0);
                this.pad(space);
                this.out.print(s);
                this.out.print(": ");
            }
        }

        void printInstruction(InstructionHandle h, int depth) {
            this.printDepth(depth);
            this.printLabel((String)this.labelMap.get(h), depth);
            Instruction inst = h.getInstruction();
            if (inst instanceof CPInstruction) {
                CPInstruction cpinst = (CPInstruction)inst;
                this.out.print(Constants.OPCODE_NAMES[cpinst.getOpcode()].toUpperCase());
                this.out.print(" ");
                this.out.print(this.pool.constantToString(this.pool.getConstant(cpinst.getIndex())));
            } else if (inst instanceof Select) {
                Select sinst = (Select)inst;
                this.out.println(Constants.OPCODE_NAMES[sinst.getOpcode()].toUpperCase());
                int[] matches = sinst.getMatchs();
                InstructionHandle[] targets = sinst.getTargets();
                InstructionHandle defaultTarget = sinst.getTarget();
                int len = matches.length;
                for (int i = 0; i < len; ++i) {
                    this.printDepth(depth);
                    this.printLabel(null, depth);
                    this.out.print("  ");
                    this.out.print(matches[i]);
                    this.out.print(": \t");
                    this.out.println(this.labelMap.get(targets[i]));
                }
                this.printDepth(depth);
                this.printLabel(null, depth);
                this.out.print("  ");
                this.out.print("default: \t");
                this.out.print(this.labelMap.get(defaultTarget));
            } else if (inst instanceof BranchInstruction) {
                BranchInstruction brinst = (BranchInstruction)inst;
                this.out.print(Constants.OPCODE_NAMES[brinst.getOpcode()].toUpperCase());
                this.out.print(" ");
                this.out.print(this.labelMap.get(brinst.getTarget()));
            } else if (inst instanceof LocalVariableInstruction) {
                LocalVariableInstruction lvinst = (LocalVariableInstruction)inst;
                this.out.print(inst.toString(false).toUpperCase());
                int index = lvinst.getIndex();
                LocalVariableTag tag = LazyMethodGen.getLocalVariableTag(h, index);
                if (tag != null) {
                    this.out.print("     // ");
                    this.out.print(tag.getType());
                    this.out.print(" ");
                    this.out.print(tag.getName());
                }
            } else {
                this.out.print(inst.toString(false).toUpperCase());
            }
        }

        void pad(int size) {
            for (int i = 0; i < size; ++i) {
                this.out.print(" ");
            }
        }
    }
}

