/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc.example;

import net.noderunner.xmlrpc.ParamIterator;
import net.noderunner.xmlrpc.XmlRpcClient;
import net.noderunner.xmlrpc.XmlRpcException;

/**
 * This interface is used for provisioning names in a database.
 */
public class XmlRpcProvisioningClient 
	implements ProvisioningInterface
{
	XmlRpcClient client;

	/**
	 * Construct a new XmlRpcProvisioningClient.
	 */
	public XmlRpcProvisioningClient(XmlRpcClient client) {
		this.client = client;
	}

	ProvIterator call(String method, ProvIterator out) 
		throws ProvException
	{
		try {
			ParamIterator pi = client.execute(INTERFACE_NAME + "." + method,
				new XmlRpcOutputAdapter(out));
			return new XmlRpcInputAdapter(pi);
		} catch (XmlRpcException xre) {
			throw new ProvException(xre);
		}
	}

	public ProvIterator addSubscribers(ProvIterator i)
		throws ProvException
	{
		return call("addSubscribers", i);
	}

	public ProvIterator deleteSubscribers(ProvIterator i)
		throws ProvException
	{
		return call("deleteSubscribers", i);
	}

	public ProvIterator findSubscribers(SubscriberSearch ss)
		throws ProvException
	{
		java.util.Vector v = new java.util.Vector();
		v.add(ss);
		return call("findSubscribers", new IteratorAdapter(v.iterator()));
	}
}
