/**
 * 
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Region;

/**
 * Algorithm for {@link NullEvictionPolicy}.
 * 
 * @author Brian Stansberry
 */
public class NullEvictionAlgorithm implements EvictionAlgorithm
{
   /** Singleton instance of this class. */
   public static final NullEvictionAlgorithm INSTANCE = new NullEvictionAlgorithm();
   
   /**
    * Constructs a new NullEvictionAlgorithm.
    */
   private NullEvictionAlgorithm()
   {
   }

   /**
    * Returns {@link NullEvictionQueue#INSTANCE}.
    */
   public EvictionQueue getEvictionQueue()
   {
      return NullEvictionQueue.INSTANCE;
   }

   /** No-op */
   public void process(Region region) throws EvictionException
   {
      // no-op
   }

   /** No-op */
   public void resetEvictionQueue(Region region)
   {
      // no-op
   }

}
