/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.cache.transaction;


import java.lang.reflect.Method;

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

/**
 * JTA standalone TM lookup.
 *
 * @author Jason T. Greene
 */
public class JBossStandaloneJTAManagerLookup implements TransactionManagerLookup
{
   private Method manager, user;

   public JBossStandaloneJTAManagerLookup()
   {
      try
      {
         manager = Class.forName("com.arjuna.ats.jta.TransactionManager").getMethod("transactionManager");
         user = Class.forName("com.arjuna.ats.jta.UserTransaction").getMethod("userTransaction");
      }
      catch (Exception e)
      {
         throw new RuntimeException(e);
      }
   }

   public TransactionManager getTransactionManager() throws Exception
   {
      return (TransactionManager) manager.invoke(null);
   }

   public UserTransaction getUserTransaction() throws Exception
   {
      return (UserTransaction) user.invoke(null);
   }
}