/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.office;

import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;

/**
 * DOM implementation of OpenDocument element  {@odf.element office:body}.
 *
 */
public class OfficeBodyElement extends OdfElement {

	public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.OFFICE, "body");

	/**
	 * Create the instance of <code>OfficeBodyElement</code>
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public OfficeBodyElement(OdfFileDom ownerDoc) {
		super(ownerDoc, ELEMENT_NAME);
	}

	/**
	 * Get the element name
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element office:body}.
	 */
	public OdfName getOdfName() {
		return ELEMENT_NAME;
	}

	/**
	 * Create child element {@odf.element office:chart}.
	 *
	 * @return the element {@odf.element office:chart}
	 */
	public OfficeChartElement newOfficeChartElement() {
		OfficeChartElement officeChart = ((OdfFileDom) this.ownerDocument).newOdfElement(OfficeChartElement.class);
		this.appendChild(officeChart);
		return officeChart;
	}

	/**
	 * Create child element {@odf.element office:database}.
	 *
	 * Child element is new in Odf 1.2
	 *
	 * @return the element {@odf.element office:database}
	 */
	public OfficeDatabaseElement newOfficeDatabaseElement() {
		OfficeDatabaseElement officeDatabase = ((OdfFileDom) this.ownerDocument).newOdfElement(OfficeDatabaseElement.class);
		this.appendChild(officeDatabase);
		return officeDatabase;
	}

	/**
	 * Create child element {@odf.element office:drawing}.
	 *
	 * @return the element {@odf.element office:drawing}
	 */
	public OfficeDrawingElement newOfficeDrawingElement() {
		OfficeDrawingElement officeDrawing = ((OdfFileDom) this.ownerDocument).newOdfElement(OfficeDrawingElement.class);
		this.appendChild(officeDrawing);
		return officeDrawing;
	}

	/**
	 * Create child element {@odf.element office:image}.
	 *
	 * @return the element {@odf.element office:image}
	 */
	public OfficeImageElement newOfficeImageElement() {
		OfficeImageElement officeImage = ((OdfFileDom) this.ownerDocument).newOdfElement(OfficeImageElement.class);
		this.appendChild(officeImage);
		return officeImage;
	}

	/**
	 * Create child element {@odf.element office:presentation}.
	 *
	 * @return the element {@odf.element office:presentation}
	 */
	public OfficePresentationElement newOfficePresentationElement() {
		OfficePresentationElement officePresentation = ((OdfFileDom) this.ownerDocument).newOdfElement(OfficePresentationElement.class);
		this.appendChild(officePresentation);
		return officePresentation;
	}

	/**
	 * Create child element {@odf.element office:spreadsheet}.
	 *
	 * @return the element {@odf.element office:spreadsheet}
	 */
	public OfficeSpreadsheetElement newOfficeSpreadsheetElement() {
		OfficeSpreadsheetElement officeSpreadsheet = ((OdfFileDom) this.ownerDocument).newOdfElement(OfficeSpreadsheetElement.class);
		this.appendChild(officeSpreadsheet);
		return officeSpreadsheet;
	}

	/**
	 * Create child element {@odf.element office:text}.
	 *
	 * @return the element {@odf.element office:text}
	 */
	public OfficeTextElement newOfficeTextElement() {
		OfficeTextElement officeText = ((OdfFileDom) this.ownerDocument).newOdfElement(OfficeTextElement.class);
		this.appendChild(officeText);
		return officeText;
	}

	@Override
	public void accept(ElementVisitor visitor) {
		if (visitor instanceof DefaultElementVisitor) {
			DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
			defaultVisitor.visit(this);
		} else {
			visitor.visit(this);
		}
	}
}
