# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ConnectionType(Model):
    """Definition of the connection type.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Gets the id of the resource.
    :vartype id: str
    :ivar name: Gets the name of the connection type.
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param is_global: Gets or sets a Boolean value to indicate if the
     connection type is global.
    :type is_global: bool
    :ivar field_definitions: Gets the field definitions of the connection
     type.
    :vartype field_definitions: dict[str,
     ~azure.mgmt.automation.models.FieldDefinition]
    :ivar creation_time: Gets the creation time.
    :vartype creation_time: datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: datetime
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'field_definitions': {'readonly': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_global': {'key': 'properties.isGlobal', 'type': 'bool'},
        'field_definitions': {'key': 'properties.fieldDefinitions', 'type': '{FieldDefinition}'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ConnectionType, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.is_global = kwargs.get('is_global', None)
        self.field_definitions = None
        self.creation_time = None
        self.last_modified_time = kwargs.get('last_modified_time', None)
        self.description = kwargs.get('description', None)
