# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class ImpactType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The impact type
    """

    #: Pending updates has no impact on resource.
    NONE = "None"
    #: Pending updates can freeze network or disk io operation on resource.
    FREEZE = "Freeze"
    #: Pending updates can cause resource to restart.
    RESTART = "Restart"
    #: Pending updates can redeploy resource.
    REDEPLOY = "Redeploy"

class MaintenanceScope(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets maintenanceScope of the configuration
    """

    #: This maintenance scope controls installation of azure platform updates i.e. services on
    #: physical nodes hosting customer VMs.
    HOST = "Host"
    #: This maintenance scope controls os image installation on VM/VMSS.
    OS_IMAGE = "OSImage"
    #: This maintenance scope controls extension installation on VM/VMSS.
    EXTENSION = "Extension"
    #: This maintenance scope controls installation of windows and linux packages on VM/VMSS.
    IN_GUEST_PATCH = "InGuestPatch"
    #: This maintenance scope controls installation of SQL server platform updates.
    SQLDB = "SQLDB"
    #: This maintenance scope controls installation of SQL managed instance platform update.
    SQL_MANAGED_INSTANCE = "SQLManagedInstance"

class UpdateStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status
    """

    #: There are pending updates to be installed.
    PENDING = "Pending"
    #: Updates installation are in progress.
    IN_PROGRESS = "InProgress"
    #: All updates are successfully applied.
    COMPLETED = "Completed"
    #: Updates installation failed but are ready to retry again.
    RETRY_NOW = "RetryNow"
    #: Updates installation failed and should be retried later.
    RETRY_LATER = "RetryLater"

class Visibility(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets or sets the visibility of the configuration. The default value is 'Custom'
    """

    #: Only visible to users with permissions.
    CUSTOM = "Custom"
    #: Visible to all users.
    PUBLIC = "Public"
