# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.elasticsan import ElasticSanManagement

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-elasticsan
# USAGE
    python elastic_sans_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret 
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ElasticSanManagement(
        credential=DefaultAzureCredential(),
        subscription_id="aaaaaaaaaaaaaaaaaa",
    )

    response = client.elastic_sans.begin_update(
        resource_group_name="rgelasticsan",
        elastic_san_name="ti7q-k952-1qB3J_5",
        parameters={
            "properties": {"baseSizeTiB": 23, "extendedCapacitySizeTiB": 4},
            "tags": {"key3137": "aaaaaaaaaaaaaaa"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/elasticsan/resource-manager/Microsoft.ElasticSan/preview/2021-11-20-preview/examples/ElasticSans_Update_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
