# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.monitor import MonitorManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMonitorManagementMetricAlertsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MonitorManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_metric_alerts_list_by_subscription(self, resource_group):
        response = self.client.metric_alerts.list_by_subscription(
            api_version="2018-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_metric_alerts_list_by_resource_group(self, resource_group):
        response = self.client.metric_alerts.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2018-03-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_metric_alerts_get(self, resource_group):
        response = self.client.metric_alerts.get(
            resource_group_name=resource_group.name,
            rule_name="str",
            api_version="2018-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_metric_alerts_create_or_update(self, resource_group):
        response = self.client.metric_alerts.create_or_update(
            resource_group_name=resource_group.name,
            rule_name="str",
            parameters={
                "criteria": "metric_alert_criteria",
                "enabled": bool,
                "evaluationFrequency": "1 day, 0:00:00",
                "location": "str",
                "scopes": ["str"],
                "severity": 0,
                "windowSize": "1 day, 0:00:00",
                "actions": [{"actionGroupId": "str", "webHookProperties": {"str": "str"}}],
                "autoMitigate": bool,
                "description": "str",
                "id": "str",
                "isMigrated": bool,
                "lastUpdatedTime": "2020-02-20 00:00:00",
                "name": "str",
                "tags": {"str": "str"},
                "targetResourceRegion": "str",
                "targetResourceType": "str",
                "type": "str",
            },
            api_version="2018-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_metric_alerts_update(self, resource_group):
        response = self.client.metric_alerts.update(
            resource_group_name=resource_group.name,
            rule_name="str",
            parameters={
                "actions": [{"actionGroupId": "str", "webHookProperties": {"str": "str"}}],
                "autoMitigate": bool,
                "criteria": "metric_alert_criteria",
                "description": "str",
                "enabled": bool,
                "evaluationFrequency": "1 day, 0:00:00",
                "isMigrated": bool,
                "lastUpdatedTime": "2020-02-20 00:00:00",
                "scopes": ["str"],
                "severity": 0,
                "tags": {"str": "str"},
                "targetResourceRegion": "str",
                "targetResourceType": "str",
                "windowSize": "1 day, 0:00:00",
            },
            api_version="2018-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_metric_alerts_delete(self, resource_group):
        response = self.client.metric_alerts.delete(
            resource_group_name=resource_group.name,
            rule_name="str",
            api_version="2018-03-01",
        )

        # please add some check logic here by yourself
        # ...
