/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf;

import java.io.IOException;
import java.lang.reflect.Array;
import uk.ac.bristol.star.cdf.CdfFormatException;
import uk.ac.bristol.star.cdf.CdfInfo;
import uk.ac.bristol.star.cdf.DataType;
import uk.ac.bristol.star.cdf.Shaper;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.DataReader;
import uk.ac.bristol.star.cdf.record.Record;
import uk.ac.bristol.star.cdf.record.RecordFactory;
import uk.ac.bristol.star.cdf.record.RecordMap;
import uk.ac.bristol.star.cdf.record.VariableDescriptorRecord;

public class Variable {
    private final VariableDescriptorRecord vdr_;
    private final Buf buf_;
    private final RecordFactory recFact_;
    private final boolean isZVariable_;
    private final boolean recordVariance_;
    private final Shaper shaper_;
    private final int rvaleng_;
    private final DataType dataType_;
    private final DataReader dataReader_;
    private final Object padRawValueArray_;
    private final Object shapedPadValueRowMajor_;
    private final Object shapedPadValueColumnMajor_;
    private final String summaryTxt_;
    private volatile RecordReader recordReader_;

    public Variable(VariableDescriptorRecord variableDescriptorRecord, CdfInfo cdfInfo, RecordFactory recordFactory) throws IOException {
        int n;
        Object object;
        Object object2;
        this.vdr_ = variableDescriptorRecord;
        this.buf_ = variableDescriptorRecord.getBuf();
        this.recFact_ = recordFactory;
        this.isZVariable_ = variableDescriptorRecord.getRecordType() == 8;
        this.dataType_ = DataType.getDataType(variableDescriptorRecord.dataType, cdfInfo);
        this.recordVariance_ = Record.hasBit(this.vdr_.flags, 0);
        int[] nArray = this.isZVariable_ ? variableDescriptorRecord.zDimSizes : cdfInfo.getRDimSizes();
        boolean[] blArray = variableDescriptorRecord.dimVarys;
        boolean bl = cdfInfo.getRowMajor();
        int n2 = variableDescriptorRecord.numElems;
        assert (this.dataType_.hasMultipleElementsPerItem() || n2 == 1);
        this.shaper_ = Shaper.createShaper(this.dataType_, nArray, blArray, bl);
        int n3 = this.shaper_.getRawItemCount();
        this.dataReader_ = new DataReader(this.dataType_, n2, n3);
        this.rvaleng_ = Array.getLength(this.dataReader_.createValueArray());
        long l = variableDescriptorRecord.getPadValueOffset();
        if (l >= 0L) {
            object2 = new DataReader(this.dataType_, n2, 1);
            assert (variableDescriptorRecord.getPadValueSize() == ((DataReader)object2).getRecordSize());
            object = ((DataReader)object2).createValueArray();
            ((DataReader)object2).readValue(this.buf_, l, object);
            Object object3 = this.dataReader_.createValueArray();
            n = this.dataType_.getGroupSize();
            for (int i = 0; i < n3; ++i) {
                System.arraycopy(object, 0, object3, i * n, n);
            }
            this.padRawValueArray_ = object3;
            this.shapedPadValueRowMajor_ = this.shaper_.shape(this.padRawValueArray_, true);
            this.shapedPadValueColumnMajor_ = this.shaper_.shape(this.padRawValueArray_, false);
        } else if (this.vdr_.sRecords != 0) {
            object2 = this.dataType_.getDefaultPadValueArray();
            object = this.dataReader_.createValueArray();
            int n4 = this.dataType_.getGroupSize();
            for (n = 0; n < n3; ++n) {
                System.arraycopy(object2, 0, object, n * n4, n4);
            }
            this.padRawValueArray_ = object;
            this.shapedPadValueColumnMajor_ = this.shapedPadValueRowMajor_ = this.shaper_.shape(this.padRawValueArray_, true);
        } else {
            this.padRawValueArray_ = null;
            this.shapedPadValueRowMajor_ = null;
            this.shapedPadValueColumnMajor_ = null;
        }
        object2 = "";
        object = "";
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                object2 = (String)object2 + ',';
            }
            object2 = (String)object2 + nArray[i];
            object = (String)object + (blArray[i] ? (char)'T' : 'F');
        }
        this.summaryTxt_ = new StringBuffer().append(this.dataType_.getName()).append(' ').append(this.isZVariable_ ? "(z)" : "(r)").append(' ').append(nArray.length).append(':').append('[').append((String)object2).append(']').append(' ').append(this.recordVariance_ ? (char)'T' : 'F').append('/').append((String)object).toString();
    }

    public String getName() {
        return this.vdr_.name;
    }

    public int getNum() {
        return this.vdr_.num;
    }

    public boolean isZVariable() {
        return this.isZVariable_;
    }

    public int getRecordCount() {
        return this.vdr_.maxRec + 1;
    }

    public DataType getDataType() {
        return this.dataType_;
    }

    public Shaper getShaper() {
        return this.shaper_;
    }

    public boolean getRecordVariance() {
        return this.recordVariance_;
    }

    public String getSummary() {
        return this.summaryTxt_;
    }

    public VariableDescriptorRecord getDescriptor() {
        return this.vdr_;
    }

    public Object createRawValueArray() {
        return this.dataReader_.createValueArray();
    }

    public boolean hasRecord(int n) throws IOException {
        return this.getRecordReader().hasRecord(n);
    }

    public void readRawRecord(int n, Object object) throws IOException {
        this.getRecordReader().readRawRecord(n, object);
    }

    public Object readShapedRecord(int n, boolean bl, Object object) throws IOException {
        return this.getRecordReader().readShapedRecord(n, bl, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordReader getRecordReader() throws IOException {
        RecordReader recordReader = this.recordReader_;
        if (recordReader == null) {
            Variable variable = this;
            synchronized (variable) {
                recordReader = this.recordReader_;
                if (recordReader == null) {
                    this.recordReader_ = recordReader = this.createRecordReader();
                }
            }
        }
        return recordReader;
    }

    private RecordReader createRecordReader() throws IOException {
        RecordMap recordMap = RecordMap.createRecordMap(this.vdr_, this.recFact_, this.dataReader_.getRecordSize());
        if (!this.recordVariance_) {
            return new NoVaryRecordReader(recordMap);
        }
        int n = this.vdr_.sRecords;
        if (n == 0) {
            return new UnsparseRecordReader(recordMap);
        }
        if (n == 1) {
            assert (this.padRawValueArray_ != null);
            return new PadRecordReader(recordMap);
        }
        if (n == 2) {
            assert (this.padRawValueArray_ != null);
            return new PreviousRecordReader(recordMap);
        }
        throw new CdfFormatException("Unknown sparse record type " + n);
    }

    private class PreviousRecordReader
    implements RecordReader {
        private final RecordMap recMap_;

        PreviousRecordReader(RecordMap recordMap) {
            this.recMap_ = recordMap;
        }

        public boolean hasRecord(int n) {
            return this.recMap_.getEntryIndex(n) >= 0 && n < Variable.this.getRecordCount();
        }

        public void readRawRecord(int n, Object object) throws IOException {
            int n2 = this.recMap_.getEntryIndex(n);
            if (n2 >= 0) {
                Variable.this.dataReader_.readValue(this.recMap_.getBuf(n2), this.recMap_.getOffset(n2, n), object);
            } else if (n2 == -1) {
                System.arraycopy(Variable.this.padRawValueArray_, 0, object, 0, Variable.this.rvaleng_);
            } else {
                int n3 = -n2 - 2;
                long l = this.recMap_.getFinalOffsetInEntry(n3);
                Variable.this.dataReader_.readValue(this.recMap_.getBuf(n3), l, object);
            }
        }

        public Object readShapedRecord(int n, boolean bl, Object object) throws IOException {
            int n2 = this.recMap_.getEntryIndex(n);
            if (n2 >= 0) {
                Variable.this.dataReader_.readValue(this.recMap_.getBuf(n2), this.recMap_.getOffset(n2, n), object);
                return Variable.this.shaper_.shape(object, bl);
            }
            if (n2 == -1) {
                return bl ? Variable.this.shapedPadValueRowMajor_ : Variable.this.shapedPadValueColumnMajor_;
            }
            int n3 = -n2 - 2;
            long l = this.recMap_.getFinalOffsetInEntry(n3);
            Variable.this.dataReader_.readValue(this.recMap_.getBuf(n2), this.recMap_.getOffset(n2, n), object);
            return Variable.this.shaper_.shape(object, bl);
        }
    }

    private class PadRecordReader
    implements RecordReader {
        private final RecordMap recMap_;

        PadRecordReader(RecordMap recordMap) {
            this.recMap_ = recordMap;
        }

        public boolean hasRecord(int n) {
            return this.hasRecord(n, this.recMap_.getEntryIndex(n));
        }

        public void readRawRecord(int n, Object object) throws IOException {
            int n2 = this.recMap_.getEntryIndex(n);
            if (this.hasRecord(n, n2)) {
                Variable.this.dataReader_.readValue(this.recMap_.getBuf(n2), this.recMap_.getOffset(n2, n), object);
            } else {
                System.arraycopy(Variable.this.padRawValueArray_, 0, object, 0, Variable.this.rvaleng_);
            }
        }

        public Object readShapedRecord(int n, boolean bl, Object object) throws IOException {
            int n2 = this.recMap_.getEntryIndex(n);
            if (this.hasRecord(n, n2)) {
                Variable.this.dataReader_.readValue(this.recMap_.getBuf(n2), this.recMap_.getOffset(n2, n), object);
                return Variable.this.shaper_.shape(object, bl);
            }
            return bl ? Variable.this.shapedPadValueRowMajor_ : Variable.this.shapedPadValueColumnMajor_;
        }

        private boolean hasRecord(int n, int n2) {
            return n2 >= 0 && n2 < this.recMap_.getEntryCount() && n < Variable.this.getRecordCount();
        }
    }

    private class UnsparseRecordReader
    implements RecordReader {
        private final RecordMap recMap_;
        private final int nrec_;
        private final Object zeros_;

        UnsparseRecordReader(RecordMap recordMap) {
            this.recMap_ = recordMap;
            this.nrec_ = ((Variable)Variable.this).vdr_.maxRec + 1;
            this.zeros_ = Variable.this.createRawValueArray();
        }

        public boolean hasRecord(int n) {
            return n < this.nrec_;
        }

        public void readRawRecord(int n, Object object) throws IOException {
            if (this.hasRecord(n)) {
                int n2 = this.recMap_.getEntryIndex(n);
                Variable.this.dataReader_.readValue(this.recMap_.getBuf(n2), this.recMap_.getOffset(n2, n), object);
            } else {
                System.arraycopy(this.zeros_, 0, object, 0, Variable.this.rvaleng_);
            }
        }

        public Object readShapedRecord(int n, boolean bl, Object object) throws IOException {
            if (this.hasRecord(n)) {
                int n2 = this.recMap_.getEntryIndex(n);
                Variable.this.dataReader_.readValue(this.recMap_.getBuf(n2), this.recMap_.getOffset(n2, n), object);
                return Variable.this.shaper_.shape(object, bl);
            }
            return null;
        }
    }

    private class NoVaryRecordReader
    implements RecordReader {
        private final Object rawValue_;
        private final Object rowMajorValue_;
        private final Object colMajorValue_;

        NoVaryRecordReader(RecordMap recordMap) throws IOException {
            UnsparseRecordReader unsparseRecordReader = new UnsparseRecordReader(recordMap);
            this.rawValue_ = Variable.this.createRawValueArray();
            unsparseRecordReader.readRawRecord(0, this.rawValue_);
            this.rowMajorValue_ = Variable.this.shaper_.shape(this.rawValue_, true);
            this.colMajorValue_ = Variable.this.shaper_.shape(this.rawValue_, false);
        }

        public boolean hasRecord(int n) {
            return false;
        }

        public void readRawRecord(int n, Object object) {
            System.arraycopy(this.rawValue_, 0, object, 0, Variable.this.rvaleng_);
        }

        public Object readShapedRecord(int n, boolean bl, Object object) {
            return bl ? this.rowMajorValue_ : this.colMajorValue_;
        }
    }

    private static interface RecordReader {
        public boolean hasRecord(int var1);

        public void readRawRecord(int var1, Object var2) throws IOException;

        public Object readShapedRecord(int var1, boolean var2, Object var3) throws IOException;
    }
}

