}q (X   versionqXT   
.. function:: wx.version()

   Returns a string containing version and port info


qX	   CallAfterqX'  
.. function:: wx.CallAfter(callableObj, *args, **kw)

   Call the specified function after the current and pending event
   handlers have been completed.  This is also good for making GUI
   method calls from non-GUI threads.  Any extra positional or
   keyword args are passed on to the callable when it is called.

   :param PyObject callableObj: the callable object
   :param args: arguments to be passed to the callable object
   :param kw: keywords to be passed to the callable object

   .. seealso::
       :ref:`wx.CallLater`

            


qX   IsMainThreadqX   
.. function:: wx.IsMainThread()

   Returns ``True`` if the current thread is what  considers the GUI thread. 

   :rtype: `bool`





qX   AbortqX   
.. function:: wx.Abort()

   Exits the program immediately.                  

   This is a simple wrapper for the standard abort() function. 

                 



   .. versionadded:: 2.9.4 
     





qX   DisableAssertsq	X   
.. function:: wx.DisableAsserts()

   Disable the condition checks in the assertions.                  

   This is the same as calling :ref:`wx.SetAssertHandler`  with ``None`` handler. 


                 



   .. versionadded:: 2.9.0 
    





q
X   TrapqXF  
.. function:: wx.Trap()

   Generate a debugger exception meaning that the control is passed to the debugger if one is attached to the process.                  

   Otherwise the program just terminates abnormally. 

   If  ``DEBUG_LEVEL``   is 0 (which is not the default) this function does nothing. 

                 


qX   DateTimeFromTimeTq
Xf   
.. function:: wx.DateTimeFromTimeT(timet)

   Compatibility wrapper for :meth:`DateTime.FromTimeT`


qX   DateTimeFromJDNqX`   
.. function:: wx.DateTimeFromJDN(jdn)

   Compatibility wrapper for :meth:`DateTime.FromJDN`


qX   DateTimeFromHMSqX   
.. function:: wx.DateTimeFromHMS(hour, minute=0, second=0, millisecond=0)

   Compatibility wrapper for :meth:`DateTime.FromHMS`


qX   DateTimeFromDMYqX   
.. function:: wx.DateTimeFromDMY(day, month, year=DateTime.Inv_Year, hour=0, minute=0, second=0, millisecond=0)

   Compatibility wrapper for :meth:`DateTime.FromDMY`


qX
   pydate2wxdateqXl   
.. function:: wx.pydate2wxdate(date)

   Convert a Python date or datetime to a :class:`DateTime` object


qX   date2pydateqXc   
.. function:: wx.date2pydate(date)

   Convert a :class:`DateTime` object to a Python datetime.


qX   NewIdRefqX  
.. function:: wx.NewIdRef(count=1)

   Reserves a new Window ID (or range of WindowIDs) and returns a
   :class:`wx.WindowIDRef` object (or list of them) that will help
   manage the reservation of that ID.

   This function is intended to be a drop-in replacement of the old
   and deprecated :func:`wx.NewId` function, with the added benefit
   that the ID should never conflict with an in-use ID or other IDs
   generated by this function.
            


qX   IsRunningUnderWineqX+  
.. function:: wx.IsRunningUnderWine()

   Returns ``True`` only for MSW programs running under Wine.                  

   This function can be used to check for some functionality not implemented when using Wine. 





   :rtype: `bool`







   .. versionadded:: 4.1/wxWidgets-3.1.6  
    





qX	   GetLocaleqX   
.. function:: wx.GetLocale()

   Get the current locale object (note that it may be ``None``!)                  

   :rtype: :ref:`wx.Locale`





qX   GetTranslationqX6  
.. function:: wx.GetTranslation(*args, **kw)



   |overload| Overloaded Implementations:

   :html:`<hr class="overloadsep" /><br />`

   
   **GetTranslation** `(string, domain=EmptyString, context=EmptyString)`
   
   This function returns the translation of `string`  in the current  ``locale()`` .                   
   
   If the string is not found in any of the loaded message catalogs (see :ref:`Internationalization`), the original string is returned. If you enable logging of trace messages with "i18n" mask (using :meth:`wx.Log.AddTraceMask` ) and debug logging is enabled (see :ref:`Debugging`), a message is also logged in this case –  which helps to find the strings which were not yet translated. 
   
   If `domain`  is specified then only that domain/catalog is searched for a matching string. As this function is used very often, an alternative (and also common in Unix world) syntax is provided: the :ref:`wx._`  macro is defined to do the same thing as :ref:`wx.GetTranslation`. 
   
   If `context`  is not empty (notice that this argument is only available starting from wxWidgets 3.1.1), item translation is looked up in the specified context. This allows having different translations for the same string appearing in different contexts, e.g. it may be necessary to translate the same English "Open" verb differently depending on the object it applies to. To do this, you need to use  ``msgctxt``   in the source message catalog and specify different contexts for the different occurrences of the string and then use the same contexts in the calls to this function (or  ``GETTEXT_IN_CONTEXT``  or ``GETTEXT_IN_CONTEXT_PLURAL``  macros). 
   
   This function is thread-safe. 
   
   
                   
   
   
   :param `string`: 
   :type `string`: string
   :param `domain`: 
   :type `domain`: string
   :param `context`: 
   :type `context`: string
   
   
   
   
   :rtype: `string`
   
   
   
   
   
   
   
   .. note:: 
   
      This function is not suitable for literal strings using :meth:`T`   macro since this macro is not recognised by  ``xgettext`` , and so such strings are not extracted to the message catalog. Instead, use the  :ref:`wx._`  and ``PLURAL``  macro for all literal strings.  
   
   
   
   
   
   
   
   .. seealso:: GetTranslation(const String&,  String&, unsigned,  String&)  
   
   
   
   
   
   :html:`<hr class="overloadsep" /><br />`

   
   **GetTranslation** `(string, plural, n, domain=EmptyString, context=EmptyString)`
   
   This is an overloaded version of GetTranslation(const String&,  String&), please see its documentation for general information.                  
   
   This version is used when retrieving translation of string that has different singular and plural forms in English or different plural forms in some other language. Like GetTranslation(const String&,const String&), the `string`  parameter must contain the singular form of the string to be converted and is used as the key for the search in the catalog. The `plural`  parameter is the plural form (in English). The parameter `n`  is used to determine the plural form. If no message catalog is found, `string`  is returned if "n == 1", otherwise `plural`  is returned. 
   
   See ``GNU`` gettext Manual for additional information on plural forms handling: `http://www.gnu.org/software/gettext/manual/gettext.html#Plural-forms <http://www.gnu.org/software/gettext/manual/gettext.html#Plural-forms>`_  For a shorter alternative see the ``PLURAL``  macro. 
   
   This function is thread-safe. 
   
                   
   
   
   :param `string`: 
   :type `string`: string
   :param `plural`: 
   :type `plural`: string
   :param `n`: 
   :param `domain`: 
   :type `domain`: string
   :param `context`: 
   :type `context`: string
   
   
   
   
   :rtype: `string`
   
   
   
   
   
   :html:`<hr class="overloadsep" /><br />`



q X
   ColourDisplayq!X  
.. function:: wx.ColourDisplay()

   Returns ``True`` if the display is colour, ``False`` otherwise.                  


                

   :rtype: `bool`







   .. note:: 

      Use of this function is not recommended in the new code as it only works for the primary display. Use `Display.GetDepth()` to retrieve the depth of the appropriate display and compare it with 1 instead.  





q"X   DisplayDepthq#X  
.. function:: wx.DisplayDepth()

   Returns the depth of the display (a value of 1 denotes a monochrome display).                  


                

   :rtype: `int`







   .. note:: 

      Use of this function is not recommended in the new code as it only works for the primary display. Use `Display.GetDepth()` to retrieve the depth of the appropriate display instead.  





q$X	   SetCursorq%Xe  
.. function:: wx.SetCursor(cursor)

   Globally sets the cursor; only has an effect on Windows, Mac and GTK+.                  

   You should call this function with NullCursor to restore the system cursor. 


                


   :param `cursor`: 
   :type `cursor`: wx.Cursor






   .. seealso:: :ref:`wx.Cursor`, :meth:`wx.Window.SetCursor`   





q&X   ClientDisplayRectq'X  
.. function:: wx.ClientDisplayRect()

   Returns the dimensions of the work area on the display.                  

   This is the same as :ref:`wx.GetClientDisplayRect`  but allows retrieving the individual components instead of the entire rectangle. 

   Any of the output pointers can be ``None`` if the corresponding value is not needed by the caller. 


                

   :rtype: `tuple`







   :returns: 

      ( `x`, `y`, `width`, `height` ) 







   .. seealso:: :ref:`wx.Display`  





q(X   GetClientDisplayRectq)X  
.. function:: wx.GetClientDisplayRect()

   Returns the dimensions of the work area on the display.                  

   On Windows this means the area not covered by the taskbar, etc. Other platforms are currently defaulting to the whole display until a way is found to provide this info for all window managers, etc. 


                

   :rtype: :ref:`wx.Rect`







   .. seealso:: :ref:`wx.Display`  





q*X
   GetDisplayPPIq+Xn  
.. function:: wx.GetDisplayPPI()

   Returns the display resolution in pixels per inch.                  

   The  ``x``   component of the returned  :ref:`wx.Size`  object contains the horizontal resolution and the  ``y``   one  –  the vertical resolution. 




                

   :rtype: :ref:`wx.Size`







   .. versionadded:: 2.9.0 
     







   .. note:: 

      Use of this function is not recommended in the new code as it only works for the primary display. Use :meth:`wx.Display.GetPPI`   to retrieve the resolution of the appropriate display instead.  







   .. seealso:: :ref:`wx.Display`  





q,X   DisplaySizeq-XI  
.. function:: wx.DisplaySize()

   Returns the display size in pixels.                  


   Either of output pointers can be ``None`` if the caller is not interested in the corresponding value.  


                

   :rtype: `tuple`







   :returns: 

      ( `width`, `height` ) 







   .. note:: 

      Use of this function is not recommended in the new code as it only works for the primary display. Use :meth:`wx.Display.GetGeometry`   to retrieve the size of the appropriate display instead.  







   .. seealso:: :ref:`wx.GetDisplaySize`, :ref:`wx.Display`  





q.X   GetDisplaySizeq/X  
.. function:: wx.GetDisplaySize()

   Returns the display size in pixels.                  


                

   :rtype: :ref:`wx.Size`







   .. note:: 

      Use of this function is not recommended in the new code as it only works for the primary display. Use :meth:`wx.Display.GetGeometry`   to retrieve the size of the appropriate display instead.  







   .. seealso:: :ref:`wx.Display`  





q0X
   DisplaySizeMMq1Xr  
.. function:: wx.DisplaySizeMM()

   Returns the display size in millimeters.                  

   Either of output pointers can be ``None`` if the caller is not interested in the corresponding value. 


                

   :rtype: `tuple`







   :returns: 

      ( `width`, `height` ) 







   .. seealso:: :ref:`wx.GetDisplaySizeMM`, :ref:`wx.Display`  





q2X   GetDisplaySizeMMq3X   
.. function:: wx.GetDisplaySizeMM()

   Returns the display size in millimeters.                  


                

   :rtype: :ref:`wx.Size`







   .. seealso:: :ref:`wx.Display`  





q4X
   IntersectRectq5X   
.. function:: wx.IntersectRect(r1, r2)

                           Calculate and return the intersection of r1 and r2.  Returns None if there
                           is no intersection. 

   :rtype: :ref:`PyObject`





q6X   MacThemeColourq7XS   
.. function:: wx.MacThemeColour(themeBrushID)



   :rtype: :ref:`wx.Colour`





q8X   InitAllImageHandlersq9X~  
.. function:: wx.InitAllImageHandlers()

   Initializes all available image handlers.                  

   This function calls :meth:`wx.Image.AddHandler`   for all the available image handlers (see :ref:`Available image handlers <wx.Image>`  for the full list). Calling it is the simplest way to initialize :ref:`wx.Image`  but it creates and registers even the handlers your program may not use. If you want to avoid the overhead of doing this you need to call :meth:`wx.Image.AddHandler`   manually just for the handlers that you do want to use. 


                 



   .. seealso:: :ref:`wx.Image`, :ref:`wx.ImageHandler`  





q:X
   EmptyImageq;X   
.. function:: wx.EmptyImage(width=0, height=0, clear=True)

   A compatibility wrapper for the wx.Image(width, height) constructor


q<X   ImageFromBitmapq=Xb   
.. function:: wx.ImageFromBitmap(bitmap)

   Create a :class:`Image` from a :class:`wx.Bitmap`


q>X   ImageFromStreamq?X   
.. function:: wx.ImageFromStream(stream, type=BITMAP_TYPE_ANY, index=-1)

   Load an image from a stream (file-like object)


q@X
   ImageFromDataqAXu   
.. function:: wx.ImageFromData(width, height, data)

   Compatibility wrapper for creating an image from RGB data


qBX   ImageFromDataWithAlphaqCX   
.. function:: wx.ImageFromDataWithAlpha(width, height, data, alpha)

   Compatibility wrapper for creating an image from RGB and Alpha data


qDX   ImageFromBufferqEX  
.. function:: wx.ImageFromBuffer(width, height, dataBuffer, alphaBuffer=None)

   Creates a :class:`Image` from the data in `dataBuffer`.  The `dataBuffer`
   parameter must be a Python object that implements the buffer interface,
   such as a string, array, etc.  The `dataBuffer` object is expected to
   contain a series of RGB bytes and be width*height*3 bytes long.  A buffer
   object can optionally be supplied for the image's alpha channel data, and
   it is expected to be width*height bytes long.

   The :class:`Image` will be created with its data and alpha pointers initialized
   to the memory address pointed to by the buffer objects, thus saving the
   time needed to copy the image data from the buffer object to the :class:`Image`.
   While this has advantages, it also has the shoot-yourself-in-the-foot
   risks associated with sharing a C pointer between two objects.

   To help alleviate the risk a reference to the data and alpha buffer
   objects are kept with the :class:`Image`, so that they won't get deleted until
   after the wx.Image is deleted.  However please be aware that it is not
   guaranteed that an object won't move its memory buffer to a new location
   when it needs to resize its contents.  If that happens then the :class:`Image`
   will end up referring to an invalid memory location and could cause the
   application to crash.  Therefore care should be taken to not manipulate
   the objects used for the data and alpha buffers in a way that would cause
   them to change size.
            


qFX   BitmapFromBufferqGX   
.. function:: wx.BitmapFromBuffer(width, height, dataBuffer, alphaBuffer=None)

   A compatibility wrapper for :meth:`wx.Bitmap.FromBuffer` and :meth:`wx.Bitmap.FromBufferAndAlpha`


qHX   BitmapFromBufferRGBAqIX   
.. function:: wx.BitmapFromBufferRGBA(width, height, dataBuffer)

   A compatibility wrapper for :meth:`wx.Bitmap.FromBufferRGBA`


qJX   EmptyBitmapRGBAqKX   
.. function:: wx.EmptyBitmapRGBA(width, height, red=0, green=0, blue=0, alpha=0)

   A compatibility wrapper for :meth:`wx.Bitmap.FromRGBA`


qLX   EmptyBitmapqMX   
.. function:: wx.EmptyBitmap(width, height, depth=BITMAP_SCREEN_DEPTH)

   A compatibility wrapper for the wx.Bitmap(width, height, depth) constructor


qNX   BitmapFromImageqOXo   
.. function:: wx.BitmapFromImage(image)

   A compatibility wrapper for the wx.Bitmap(wx.Image) constructor


qPX	   EmptyIconqQX^   
.. function:: wx.EmptyIcon()

   A compatibility wrapper for the :class:`Icon` constructor


qRX   FFontqSX{   
.. function:: wx.FFont(pointSize, family, flags=FONTFLAG_DEFAULT, faceName=EmptyString, encoding=FONTENCODING_DEFAULT)



qTX   AutoBufferedPaintDCFactoryqUX  
.. function:: wx.AutoBufferedPaintDCFactory(window)

   Check if the window is natively double buffered and will return a :ref:`wx.PaintDC`  if it is, a :ref:`wx.BufferedPaintDC`  otherwise.                  

   It is the caller's responsibility to delete the :ref:`wx.DC`  pointer when finished with it.                  


   :param `window`: 
   :type `window`: wx.Window




   :rtype: :ref:`wx.DC`





qVX   GetAccelFromStringqWX/   
.. function:: wx.GetAccelFromString(label)



qXX   SafeShowMessageqYX_  
.. function:: wx.SafeShowMessage(title, text)

   This function shows a message to the user in a safe way and should be safe to call even before the application has been initialized or if it is currently in some other strange state (for example, about to crash).                  

   Under Windows this function shows a message box using a native dialog instead of :ref:`wx.MessageBox`  (which might be unsafe to call), elsewhere it simply prints the message to the standard output using the title as prefix. 




   :param `title`: The title of the message box shown to the user or the prefix of the message string.   
   :type `title`: string
   :param `text`: The text to show to the user.   
   :type `text`: string








   :rtype: `bool`




                  



   :returns: 

      ``True`` If a message box was actually shown or ``False`` if the message was logged to the console because there is no safe to show it currently (the return value is only available since wxWidgets 3.1.5, the function doesn't return anything in the previous versions).  







   .. seealso:: :ref:`wx.LogFatalError`  





qZX   SysErrorCodeq[X9  
.. function:: wx.SysErrorCode()

   Returns the error code from the last system call.                  

   This function uses  ``errno``   on Unix platforms and   ``GetLastError``   under Win32. 


                

   :rtype: `int`







   .. seealso:: :ref:`wx.SysErrorMsgStr`, :ref:`wx.LogSysError`  





q\X   SysErrorMsgStrq]X0  
.. function:: wx.SysErrorMsgStr(errCode=0)

   Returns the error message corresponding to the given system error code.                  

   If `errCode`  is 0 (default), the last error code (as returned by :ref:`wx.SysErrorCode`) is used. 

   Use this function instead of :ref:`wx.SysErrorMsg`, as the latter one is not thread-safe. 


                


   :param `errCode`: 
   :type `errCode`: long




   :rtype: `string`







   .. versionadded:: 4.1/wxWidgets-3.1.0  
    







   .. seealso:: :ref:`wx.SysErrorCode`, :ref:`wx.LogSysError`  





q^X   SysErrorMsgq_X  
.. function:: wx.SysErrorMsg(errCode=0)

   Returns the error message corresponding to the given system error code.                  

   If `errCode`  is 0 (default), the last error code (as returned by :ref:`wx.SysErrorCode`) is used. 

   Use :ref:`wx.SysErrorMsgStr`  instead of this function especially in a multi-threaded application. 


                


   :param `errCode`: 
   :type `errCode`: long




   :rtype: `string`







   .. seealso:: :ref:`wx.SysErrorCode`, :ref:`wx.LogSysError`  





q`X
   LogGenericqaXW  
.. function:: wx.LogGeneric(level, message)

   Logs a message with the given LogLevel.                  

   E.g. using  ``LOG_Message``   as first argument, this function behaves like  :ref:`wx.LogMessage`. 

                


   :param `level`: 
   :type `level`: wx.LogLevel
   :param `message`: 
   :type `message`: :class:`String`




qbX
   LogMessageqcX  
.. function:: wx.LogMessage(message)

   For all normal, informational messages.                  

   They also appear in a message box by default (but it can be changed). 

                


   :param `message`: 
   :type `message`: :class:`String`




qdX   LogInfoqeXk  
.. function:: wx.LogInfo(formatString, )

   For low priority messages.                  

   They are handled in the same way as messages logged by :ref:`wx.LogMessage`  by the default logger but could be handled differently by the custom loggers. 

                


   :param `formatString`: 
   :type `formatString`: int
   :param ``: 
   :type ``: ...




qfX
   LogVerboseqgX  
.. function:: wx.LogVerbose(message)

   For verbose output.                  

   Messages generated by these functions are suppressed by default, even if the log level is higher than :ref:`wx.LOG_Info`  and need to be explicitly activated by calling :meth:`wx.Log.SetVerbose` . 

   Notice that this is done automatically by wxWidgets, unless the standard command line handling is overridden, if  ``--verbose``   option is specified on the program command line, so using these functions provides a simple way of having some diagnostic messages not shown by default but which can be easily shown by the user if needed. 

                


   :param `message`: 
   :type `message`: :class:`String`




qhX
   LogWarningqiX   
.. function:: wx.LogWarning(message)

   For warnings - they are also normally shown to the user, but don't interrupt the program work.                  

                


   :param `message`: 
   :type `message`: :class:`String`




qjX
   LogFatalErrorqkX9  
.. function:: wx.LogFatalError(message)

   Like :ref:`wx.LogError`, but also terminates the program with the exit code 3.                  

   Using `abort()`  standard function also terminates the program with this exit code. 

                


   :param `message`: 
   :type `message`: :class:`String`




qlX   LogErrorqmX;  
.. function:: wx.LogError(message)

   The functions to use for error messages, i.e.                  

   the messages that must be shown to the user. The default processing is to pop up a message box to inform the user about it. 

                


   :param `message`: 
   :type `message`: :class:`String`




qnX   LogDebugqoXL  
.. function:: wx.LogDebug(message)

   The right functions for debug output.                  

   They only do something in debug mode (when the preprocessor symbol  ``__WXDEBUG__``   is defined) and expand to nothing in release mode (otherwise). 

                


   :param `message`: 
   :type `message`: :class:`String`




qpX	   LogStatusqqXD  
.. function:: wx.LogStatus(*args, **kw)



   |overload| Overloaded Implementations:

   :html:`<hr class="overloadsep" /><br />`

   
   **LogStatus** `(frame, message)`
   
   Messages logged by this function will appear in the statusbar of the `frame`  or of the top level application window by default (i.e.                  
   
   when using the second version of the functions). 
   
   If the target frame doesn't have a statusbar, the message will be lost. 
   
                   
   
   
   :param `frame`: 
   :type `frame`: wx.Frame
   :param `message`: 
   :type `message`: :class:`String`
   
   
   
   
   :html:`<hr class="overloadsep" /><br />`

   
   **LogStatus** `(message)`
   
   
   
   
   :param `message`: 
   :type `message`: :class:`String`
   
   
   
   
   :html:`<hr class="overloadsep" /><br />`



qrX   LogSysErrorqsXP  
.. function:: wx.LogSysError(message)

   Mostly used by wxWidgets itself, but might be handy for logging errors after system call (API function) failure.                  

   It logs the specified message text as well as the last system error code (`errno`  or `GetLastError()`  depending on the platform) and the corresponding error message. The second form of this function takes the error code explicitly as the first argument. 


                


   :param `message`: 
   :type `message`: :class:`String`






   .. seealso:: :ref:`wx.SysErrorCode`, :ref:`wx.SysErrorMsgStr`  





qtX   IsDragResultOkquX  
.. function:: wx.IsDragResultOk(res)

   Returns ``True`` if res indicates that something was done during a DnD operation, i.e.                  

   is neither error nor none nor cancel.                  


   :param `res`: 
   :type `res`: wx.DragResult




   :rtype: `bool`





qvX   NewEventTypeqwX   
.. function:: wx.NewEventType()

   Generates a new unique event type.                  

   Usually this function is only used by ``DEFINE_EVENT``  and not called directly.                  

   :rtype: :ref:`wx.EventType`





qxX	   PostEventqyX  
.. function:: wx.PostEvent(dest, event)

   In a GUI application, this function posts `event`  to the specified `dest`  object using :meth:`wx.EvtHandler.AddPendingEvent` .                  

   Otherwise, it dispatches `event`  immediately using :meth:`wx.EvtHandler.ProcessEvent` . See the respective documentation for details (and caveats). Because of limitation of :meth:`wx.EvtHandler.AddPendingEvent`   this function is not thread-safe for event objects having :ref:`String`  fields, use :ref:`wx.QueueEvent`  instead. 

                


   :param `dest`: 
   :type `dest`: wx.EvtHandler
   :param `event`: 
   :type `event`: wx.Event




qzX
   QueueEventq{X  
.. function:: wx.QueueEvent(dest, event)

   Queue an event for processing on the given object.                  

   This is a wrapper around :meth:`wx.EvtHandler.QueueEvent` , see its documentation for more details. 






   :param `dest`: The object to queue the event on, can't be  ``NULL`` .    
   :type `dest`: wx.EvtHandler
   :param `event`: The heap-allocated and non- ``NULL``   event to queue, the function takes ownership of it.    
   :type `event`: wx.Event






                  


q|X   GetAppq}Xn   
.. function:: wx.GetApp()

   Returns the current application object. 

   :rtype: :ref:`wx.AppConsole`





q~X   HandleFatalExceptionsqXt  
.. function:: wx.HandleFatalExceptions(doIt=True)

   If `doIt`  is ``True``, the fatal exceptions (also known as general protection faults under Windows or segmentation violations in the Unix world) will be caught and passed to :meth:`wx.App.OnFatalException` .                  

   By default, i.e. before this function is called, they will be handled in the normal way which usually just means that the application will be terminated. Calling :ref:`wx.HandleFatalExceptions`  with `doIt`  equal to ``False`` will restore this default behaviour. 

   Notice that this function is only available if  ``USE_ON_FATAL_EXCEPTION``   is 1 and under Windows platform this requires a compiler with support for ``SEH`` (structured exception handling) which currently means only Microsoft Visual C++. 

                


   :param `doIt`: 
   :type `doIt`: bool




   :rtype: `bool`





qX
   WakeUpIdleqX  
.. function:: wx.WakeUpIdle()

   This function wakes up the (internal and platform dependent) idle system, i.e.                  

   it will force the system to send an idle event even if the system currently `is`  idle and thus would not send any idle event until after some other event would get sent. This is also useful for sending events between two threads and is used by the corresponding functions :ref:`wx.PostEvent`  and :meth:`wx.EvtHandler.AddPendingEvent` . 

                 


qX   YieldqXd  
.. function:: wx.Yield()

   Calls :meth:`wx.AppConsole.Yield`   if there is an existing application object.                  

   Does nothing if there is no application (which typically only happens early during the program startup or late during its shutdown). 


                

   :rtype: `bool`







   .. seealso:: `EvtLoopBase.Yield()`  





qX	   SafeYieldqX  
.. function:: wx.SafeYield(win=None, onlyIfNeeded=False)

   Calls :meth:`wx.App.SafeYield` .                  

                


   :param `win`: 
   :type `win`: wx.Window
   :param `onlyIfNeeded`: 
   :type `onlyIfNeeded`: bool




   :rtype: `bool`





qX   ExitqXB  
.. function:: wx.Exit()

   Exits application after calling :meth:`wx.App.OnExit` .                  

   Should only be used in an emergency: normally the top-level frame should be deleted (after deleting all other frames) to terminate the application. See :ref:`wx.CloseEvent`  and :ref:`wx.App`. 

                 


qX
   YieldIfNeededqXY   
.. function:: wx.YieldIfNeeded()

   Convenience function for wx.GetApp().Yield(True)


qX   FindWindowAtPointerqX!  
.. function:: wx.FindWindowAtPointer()

   Find the deepest window at the mouse pointer position, returning the window and current pointer position in screen coordinates.                  

                

   :rtype: `tuple`







   :returns: 

      ( :ref:`wx.Window`, `pt` ) 





qX   GetActiveWindowqX   
.. function:: wx.GetActiveWindow()

   Gets the currently active window (implemented for MSW and GTK only currently, always returns ``None`` in the other ports).                  

                

   :rtype: :ref:`wx.Window`





qX   GetTopLevelParentqX|  
.. function:: wx.GetTopLevelParent(window)

   Returns the first top level parent of the given window, or in other words, the frame or dialog containing it, or ``None``.                  

   Notice that if `window`  is itself already a ``TLW``, it is returned directly. 

                


   :param `window`: 
   :type `window`: wx.Window




   :rtype: :ref:`wx.Window`





qX
   DumpWindowqX  
.. function:: wx.DumpWindow(window)

   Return a string with human-readable platform-specific description of the window useful for diagnostic purposes.                  

   The string returned from this function doesn't have any fixed form and can vary between different wxWidgets ports and versions, but contains some useful description of the window and uniquely identifies it. This can be useful to include in debug or tracing messages. 




   :param `window`: Window pointer which is allowed to be ``None``.  
   :type `window`: wx.Window






   :rtype: `string`





                 



   .. versionadded:: 4.1/wxWidgets-3.1.6  
     





qX   GetTopLevelWindowsqX   
.. function:: wx.GetTopLevelWindows()

   Returns a list-like object of the the application's top-level windows, (frames,dialogs, etc.) 

   :rtype: :ref:`WindowList`





qX   FindWindowByIdqX  
.. function:: wx.FindWindowById(id, parent=None)

                           FindWindowById(id, parent=None) . Window

                           Find the first window in the application with the given id. If parent
                           is None, the search will start from all top-level frames and dialog
                           boxes; if non-None, the search will be limited to the given window
                           hierarchy. The search is recursive in both cases.
                         

   :rtype: :ref:`wx.Window`





qX   FindWindowByNameqX  
.. function:: wx.FindWindowByName(name, parent=None)





   Find a window by its name (as given in a window constructor or `Create`  function call). If `parent`  is ``None``, the search will start from all top-level frames and dialog boxes; if non-NULL, the search will be limited to the given window hierarchy. The search is recursive in both cases. 

   If no such named window is found, :ref:`wx.FindWindowByLabel`  is called. 

                


   :param `name`: 
   :type `name`: string
   :param `parent`: 
   :type `parent`: wx.Window




   :rtype: :ref:`wx.Window`







   .. wxdeprecated:: 
      Replaced by :meth:`wx.Window.FindWindowByName` .   





qX   FindWindowByLabelqXm  
.. function:: wx.FindWindowByLabel(label, parent=None)





   Find a window by its label. Depending on the type of window, the label may be a window title or panel item label. If `parent`  is ``None``, the search will start from all top-level frames and dialog boxes; if non-NULL, the search will be limited to the given window hierarchy. The search is recursive in both cases. 

                


   :param `label`: 
   :type `label`: string
   :param `parent`: 
   :type `parent`: wx.Window




   :rtype: :ref:`wx.Window`







   .. wxdeprecated:: 
      Replaced by :meth:`wx.Window.FindWindowByLabel` .   





qX   DirSelectorqX  
.. function:: wx.DirSelector(message=DirSelectorPromptStr, default_path=EmptyString, style=0, pos=DefaultPosition, parent=None)

   Pops up a directory selector dialog.                  

   The arguments have the same meaning as those of :meth:`DirDialog.__init__` . The message is displayed at the top, and the default_path, if specified, is set as the initial selection. 

   The application must check for an empty return value (if the user pressed Cancel). For example: 

   ::

           selector = wx.DirSelector("Choose a folder")
           if selector.strip():
               # Do something with the folder name
               print selector



                


   :param `message`: 
   :type `message`: string
   :param `default_path`: 
   :type `default_path`: string
   :param `style`: 
   :type `style`: long
   :param `pos`: 
   :type `pos`: wx.Point
   :param `parent`: 
   :type `parent`: wx.Window




   :rtype: `string`





qX   FileSelectorqX  
.. function:: wx.FileSelector(message, default_path=EmptyString, default_filename=EmptyString, default_extension=EmptyString, wildcard=FileSelectorDefaultWildcardStr, flags=0, parent=None, x=DefaultCoord, y=DefaultCoord)

   Pops up a file selector box.                  

   In Windows, this is the common file selector dialog. In X, this is a file selector box with the same functionality. The path and filename are distinct elements of a full file pathname. If path is empty, the current directory will be used. If filename is empty, no default filename will be supplied. The wildcard determines what files are displayed in the file selector, and file extension supplies a type extension for the required filename. Flags may be a combination of ``wx.FD_OPEN``, ``wx.FD_SAVE``, ``wx.FD_OVERWRITE_PROMPT`` or ``wx.FD_FILE_MUST_EXIST``. 


   Both the Unix and Windows versions implement a wildcard filter. Typing a filename containing wildcards (, ?) in the filename text item, and clicking on Ok, will result in only those files matching the pattern being displayed.  

   The wildcard may be a specification for multiple types of file with a description for each, such as: 

   ::

           wildcard = "BMP files (*.bmp)|*.bmp|GIF files (*.gif)|*.gif"



   The application must check for an empty return value (the user pressed Cancel). For example: 

   ::

           filename = wx.FileSelector("Choose a file to open")

           if filename.strip():
               # work with the file
               print filename

           # else: cancelled by user



                


   :param `message`: 
   :type `message`: string
   :param `default_path`: 
   :type `default_path`: string
   :param `default_filename`: 
   :type `default_filename`: string
   :param `default_extension`: 
   :type `default_extension`: string
   :param `wildcard`: 
   :type `wildcard`: string
   :param `flags`: 
   :type `flags`: int
   :param `parent`: 
   :type `parent`: wx.Window
   :param `x`: 
   :type `x`: int
   :param `y`: 
   :type `y`: int




   :rtype: `string`







   .. note:: 

      ``wx.FD_MULTIPLE`` can only be used with :ref:`wx.FileDialog`  and not here since this function only returns a single file name.  





qX   FileSelectorExqX5  
.. function:: wx.FileSelectorEx(message=FileSelectorPromptStr, default_path=EmptyString, default_filename=EmptyString, indexDefaultExtension=None, wildcard=FileSelectorDefaultWildcardStr, flags=0, parent=None, x=DefaultCoord, y=DefaultCoord)

   An extended version of :ref:`wx.FileSelector`                   

                


   :param `message`: 
   :type `message`: string
   :param `default_path`: 
   :type `default_path`: string
   :param `default_filename`: 
   :type `default_filename`: string
   :param `indexDefaultExtension`: 
   :type `indexDefaultExtension`: int
   :param `wildcard`: 
   :type `wildcard`: string
   :param `flags`: 
   :type `flags`: int
   :param `parent`: 
   :type `parent`: wx.Window
   :param `x`: 
   :type `x`: int
   :param `y`: 
   :type `y`: int




   :rtype: `string`





qX   LoadFileSelectorqX  
.. function:: wx.LoadFileSelector(what, extension, default_name=EmptyString, parent=None)

   Shows a file dialog asking the user for a file name for opening a file.                  


                


   :param `what`: 
   :type `what`: string
   :param `extension`: 
   :type `extension`: string
   :param `default_name`: 
   :type `default_name`: string
   :param `parent`: 
   :type `parent`: wx.Window




   :rtype: `string`







   .. seealso:: :ref:`wx.FileSelector`, :ref:`wx.FileDialog`  





qX   SaveFileSelectorqX  
.. function:: wx.SaveFileSelector(what, extension, default_name=EmptyString, parent=None)

   Shows a file dialog asking the user for a file name for saving a file.                  


                


   :param `what`: 
   :type `what`: string
   :param `extension`: 
   :type `extension`: string
   :param `default_name`: 
   :type `default_name`: string
   :param `parent`: 
   :type `parent`: wx.Window




   :rtype: `string`







   .. seealso:: :ref:`wx.FileSelector`, :ref:`wx.FileDialog`  





qX
   MessageBoxqX  
.. function:: wx.MessageBox(message, caption=MessageBoxCaptionStr, style=OK|CENTRE, parent=None, x=DefaultCoord, y=DefaultCoord)

   Show a general purpose message dialog.                  

   This is a convenient function which is usually used instead of using :ref:`wx.MessageDialog`  directly. Notice however that some of the features, such as extended text and custom labels for the message box buttons, are not provided by this function but only by :ref:`wx.MessageDialog`. 

   The return value is one of:  ``YES`` ,   ``NO`` ,   ``CANCEL`` ,   ``OK``   or   ``HELP``   (notice that this return value is  **different**  from the return value of :meth:`wx.MessageDialog.ShowModal` ). 

   For example: ::

           answer = wx.MessageBox("Quit program?", "Confirm",
                                  wx.YES_NO | wx.CANCEL, main_frame)
           if answer == wx.YES:
               main_frame.Close()



   `message`  may contain newline characters, in which case the message will be split into separate lines, to cater for large messages. 




   :param `message`: Message to show in the dialog.   
   :type `message`: string
   :param `caption`: The dialog title.   
   :type `caption`: string
   :param `style`: Combination of style flags described in :ref:`wx.MessageDialog`  documentation.   
   :type `style`: int
   :param `parent`: Parent window.   
   :type `parent`: wx.Window
   :param `x`: Horizontal dialog position (ignored under MSW). Use :ref:`wx.DefaultCoord`  for  `x`  and  `y`  to let the system position the window.   
   :type `x`: int
   :param `y`: Vertical dialog position (ignored under MSW).  
   :type `y`: int
















   :rtype: `int`



                  


qX   GetColourFromUserqXx  
.. function:: wx.GetColourFromUser(parent, colInit, caption=EmptyString, data=None)

   Shows the colour selection dialog and returns the colour selected by user or invalid colour (use :meth:`wx.Colour.IsOk`   to test whether a colour is valid) if the dialog was cancelled.                  




   :param `parent`: The parent window for the colour selection dialog.   
   :type `parent`: wx.Window
   :param `colInit`: If given, this will be the colour initially selected in the dialog.   
   :type `colInit`: wx.Colour
   :param `caption`: If given, this will be used for the dialog caption.   
   :type `caption`: string
   :param `data`: Optional object storing additional colour dialog settings, such as custom colours. If none is provided the same settings as the last time are used.  
   :type `data`: wx.ColourData












   :rtype: :ref:`wx.Colour`



                  


qX   GetSingleChoiceqX1  
.. function:: wx.GetSingleChoice(*args, **kw)



   |overload| Overloaded Implementations:

   :html:`<hr class="overloadsep" /><br />`

   
   **GetSingleChoice** `(message, caption, aChoices, parent=None, x=DefaultCoord, y=DefaultCoord, centre=True, width=CHOICE_WIDTH, height=CHOICE_HEIGHT, initialSelection=0)`
   
   Pops up a dialog box containing a message, OK/Cancel buttons and a single-selection listbox.                  
   
   The user may choose an item and press ``wx.OK`` to return a string or Cancel to return the empty string. Use :ref:`wx.GetSingleChoiceIndex`  if empty string is a valid choice and if you want to be able to detect pressing Cancel reliably. 
   
   You may pass the list of strings to choose from either using  ``choices``   which is an array of  `n`  strings for the listbox or by using a single  ``aChoices``   parameter of type  :ref:`ArrayString`. 
   
   If  ``centre``   is ``True``, the message text (which may include new line characters) is centred; if ``False``, the message is left-justified. 
   
   
   
   
   
   :html:`<hr class="overloadsep" /><br />`

   
   **GetSingleChoice** `(message, caption, choices, initialSelection, parent=None)`
   
   
   
   
   :param `message`: 
   :type `message`: string
   :param `caption`: 
   :type `caption`: string
   :param `choices`: 
   :type `choices`: list of strings
   :param `initialSelection`: 
   :type `initialSelection`: int
   :param `parent`: 
   :type `parent`: wx.Window
   
   
   
   
   :rtype: `string`
   
   
   
   
   
   :html:`<hr class="overloadsep" /><br />`



qX   GetFontFromUserqX  
.. function:: wx.GetFontFromUser(parent, fontInit, caption=EmptyString)

   Shows the font selection dialog and returns the font selected by user or invalid font (use :meth:`wx.Font.IsOk`   to test whether a font is valid) if the dialog was cancelled.                  




   :param `parent`: The parent window for the font selection dialog.   
   :type `parent`: wx.Window
   :param `fontInit`: If given, this will be the font initially selected in the dialog.   
   :type `fontInit`: wx.Font
   :param `caption`: If given, this will be used for the dialog caption.  
   :type `caption`: string










   :rtype: :ref:`wx.Font`



                  


qX   GetTextFromUserqX  
.. function:: wx.GetTextFromUser(message, caption=GetTextFromUserPromptStr, default_value=EmptyString, parent=None, x=DefaultCoord, y=DefaultCoord, centre=True)

   Pop up a dialog box with title set to `caption`,  ``message`` , and a   ``default_value`` .                   

   The user may type in text and press ``wx.OK`` to return this text, or press Cancel to return the empty string. 

   If  ``centre``   is ``True``, the message text (which may include new line characters) is centred; if ``False``, the message is left-justified. 

   This function is a wrapper around :ref:`wx.TextEntryDialog`  and while it is usually more convenient to use, using the dialog directly is more flexible, e.g. it allows you to specify the  ``TE_MULTILINE``   to allow the user enter multiple lines of text while this function is limited to single line entry only. 

                


   :param `message`: 
   :type `message`: string
   :param `caption`: 
   :type `caption`: string
   :param `default_value`: 
   :type `default_value`: string
   :param `parent`: 
   :type `parent`: wx.Window
   :param `x`: 
   :type `x`: int
   :param `y`: 
   :type `y`: int
   :param `centre`: 
   :type `centre`: bool




   :rtype: `string`





qX   GetPasswordFromUserqX  
.. function:: wx.GetPasswordFromUser(message, caption=GetPasswordFromUserPromptStr, default_value=EmptyString, parent=None, x=DefaultCoord, y=DefaultCoord, centre=True)

   Similar to :ref:`wx.GetTextFromUser`  but the text entered in the dialog is not shown on screen but replaced with stars.                  

   This is intended to be used for entering passwords as the function name implies. 

                


   :param `message`: 
   :type `message`: string
   :param `caption`: 
   :type `caption`: string
   :param `default_value`: 
   :type `default_value`: string
   :param `parent`: 
   :type `parent`: wx.Window
   :param `x`: 
   :type `x`: int
   :param `y`: 
   :type `y`: int
   :param `centre`: 
   :type `centre`: bool




   :rtype: `string`





qX   GetNumberFromUserqX  
.. function:: wx.GetNumberFromUser(message, prompt, caption, value, min=0, max=100, parent=None, pos=DefaultPosition)

   Shows a dialog asking the user for numeric input.                  

   The dialogs title is set to  ``caption`` , it contains a (possibly) multiline   ``message``   above the single line   ``prompt``   and the zone for entering the number. 

   The number entered must be in the range  ``min``   to   ``max``   (both of which should be positive) and   ``value``   is the initial value of it. If the user enters an invalid value, it is forced to fall into the specified range. If the user cancels the dialog, the function returns -1. If it is important to distinguish between cancelling the dialog and actually entering -1 in it, i.e. if -1 is a valid input value, this convenience function can't be used and  :ref:`wx.NumberEntryDialog`  should be used directly instead. 

   Dialog is centered on its  ``parent``   unless an explicit position is given in   ``pos`` . 



                


   :param `message`: 
   :type `message`: string
   :param `prompt`: 
   :type `prompt`: string
   :param `caption`: 
   :type `caption`: string
   :param `value`: 
   :type `value`: long
   :param `min`: 
   :type `min`: long
   :param `max`: 
   :type `max`: long
   :param `parent`: 
   :type `parent`: wx.Window
   :param `pos`: 
   :type `pos`: wx.Point




   :rtype: `long`







   .. seealso:: :ref:`wx.NumberEntryDialog`    





qX   BeginBusyCursorqX  
.. function:: wx.BeginBusyCursor(cursor=HOURGLASS_CURSOR)

   Changes the cursor to the given cursor for all windows in the application.                  

   Use :ref:`wx.EndBusyCursor`  to revert the cursor back to its previous state. These two calls can be nested, and a counter ensures that only the outer calls take effect. 


                


   :param `cursor`: 
   :type `cursor`: wx.Cursor






   .. seealso:: :ref:`wx.IsBusy`, :ref:`wx.BusyCursor`  





qX
   EndBusyCursorqX
  
.. function:: wx.EndBusyCursor()

   Changes the cursor back to the original cursor, for all windows in the application.                  

   Use with :ref:`wx.BeginBusyCursor`. 


                 



   .. seealso:: :ref:`wx.IsBusy`, :ref:`wx.BusyCursor`  





qX   IsBusyqX   
.. function:: wx.IsBusy()

   Returns ``True`` if between two :ref:`wx.BeginBusyCursor`  and :ref:`wx.EndBusyCursor`  calls.                  


                

   :rtype: `bool`







   .. seealso:: :ref:`wx.BusyCursor`.  





qX   BellqX   
.. function:: wx.Bell()

   Ring the system bell.                  










   .. note:: 

      This function is categorized as a GUI one and so is not thread-safe.  





qX   InfoMessageBoxqX>  
.. function:: wx.InfoMessageBox(parent)

   Shows a message box with the information about the wxWidgets build used, including its version, most important build parameters and the version of the underlying GUI toolkit.                  

   This is mainly used for diagnostic purposes and can be invoked by Ctrl-Alt-middle clicking on any :ref:`wx.Window`  which doesn't otherwise handle this event. 


                


   :param `parent`: 
   :type `parent`: wx.Window






   .. versionadded:: 2.9.0 
    







   .. seealso:: :ref:`wx.GetLibraryVersionInfo`  





qX   GetLibraryVersionInfoqX   
.. function:: wx.GetLibraryVersionInfo()

   Get wxWidgets version information.                  








   :rtype: :ref:`wx.VersionInfo`







   .. versionadded:: 2.9.2 
    







   .. seealso:: :ref:`wx.VersionInfo`  





qX   SecureZeroMemoryqX  
.. function:: wx.SecureZeroMemory(p, n)

   Fills the memory block with zeros in a way that is guaranteed not to be optimized away by the compiler.                  




   :param `p`: Pointer to the memory block to be zeroed, must be non-NULL.   
   :param `n`: The number of bytes to zero.  
   :type `n`: int










                 



   .. versionadded:: 4.1/wxWidgets-3.1.6  
     





qX   GetBatteryStateqX  
.. function:: wx.GetBatteryState()

   Returns battery state as one of  ``BATTERY_NORMAL_STATE`` ,   ``BATTERY_LOW_STATE`` ,   ``BATTERY_CRITICAL_STATE`` ,   ``BATTERY_SHUTDOWN_STATE``   or   ``BATTERY_UNKNOWN_STATE`` .                   

    ``BATTERY_UNKNOWN_STATE``   is also the default on platforms where this feature is not implemented (currently everywhere but MS Windows). 

                

   :rtype: :ref:`wx.BatteryState`





qX   GetPowerTypeqXe  
.. function:: wx.GetPowerType()

   Returns the type of power source as one of  ``POWER_SOCKET`` ,   ``POWER_BATTERY``   or   ``POWER_UNKNOWN`` .                   

    ``POWER_UNKNOWN``   is also the default on platforms where this feature is not implemented (currently everywhere but MS Windows). 

                

   :rtype: :ref:`wx.PowerType`





qX   GetKeyStateqX  
.. function:: wx.GetKeyState(key)

   For normal keys, returns ``True`` if the specified key is currently down.                  

   For togglable keys (Caps Lock, Num Lock and Scroll Lock), returns ``True`` if the key is toggled such that its ``LED`` indicator is lit. There is currently no way to test whether togglable keys are up or down. 

   Even though there are virtual key codes defined for mouse buttons, they cannot be used with this function currently. 

   In wxGTK, this function can be only used with modifier keys ( ``WXK_ALT`` ,   ``WXK_CONTROL``   and   ``WXK_SHIFT`` ) when not using X11 backend currently. 

                


   :param `key`: 
   :type `key`: wx.KeyCode




   :rtype: `bool`





qX   GetMousePositionqX   
.. function:: wx.GetMousePosition()

   Returns the mouse position in screen coordinates.                  

                

   :rtype: :ref:`wx.Point`





qX
   GetMouseStateqXy  
.. function:: wx.GetMouseState()

   Returns the current state of the mouse.                  

   Returns a :ref:`wx.MouseState`  instance that contains the current position of the mouse pointer in screen coordinates, as well as boolean values indicating the up/down status of the mouse buttons and the modifier keys. 

                

   :rtype: :ref:`wx.MouseState`





qX   EnableTopLevelWindowsqX   
.. function:: wx.EnableTopLevelWindows(enable=True)

   This function enables or disables all top level windows.                  

   It is used by :ref:`wx.SafeYield`. 

                


   :param `enable`: 
   :type `enable`: bool




qX   FindWindowAtPointqX  
.. function:: wx.FindWindowAtPoint(pt)

   Find the deepest window at the given mouse position in screen coordinates, returning the window if found, or ``None`` if not.                  

   This function takes child windows at the given position into account even if they are disabled. The hidden children are however skipped by it. 

                


   :param `pt`: 
   :type `pt`: wx.Point




   :rtype: :ref:`wx.Window`





qX   FindMenuItemIdqXi  
.. function:: wx.FindMenuItemId(frame, menuString, itemString)

   Find a menu item identifier associated with the given frame's menu bar.                  

                


   :param `frame`: 
   :type `frame`: wx.Frame
   :param `menuString`: 
   :type `menuString`: string
   :param `itemString`: 
   :type `itemString`: string




   :rtype: `int`





qX   NewIdqX  
.. function:: wx.NewId()



   Generates an integer identifier unique to this run of the program. 


                

   :rtype: :ref:`wx.WindowID`







   .. wxdeprecated:: 
      IDs generated by this function can possibly conflict with IDs used elsewhere in the application code. It is recommended to instead use the ``wx.ID_ANY`` ``ID`` to assign generated IDs for the controls, menu items and etc. that you create in the application. These IDs are guaranteed to not conflict with the other IDs that are in use in the application. For those cases where you need to create an ``ID`` that can be used more than once then please see :func:`wx.NewIdRef`. 







   .. seealso:: :ref:`wx.RegisterId`  





qX
   RegisterIdqX   
.. function:: wx.RegisterId(id)

   Ensures that Ids subsequently generated by :ref:`wx.NewId`  do not clash with the given `id`.                  

                


   :param `id`: 
   :type `id`: wx.WindowID




qX   LaunchDefaultApplicationqX  
.. function:: wx.LaunchDefaultApplication(document, flags=0)

   Opens the `document`  in the application associated with the files of this type.                  

   The `flags`  parameter is currently not used 

   Returns ``True`` if the application was successfully launched. 


                


   :param `document`: 
   :type `document`: string
   :param `flags`: 
   :type `flags`: int




   :rtype: `bool`







   .. seealso:: :ref:`wx.LaunchDefaultBrowser`, :ref:`wx.Execute`  





qX   LaunchDefaultBrowserqXL  
.. function:: wx.LaunchDefaultBrowser(url, flags=0)

   Opens the `url`  in user's default browser.                  

   If the `flags`  parameter contains  ``BROWSER_NEW_WINDOW``   flag, a new window is opened for the URL (currently this is only supported under Windows). 

   And unless the `flags`  parameter contains  ``BROWSER_NOBUSYCURSOR``   flag, a busy cursor is shown while the browser is being launched (using  :ref:`wx.BusyCursor`). 

   The parameter `url`  is interpreted as follows:

   - if it has a valid scheme (e.g.  ``"file:"`` ,   ``"http:"``   or   ``"mailto:"`` ) it is passed to the appropriate browser configured in the user system. 
   - if it has no valid scheme (e.g. it's a local file path without the  ``"file:"``   prefix), then  :meth:`FileExists`   and :meth:`DirExists`   are used to test if it's a local file/directory; if it is, then the browser is called with the `url`  parameter eventually prefixed by  ``"file:"`` . 
   - if it has no valid scheme and it's not a local file/directory, then  ``"http:"``   is prepended and the browser is called. 




   Returns ``True`` if the application was successfully launched. 


                


   :param `url`: 
   :type `url`: string
   :param `flags`: 
   :type `flags`: int




   :rtype: `bool`







   .. note:: 

      For some configurations of the running user, the application which is launched to open the given URL may be URL-dependent (e.g. a browser may be used for local URLs while another one may be used for remote URLs).  







   .. seealso:: :ref:`wx.LaunchDefaultApplication`, :ref:`wx.Execute`  





qX   StripMenuCodesqX  
.. function:: wx.StripMenuCodes(str, flags=Strip_All)

   Strips any menu codes from `str`  and returns the result.                  

   By default, the functions strips both the mnemonics character ( ``'&'`` ) which is used to indicate a keyboard shortkey, and the accelerators, which are used only in the menu items and are separated from the main text by the   ``\t``   (``TAB``) character. By using  `flags`  of  ``Strip_Mnemonics``   or   ``Strip_Accel``   to strip only the former or the latter part, respectively. 

   Notice that in most cases :meth:`wx.MenuItem.GetLabelFromText`   or :meth:`wx.Control.GetLabelText`   can be used instead. 

                


   :param `str`: 
   :type `str`: string
   :param `flags`: 
   :type `flags`: int




   :rtype: `string`





qX   GetEmailAddressqXH  
.. function:: wx.GetEmailAddress()

   Copies the user's email address into the supplied buffer, by concatenating the values returned by :ref:`wx.GetFullHostName`  and :ref:`wx.GetUserId`.                  


                

   :rtype: `string`







   :returns: 

      ``True`` if successful, ``False`` otherwise.  





qX
   GetHomeDirqX   
.. function:: wx.GetHomeDir()

   Return the (current) user's home directory.                  


                

   :rtype: `string`







   .. seealso:: :ref:`wx.GetUserHome`, :ref:`wx.StandardPaths`  





qX   GetHostNameqX  
.. function:: wx.GetHostName()

   Copies the current host machine's name into the supplied buffer.                  

   Please note that the returned name is `not`  fully qualified, i.e. it does not include the domain name. 


                

   :rtype: `string`







   :returns: 

      The hostname if successful or an empty string otherwise.  







   .. seealso:: :ref:`wx.GetFullHostName`  





qX   GetFullHostNameqX   
.. function:: wx.GetFullHostName()

   Returns the ``FQDN`` (fully qualified domain host name) or an empty string on error.                  


                

   :rtype: `string`







   .. seealso:: :ref:`wx.GetHostName`  





qX   GetUserHomeqX  
.. function:: wx.GetUserHome(user=EmptyString)

   Returns the home directory for the given user.                  

   If the `user`  is empty (default value), this function behaves like :ref:`wx.GetHomeDir`  (i.e. returns the current user home directory). 

   If the home directory couldn't be determined, an empty string is returned. 

                


   :param `user`: 
   :type `user`: string




   :rtype: `string`





qX	   GetUserIdqXh  
.. function:: wx.GetUserId()

   This function returns the "user id" also known as "login name" under Unix (i.e.                  

   something like "jsmith"). It uniquely identifies the current user (on this system). Under Windows or NT, this function first looks in the environment variables ``USER`` and ``LOGNAME``; if neither of these is found, the entry **UserId**  in the **wxWidgets**  section of the WIN.INI file is tried. 


                

   :rtype: `string`







   :returns: 

      The login name if successful or an empty string otherwise.  







   .. seealso:: :ref:`wx.GetUserName`  





qX   GetUserNameqX  
.. function:: wx.GetUserName()

   This function returns the full user name (something like "Mr. John Smith").                  

   Under Windows or NT, this function looks for the entry UserName in the wxWidgets section of the WIN.INI file. If PenWindows is running, the entry Current in the section User of the PENWIN.INI file is used. 


                

   :rtype: `string`







   :returns: 

      The full user name if successful or an empty string otherwise.  







   .. seealso:: :ref:`wx.GetUserId`  





qX   GetOsDescriptionqXq  
.. function:: wx.GetOsDescription()

   Returns the string containing the description of the current platform in a user-readable form.                  

   For example, this function may return strings like "Windows 10 (build 10240), 64-bit edition" or "Linux 4.1.4 i386". 


                

   :rtype: `string`







   .. seealso:: :ref:`wx.GetOsVersion`  





qX   GetOsVersionqXL  
.. function:: wx.GetOsVersion(micro=None)

   Gets the version and the operating system ``ID`` for currently running OS.                  

   The returned OperatingSystemId value can be used for a basic categorization of the OS family; the major, minor, and micro version numbers allows detecting a specific system. 

   If on Unix-like systems the version can't be detected all three version numbers will have a value of -1. 

   On systems where only the micro version can't be detected or doesn't make sense, it will have a value of 0. 

   For Unix-like systems ( ``OS_UNIX`` ) the major, minor, and micro version integers will contain the kernel's major, minor, and micro version numbers (as returned by the 'uname -r' command); e.g. "4", "1", and "4" if the machine is using kernel 4.1.4. 

   For macOS systems ( ``OS_MAC`` ) the major and minor version integers are the natural version numbers associated with the OS; e.g. "10", "11" and "2" if the machine is using macOS El Capitan 10.11.2. 

   For Windows-like systems ( ``OS_WINDOWS`` ) the major, minor and micro (equal to the build number) version integers will contain the following values:  

   ============================= ================ ================ ================ 
   Windows OS name               Major version    Minor version    Build number     
   ============================= ================ ================ ================ 
   Windows 11                    10               0                >= 22000         
   Windows Server 2022           10               0                >= 22000         
   Windows 10                    10               0                                 
   Windows Server 2016           10               0                                 
   Windows 8.1                   6                3                                 
   Windows Server 2012 ``R2``    6                3                                 
   Windows 8                     6                2                                 
   Windows Server 2012           6                2                                 
   Windows 7                     6                1                                 
   Windows 2008 ``R2``           6                1                                 
   Windows Vista                 6                0                                 
   Windows Server 2008           6                0                                 
   Windows Server 2003 ``R2``    5                2                                 
   Windows Server 2003           5                2                                 
   Windows XP                    5                1                                 
   ============================= ================ ================ ================ 

   |


   See the`MSDN <http://msdn.microsoft.com/en-us/library/ms724832(VS.85).aspx>`_  for more info about the values above. 


                


   :param `micro`: 
   :type `micro`: int




   :rtype: `tuple`







   :returns: 

      ( :ref:`wx.OperatingSystemId`, `major`, `minor` ) 







   .. seealso:: :ref:`wx.GetOsDescription`, :ref:`PlatformInfo`  





qX   CheckOsVersionqX   
.. function:: wx.CheckOsVersion(majorVsn, minorVsn=0, microVsn=0)

   Returns ``True`` if the version of the operating system on which the program is running under is the same or later than the given version.                  


                


   :param `majorVsn`: 
   :type `majorVsn`: int
   :param `minorVsn`: 
   :type `minorVsn`: int
   :param `microVsn`: 
   :type `microVsn`: int




   :rtype: `bool`







   .. versionadded:: 4.1/wxWidgets-3.1.0  
    







   .. seealso:: :ref:`wx.GetOsVersion`, :ref:`PlatformInfo`  





qX   IsPlatform64BitqX]  
.. function:: wx.IsPlatform64Bit()

   Returns ``True`` if the operating system the program is running under is 64 bit.                  

   The check is performed at run-time and may differ from the value available at compile-time (at compile-time you can just check if  ``sizeof(void*) == 8`` ) since the program could be running in emulation mode or in a mixed 32/64 bit system. 


                

   :rtype: `bool`







   .. note:: 

      This function is not 100% reliable on some systems given the fact that there isn't always a standard way to do a reliable check on the OS bitness.  





qX   IsPlatformLittleEndianqXJ  
.. function:: wx.IsPlatformLittleEndian()

   Returns ``True`` if the current platform is little endian (instead of big endian).                  

   The check is performed at run-time. 


                

   :rtype: `bool`







   .. seealso:: :ref:`Byte Order Functions and Macros <byte order functions and macros>`  





qX   GetCpuArchitectureNameqX  
.. function:: wx.GetCpuArchitectureName()

   Returns the ``CPU`` architecture name.                  

   This can be, for example, "x86_64", "arm64", or "i86pc". The name for the same ``CPU`` running on the same hardware can vary across operating systems. 

   The returned string may be empty if the ``CPU`` architecture couldn't be recognized. 

                

   :rtype: `string`







   .. versionadded:: 4.1/wxWidgets-3.1.5  
     







   .. seealso:: :ref:`wx.GetNativeCpuArchitectureName`  





qX   GetNativeCpuArchitectureNameqX  
.. function:: wx.GetNativeCpuArchitectureName()

   In some situations the current process and native ``CPU`` architecture may be different.                  

   This returns the native ``CPU`` architecture regardless of the current process ``CPU`` architecture. 

   Common examples for ``CPU`` architecture differences are the following:

   - Win32 process in x64 Windows (WoW) 
   - Win32 or x64 process on ``ARM64`` Windows (WoW64) 
   - x86_64 process on ``ARM64`` macOS (Rosetta 2) 




   The returned string may be empty if the ``CPU`` architecture couldn't be recognized. 

                

   :rtype: `string`







   .. versionadded:: 4.1/wxWidgets-3.1.6  
     







   .. seealso:: :ref:`wx.GetCpuArchitectureName`  





qX   ExecuteqX  
.. function:: wx.Execute(command, flags=EXEC_ASYNC, callback=None, env=None)

   Executes another program in Unix or Windows.                  

   In the overloaded versions of this function, if `flags`  parameter contains  ``EXEC_ASYNC``   flag (the default), flow of control immediately returns. If it contains   ``EXEC_SYNC`` , the current application waits until the other program has terminated. 

   In the case of synchronous execution, the return value is the exit code of the process (which terminates by the moment the function returns) and will be -1 if the process couldn't be started and typically 0 if the process terminated successfully. Also, while waiting for the process to terminate, :ref:`wx.Execute`  will call :ref:`wx.Yield`. Because of this, by default this function disables all application windows to avoid unexpected reentrancies which could result from the users interaction with the program while the child process is running. If you are sure that it is safe to not disable the program windows, you may pass  ``EXEC_NODISABLE``   flag to prevent this automatic disabling from happening. 

   For asynchronous execution, however, the return value is the process id and zero value indicates that the command could not be executed. As an added complication, the return value of -1 in this case indicates that we didn't launch a new process, but connected to the running one (this can only happen when using ``DDE`` under Windows for command execution). In particular, in this case only, the calling code will not get the notification about process termination. 

   If `callback`  isn't ``None`` and if execution is asynchronous, :meth:`wx.Process.OnTerminate`   will be called when the process finishes. Specifying this parameter also allows you to redirect the standard input and/or output of the process being launched by calling :meth:`wx.Process.Redirect` . 

   Under Windows, when launching a console process its console is shown by default but hidden if its ``IO`` is redirected. Both of these default behaviours may be overridden: if ``EXEC_HIDE_CONSOLE``  is specified, the console will never be shown. If ``EXEC_SHOW_CONSOLE``  is used, the console will be shown even if the child process ``IO`` is redirected. Neither of these flags affect non-console Windows applications or does anything under the other systems. 

   Under Unix the flag  ``EXEC_MAKE_GROUP_LEADER``   may be used to ensure that the new process is a group leader (this will create a new session if needed). Calling  :ref:`wx.Kill`  passing ``wx.KILL_CHILDREN`` will kill this process as well as all of its children (except those which have started their own session). Under MSW, this flag can be used with console processes only and corresponds to the native  ``CREATE_NEW_PROCESS_GROUP``   flag. 

   The  ``EXEC_NOEVENTS``   flag prevents processing of any events from taking place while the child process is running. It should be only used for very short-lived processes as otherwise the application windows risk becoming unresponsive from the users point of view. As this flag only makes sense with   ``EXEC_SYNC`` ,   ``EXEC_BLOCK``   equal to the sum of both of these flags is provided as a convenience. 




   :param `command`: The command to execute and any parameters to pass to it as a single string, i.e. "emacs file.txt".   
   :type `command`: string
   :param `flags`: Must include either ``wx.EXEC_ASYNC`` or ``wx.EXEC_SYNC`` and can also include ``wx.EXEC_SHOW_CONSOLE``, ``wx.EXEC_HIDE_CONSOLE``, ``wx.EXEC_MAKE_GROUP_LEADER`` (in either case) or ``wx.EXEC_NODISABLE`` and ``wx.EXEC_NOEVENTS`` or ``wx.EXEC_BLOCK``, which is equal to their combination, in ``wx.EXEC_SYNC`` case.   
   :type `flags`: int
   :param `callback`: An optional pointer to :ref:`wx.Process`.   
   :type `callback`: wx.Process
   :param `env`: An optional pointer to additional parameters for the child process, such as its initial working directory and environment variables. This parameter is available in wxWidgets 2.9.2 and later only.  
   :type `env`: ExecuteEnv












   :rtype: `long`






   

qX   GetProcessIdqX   
.. function:: wx.GetProcessId()

   Returns the number uniquely identifying the current process in the system.                  

   If an error occurs, 0 is returned. 

                

   :rtype: `int`





qX   KillqX	  
.. function:: wx.Kill(pid, sig=SIGTERM, rc=None, flags=KILL_NOCHILDREN)

   Equivalent to the Unix kill function: send the given signal `sig`  to the process with ``PID`` `pid`.                  

   The valid signal values are: 

   ::

               # Signal enumeration

               wx.SIGNONE  # verify if the process exists under Unix
               wx.SIGHUP
               wx.SIGINT
               wx.SIGQUIT
               wx.SIGILL
               wx.SIGTRAP
               wx.SIGABRT
               wx.SIGEMT
               wx.SIGFPE
               wx.SIGKILL  # forcefully kill, dangerous!
               wx.SIGBUS
               wx.SIGSEGV
               wx.SIGSYS
               wx.SIGPIPE
               wx.SIGALRM
               wx.SIGTERM  # terminate the process gently



    ``SIGNONE`` ,   ``SIGKILL``   and   ``SIGTERM``   have the same meaning under both Unix and Windows but all the other signals are equivalent to   ``SIGTERM``   under Windows. Moreover, under Windows,   ``SIGTERM``   is implemented by posting a message to the application window, so it only works if the application does have windows. If it doesn't, as is notably always the case for the console applications, you need to use   ``SIGKILL``   to actually kill the process. Of course, this doesn't allow the process to shut down gracefully and so should be avoided if possible. 

   Returns 0 on success, -1 on failure. If the `rc`  parameter is not ``None``, it will be filled with a value from the  ``KillError``   enum: 

   ::

           # KillError enumeration

           wx.KILL_OK             # no error
           wx.KILL_BAD_SIGNAL     # no such signal
           wx.KILL_ACCESS_DENIED  # permission denied
           wx.KILL_NO_PROCESS     # no such process
           wx.KILL_ERROR          # another, unspecified error



   The `flags`  parameter can be ``wx.KILL_NOCHILDREN`` (the default), or ``wx.KILL_CHILDREN``, in which case the child processes of this process will be killed too. Note that under Unix, for ``wx.KILL_CHILDREN`` to work you should have created the process by passing ``wx.EXEC_MAKE_GROUP_LEADER`` to :ref:`wx.Execute`. 


                


   :param `pid`: 
   :type `pid`: long
   :param `sig`: 
   :type `sig`: wx.Signal
   :param `rc`: 
   :type `rc`: wx.KillError
   :param `flags`: 
   :type `flags`: int




   :rtype: `int`







   .. seealso:: :meth:`wx.Process.Kill` , :meth:`wx.Process.Exists` , :ref:`External Program Execution Sample <external program execution sample>`  





qX   ShellqX  
.. function:: wx.Shell(command=EmptyString)

   Executes a command in an interactive shell window.                  

   If no command is specified, then just the shell is spawned. 


                


   :param `command`: 
   :type `command`: string




   :rtype: `bool`







   .. seealso:: :ref:`wx.Execute`, :ref:`External Program Execution Sample <external program execution sample>`  





qX   ShutdownqX  
.. function:: wx.Shutdown(flags=SHUTDOWN_POWEROFF)

   This function shuts down or reboots the computer depending on the value of the `flags`.                  




   :param `flags`: One of  ``SHUTDOWN_POWEROFF`` ,   ``SHUTDOWN_REBOOT``   or   ``SHUTDOWN_LOGOFF``   (currently implemented only for MSW) possibly combined with   ``SHUTDOWN_FORCE``   which forces shutdown under MSW by forcefully terminating all the applications. As doing this can result in a data loss, this flag shouldn't be used unless really necessary.  
   :type `flags`: int






   :rtype: `bool`




                  



   :returns: 

      ``True`` on success, ``False`` if an error occurred.  







   .. note:: 

      Note that performing the shutdown requires the corresponding access rights (superuser under Unix, ``SE_SHUTDOWN`` privilege under Windows) and that this function is only implemented under Unix and MSW.  





r   X
   MicroSleepr  X  
.. function:: wx.MicroSleep(microseconds)

   Sleeps for the specified number of microseconds.                  

   The microsecond resolution may not, in fact, be available on all platforms (currently only Unix platforms with nanosleep(2) may provide it) in which case this is the same as calling :ref:`wx.MilliSleep`  with the argument of `microseconds/1000`. 

                


   :param `microseconds`: 
   :type `microseconds`: long




r  X
   MilliSleepr  X]  
.. function:: wx.MilliSleep(milliseconds)

   Sleeps for the specified number of milliseconds.                  

   Notice that usage of this function is encouraged instead of calling usleep(3) directly because the standard `usleep()`  function is not ``MT`` safe. 

                


   :param `milliseconds`: 
   :type `milliseconds`: long




r  X   Nowr  X   
.. function:: wx.Now()

   Returns a string representing the current date and time.                  

                

   :rtype: `string`





r  X   Sleepr  X   
.. function:: wx.Sleep(secs)

   Sleeps for the specified number of seconds.                  

                


   :param `secs`: 
   :type `secs`: int




r  X   DecToHexr	  X  
.. function:: wx.DecToHex(*args, **kw)



   |overload| Overloaded Implementations:

   :html:`<hr class="overloadsep" /><br />`

   
   **DecToHex** `(dec, buf)`
   
   Convert decimal integer to 2-character hexadecimal string.                  
   
   
   
   
   :param `dec`: A number to be converted.   
   :type `dec`: int
   :param `buf`: A pointer to the buffer that receives hexadecimal string (not prefixed by  ``0x`` ). This buffer should be large enough to hold at least 3 characters: 2 hexadecimal digits and the terminating null character.  
   :type `buf`: wx.Char
   
   
   
   
   
   
   
                     
   
   
   
   .. note:: 
   
      Returned string is composed of uppercase hexdecimal characters.  
   
   
   
   
   
   :html:`<hr class="overloadsep" /><br />`

   
   **DecToHex** `(dec)`
   
   Convert decimal integer to 2-character hexadecimal string.                  
   
   
   
   
   :param `dec`: A number to be converted.   
   :type `dec`: int
   
   
   
   
   
   
   :rtype: `string`
   
   
   
   
                     
   
   
   
   :returns: 
   
      String containing hexadecimal string, not prefixed by  ``0x`` , composed of uppercase characters.  
   
   
   
   
   
   :html:`<hr class="overloadsep" /><br />`

   
   **DecToHex** `(dec, ch1, ch2)`
   
   Returns 2 characters of hexadecimal representation of a given number.                  
   
   
   
   
   :param `dec`: A number to be converted.   
   :type `dec`: int
   :param `ch1`: Pointer to the variable that receives 1st hexadecimal character. It must not be ``None``.   
   :type `ch1`: int
   :param `ch2`: Pointer to the variable that receives 2nd hexadecimal character. It must not be ``None``.  
   :type `ch2`: int
   
   
   
   
   
   
   
   
   
                     
   
   
   
   .. note:: 
   
      Returned characters are uppercase.  
   
   
   
   
   
   :html:`<hr class="overloadsep" /><br />`



r
  X   HexToDecr  X  
.. function:: wx.HexToDec(*args, **kw)



   |overload| Overloaded Implementations:

   :html:`<hr class="overloadsep" /><br />`

   
   **HexToDec** `(buf)`
   
   Convert 2-character hexadecimal string to decimal integer.                  
   
   
   
   
   :param `buf`: String containing uppercase hexadecimal characters, not prefixed by  ``0x`` . Its length must be at least 2 characters. If it is longer than 2 characters, only first two will be converted to the number.  
   :type `buf`: string
   
   
   
   
   
   
   :rtype: `int`
   
   
   
   
                     
   
   
   
   :returns: 
   
      An integer number between 0 and 255 that is equivalent to the number in `buf`, or  ``-1``   if  `buf`  is not a hexadecimal string.  
   
   
   
   
   
   :html:`<hr class="overloadsep" /><br />`

   
   **HexToDec** `(buf)`
   
   This is an overloaded member function, provided for convenience. It differs from the above function only in what argument(s) it accepts.                  
   
   
   :param `buf`: 
   :type `buf`: int
   
   
   
   
   :rtype: `int`
   
   
   
   
   
   :html:`<hr class="overloadsep" /><br />`



r  X   HelpControllerr
  X
  
.. function:: wx.HelpController(parentWindow=None)

   Rather than being an alias for some class, the Python version of
   ``HelpController`` is a factory function that creates and returns an
   instance of the best Help Controller for the platform.
            


r  X
   GetStockLabelr  X  
.. function:: wx.GetStockLabel(id, flags=STOCK_WITH_MNEMONIC)

   Returns label that should be used for given `id`  element.                  




   :param `id`: Given id of the :ref:`wx.MenuItem`, :ref:`wx.Button`, :ref:`wx.ToolBar`  tool, etc.   
   :type `id`: wx.WindowID
   :param `flags`: Combination of the elements of StockLabelQueryFlag.  
   :type `flags`: long








   :rtype: `string`



                  


r  u.