/****************************************************************************
 * This module is based on Twm, but has been siginificantly modified 
 * by Rob Nation (nation@rocket.sanders.lockheed.com)
 ****************************************************************************/
/*
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising
 * or publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/***********************************************************************
 *
 * fvwm per-screen data include file
 *
 ***********************************************************************/

#ifndef _SCREEN_
#define _SCREEN_

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include "misc.h"
#include "menus.h"

#define SIZE_HINDENT 10
#define SIZE_VINDENT 3
#define MAX_WINDOW_WIDTH 32767
#define MAX_WINDOW_HEIGHT 32767


/* Cursor types */
#define POSITION 0		/* upper Left corner cursor */
#define TITLE_CURSOR 1          /* title-bar cursor */
#define DEFAULT 2		/* cursor for apps to inherit */
#define SYS 3        		/* sys-menu and iconify boxes cursor */
#define MOVE 4                  /* resize cursor */
#define WAIT 5   		/* wait a while cursor */
#define MENU 6  		/* menu cursor */
#define SELECT 7	        /* dot cursor for f.move, etc. from menus */
#define DESTROY 8		/* skull and cross bones, f.destroy */
#define TOP 9
#define RIGHT 10
#define BOTTOM 11
#define LEFT 12
#define TOP_LEFT 13
#define TOP_RIGHT 14
#define BOTTOM_LEFT 15
#define BOTTOM_RIGHT 16
#define MAX_CURSORS 18

/* Maximum number of icon boxes that are allowed */
#define MAX_BOXES 4

typedef struct ScreenInfo
{
  int screen;
  int d_depth;	        	/* copy of DefaultDepth(dpy, screen) */
  int NumberOfScreens;          /* number of screens on display */
  Visual *d_visual;		/* copy of DefaultVisual(dpy, screen) */
  int MyDisplayWidth;		/* my copy of DisplayWidth(dpy, screen) */
  int MyDisplayHeight;	        /* my copy of DisplayHeight(dpy, screen) */
  
  FvwmWindow FvwmRoot;		/* the head of the fvwm window list */
  Window Root;		        /* the root window */
  Window SizeWindow;		/* the resize dimensions window */
  Window NoFocusWin;            /* Window which will own focus when no other
				 * windows have it */
  
  Pixmap gray_pixmap;           /* dark gray pattern for inactive borders */
  Pixmap light_gray_pixmap;     /* light gray pattern for inactive borders */
#ifdef MORE_COLORS
  Pixmap sticky_gray_pixmap;     /* light gray pattern for sticky borders */
#endif  
  MouseButton *MouseButtonRoot;
  FuncKey FuncKeyRoot;

  int root_pushes;		/* current push level to install root
				   colormap windows */
  FvwmWindow *pushed_window;	/* saved window to install when pushes drops
				   to zero */
#ifndef NO_PAGER
  FvwmWindow *FvwmPager;
  Window Pager_w;
  Window CPagerWin;
#endif
  Cursor FvwmCursors[MAX_CURSORS];

  name_list *TheList;		/* list of window names with attributes */
  char *DefaultIcon;            /* Icon to use when no other icons are found */

  ColorPair StdColors; 	/* standard fore/back colors */
#ifdef MORE_COLORS
  ColorPair StickyColors; 	/* sticky fore/back colors */
  ColorPair StickyRelief; 	/* sticky hilight colors */
  ColorPair ButtonColors;	/* button colors for all windows */
  ColorPair ButtonRelief;	/* button colors for all windows */
  ColorPair MenuColors;		/* Root menu colors */
  ColorPair MenuRelief;		/* Root menu colors */
  ColorPair BorderColors;	/* Windows normal border colors */
  ColorPair BorderRelief;	/* Windows normal border colors */
  ColorPair HiBorderColors;	/* Windows highlighted border colors */
  ColorPair HiBorderRelief;	/* Windows highlighted border colors */
  ColorPair MenuArrowColors;	/* Submenu arrow colors */
  ColorPair MenuArrowRelief;	/* Submenu arrow colors */
#endif
  ColorPair HiColors; 	/* standard fore/back colors */
  ColorPair StdRelief;
  ColorPair HiRelief;
  MyFont StdFont;     	/* font structure */
  MyFont WindowFont;   	/* font structure for window titles */
#ifndef NO_PAGER
  MyFont PagerFont;   	/* font struct for window labels in pager (optional)*/
#endif
#ifndef NO_ICONS
  MyFont IconFont;      /* for icon labels */
#endif
  
  GC NormalGC;		        /* normal GC for pager, resize window */
  GC DrawGC;			/* GC to draw lines for move and resize */
  GC HiReliefGC;                /* GC for highlighted window relief */
  GC HiShadowGC;                /* GC for highlighted window shadow */
  GC StdReliefGC;               /* GC for unselected window relief */
  GC StdShadowGC;               /* GC for unselected window shadow */
#ifdef MORE_COLORS
  GC StickyReliefGC;            /* GC for unselected sticky window relief */
  GC StickyShadowGC;            /* GC for unselected sticky window shadow */
  GC ButtonsMenuGC;		/* GC for window button menus */
  GC ButtonsReliefGC;		/* GC for window buttons */
  GC ButtonsShadowGC;		/* GC for window buttons */
  GC MenusGC;			/* GC for root menus */
  GC MenusReliefGC;		/* GC for root menus */
  GC MenusShadowGC;		/* GC for root menus */
  GC BordersReliefGC;		/* GC for normal borders */
  GC BordersShadowGC;		/* GC for normal borders */
  GC HiBordersReliefGC;		/* GC for highlighted borders */
  GC HiBordersShadowGC;		/* GC for highlighted borders */
  GC MenusArrowGC;		/* GC for menu arrows */
  GC MenusArrowReliefGC;	/* GC for menu arrows */
  GC MenusArrowShadowGC;	/* GC for menu arrows */
#endif
  GC FontGC;                    /* GC for non-standard fonts */

  int SizeStringWidth;	        /* minimum width of size window */
  int BorderWidth;		/* border width of fvwm windows */
  int CornerWidth;	        /* corner width for decoratedwindows */
  int BoundaryWidth;	        /* frame width for decorated windows */
  int NoBoundaryWidth;	        /* frame width for decorated windows */
  int TitleHeight;		/* height of the title bar window */
  FvwmWindow *Hilite;		/* the fvwm window that is highlighted 
				 * except for networking delays, this is the
				 * window which REALLY has the focus */
  FvwmWindow *Focus;            /* Last window which Fvwm gave the focus to 
                                 * NOT the window that really has the focus */
  FvwmWindow *PreviousFocus;    /* Window which had focus before fvwm stole it
				 * to do moves/menus/etc. */
  int EntryHeight;		/* menu entry height */
  int EdgeScrollX;              /* #pixels to scroll on screen edge */
  int EdgeScrollY;              /* #pixels to scroll on screen edge */
  unsigned char buttons2grab;   /* buttons to grab in click to focus mode */

  unsigned flags;
  int IconBoxes[MAX_BOXES][4];
  int NumBoxes;
  int randomx;                  /* values used for randomPlacement */
  int randomy;
  unsigned VScale;              /* Panner scale factor */
  FvwmWindow *LastWindowRaised; /* Last window which was raised. Used for raise
				 * lower func. */
  int VxMax;                    /* Max location for top left of virt desk*/
  int VyMax;
  int Vx;                       /* Current loc for top left of virt desk */
  int Vy;

  int nr_left_buttons;         /* number of left-side title-bar buttons */
  int nr_right_buttons;        /* number of right-side title-bar buttons */
  int left_button_styles[2][5];
  int right_button_styles[2][5];

  int ClickTime;               /*Max button-click delay for Function built-in*/
  int AutoRaiseDelay;          /* Delay between setting focus and raising win*/
  int ScrollResistance;        /* resistance to scrolling in desktop */
  int MoveResistance;          /* res to moving windows over viewport edge */
  int OpaqueSize;
} ScreenInfo;

extern ScreenInfo Scr;

/* for the flags value - these used to be seperate Bool's */
#define ClickToFocus        1  /* Focus follows mouse, or click to focus?*/
#define DecorateTransients  2  /* decorate transient windows? */
#define DontMoveOff         4  /* make sure that all windows stay on desktop*/
#define RandomPlacement     8  /* place windows in random locations? */
#define SuppressIcons      16  /* prevent generation of icon windows */
#define StickyIcons        32  /* Icons always sticky? */
#define EdgeWrapX          64  /* Should EdgeScroll wrap around? */
#define EdgeWrapY         128 
#define CenterOnCirculate 256  /* center the target window when circulating? */
#define MWMBorders        512
#define MWMMenus         1024
#define MWMButtons       2048



#endif /* _SCREEN_ */
