.\" t
.\" @(#)fvwm.1	8/24/93
.TH FVWM 0.99 "24 October 1993"
.UC
.SH NAME
fvwm \- F(?) Virtual Window Manager for X11
.SH SYNOPSIS
\fBfvwm\fP [ \fIoptions\fP ]
.SH DESCRIPTION
\fIFvwm\fP is a window manager for X11. It is a derivative of \fItwm\fP, 
redesigned 
to minimize memory consumption, provide a 3-D look to window frames, and
provide a simple virtual desktop.  Memory consumption is estimated at about 
one-half to one-third the memory consumption of \fItwm\fP, due primarily to a 
redesign of \fItwm\fP's inefficient method to storing mouse bindings. In 
addition, many of the configurable options of Twm have been removed. 

The name "FVWM" used to stand for something, but I forgot what.


.SH SPECIAL NOTE FOR XFREE86 USERS
Xfree86 provides a virtual screen whose operation can be confusing when
used in conjunction with this virtual window manager. With Xfree86, windows
which appear on the virtual screen actually get drawn into video memory, so the
virtual screen size is limited by available video memory.

With \fIfvwm\fP's virtual desktop, windows which do not appear on the screen
do not actually get drawn into video RAM. The size of the virtual desktop is 
limited to about 32,000 by 32,000 pixels. It is probably impractical to use a
virtual desktop more than about 5 times the visible screen in each direction. 
Note that memory usage with the virtual desktop is a function of the number of
windows which exist. The size of the desktop makes no difference.

When becoming familiar with \fIfvwm\fP, it is recommended that you disable 
Xfree86's virtial screen, by setting the virtual screen size to the
physical screen size. When familiar with \fIfvwm\fP, you may want to
re-enable Xfree86's virtual screen.

.SH COPYRIGHTS
Since \fIfvwm\fP is derived from \fItwm\fP code it shares \fItwm\fP's 
copyrights.

\fIfvwm\fP is copyright 1988 by Evans and Sutherland Computer Corporation, 
Salt Lake City, Utah, and 1989 by the Massachusetts Institute of Technology,
Cambridge, Massachusetts, All rights reserved. It is also copyright 1993 by
Robert Nation.

Permission to use, copy, modify, and distribute this software and   
its documentation  for  any  purpose  and  without  fee is hereby   
granted, provided that the above copyright notice appear  in  all   
copies and that both  that  copyright  notice  and  this  permission   
notice appear in supporting  documentation,  and  that  the   
names of Evans & Sutherland and M.I.T. not be used in advertising   
in publicity pertaining to distribution of the  software  without   
specific, written prior permission.                                 

ROBERT NATION, EVANS & SUTHERLAND, AND M.I.T. DISCLAIM ALL WARRANTIES WITH 
REGARD 
TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES  OF  MERCHANT-   
ABILITY  AND  FITNESS,  IN  NO  EVENT SHALL EVANS & SUTHERLAND OR   
M.I.T. BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL  DAM-   
AGES OR  ANY DAMAGES WHATSOEVER  RESULTING FROM LOSS OF USE, DATA   
OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN  CONNECTION  WITH  THE  USE
OR PERFORMANCE OF THIS SOFTWARE.                                 

.SH ANATOMY OF A WINDOW
\fIFvwm\fP puts a decorative border around most windows. This border consists
of a bar on each side, and a small "L" shaped section on each corner. 
There is an additional  top bar is called the title bar, and is used to 
display the name of the window. In addition, there are up to 10 title-bar
buttons.
The top, side and bottom bars are collectively known as the side-bars. 
The corner pieces are called the frame.

Unless the standard defaults files are modified, pressing mouse button 1 in
the title or side-bars will begin a 
move operation on the window. Pressing button 1 in the corner frame pieces 
will begin a resize operation. Pressing
button 2 anywhere in the border brings up an extensive list of window 
operations. 

Up to ten title-bar buttons may exist. Their use is completely user defineable.
The default configuration has a title-bar button on each side of the
title-bar. The one on the left is used to bring up a list of window
options, regardless of which mouse button is used. The one on the right
is used to iconify the window.
The number of title-bar buttons used depends on which ones have
mouse actions bound to them. See the section on "Mouse".


.SH THE VIRTUAL DESKTOP
\fIFvwm\fP is a virtual window manager, which means that the user can scroll
around on a desktop whose size is larger than the visible screen. The virtual
desktop size is user-configurable, but is 3 times the visible screen size in 
each direction, by default.

Window geometries
are specified relative  to the current viewport. That is xterm -geometry +0+0
will always show up in the upper-left hand corner of the visible portion of
the screen. It is permissible to specify geometries which place windows on
the virtual desktop, but off the screen. For example, if the visible screen
is 1000 by 1000 pixels, and the desktop size is 3x3, and the current viewport
is at the upper left hand corner of the desktop, then invoking xterm -geometry 
+1000+1000 will place the window just off of the lower right hand corner of
the screen. It can be found by moving the mouse to the lower right hand 
corner of the screen, and waiting for it to scroll into view.

A geometry specified as something like xterm -geometry -5-5 will generally
place the windows lower right hand corner 5 pixels from the lower right hand 
corner of the visible portion of the screen. Not all applications support
window geometries with negative offsets.

.SH INITIALIZATION
Unlike some other window managers, \fIfvwm\fP does not attempt to manage all 
local screens. Only screen zero of the default or specified display will be
managed. This dramatically simplifies the \fIfvwm\fP code.

During initialization, \fIfvwm\fP will search for a configuration file which
describes key and button bindings, and a few other things. The format of 
these files will be described later. First, \fIfvwm\fP will search for a file
named .fvwmrc in the users home directory. Failing that, it will look for
/usr/lib/X11/fvwm/system.fvwmrc for system-wide defaults. If that file is not 
found, fvwm will exit.

.SH SHAPED WINDOWS
If you typically use shaped windows such as xeyes or oclock you have several
options. You can make them all undecorated (NoBorder oclock and NoTitle oclock,
for example),
or you can use the default configuration, and leave them decorated, in which
case a decorative border and a solid-color backdrop are shown. Alternately,
you can compile in the SHAPE extensions, by changing a flag in the Makefile,
in which case you get the shaped window with no backdrop, and a title bar 
floats above the window. The shaped window extensions increase the window 
manager's memory consumption by about 60Kbytes when no shaped windows are
present, but have little effect when shaped windows are present.

.SH ICONS
The basic fvwm configuration uses monochrome bitmap icons, similar to twm. If
XPM extensions are compiled in, then color icons similar to ctwm, MS-DOS 
windows, or the Macintosh icons can be used. In order to use these options,
you will need the XPM package, as described in the Makefile.noImake and the 
Imakefile. 

If both the SHAPE and XPM options are compiled in, the you will get shaped 
color icons, which are very spiffy.

.SH OPTIONS
Only three command line options are supported by \fIfvwm\fP:
.IP "\fB-d\fP \fIdisplayname\fP"
Manage the display called, "displayname", instead of the name obtained from 
the environment variable $DISPLAY.
.IP "\fB-debug\fP"
Puts X transactions in synchronous mode, which dramatically slows things
down, but guarantees that \fIfvwm\fP's internal error messages are correct.
.IP "\fB-f\fP \fIconfig_file\fP"
Causes \fIfvwm\fP to use \fIconfig_file\fP in the user's home directory
instead of .fvwmrc as the window manager configuration file.
.IP "\fB-s\fP
Run fvwm on only the specified screen of a multi-screen display. Normally,
fvwm will attempt to start up on all screens of a multi-screen display.
The "specified screen" is the one provided in the DISPLAY environment variable,
or provided through the -f option.
.SH CONFIGURATION FILES
The configuration file is used to describe mouse and button bindings,
colors, the virtual display size, and related items. This section describes 
the configuration options.

.IP "StdForeColor \fIcolorname\fP"
Sets the foreground color for menus and non-selected window
titles to \fIcolorname\fP. When using a monochrome screen, this option is 
ignored, and black is used. 

.IP "StdBackColor \fIcolorname\fP"
Sets the background color for menus, and non-selected 
windows to \fIcolorname\fP. When using a monochrome screen, this option is 
ignored, and white is used.

.IP "HiForeColor \fIcolorname\fP"
Sets the color for selected window's
title to \fIcolorname\fP. When using a monochrome screen, this option is 
ignored, and black is used.

.IP "HiBackColor \fIcolorname\fP"
Sets the background color for the selected 
window to \fIcolorname\fP. When using a monochrome screen, this option is 
ignored, and white is used.

.IP "PagerBackColor \fIcolorname\fP"
Causes the pager background color to be \fIcolorname\fP, instead of white.
On a monochrome screen, this option is ignored. If the NO_PAGER option is set 
when building fvwm, this option is unavailable.

.IP "PagerForeColor \fIcolorname\fP"
Causes the pager foreground color to be \fIcolorname\fP, instead of black.
This is the color used to highlight the current viewport in the pager window.
On a monochrome screen, this option is ignored. If the NO_PAGER option is set 
when building fvwm, this option is unavailable.

.IP "Font \fIfontname\fP"
Makes \fIfvwm\fP use font \fIfontname\fP instead of "fixed" for menus, the resize indicators, and icon labels (if IconFont is not specified).

.IP "WindowFont \fIfontname\fP"
Makes \fIfvwm\fP use font \fIfontname\fP instead of "fixed" for the window 
title bar.

.IP "PagerFont \fIfontname\fP"
Makes \fIfvwm\fP use font \fIfontname\fP for writing window icon names into the
window's representation in the pager. If this option is omitted, no
names are written into the pager windows.

.IP "IconFont \fIfontname\fP"
Makes \fIfvwm\fP use font \fIfontname\fP for writing icon name labels. If
omitted, the menu font will be used instead.

.IP "NoTitle \fIwindowname\fP"
Keeps \fIfvwm\fP from putting a title-bar in the decorations for windows
named \fIwindowname\fP. This is
handy for clocks and similar gadgets that you don't want to take up too
much space. \fIwindowname\fP can be a window's name or its class.

.IP "NoBorder \fIwindowname\fP"
Keeps \fIfvwm\fP from putting decorative borders on windows 
named \fIwindowname\fP. This command has no effect on the title-bar.
This is handy for clocks and similar gadgets that you don't want to take up too
much space. \fIwindowname\fP can be a window's name or its class. 

If you specify both NoBorder \fIwindowname\fP and NoTitle \fIwindowname\fP 
for the same window in your .fvwmrc file, the window will be completely 
undecorated.

.IP "Sticky \fIwindowname\fP"
Sticky windows "stick to the screen's glass." That is, they don't move the
the viewport into the virtual desktop changes.  \fIwindowname\fP can be a 
window's name or its class.

.IP "StaysOnTop \fIwindowname\fP"
These  windows always try to stay on top of the other windows. This might mbe
handy for clocks or mailboxes that you would always like to be visible. If the
window is explicitly lowered, it will not try to force its way back to the top
until it is explicitly raised. \fIwindowname\fP can be a window's name or its 
class.

.IP "CirculateSkip \fIwindowname\fP"
Causes windows with the indicated name to be skipped over when the circulate-up
or circulate-down functions are invoked. \fIwindowname\fP can be a window's 
name or its class.

.IP "WindowListSkip \fIwindowname\fP"
Causes windows with the indicated name to be left out of the window list.

.IP "CenterOnCirculate"
When circulating, the desktop page containing the window which the pointer
is moving to is automatically selected. If CenterOnCirculate is selected,
then fvwm will do its best to center the target window in the desktop 
viewport, rather than just lining up to the closest page.

.IP "DeskTopSize \fIHorizontal\fPx\fIVertical\fP"
Defines the virtual desktop size in units of the physical screen size.

.IP "DeskTopScale \fIScale\fP"
Defines the virtual desktop scale with respect to the screen.

.IP "BoundaryWidth \fIWidth\fP"
Changes the boundary width on decorated windows to the specified value.
The default is 6.

.IP "EdgeScroll \fIhorizontal vertical\fP"
Specifies the percentage of a page to scroll when the cursor hits the edge of
a page. If you don't want any paging or scrolling when you hit the edge of a 
page, include EdgeScroll 0 0 in your .fvwmrc file. If you want whole pages, use
EdgeScroll 100 100. Both horizontal and vertical should be positive numbers.

If the horizontal and vertical percentages are multiplied by 1000, then 
scrolling will wrap around at the edge of the desktop. If "EdgeScroll 100000 100000" is
used, fvwm will scroll by whole pages, wrapping around at the edge of the desktop.

.IP "EdgeResistance \fIscrolling moving\fP"
Tells how hard it should be to change the desktop viewport be moving the 
mouse over the edge of the screen, and how hard it should be to move a 
window over the edge of the screen.

The first parameter tells how milliseconds the pointer must spend on the screen
edge before fvwm will move the viewport. This is intended for people who
use EdgeScroll 100 100, but find themselves accidentally flipping pages when
they don't want to. 

The second parameter 
tells how many pixels over the edge of the screen a window's edge must 
move before it actually moves partially off the screen.

Note that, with EdgeScroll 0 0, it is still possible to move or resize windows
across the edge of the current screen. By making the first parameter to 
EdgeResistance 10000, this type of motion is impossible. With EdgeResistances
less than 10000, but greater than 0, moving over pages becomes difficult 
but not impossible.

.IP "OpaqueMove \fIpercentage\fP"
Tells fvwm the maximum size window with which opaque window movement should be
used. The percentage is percent of the total screen area. With OpaqueMove 0,
all windows will be moved using the traditional rebber-band outline. With 
OpaqueMove 100, all windows will be move as solid windows. The default is 
OpaqueMove 5 which allows small windows to be moved in an opaque manner, but
large windows to be moved as rubber-bands.

.IP "ClickToFocus"
Normally keyboard input goes to the window the mouse pointer is in. If this
option is set, the keyboard input stays with one window until a new
window is clicked on.

.IP "DontMoveOff"
Prevents windows from being moved off or initially placed off of the desktop.
A few programs will not work correctly if you use this option. This only keeps
windows from being completely lost off the edge of the desktop. It insists on
keeping 16 pixels on the desktop, but doesn't care a bit about keeping the
whole window on the desk. See EdgeResistance if you don't like having windows
partially off the screen.

.IP "AutoRaise \fIdelay\fP"
Enables auto-raising of windows and specifies the time delay 
(in milli-seconds) between when a window acquires the input focus and when
it is automatically raised. This option works in focus-follows-mouse mode,
and in click-to-focus mode if the focus is changed by clicking in the
application window instead of a decoration window.

.IP "Pager \fI X_Location Y_Location\fP"
Enables a paging style of moving across the desktop. A Pager window
will appear at (X_Location, Y_Location) (not a pop-up). Miniature versions of 
all the non-sticky windows on the virtual desktop are shown in the pager. 
The color of the miniature version is the same as the color of the full-size
window's border.

In the Pager window, pressing mouse button 1 will move the desktop viewport
to the selected page (in click-to-focus mode, it will also move the keyboard 
focus to the window whose miniature you click on).
Pressing button 2 on a window in the pager will begin a window move, using the
miniature to quickly move the window anywhere on the desktop.
Pressing button 3 will move the top-left corner of the viewport
to the location of the button press, even if it does not line up with a page.
Dragging button 3 will cause the selected viewport to scroll as you move the 
pointer. The Pager is automatically sticky, but does not automatically
StayOnTop.

.IP "Mouse \fIButton Context Modifiers Function\fP"
Defines a mouse binding. \fIButton\fP is the mouse button number. If
\fIButton\fP is zero, then any button will perform the specified function.
\fIContext\fP describes in what context the binding applies. Valid contexts 
are R for the root window, W for an application window, T for a window title 
bar, S for a window side, top, or bottom bar, F for a window frame 
(the corners), I for an Icon window, or 0 through 9 for title-bar buttons, or
any combination of these letters. A is for any context except for title-bar 
buttons. For instance, a context of FST will apply when the mouse is anywhere
in a window's border, except the title-bar buttons.

\fIModifiers\fP is any combination of N for no modifiers,
C for control, S for shift, M for Meta, or A for any modifier. 
For example, a modifier of CM will
apply when both the Meta and shift keys are down. Function is one of 
\fIfvwm\fP's built in functions.

The title bar buttons contexts are numbered with odd numbered buttons on 
the left side of the title bar, and even numbers on the right. Button 1 
is the leftmost button on the left side. Button 9 is the innermost button 
on the left side. Button 2 is the outermost on the right side, and 0 
(short for 10) is the innermost on the right. In summary, the buttons are 
numbered "1 3 5 7 9    0 8 6 4 2". The highest odd numbered button which has
an action bound to it determines the number of buttons drawn on the left
side of the title bar. The highest even number determines the number or right
side buttons which are drawn. Actions can be bound to either mouse buttons or
keyboard keys.


.IP "Key \fIkeyname Context Modifiers Function\fP"
Binds a keyboard key to a specified \fIfvwm\fP built in function.
Definition is the same as for a mouse binding, except that the mouse button 
number is replaced with a key name. The \fIkeyname\fP is one of the entries 
from /usr/include/X11/keysymdef.h, with the leading XK_ omitted. The 
\fIContext\fP and \fIModifiers\fP fields are defined as in the mouse binding.

Binding a key to a title-bar button will not cause that button to appear
unless a mouse binding also exists.

.IP "IconBox \fIleft top right bottom\fP"
Defines regions of the screen in which to place icons. Up to four icon boxes 
can be defined. If an IconBox line is
provided, the icons will automatically be placed in them, if possible. Each 
time a window is iconified, a new place is found for it icon boxes are searched
for space going left to right, then top to bottom. Icons will not be
auto-placed on top of other icons, but they may be placed underneath 
application windows. If \fIleft\fP or \fIright\fP is negative, then fvwm will
add the screen width to it. If \fItop\fP or \fIbottom\fP is negative, then
fvwm will add the screen height to it. NOTE: -0 is not parsed as the
right or bottom pixel on the screen. You have to use -1 instead.

If no IconBox line is provided, or all icon boxes are full, then fvwm will
place icons near the current pointer location.


.IP "Icon \fIwindowname bitmap-file\fP"
Specifies the bitmap to be used for a window when it is iconified.
The \fIwindowname\fP can be an applications window name or class name, and
must be enclosed in qoutes. The \fIbitmap-file\fP is the full path name to a
standard X11 bitmap file. The specified bitmap/pixmap is used in 
preference to any icon supplied by the window itself.

If fvwm is compiled with XPM support for color icons, then \fIbitmap\fP 
can be an XPM pixmap file.

\fIwindowname\fP should be enclosed in double qoutes, but \fIbitmap-file\fP
should not. No environmental variables should be used in the \fIbitmap-file\fP
specification.

If \fIwindowname\fP is an empty string, then the specified file is the 
default icon, and will be used if no other icon bitmap or pixmap can be found:
.nf
.sp
Icon "" my-favorite-icon
.sp
.fi


.IP "DecorateTransients"
Causes transient windows, which are normally left undecorated, to be given the
usual \fIfvwm\fP decorations. Note that some pop-up windows, such as the xterm
menus, are not managed by the window manager, and still do not receive 
decorations.

.IP "RandomPlacement"
Causes windows which would normally require user-placement to be automatically
placed in ever-so-slightly random locations.

.IP "ClickTime \fIdelay\fP"
Specifies the maximum delay (in milli-seconds) between a button press and
a button release for the Function builtin to consider the action a mouse click.

.IP "SuppressIcons"
Prevents icon windows from being created or drawn. When used with the 
window-list, this provides a sort of icon manager.

.IP "StickyIcons"
Causes icons to always stick to the screen's glass. That is, icons always 
follow you around the desktop. When a window is de-iconified, it gets 
un-stuck. Some people find this a useful way of moving windows around.

.IP "Cursor \fI cursor_num cursor_type\fP"
This provides a very awkward way of changing cursor styles. \fICursor num\fP
tells which cursor you are changing, and is a number between 0 and 12, as 
follows
.nf
.sp
 0 POSITION - used when initially placing windows
 1 TITLE    - used in a window title-bar
 2 FRAME    - used in the corner pieces of a window border.
 3 SYS      - used in one of the title-bar buttons
 4 MOVE     - used when moving or resizing windows.
 5 WAIT     - used during an EXEC builtin command.
 6 MENU     - used in a menus.
 7 SELECT   - used for various builtin commands such as iconify.
 8 DESTROY  - used for DESTROY and DELETE built-ins.
 9 LEFT     - used in the left side-bar of a window.
10 RIGHT    - used in the right side-bar of a window
11 BOTTOM   - used in the bottom side-bar of a window
12 TOP      - used in the top side-bar of a window
.sp
.fi
The \fIcursor_type\fP argument is a number which tells the cursor shape 
to use. The available numbers can be found in /usr/include/X11/cursorfont.h,
and are currently even numbers between 0 and 152. At the current time, the following cursor types are available.
.nf
.sp
0   X_cursor 				2   arrow 
4   based_arrow_down 		6   based_arrow_up 
8   boat 					10  bogosity 
12  bottom_left_corner		14  bottom_right_corner 
16  bottom_side 			18  bottom_tee 
20  box_spiral 			22  center_ptr 
24  circle 				26  clock 
28  coffee_mug 			30  cross 
32  cross_reverse 			34  crosshair 
36  diamond_cross 			38  dot 
40  dotbox 				42  double_arrow 
44  draft_large 			46  draft_small 
48  draped_box 			50  exchange 
52  fleur 				54  gobbler 
56  gumby 				58  hand1 
60  hand2 				62  heart 
64  icon 					66  iron_cross 
68  left_ptr 				70  left_side 
72  left_tee 				74  leftbutton 
76  ll_angle 				78  lr_angle 
80  man 					82  middlebutton 
84  mouse 				86  pencil 
88  pirate 				90  plus 
92  question_arrow 			94  right_ptr 
96  right_side 			98  right_tee 
100 rightbutton 			102 rtl_logo 
104 sailboat 				106 sb_down_arrow 
108 sb_h_double_arrow 			110 sb_left_arrow 
112 sb_right_arrow 			114 sb_up_arrow 
116 sb_v_double_arrow 			118 shuttle 
120 sizing 				122 spider 
124 spraycan 				126 star 
128 target 				130 tcross 
132 top_left_arrow 			134 top_left_corner 
136 top_right_corner			138 top_side 
140 top_tee 				142 trek 
144 ul_angle 				146 umbrella 
148 ur_angle 				150 watch 
152 xterm 
.sp
.fi

.IP "ButtonStyle \fIbutton# Width\fPx\fIHeight\fP"
Defines the rectangular decoration shape to be used in a title-bar button.
\fIbutton#\fP is the title-bar button number, and is between 0 and 9.
A description of title-bar button numbers is given Mouse section above.
Width is the percentage of the full button width which is to be used. Height 
is the percentage of the full height to be used. Negative numbers cause the
shading to be inverted.


.IP "Popup \fIPopupName\fP" 
Starts the definition of a pop-up menu which will later be bound to a mouse 
button or key. \fIPopupName\fP must be enclosed in quotes. 
Menu entries are included
on lines following the Popup keyword. The menu definition ends with the key 
word EndPopup. Menu entries are specified as shown in the following example. 
The first word on each line is the built-in function which will be performed,
followed by the caption (enclosed in qoutes) which will be shown in the menu,
followed by any additional arguments needed by the built-in function. Sub-menus
can be specified by using the Popup built-in, as long as the sub-menu 
was defined earlier in the configuration file. 
.nf
.sp
Popup "Window Ops"
  Title   "Window Ops" 
  Move    "Move"
  Resize  "Resize"
  Raise   "Raise"
  Lower   "Lower"
  Iconify "(De)Iconify"
  Nop	  " "
  Destroy "Destroy"
  Title   "HARDCOPY"
  Exec    "Hardcopy"  exec xdpr &
  Exec    "Hardcopy RV"  exec xdpr -rv &
EndMenu
.sp
.fi
Note that if a tab character is embedded in the caption of a menu entry, then 
the text following the tab will be entered into a second column in the menu,
and the entire menu will be left-adjusted. This is intended for shortcut 
labelling. The tab character must really be a tab. If it is expanded into 
spaces it will not work! For example 
.nf
.sp
Popup "Window Ops"
  Title   "Window Ops	Alt-F1" 
.sp
.fi
Is the start of a left adjusted menu. Alt-F1 will be placed toward the 
right side of the menu. Users who prefer left adjusted menus should simply add
a trailing tab to the menu title line.


.IP "Function \fIFunctionName\fP" 
Starts the definition of a complex function, composed of the fvwm built-in 
functions, which will later be bound to a mouse 
button or key. \fIFunctionName\fP must be enclosed in quotes. 
Function entries are included
on lines following the Function keyword. The definition ends with the key 
word EndFunction. Function entries are specified as shown in the following 
example. The first word on each line is the built-in function which will be 
performed, followed the type of event which should trigger the action 
(enclosed in quotes), followed by any additional arguments needed by the 
built-in function. Menus can be specified by using the Popup built-in, as 
long as the menu was defined earlier in the configuration file. 

The trigger actions which are recognized are Motion, Click, and DoubleClick.
Once a function is triggered, fvwm will wait to see if the user is clicking, 
double-clicking or dragging the mouse. After the decision is made Fvwm will 
execute only the builtins from the function definition whose trigger action
matches the action performed by the user. If the following example were
bound to button 1 in a window title-bar, then, when button 1 is pressed, 
fvwm would wait 150 msec to see if the button is released. If the button is not
released, fvwm will start a move operation. When the move operation is
complete, a raise operation will be performed. If a button release is detected,
then fvwm will wait another 150 msec for a second click. If only one click
is detecteed, then the window will be raised. If two clicks are detected,
the window will be alternately raised and lowered. The 150 msec wait duration 
can be altered using the ClickTime option.
.nf
.sp
Function "Move-or-Raise"
        Move            "Motion"
        Raise           "Motion"
        Raise           "Click"
        RaiseLower      "DoubleClick"
EndFunction
.sp
.fi
The clicking and double clicking concepts do not carry through to using 
keyboard shortcuts.


.SH BUILT IN FUNCTIONS
\fIFvwm\fP supports a small set of built in functions which can be bound to
keyboard or mouse buttons.
.IP "Nop       "
Does nothing. This is used to insert a blank line or separator in a menu. If 
the menu item specification is Nop " ", then a blank line is inserted. If it
looks like Nop "", then a separator line is inserted.
.IP "Title     "
Does nothing. This is used to insert a title line in a popup or menu.
.IP "Beep      "
Makes the computer beep.
.IP "Quit      "
Exits \fIfvwm\fP, generally causing X to exit too.
.IP "Restart  \fIname WindowManagerName\fP "
Causes \fIfvwm\fP to re-read itself if WindowManagerName = fvwm, or
to switch to an alternate window manager if WindowManagerName != fvwm.
If the window manager is not in your default search path, then you should
use the full path name for \fIWindowManagerName\fP.

\fIWindowManagerName \fP is not quoted, but \fIname\fP is.
\fIname\fP is the name that appears in a menu, if that is where the function is
called from. \fIname\fP is required even if the function is not called from a 
menu, for ease of parsing.

This command should not have a trailing ampersand, and should not make use 
of any environmental variables. Of the following examples, the first two are
sure loosers, but the third is OK:
.nf
.sp
Key F1 R N Restart " " fvwm &
Key F1 R N Restart " " $(HOME)/bin/fvwm
Key F1 R N Restart " " /home/nation/bin/fvwm
.sp
.fi
.IP "Refresh   "
Causes all windows on the screen to re-draw themselves.
.IP "Move      "
Allows the user to move a window. If called from somewhere in a window or its 
border, then that window will be moved. If called from the root window, then
the user will be allowed to select the target window
.IP "Resize    "
Allows the user to resize a window.
.IP "Raise     "
Allows the user to raise a window.
.IP "Lower     "
Allows the user to lower a window.
.IP "RaiseLower"
Alternately raises and lowers a window.
.IP "Delete    "
Sends a message to a window asking that it remove itself, frequently causing
the application to exit.
.IP "Destroy   "
Destroys a window. Guaranteed to get rid of the window, but is a fairly violent
way to terminate an application.
.IP "Iconify   "
Iconfies a window if it is not already iconified, or de-iconifies it if it is
already iconified.
.IP "Maximize [\fI horizontal vertical\fP] "
Without its optional arguments, Maximize causes the window to alternately 
switch from a full-screen size to its normal size.

With the optional arguments horizontal and vertical, which are expressed 
as percentage of a full screen, the user can control the new size of the 
window. If horizonal >0, then the horizontal dimension of the window will 
be set to horizontal*screen_width/100. The vertical resizing is similar. 
For example, the following will add a title-bar button to switch a window 
to the full vertical size of the screen:
.nf
.sp
Mouse 0 4 A Maximize 0 100
.sp
.fi
The following causes windows to be stretched to the full width
.nf
.sp
Mouse 0 4 A Maximize 100 0
.sp
.fi
This makes a window that is half the screen size in each direction
.nf
.sp
Mouse 0 4 A Maximize 50 50
.sp
.fi
Values larger than 100 can be used with caution.

.IP "Stick     "
Makes a window sticky if it is not already sticky, or non-sticky if it
is already sticky.
.IP "Scroll \fIhorizonal vertical\fP"
Scrolls the virtual desktop's viewport by \fIhorizontal\fP pages in the
x-direction, and \fIvertical\fP pages in the y-direction. Either or both 
entries may be negative. Both horizontal and vertical values are expressed 
in percent of pages, so Scroll 100 100 means to scroll down and left by one
full page. Scroll 50 25 means to scroll left half a page and down a quarter of
a page. The scroll function should not be called from pop-up menus. Normally,
scrolling stops at the  edge of the desktop.

If the horizontal and vertical percentages are multiplied by 1000, then 
scrolling will wrap around at the edge of the desktop. If "Scroll 100000 0" is
executed over and over, fvwm will move to the next desktop page on each
execution, and will wrap around at the edge of the desktop, so that every
page is hit in turn.

.IP "CursorMove \fIhorizonal vertical\fP"
Moves the mouse pointer by \fIhorizontal\fP pages in the
x-direction, and \fIvertical\fP pages in the y-direction. Either or both 
entries may be negative. Both horizontal and vertical values are expressed 
in percent of pages, so CursorMove 100 100 means to move down and left by one
full page. CursorMove 50 25 means to move left half a page and down a 
quarter of a page. The CursorMove function should not be called from 
pop-up menus.
.IP "CirculateUp \fI[name window_name]\fP"
Causes the pointer to move to the previous window in the list of windows for 
which CirculateSkip has not not been specified as CirculateSkip. 

If the 
optional arguments are supplied, then the focus will move to the
first window whose name (or icon name or class) matches \fIwindow_name\fP.
The optional argument \fIname\fP is required if \fIwindow_name\fP is supplied,
and is enclosed in qoutes. This argument is the name which appears
in menus if the function is called from a menu, but serves no purpose
if the function is not called from a menu

Here's an example that move the focus to an xterm window when Alt-F1 is pressed:
.nf
.sp
Key F1 A M CirculateUp "whatever" xterm
.sp
.fi

.IP "CirculateDown \fI[name window_name]\fP"
Causes the pointer to move to the next window in the list of windows for which
CirculateSkip has not not been specified as CirculateSkip.

If the 
optional arguments are supplied, then the focus will move to the
first window whose name (or icon name or class) matches \fIwindow_name\fP.
The optional argument \fIname\fP is required if \fIwindow_name\fP is supplied,
and is enclosed in qoutes. This argument is the name which appears
in menus if the function is called from a menu, but serves no purpose
if the function is not called from a menu

.IP "GotoPage  x y"
Moves the desktop viewport to page (x,y). The upper left page is (0,0), the
upper right is (N,0), where N is one less than the current number of horizontal
pages specified in the DeskTopSize command. The lower left page is (0,M), 
and the lower right page is (N,M), where M is the desktop's vertical size 
as specified in the DeskTopSize command. The GotoPage function should not be
used in a pop-up menu.
.IP "WindowList
Generates a popup menu (and pops it up) in which the title and geometry of 
each of the windows currently on the desk top are shown. The geometry of 
iconified windows is shown in brackets. Selecting an item from the window list
pop-up menu will cause that window to be moved onto the desktop if it is
currently not on it, will move the desktop viewport to the page containing the
upper left hand corner of the window, will de-iconify the window if it is
iconified, and will raise the window.

.IP "Exec \fIname command\fP"
Executes \fIcommand\fP. \fIcommand\fP is not quoted, but \fIname\fP is.
\fIname\fP is the name that appears in a menu, if that is where the function is
called from. \fIname\fP is required even if the function is not called from a 
menu, for ease of parsing.

The following example binds function key F1 in the root window, with no 
modifiers, to the exec function. The program rxvt will be started,
with an assortment of options.
.nf
.sp
Key F1 R N Exec "rxvt" exec rxvt -fg yellow -bg blue -e /bin/tcsh &
.sp
.fi

.IP "Popup \fI\"PopupName\"\fP"
NOTE: This built-in takes a slightly different form when used to bind
a submenu into a menu than it does when binding the main menu to a key
or mouse button. The form described here is for binding a main menu to a
key or mouse button.

Used to bind a previously defined pop-up menu to a key or mouse button.

The following example binds mouse buttons 2 and 3 to a popup called
"Window Ops", whose definition was provided as an example earlier in this man 
page.
The menu will pop-up if the buttons 2 or 3 are pressed in the window frame, 
side-bar, or title-bar, with no modifiers (none of shift, control, or meta).
.nf
.sp
Mouse 2		FST	N	Popup "Window Ops"
Mouse 3		FST	N	Popup "Window Ops"
.sp
.fi
Popups can be bound to keys through the use of the key modiifer. Popups can
be operated without using the mouse by binding to keys, and operating via the
up arrow, down arrow, and enter keys.

.IP "Popup \fI\"MenuEntry\" PopupName\fP"
NOTE: This built-in takes a slightly different form when used to bind
a submenu into a menu than it does when binding the main menu to a key
or mouse button. The form described here is for binding a sub-menu to a main 
menu.

Used to bind a previously defined pop-up menu to another menu, for use as a 
sub-menu.

The following example defines a sub menu, "Quit-Verify" and binds it into a
main menu, called "Utilities".
.nf
.sp
Popup "Quit-Verify"
        Title   "Really Quit Fvwm?"
        Quit    "Yes, Really Quit"
        Restart "Restart Fvwm" fvwm
        Nop     ""
        Nop     "No, Don't Quit"
EndPopup

Popup "Utilities"
        Title   "Utilities"
        Exec    "Xterm"         exec xterm &
        Exec    "Rxvt"          exec rxvt &
        Exec    "Top"           exec rxvt -T Top -n Top -e top &
        Exec    "Calculator"    exec xcalc &
        Exec    "Xman"          exec xman &
        Exec    "Xmag"          exec xmag &
        Nop     ""
        Popup   "Exit Fvwm"     Quit-Verify
EndPopup
.sp
.fi
Sub-menus must be defined prior to the main menu in which they are bound.
Sub-menu nesting can be arbitrarily deep.



.IP "Function \fI\"FunctionName\"\fP"
Used to bind a previously defined function to a key or mouse button.

The following example binds mouse button 1 to a function called 
"Move-or-Raise", whose definition was provided as an example earlier in 
this man page. After performing this binding, fvwm will execute to 
move-or-raise function whenever button 1 is pressed in a window title-bar.
.nf
.sp
Mouse 1         T       A       Function "Move-or-Raise"
.sp
.fi


.SH KEYBOARD SHORTCUTS
All (I think) window-manager operations can be performed from the keyboard,
so mouse-less operation should not be difficult. In addition to scrolling
around the virtual desktop by binding the Scroll builtin to appropriate keys,
Popups, move, resize and most other builtins can be bound to keys. Once a
built-in function is started, the pointer is moved by using the up, down, 
left, and right arrows, and the action is terminated by pressing return.
Holding down the shift key will cause the pointer movement to go in larger
steps, and holding down the control key will cause the cursor movement to
go in smaller steps. As of release 0.975, standard emacs and vi cursor 
movement controls (^n, ^p, ^f, ^b, and ^j, ^k, ^h, ^l) can be used 
instead of the arrow keys.

.SH SUPPLIED CONFIGURATION
A sample configuration file, system.fvwmrc was supplied with the fvwm 
distribution. It is well commented and can be used as a source of examples 
for fvwm configuration


.SH USE ON MULTI-SCREEN DISPLAYS
As of fvwm-0.99, fvwm does work on multi-screen displays. If the -s command
line argument is not given to fvwm, it will automatically start up
on every screen on the specified display. After fvwm starts, each screen
is treated independently. Re-starts of fvwm need to be performed seperately
on each screen. The use of EdgeScroll 0 0 is strongly recommended for
multi-screen displays.

You may need to quit on each screen to quit from the X session completely,
I'm not sure.


.SH BUGS
As of fvwm 0.99, there are exactly 39.342 unidentified bugs. Identified
bugs have mostly been fixed, though.

Binding a key to a window decoration, but not to the window itself is
discouraged, because when the keypress event finally gets to the window,
it will be marked as SYNTHETIC, and will be ignored by many applications.



.SH AUTHOR
Robert Nation (nation@rocket.sanders.lockheed.com), with help from
many people, based on \fItwm\fP code, which was written by Thomas LaStrange.

